/*
 * Decompiled with CFR 0.152.
 */
package net.mebahelcreaturesdraugr.raid;

import java.util.HashMap;
import java.util.UUID;
import net.mebahelcreaturesdraugr.MebahelCreaturesDraugr;
import net.mebahelcreaturesdraugr.raid.DraugrRaid;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public class DraugrRaidPersistentData
extends class_18 {
    private final HashMap<UUID, DraugrRaid> raids = new HashMap();
    private final class_3218 world;

    public DraugrRaidPersistentData(class_3218 world) {
        this.world = world;
    }

    public void addRaidByUuid(UUID raidUuid, DraugrRaid raid) {
        this.raids.put(raidUuid, raid);
        this.method_80();
    }

    public DraugrRaid getRaidByUuid(UUID raidUuid) {
        return this.raids.get(raidUuid);
    }

    public DraugrRaid getRaid(UUID playerUuid) {
        return this.raids.get(playerUuid);
    }

    public DraugrRaid getRaidByWorld(class_3218 world) {
        return this.raids.get(world);
    }

    public HashMap<UUID, DraugrRaid> getAllRaids() {
        return this.raids;
    }

    public void removeRaid(UUID playerUuid) {
        if (this.raids.containsKey(playerUuid)) {
            this.raids.remove(playerUuid);
            System.out.println("[PersistentRaidData] Raid supprim\u00e9 pour le joueur : " + String.valueOf(playerUuid));
        }
    }

    public void removeRaidByRaid(DraugrRaid raid) {
        this.raids.remove(raid);
        this.method_80();
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2487 raidsNbt = new class_2487();
        for (UUID uuid : this.raids.keySet()) {
            DraugrRaid raid = this.raids.get(uuid);
            class_2487 raidNbt = new class_2487();
            raid.writeNbt(raidNbt);
            raidsNbt.method_10566(uuid.toString(), (class_2520)raidNbt);
        }
        nbt.method_10566("Raids", (class_2520)raidsNbt);
        return nbt;
    }

    public static DraugrRaidPersistentData fromNbt(class_2487 nbt, class_3218 world) {
        DraugrRaidPersistentData data = new DraugrRaidPersistentData(world);
        class_2487 raidsNbt = nbt.method_10562("Raids");
        for (String uuidStr : raidsNbt.method_10541()) {
            UUID uuid = UUID.fromString(uuidStr);
            class_2487 raidCompound = raidsNbt.method_10562(uuidStr);
            boolean raidAlreadyExists = MebahelCreaturesDraugr.ongoingRaids.stream().anyMatch(raid -> raid.raidUuid.equals(uuid));
            if (raidAlreadyExists) {
                System.out.println("Raid avec UUID " + String.valueOf(uuid) + " d\u00e9j\u00e0 pr\u00e9sent dans ongoingRaids. Ignor\u00e9.");
                continue;
            }
            if (raidCompound.method_10545("activeMobs")) {
                class_2499 activeMobsList = raidCompound.method_10554("activeMobs", 10);
                boolean hasAliveMobs = false;
                for (int i = 0; i < activeMobsList.size(); ++i) {
                    class_2487 mobCompound = activeMobsList.method_10602(i);
                    UUID mobUuid = mobCompound.method_25926("UUID");
                    class_1297 entity = world.method_14190(mobUuid);
                    if (entity != null && entity.method_5805()) {
                        hasAliveMobs = true;
                        continue;
                    }
                    System.out.println("Entit\u00e9 introuvable ou morte : " + String.valueOf(mobUuid));
                }
                if (!hasAliveMobs) {
                    System.out.println("Aucune entit\u00e9 active trouv\u00e9e pour le raid : " + String.valueOf(uuid) + ". Ignor\u00e9.");
                    continue;
                }
            } else {
                System.out.println("Aucune activeMobs list\u00e9e pour le raid : " + String.valueOf(uuid) + ". Ignor\u00e9.");
                continue;
            }
            System.out.println("- Chargement du raid pour UUID : " + String.valueOf(uuid));
            DraugrRaid raid2 = DraugrRaid.fromNbt(raidCompound, world);
            if (raid2 != null) {
                data.raids.put(uuid, raid2);
                continue;
            }
            System.out.println("Erreur : Impossible de charger le raid pour UUID : " + String.valueOf(uuid));
        }
        return data;
    }

    public static DraugrRaidPersistentData get(class_3218 world) {
        class_18.class_8645 type = new class_18.class_8645(() -> new DraugrRaidPersistentData(world), (nbt, lookup) -> DraugrRaidPersistentData.fromNbt(nbt, world), null);
        return (DraugrRaidPersistentData)world.method_17983().method_17924(type, "mebahelcreaturesdraugr_draugr_raids");
    }
}

