/*
 * Decompiled with CFR 0.152.
 */
package net.mebahelcreaturesdraugr.item.soul_gem;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.mebahelcreaturesdraugr.entity.custom.DraugrEntity;
import net.mebahelcreaturesdraugr.item.ModItems;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class DraugrAwakeningSoulGem
extends class_1792 {
    private static final String KILL_COUNT_KEY = "DraugrKills";
    private static final int MAX_KILL = 12;

    public DraugrAwakeningSoulGem(class_1792.class_1793 settings) {
        super(settings);
    }

    private static class_9279 getCustomDataComponent(class_1799 stack) {
        return (class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
    }

    private static class_9279 withKillCount(class_1799 stack, int value) {
        class_9279 current = DraugrAwakeningSoulGem.getCustomDataComponent(stack);
        class_2487 nbt = current.method_57461();
        nbt.method_10569(KILL_COUNT_KEY, value);
        return class_9279.method_57456((class_2487)nbt);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        int killCount = DraugrAwakeningSoulGem.getKillCount(stack);
        tooltip.add((class_2561)class_2561.method_43470((String)"Draugrs killed: ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)(killCount + " / 12")).method_27692(class_124.field_1054)));
        if (killCount >= 12) {
            tooltip.add((class_2561)class_2561.method_43470((String)"Filled \u2013 ready to awaken an ancient evil...").method_27692(class_124.field_1064));
        } else {
            tooltip.add((class_2561)class_2561.method_43470((String)"Absorbing draugr souls...").method_27692(class_124.field_1080));
        }
    }

    public static int getKillCount(class_1799 stack) {
        class_9279 data = DraugrAwakeningSoulGem.getCustomDataComponent(stack);
        class_2487 nbt = data.method_57461();
        return nbt.method_10550(KILL_COUNT_KEY);
    }

    public static void incrementKillCount(class_1799 stack, class_1657 player) {
        int current = DraugrAwakeningSoulGem.getKillCount(stack);
        if (current >= 12) {
            return;
        }
        stack.method_57379(class_9334.field_49628, (Object)DraugrAwakeningSoulGem.withKillCount(stack, ++current));
        player.method_31548().method_5431();
        player.field_7512.method_7623();
        if (current >= 12) {
            DraugrAwakeningSoulGem.transformToFilledGem(player, stack);
        }
    }

    private static void transformToFilledGem(class_1657 player, class_1799 originalStack) {
        class_2561 customName;
        if (player.method_37908().field_9236) {
            return;
        }
        class_1799 filled = new class_1799((class_1935)ModItems.FILLED_DRAUGR_AWAKENING_SOUL_GEM);
        if (originalStack.method_57826(class_9334.field_49631) && (customName = (class_2561)originalStack.method_57824(class_9334.field_49631)) != null) {
            filled.method_57379(class_9334.field_49631, (Object)customName);
        }
        boolean replaced = false;
        if (player.method_6047() == originalStack) {
            player.method_6122(class_1268.field_5808, filled);
            replaced = true;
        }
        if (!replaced && player.method_6079() == originalStack) {
            player.method_6122(class_1268.field_5810, filled);
            replaced = true;
        }
        if (!replaced) {
            class_1661 inv = player.method_31548();
            for (int i = 0; i < inv.method_5439(); ++i) {
                if (inv.method_5438(i) != originalStack) continue;
                inv.method_5447(i, filled);
                replaced = true;
                break;
            }
        }
        if (!replaced) {
            originalStack.method_7934(1);
            player.method_7270(filled);
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        return class_1271.method_22430((Object)player.method_5998(hand));
    }

    public static void onDraugrKilled(class_1657 player, class_1309 killedEntity) {
        class_1799 off;
        if (!(killedEntity instanceof DraugrEntity)) {
            return;
        }
        ArrayList<class_1799> validGems = new ArrayList<class_1799>();
        class_1799 main = player.method_6047();
        if (DraugrAwakeningSoulGem.isValidBaseGem(main)) {
            validGems.add(main);
        }
        if (DraugrAwakeningSoulGem.isValidBaseGem(off = player.method_6079())) {
            validGems.add(off);
        }
        for (class_1799 stack : player.method_31548().field_7547) {
            if (!DraugrAwakeningSoulGem.isValidBaseGem(stack)) continue;
            validGems.add(stack);
        }
        if (!validGems.isEmpty()) {
            Random random = new Random();
            class_1799 selected = (class_1799)validGems.get(random.nextInt(validGems.size()));
            DraugrAwakeningSoulGem.incrementKillCount(selected, player);
        }
    }

    private static boolean isValidBaseGem(class_1799 stack) {
        return !stack.method_7960() && stack.method_7909() == ModItems.DRAUGR_AWAKENING_SOUL_GEM && DraugrAwakeningSoulGem.getKillCount(stack) < 12;
    }
}

