/*
 * Decompiled with CFR 0.152.
 */
package net.mebahelcreaturesdraugr.entity.draugr;

import com.google.common.collect.Maps;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mebahelcreaturesdraugr.entity.custom.DraugrEntity;
import net.mebahelcreaturesdraugr.entity.variant.DraugrVariant;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

@Environment(value=EnvType.CLIENT)
public class DraugrModel
extends GeoModel<DraugrEntity> {
    public static final Map<DraugrVariant, class_2960> LOCATION_BY_VARIANT = (Map)class_156.method_654((Object)Maps.newEnumMap(DraugrVariant.class), map -> {
        map.put(DraugrVariant.TEMPERATE, class_2960.method_60655((String)"mebahelcreaturesdraugr", (String)"textures/entity/draugr/draugr_temperate.png"));
        map.put(DraugrVariant.COLD, class_2960.method_60655((String)"mebahelcreaturesdraugr", (String)"textures/entity/draugr/draugr_cold.png"));
        map.put(DraugrVariant.HOT, class_2960.method_60655((String)"mebahelcreaturesdraugr", (String)"textures/entity/draugr/draugr_hot.png"));
        map.put(DraugrVariant.TEMPERATE_AXE, class_2960.method_60655((String)"mebahelcreaturesdraugr", (String)"textures/entity/draugr/draugr_temperate_axe.png"));
        map.put(DraugrVariant.COLD_AXE, class_2960.method_60655((String)"mebahelcreaturesdraugr", (String)"textures/entity/draugr/draugr_cold_axe.png"));
        map.put(DraugrVariant.HOT_AXE, class_2960.method_60655((String)"mebahelcreaturesdraugr", (String)"textures/entity/draugr/draugr_hot_axe.png"));
    });

    public class_2960 getModelResource(DraugrEntity object) {
        return class_2960.method_60655((String)"mebahelcreaturesdraugr", (String)"geo/draugr.geo.json");
    }

    public class_2960 getTextureResource(DraugrEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public class_2960 getAnimationResource(DraugrEntity animatable) {
        return class_2960.method_60655((String)"mebahelcreaturesdraugr", (String)"animations/draugr.animation.json");
    }

    public void setCustomAnimations(DraugrEntity entity, long uniqueID, AnimationState<DraugrEntity> customPredicate) {
        GeoBone head = this.getBone("Head").orElse(null);
        EntityModelData extraData = (EntityModelData)customPredicate.getData(DataTickets.ENTITY_MODEL_DATA);
        float yawAngle = 0.125f * extraData.netHeadYaw() * ((float)Math.PI / 180);
        float pitchAngle = 0.125f * extraData.headPitch() * ((float)Math.PI / 180);
        if (Math.abs(yawAngle) > 0.6f) {
            yawAngle = 0.0f;
        }
        if (head != null) {
            head.setRotY(7.0f * yawAngle);
            head.setRotX(7.0f * pitchAngle);
        }
    }
}

