/*
 * Decompiled with CFR 0.152.
 */
package net.mebahelcreaturesdraugr.entity.custom;

import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.mebahelcreaturesdraugr.config.ModBonusHealthConfig;
import net.mebahelcreaturesdraugr.config.ModCombatBalancingConfig;
import net.mebahelcreaturesdraugr.config.ModSpawnRateConfig;
import net.mebahelcreaturesdraugr.entity.ai.DraugrBlockGoal;
import net.mebahelcreaturesdraugr.entity.ai.DraugrDrinkPotionGoal;
import net.mebahelcreaturesdraugr.entity.ai.DraugrSpellGoal;
import net.mebahelcreaturesdraugr.entity.ai.DraugrWightMeleeAttackGoal;
import net.mebahelcreaturesdraugr.entity.ai.util.CustomRevengeGoal;
import net.mebahelcreaturesdraugr.entity.custom.DraugrEntity;
import net.mebahelcreaturesdraugr.entity.variant.DraugrWightVariant;
import net.mebahelcreaturesdraugr.particle.ModParticles;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class DraugrWightEntity
extends DraugrEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final class_2940<Integer> COOLDOWN = class_2945.method_12791(DraugrWightEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SHOOTING = class_2945.method_12791(DraugrWightEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(DraugrWightEntity.class, (class_2941)class_2943.field_13327);

    public DraugrWightEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public boolean isShooting() {
        return (Boolean)this.field_6011.method_12789(SHOOTING);
    }

    public void setShooting(boolean shooting) {
        this.field_6011.method_12778(SHOOTING, (Object)shooting);
    }

    public void setCooldown(int cooldown) {
        this.field_6011.method_12778(COOLDOWN, (Object)cooldown);
    }

    public int getCooldown() {
        return (Integer)this.field_6011.method_12789(COOLDOWN);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(DraugrWightVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public DraugrWightVariant getWightVariant() {
        return DraugrWightVariant.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_ID_TYPE_VARIANT, (Object)0);
        builder.method_56912(COOLDOWN, (Object)80);
        builder.method_56912(SHOOTING, (Object)false);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new DraugrDrinkPotionGoal(this));
        this.field_6201.method_6277(3, (class_1352)new DraugrBlockGoal(this));
        this.field_6201.method_6277(4, (class_1352)new DraugrSpellGoal(this, 3.0f));
        this.field_6201.method_6277(5, (class_1352)new DraugrWightMeleeAttackGoal(this, 1.0, 25, 15));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, (double)0.85f, 1.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new CustomRevengeGoal((class_1314)this, DraugrEntity.class));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23716, 34.0 + (double)ModBonusHealthConfig.draugrBonusHealth).method_26868(class_5134.field_23724, 4.0).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23718, (double)0.2f).method_26868(class_5134.field_23722, 0.5);
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> animationState) {
        if (!this.getHasSpawned()) {
            return PlayState.STOP;
        }
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("transition_walk", Animation.LoopType.PLAY_ONCE).then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (!animationState.isMoving() && !this.method_6510()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attacking", 0, state -> PlayState.CONTINUE).triggerableAnim("attack", RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE)).triggerableAnim("attack2", RawAnimation.begin().then("attack2", Animation.LoopType.PLAY_ONCE)).triggerableAnim("attack_combo1", RawAnimation.begin().then("attack_combo1", Animation.LoopType.PLAY_ONCE)).triggerableAnim("attack_combo2", RawAnimation.begin().then("attack_combo2", Animation.LoopType.PLAY_ONCE)).triggerableAnim("frostbite", RawAnimation.begin().then("frostbite", Animation.LoopType.PLAY_ONCE)).triggerableAnim("block_attack", RawAnimation.begin().then("block_attack", Animation.LoopType.PLAY_ONCE)).triggerableAnim("drink_potion", RawAnimation.begin().then("drink_potion", Animation.LoopType.PLAY_ONCE)));
        controllers.add(new AnimationController((GeoAnimatable)this, "spawning", 0, state -> PlayState.CONTINUE).triggerableAnim("spawn", RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE)));
    }

    @Override
    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_6880 biome = world.method_23753(this.method_24515());
        boolean useAxeVariant = this.field_5974.method_43056();
        DraugrWightVariant variant = biome.method_40220(ConventionalBiomeTags.IS_DESERT) || biome.method_40220(ConventionalBiomeTags.IS_DRY_OVERWORLD) || biome.method_40220(ConventionalBiomeTags.IS_HOT_OVERWORLD) ? (useAxeVariant ? DraugrWightVariant.HOT_AXE : DraugrWightVariant.HOT) : (biome.method_40220(ConventionalBiomeTags.IS_COLD_OVERWORLD) || biome.method_40220(ConventionalBiomeTags.IS_SNOWY) || biome.method_40220(ConventionalBiomeTags.IS_ICY) || biome.method_40220(ConventionalBiomeTags.IS_TAIGA) ? (useAxeVariant ? DraugrWightVariant.COLD_AXE : DraugrWightVariant.COLD) : (useAxeVariant ? DraugrWightVariant.TEMPERATE_AXE : DraugrWightVariant.TEMPERATE));
        this.setVariant(variant);
        if (this.field_5974.method_43057() < ModCombatBalancingConfig.draugrSpawnWithPotionProbability / 100.0f) {
            this.giveRandomMeleePotion();
        }
        float randomScale = 1.0f + this.field_5974.method_43057() * 0.15f;
        this.setDraugrScale(randomScale);
        this.method_18382();
        return entityData;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.shouldDespawnInPeaceful()) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
        if (this.field_6012 % 7 == 0 && !this.isShooting() && !this.isSwinging()) {
            this.generateLeftHandParticles();
        }
    }

    private void generateLeftHandParticles() {
        class_243 leftHandOffset = new class_243(-0.42, 0.85, -0.075);
        class_243 lookDirection = this.method_5828(1.0f);
        class_243 leftHandPosition = this.method_19538().method_1019(lookDirection.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029().method_1021(leftHandOffset.field_1352)).method_1031(0.0, leftHandOffset.field_1351, 0.0);
        if (this.method_37908().field_9236) {
            this.method_37908().method_8406((class_2394)ModParticles.SNOWFLAKE_HAND_PARTICLE, leftHandPosition.field_1352, leftHandPosition.field_1351, leftHandPosition.field_1350, 0.0, -0.05, 0.0);
        }
    }

    public static boolean canMobSpawnWithRate(class_1299<? extends class_1588> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random, Boolean draugrCanSpawnInDark) {
        if (spawnReason == class_3730.field_16469 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16467) {
            return true;
        }
        if (draugrCanSpawnInDark.booleanValue()) {
            class_2338 blockPos = pos.method_10074();
            if (!world.method_8320(blockPos).method_26170((class_1922)world, blockPos, type)) {
                return false;
            }
            int randomValue = random.method_43048(10);
            return randomValue < ModSpawnRateConfig.draugrWightSpawnRate;
        }
        return false;
    }
}

