/*
 * Decompiled with CFR 0.152.
 */
package net.mebahelcreaturesdraugr.entity.custom;

import net.mebahelcreaturesdraugr.block.entity.custom.BlockScanEntity;
import net.mebahelcreaturesdraugr.config.ModBonusHealthConfig;
import net.mebahelcreaturesdraugr.entity.ModEntities;
import net.mebahelcreaturesdraugr.entity.ai.DraugrOverlordBlockGoal;
import net.mebahelcreaturesdraugr.entity.ai.DraugrOverlordMeleeAttackGoal;
import net.mebahelcreaturesdraugr.entity.ai.DraugrOverlordSpecialAttackGoal;
import net.mebahelcreaturesdraugr.entity.ai.DraugrOverlordSpinGoal;
import net.mebahelcreaturesdraugr.entity.ai.util.CustomRevengeGoal;
import net.mebahelcreaturesdraugr.entity.custom.DraugrEntity;
import net.mebahelcreaturesdraugr.entity.variant.DraugrOverlordVariant;
import net.mebahelcreaturesdraugr.sound.ModSounds;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class DraugrOverlordEntity
extends DraugrEntity
implements GeoEntity {
    private final class_3213 bossBar;
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int attackTick = 0;
    private boolean wantsSpin = false;
    private float damageWindowAmount = 0.0f;
    private int damageWindowTicks = 0;
    private int blockReactionCooldownTicks = 0;
    private static final int DAMAGE_WINDOW_MAX_TICKS = 40;
    private static final float DAMAGE_WINDOW_THRESHOLD_FRACTION = 0.15f;
    public static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(DraugrOverlordEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SWINGING = class_2945.method_12791(DraugrOverlordEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<String> ATTACK_NAME = class_2945.method_12791(DraugrOverlordEntity.class, (class_2941)class_2943.field_13326);
    public static final class_2940<Boolean> HAS_SPAWNED = class_2945.method_12791(DraugrOverlordEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> SPECIAL_COOLDOWN = class_2945.method_12791(DraugrOverlordEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SPECIAL = class_2945.method_12791(DraugrOverlordEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SPINNING = class_2945.method_12791(DraugrOverlordEntity.class, (class_2941)class_2943.field_13323);

    public DraugrOverlordEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6191 = -this.method_5970();
        this.bossBar = new class_3213(class_2561.method_30163((String)"Draugr Overlord"), class_1259.class_1260.field_5784, class_1259.class_1261.field_5791);
        this.bossBar.method_5408(1.0f);
        this.method_5971();
    }

    public boolean wantsSpin() {
        return this.wantsSpin;
    }

    public void requestSpin() {
        this.wantsSpin = true;
    }

    public void clearSpinRequest() {
        this.wantsSpin = false;
    }

    public int incrementAttackTick() {
        return ++this.attackTick;
    }

    public void resetAttackTick() {
        this.attackTick = 0;
    }

    public boolean getSpecial() {
        return (Boolean)this.field_6011.method_12789(SPECIAL);
    }

    public void setSpecial(boolean bool) {
        this.field_6011.method_12778(SPECIAL, (Object)bool);
    }

    public int getSpecialCooldown() {
        return (Integer)this.field_6011.method_12789(SPECIAL_COOLDOWN);
    }

    public void setSpecialCooldown(int value) {
        this.field_6011.method_12778(SPECIAL_COOLDOWN, (Object)value);
    }

    @Override
    public boolean getHasSpawned() {
        return (Boolean)this.field_6011.method_12789(HAS_SPAWNED);
    }

    @Override
    public void setHasSpawned(boolean bool) {
        this.field_6011.method_12778(HAS_SPAWNED, (Object)bool);
    }

    @Override
    public void setSwinging(boolean swinging) {
        this.field_6011.method_12778(SWINGING, (Object)swinging);
    }

    @Override
    public boolean isSwinging() {
        return (Boolean)this.field_6011.method_12789(SWINGING);
    }

    @Override
    public void setAttackName(String attackName) {
        this.field_6011.method_12778(ATTACK_NAME, (Object)attackName);
    }

    @Override
    public String getAttackName() {
        return (String)this.field_6011.method_12789(ATTACK_NAME);
    }

    public boolean isSpinning() {
        return (Boolean)this.field_6011.method_12789(SPINNING);
    }

    public void setSpinning(boolean spinning) {
        this.field_6011.method_12778(SPINNING, (Object)spinning);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SWINGING, (Object)false);
        builder.method_56912(ATTACK_NAME, (Object)"sl_attack_rush");
        builder.method_56912(DATA_ID_TYPE_VARIANT, (Object)0);
        builder.method_56912(HAS_SPAWNED, (Object)true);
        builder.method_56912(SPECIAL, (Object)false);
        builder.method_56912(SPECIAL_COOLDOWN, (Object)70);
        builder.method_56912(SPINNING, (Object)false);
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new DraugrOverlordSpinGoal(this));
        this.field_6201.method_6277(3, (class_1352)new DraugrOverlordBlockGoal(this));
        this.field_6201.method_6277(4, (class_1352)new DraugrOverlordSpecialAttackGoal(this));
        this.field_6201.method_6277(5, (class_1352)new DraugrOverlordMeleeAttackGoal(this, 0.95f));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, (double)0.85f, 1.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new CustomRevengeGoal((class_1314)this, DraugrEntity.class));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23716, 400.0 + (double)ModBonusHealthConfig.draugrOverlordBonusHealth).method_26868(class_5134.field_23724, 15.0).method_26868(class_5134.field_23721, 12.0).method_26868(class_5134.field_23718, (double)0.9f).method_26868(class_5134.field_23722, 0.5);
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> state) {
        if (!this.getHasSpawned()) {
            return PlayState.STOP;
        }
        if (state.isMoving() && !this.getSpecial() && !this.isSwinging() && !this.isSpinning()) {
            this.spawnSwordDraggingParticles();
            state.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (!(state.isMoving() || this.method_6510() || this.getSpecial() || this.isSpinning())) {
            state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attacking", 0, state -> PlayState.CONTINUE).triggerableAnim("block_attack", RawAnimation.begin().then("block_attack", Animation.LoopType.PLAY_ONCE)).triggerableAnim("sl_attack_quake", RawAnimation.begin().then("sl_attack_quake", Animation.LoopType.PLAY_ONCE)).triggerableAnim("sl_block_spin2", RawAnimation.begin().then("sl_block_spin2", Animation.LoopType.PLAY_ONCE)).triggerableAnim("sl_attack_rush", RawAnimation.begin().then("sl_attack_rush", Animation.LoopType.PLAY_ONCE)).triggerableAnim("sl_attack_double1", RawAnimation.begin().then("sl_attack_double1", Animation.LoopType.PLAY_ONCE)).triggerableAnim("sl_attack_double2", RawAnimation.begin().then("sl_attack_double2", Animation.LoopType.PLAY_ONCE)).triggerableAnim("sl_attack_triple", RawAnimation.begin().then("sl_attack_triple", Animation.LoopType.PLAY_ONCE)));
        controllers.add(new AnimationController((GeoAnimatable)this, "spawning", 0, state -> PlayState.CONTINUE).triggerableAnim("spawn", RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE)));
    }

    public DraugrOverlordVariant getOverlordVariant() {
        return DraugrOverlordVariant.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant() {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(DraugrOverlordVariant.GREATSWORD.getId() & 0xFF));
    }

    @Override
    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.setVariant();
        return entityData;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.updateBossBar();
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
        if (this.damageWindowTicks > 0) {
            --this.damageWindowTicks;
            if (this.damageWindowTicks == 0) {
                this.damageWindowAmount = 0.0f;
            }
        }
        if (this.method_29504() || this.method_31481()) {
            this.bossBar.method_14094();
        }
    }

    private void updateBossBar() {
        class_238 detectionBox = new class_238(this.method_24515()).method_1014(18.0);
        for (class_1657 player : this.method_37908().method_18456()) {
            if (!(player instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)player;
            if (detectionBox.method_1006(player.method_19538())) {
                if (this.bossBar.method_14092().contains(serverPlayer)) continue;
                this.bossBar.method_14088(serverPlayer);
                continue;
            }
            if (!this.bossBar.method_14092().contains(serverPlayer)) continue;
            this.bossBar.method_14089(serverPlayer);
        }
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
    }

    public void spawnSwordDraggingParticles() {
        if (!this.method_6039()) {
            double yawRad = Math.toRadians(-this.field_6283);
            double cosYaw = Math.cos(yawRad);
            double sinYaw = Math.sin(yawRad);
            double offsetBackX = -sinYaw;
            double offsetBackZ = -cosYaw;
            double offsetRightX = -cosYaw;
            double offsetRightZ = sinYaw;
            double particleX = this.method_23317() + offsetBackX + offsetRightX;
            double particleZ = this.method_23321() + offsetBackZ + offsetRightZ;
            double particleY = this.method_23318();
            class_2338 blockPos = new class_2338((int)particleX, (int)(particleY - 1.0), (int)particleZ);
            class_2680 blockState = this.method_37908().method_8320(blockPos);
            if (blockState.method_26215()) {
                return;
            }
            for (int i = 0; i < 1; ++i) {
                double randomOffsetX = (this.field_5974.method_43058() - 0.5) * 0.1;
                double randomOffsetZ = (this.field_5974.method_43058() - 0.5) * 0.1;
                this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), particleX + randomOffsetX, particleY, particleZ + randomOffsetZ, 0.0, 0.05, 0.0);
            }
        }
    }

    public static void AreaCrackedGround(class_1309 mob, class_1937 world, class_2338 centerPos, int radius) {
        class_2338 startPos = centerPos.method_10074();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                class_2338 targetPos = startPos.method_10069(x, -1, z);
                if (!(startPos.method_10262((class_2382)targetPos) <= (double)(radius * radius))) continue;
                class_2680 blockState = world.method_8320(targetPos);
                class_2338 spawnPos = targetPos.method_10084();
                DraugrOverlordEntity.spawnBlockScanEntity(world, spawnPos, blockState, mob.method_59922());
            }
        }
    }

    public static void spawnBlockScanEntity(class_1937 world, class_2338 pos, class_2680 blockState, class_5819 random) {
        BlockScanEntity blockScanEntity = new BlockScanEntity(ModEntities.BLOCK_SCAN_ENTITY, world);
        float randomYOffset = random.method_43057() * 0.2f + 0.2f;
        blockScanEntity.method_5814(pos.method_10263(), (double)pos.method_10264() - 0.5 + (double)randomYOffset, pos.method_10260());
        blockScanEntity.setBlockState(blockState);
        float randomPitch = random.method_43057() * 40.0f - 20.0f;
        float randomYaw = random.method_43057() * 40.0f - 20.0f;
        blockScanEntity.method_36457(randomPitch);
        blockScanEntity.method_36456(randomYaw);
        world.method_8649((class_1297)blockScanEntity);
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(ModSounds.DRAUGR_WALK_1, 0.65f, 0.7f);
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        boolean result = super.method_5643(source, amount);
        if (!this.method_37908().field_9236 && result && amount > 0.0f && !this.method_29504()) {
            this.handleBurstDamage(source, amount);
        }
        return result;
    }

    private void handleBurstDamage(class_1282 source, float amount) {
        if (this.method_6039() || this.wantsToBlock() || this.isSpinning() || this.getSpecial()) {
            return;
        }
        if (this.blockReactionCooldownTicks > 0) {
            return;
        }
        if (this.damageWindowTicks <= 0) {
            this.damageWindowTicks = 40;
            this.damageWindowAmount = 0.0f;
        }
        this.damageWindowAmount += amount;
        float threshold = this.method_6063() * 0.15f;
        if (this.damageWindowAmount >= threshold) {
            this.requestBlock();
            this.damageWindowAmount = 0.0f;
            this.damageWindowTicks = 0;
            this.blockReactionCooldownTicks = 80;
        }
    }
}

