/*
 * Decompiled with CFR 0.152.
 */
package net.mebahelcreaturesdraugr.entity.custom;

import java.util.Objects;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.mebahelcreaturesdraugr.config.ModBonusHealthConfig;
import net.mebahelcreaturesdraugr.config.ModCombatBalancingConfig;
import net.mebahelcreaturesdraugr.config.ModSpawnRateConfig;
import net.mebahelcreaturesdraugr.entity.ai.DraugrBlockGoal;
import net.mebahelcreaturesdraugr.entity.ai.DraugrDrinkPotionGoal;
import net.mebahelcreaturesdraugr.entity.ai.DraugrMeleeAttackGoal;
import net.mebahelcreaturesdraugr.entity.ai.util.CustomRevengeGoal;
import net.mebahelcreaturesdraugr.entity.variant.DraugrVariant;
import net.mebahelcreaturesdraugr.sound.ModSounds;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class DraugrEntity
extends class_1588
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final class_2940<Integer> POTION_TYPE = class_2945.method_12791(DraugrEntity.class, (class_2941)class_2943.field_13327);
    public static final int POTION_NONE = 0;
    public static final int POTION_HEAL = 1;
    public static final int POTION_STRENGTH = 2;
    public static final int POTION_RESISTANCE = 3;
    public static final int POTION_SPEED = 4;
    public static final int POTION_INVISIBILITY = 5;
    private boolean wantsToDrinkPotion = false;
    private boolean wantsToBlock = false;
    public static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(DraugrEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SWINGING = class_2945.method_12791(DraugrEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> IS_PART_OF_RAID = class_2945.method_12791(DraugrEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<String> ATTACK_NAME = class_2945.method_12791(DraugrEntity.class, (class_2941)class_2943.field_13326);
    public static final class_2940<Boolean> HAS_SPAWNED = class_2945.method_12791(DraugrEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> BLOCKING = class_2945.method_12791(DraugrEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> HAS_HEAL_POTION = class_2945.method_12791(DraugrEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> USING_POTION = class_2945.method_12791(DraugrEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> HEAL_TICKS = class_2945.method_12791(DraugrEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Float> SCALE = class_2945.method_12791(DraugrEntity.class, (class_2941)class_2943.field_13320);
    public double speed;

    public DraugrEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6191 = -this.method_5970();
        this.speed = Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6194();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void setPotionType(int type) {
        this.field_6011.method_12778(POTION_TYPE, (Object)type);
    }

    public int getPotionType() {
        return (Integer)this.field_6011.method_12789(POTION_TYPE);
    }

    public void setHasPotion(boolean value) {
        this.field_6011.method_12778(HAS_HEAL_POTION, (Object)value);
    }

    public boolean hasPotion() {
        return (Boolean)this.field_6011.method_12789(HAS_HEAL_POTION);
    }

    public boolean wantsToDrinkPotion() {
        return this.wantsToDrinkPotion;
    }

    public void requestPotionUse() {
        this.wantsToDrinkPotion = true;
    }

    public void clearPotionUseRequest() {
        this.wantsToDrinkPotion = false;
    }

    public boolean wantsToBlock() {
        return this.wantsToBlock;
    }

    public void requestBlock() {
        this.wantsToBlock = true;
    }

    public void clearBlockRequest() {
        this.wantsToBlock = false;
    }

    public boolean shouldDespawnInPeaceful() {
        return this.method_37908().method_8407() == class_1267.field_5801;
    }

    public void setHealTicks(int value) {
        this.field_6011.method_12778(HEAL_TICKS, (Object)value);
    }

    public int getHealTicks() {
        return (Integer)this.field_6011.method_12789(HEAL_TICKS);
    }

    public boolean isUsingPotion() {
        return (Boolean)this.field_6011.method_12789(USING_POTION);
    }

    public void setUsingPotion(boolean value) {
        this.field_6011.method_12778(USING_POTION, (Object)value);
    }

    public void setBlocking(boolean blocking) {
        this.field_6011.method_12778(BLOCKING, (Object)blocking);
    }

    public boolean method_6039() {
        return (Boolean)this.field_6011.method_12789(BLOCKING);
    }

    public boolean getHasSpawned() {
        return (Boolean)this.field_6011.method_12789(HAS_SPAWNED);
    }

    public void setHasSpawned(boolean bool) {
        this.field_6011.method_12778(HAS_SPAWNED, (Object)bool);
    }

    public boolean isPartOfRaid() {
        return (Boolean)this.field_6011.method_12789(IS_PART_OF_RAID);
    }

    public void setPartOfRaid(Boolean isPartOfRaid) {
        this.field_6011.method_12778(IS_PART_OF_RAID, (Object)isPartOfRaid);
    }

    public void setSwinging(boolean swinging) {
        this.field_6011.method_12778(SWINGING, (Object)swinging);
    }

    public boolean isSwinging() {
        return (Boolean)this.field_6011.method_12789(SWINGING);
    }

    public void setAttackName(String attackName) {
        this.field_6011.method_12778(ATTACK_NAME, (Object)attackName);
    }

    public String getAttackName() {
        return (String)this.field_6011.method_12789(ATTACK_NAME);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SWINGING, (Object)false);
        builder.method_56912(DATA_ID_TYPE_VARIANT, (Object)0);
        builder.method_56912(IS_PART_OF_RAID, (Object)false);
        builder.method_56912(ATTACK_NAME, (Object)"attack");
        builder.method_56912(HAS_SPAWNED, (Object)true);
        builder.method_56912(BLOCKING, (Object)false);
        builder.method_56912(HAS_HEAL_POTION, (Object)false);
        builder.method_56912(USING_POTION, (Object)false);
        builder.method_56912(POTION_TYPE, (Object)0);
        builder.method_56912(HEAL_TICKS, (Object)0);
        builder.method_56912(SCALE, (Object)Float.valueOf(1.0f));
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new DraugrDrinkPotionGoal(this));
        this.field_6201.method_6277(3, (class_1352)new DraugrBlockGoal(this));
        this.field_6201.method_6277(4, (class_1352)new DraugrMeleeAttackGoal(this, 1.0, 25, 15, 10));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, (double)0.85f, 1.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new CustomRevengeGoal((class_1314)this, DraugrEntity.class));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23716, 30.0 + (double)ModBonusHealthConfig.draugrBonusHealth).method_26868(class_5134.field_23724, 6.0).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23718, (double)0.2f).method_26868(class_5134.field_23722, 0.5);
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> animationState) {
        if (!this.getHasSpawned()) {
            return PlayState.STOP;
        }
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("transition_walk", Animation.LoopType.PLAY_ONCE).then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (!animationState.isMoving() && !this.method_6510()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attacking", 0, state -> PlayState.CONTINUE).triggerableAnim("attack", RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE)).triggerableAnim("attack2", RawAnimation.begin().then("attack2", Animation.LoopType.PLAY_ONCE)).triggerableAnim("attack_combo1", RawAnimation.begin().then("attack_combo1", Animation.LoopType.PLAY_ONCE)).triggerableAnim("attack_combo2", RawAnimation.begin().then("attack_combo2", Animation.LoopType.PLAY_ONCE)).triggerableAnim("block_attack", RawAnimation.begin().then("block_attack", Animation.LoopType.PLAY_ONCE)).triggerableAnim("drink_potion", RawAnimation.begin().then("drink_potion", Animation.LoopType.PLAY_ONCE)));
        controllers.add(new AnimationController((GeoAnimatable)this, "spawning", 0, state -> PlayState.CONTINUE).triggerableAnim("spawn", RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE)));
    }

    public DraugrVariant getVariant() {
        return DraugrVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(DraugrVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_6880 biome = world.method_23753(this.method_24515());
        boolean useAxeVariant = this.field_5974.method_43056();
        DraugrVariant variant = biome.method_40220(ConventionalBiomeTags.IS_DESERT) || biome.method_40220(ConventionalBiomeTags.IS_DRY_OVERWORLD) || biome.method_40220(ConventionalBiomeTags.IS_HOT_OVERWORLD) ? (useAxeVariant ? DraugrVariant.HOT_AXE : DraugrVariant.HOT) : (biome.method_40220(ConventionalBiomeTags.IS_COLD_OVERWORLD) || biome.method_40220(ConventionalBiomeTags.IS_SNOWY) || biome.method_40220(ConventionalBiomeTags.IS_ICY) || biome.method_40220(ConventionalBiomeTags.IS_TAIGA) ? (useAxeVariant ? DraugrVariant.COLD_AXE : DraugrVariant.COLD) : (useAxeVariant ? DraugrVariant.TEMPERATE_AXE : DraugrVariant.TEMPERATE));
        this.setVariant(variant);
        if (this.field_5974.method_43057() < ModCombatBalancingConfig.draugrSpawnWithPotionProbability / 100.0f) {
            this.giveRandomMeleePotion();
        }
        float randomScale = 1.0f + this.field_5974.method_43057() * 0.15f;
        this.setDraugrScale(randomScale);
        this.method_18382();
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected class_4048 method_55694(class_4050 pose) {
        float scale = this.getDraugrScale();
        return super.method_55694(pose).method_18383(scale);
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        if (SCALE.equals(data)) {
            this.method_18382();
        }
    }

    public float getDraugrScale() {
        return ((Float)this.field_6011.method_12789(SCALE)).floatValue();
    }

    public void setDraugrScale(float scale) {
        this.field_6011.method_12778(SCALE, (Object)Float.valueOf(scale));
    }

    public void giveRandomMeleePotion() {
        int roll = this.field_5974.method_43048(3);
        this.setPotionType(switch (roll) {
            case 0 -> 1;
            case 1 -> 2;
            default -> 3;
        });
        this.setHasPotion(true);
    }

    protected class_3414 method_6011(class_1282 source) {
        double rand = Math.random();
        if (rand < 0.25) {
            return ModSounds.DRAUGR_HURT_1;
        }
        if (rand < 0.5) {
            return ModSounds.DRAUGR_HURT_2;
        }
        if (rand < 0.75) {
            return ModSounds.DRAUGR_HURT_3;
        }
        return ModSounds.DRAUGR_HURT_4;
    }

    protected class_3414 method_6002() {
        return ModSounds.DRAUGR_DEATH_1;
    }

    protected class_3414 method_5994() {
        double rand = Math.random();
        if (rand < 0.2) {
            return ModSounds.DRAUGR_AMBIENT_1;
        }
        if (rand < 0.4) {
            return ModSounds.DRAUGR_AMBIENT_2;
        }
        if (rand < 0.6) {
            return ModSounds.DRAUGR_AMBIENT_3;
        }
        if (rand < 0.8) {
            return ModSounds.DRAUGR_AMBIENT_4;
        }
        return ModSounds.DRAUGR_AMBIENT_5;
    }

    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        if (soundEvent != null) {
            this.method_5783(soundEvent, 0.8f, 1.0f);
        }
    }

    public int method_5970() {
        return 160 + this.method_59922().method_43048(60);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_6039()) {
            if (!this.method_37908().field_9236) {
                class_3218 serverWorld = (class_3218)this.method_37908();
                serverWorld.method_14199((class_2394)class_2398.field_11205, this.method_23317(), this.method_23323(0.5), this.method_23321(), 8, 0.5, 0.8, 0.5, 0.2);
            }
            this.method_5783(ModSounds.WEAPON_SWORD_BLOCK, 0.75f + this.method_59922().method_43057() * 0.2f, 0.8f + this.method_59922().method_43057() * 0.4f);
            return false;
        }
        if (source.method_49708(class_8111.field_42335) || source.method_49708(class_8111.field_42337)) {
            return super.method_5643(source, amount * 2.0f);
        }
        if (source.method_49708(class_8111.field_42354)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public void method_5773() {
        super.method_5773();
        if (this.shouldDespawnInPeaceful()) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
        if (this.isPartOfRaid() && this.field_6012 >= 1000 && !this.method_5851()) {
            this.method_5834(true);
        }
        if (!this.getHasSpawned()) {
            this.spawnHoveringParticles();
        }
        if (this.field_6012 == 1 && !this.getHasSpawned()) {
            this.triggerAnim("spawning", "spawn");
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.0);
            this.method_5783(ModSounds.MUMMY_SPAWN, 0.75f + this.method_59922().method_43057() * 0.2f, 0.8f + this.method_59922().method_43057() * 0.4f);
        } else if (this.field_6012 == 40 && !this.getHasSpawned()) {
            this.setHasSpawned(true);
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(this.speed);
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getTypeVariant());
        nbt.method_10556("PartOfRaid", this.isPartOfRaid());
        nbt.method_10569("PotionType", this.getPotionType());
        nbt.method_10556("HasPotion", this.hasPotion());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)nbt.method_10550("Variant"));
        this.field_6011.method_12778(IS_PART_OF_RAID, (Object)nbt.method_10577("PartOfRaid"));
        this.field_6011.method_12778(HAS_SPAWNED, (Object)true);
        if (nbt.method_10545("PotionType")) {
            this.setPotionType(nbt.method_10550("PotionType"));
        }
        if (nbt.method_10545("HasPotion")) {
            this.setHasPotion(nbt.method_10577("HasPotion"));
        }
    }

    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
    }

    public static boolean canMobSpawnWithRate(class_1299<? extends class_1588> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random, Boolean draugrCanSpawnInDark) {
        if (spawnReason == class_3730.field_16469 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16467) {
            return true;
        }
        if (draugrCanSpawnInDark.booleanValue()) {
            class_2338 blockPos = pos.method_10074();
            if (!world.method_8320(blockPos).method_26170((class_1922)world, blockPos, type)) {
                return false;
            }
            int randomValue = random.method_43048(10);
            return randomValue < ModSpawnRateConfig.draugrSpawnRate;
        }
        return false;
    }

    void spawnHoveringParticles() {
        double posX = this.method_23317();
        double posY = this.method_23318() - 0.1;
        double posZ = this.method_23321();
        class_2338 blockPos = new class_2338((int)posX, (int)(this.method_23318() - 0.5), (int)posZ);
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        if (!blockState.method_26215()) {
            for (int i = 0; i < 3; ++i) {
                double offsetX = (this.field_5974.method_43058() - 0.5) * 0.1;
                double offsetZ = (this.field_5974.method_43058() - 0.5) * 0.1;
                double velocityY = 0.1;
                this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), posX + offsetX, posY, posZ + offsetZ, 0.0, velocityY, 0.0);
            }
        }
    }

    public void giveRandomRangedPotion() {
        int roll = this.field_5974.method_43048(2);
        int type = roll == 0 ? 4 : 5;
        this.setPotionType(type);
        this.setHasPotion(true);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(ModSounds.DRAUGR_WALK_1, 0.4f + this.method_59922().method_43057() * 0.2f, 0.9f + this.method_59922().method_43057() * 0.4f);
    }
}

