/*
 * Decompiled with CFR 0.152.
 */
package net.mebahelcreaturesdraugr.entity.ai;

import java.util.EnumSet;
import java.util.Objects;
import net.mebahelcreaturesdraugr.entity.custom.DraugrEntity;
import net.mebahelcreaturesdraugr.entity.custom.DraugrOverlordEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class DraugrOverlordSpinGoal
extends class_1352 {
    private final DraugrOverlordEntity mob;
    private static final int SPIN_TOTAL_TICKS = 60;
    private static final int SPIN_DASH_TICK = 15;
    private static final int DASH_END_TICK = 35;
    private static final double DASH_POWER = 2.8;
    private static final int AOE_T1 = 18;
    private static final int AOE_T2 = 22;
    private static final int AOE_T3 = 28;
    private static final int AOE_T4 = 34;
    private static final int AOE_T5 = 38;
    private int spinTicks = 0;
    private final double originalSpeed = 0.3;
    private boolean hasDashed = false;
    private class_243 dashDirection = class_243.field_1353;

    public DraugrOverlordSpinGoal(DraugrOverlordEntity mob) {
        this.mob = mob;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (!this.mob.wantsSpin()) {
            return false;
        }
        if (this.mob.isSpinning()) {
            return false;
        }
        class_1309 target = this.mob.method_5968();
        return target != null && target.method_5805();
    }

    public boolean method_6266() {
        class_1309 target = this.mob.method_5968();
        if (target == null || !target.method_5805()) {
            return false;
        }
        return this.spinTicks > 0 && this.spinTicks < 60 && this.mob.isSpinning();
    }

    public void method_6269() {
        this.spinTicks = 0;
        this.hasDashed = false;
        this.dashDirection = class_243.field_1353;
        this.mob.method_19540(true);
        this.mob.setSwinging(false);
        this.mob.setBlocking(false);
        this.mob.clearBlockRequest();
        this.mob.setSpinning(true);
        this.mob.clearSpinRequest();
        Objects.requireNonNull(this.mob.method_5996(class_5134.field_23719)).method_6192(0.0);
        this.mob.method_5942().method_6340();
        this.mob.method_5962().method_6243(0.0f, 0.0f);
        this.mob.triggerAnim("attacking", "sl_block_spin2");
    }

    public void method_6270() {
        this.mob.setSpinning(false);
        this.mob.method_19540(false);
        this.mob.setSwinging(false);
        Objects.requireNonNull(this.mob.method_5996(class_5134.field_23719)).method_6192(0.3);
        this.mob.method_5942().method_6340();
        this.mob.method_5962().method_6243(0.0f, 0.0f);
        this.mob.method_18800(0.0, this.mob.method_18798().field_1351, 0.0);
        this.spinTicks = 0;
        this.hasDashed = false;
        this.dashDirection = class_243.field_1353;
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        class_1309 target = this.mob.method_5968();
        if (target == null || !target.method_5805()) {
            this.method_6270();
            return;
        }
        ++this.spinTicks;
        if (this.spinTicks < 15) {
            this.mob.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
            this.mob.method_5942().method_6340();
            this.mob.method_18800(0.0, this.mob.method_18798().field_1351, 0.0);
        } else if (this.spinTicks == 15 && !this.hasDashed) {
            this.dashTowardLastKnownPosition(target, 2.8);
            this.hasDashed = true;
        } else {
            this.mob.method_5942().method_6340();
            if (this.hasDashed && this.spinTicks <= 35 && !this.dashDirection.equals((Object)class_243.field_1353)) {
                class_243 extra = this.dashDirection.method_1021(0.25);
                this.mob.method_5762(extra.field_1352, 0.0, extra.field_1350);
                this.mob.field_6007 = true;
            }
        }
        if (this.spinTicks == 18 || this.spinTicks == 22 || this.spinTicks == 28 || this.spinTicks == 34 || this.spinTicks == 38) {
            this.performSpinAoe(4.0, 0.8f);
        }
        if (this.spinTicks >= 60) {
            this.method_6270();
        }
    }

    private void dashTowardLastKnownPosition(class_1309 target, double power) {
        class_243 dir;
        this.dashDirection = dir = target.method_19538().method_1020(this.mob.method_19538()).method_1029();
        float yaw = (float)(class_3532.method_15349((double)dir.field_1350, (double)dir.field_1352) * 57.29577951308232) - 90.0f;
        this.mob.method_36456(yaw);
        this.mob.method_5847(yaw);
        this.mob.method_5636(yaw);
        this.mob.field_5982 = yaw;
        this.mob.field_6220 = yaw;
        class_243 dash = new class_243((double)(-class_3532.method_15374((float)(this.mob.method_36454() * ((float)Math.PI / 180)))) * power, 0.05, (double)class_3532.method_15362((float)(this.mob.method_36454() * ((float)Math.PI / 180))) * power);
        this.mob.method_5762(dash.field_1352, dash.field_1351, dash.field_1350);
        this.mob.field_6007 = true;
    }

    private void performSpinAoe(double radius, float damageMultiplier) {
        class_1937 world = this.mob.method_37908();
        if (world.method_8608()) {
            return;
        }
        double baseDamage = this.mob.method_45325(class_5134.field_23721);
        float aoeDamage = (float)(baseDamage * (double)damageMultiplier);
        world.method_8333((class_1297)this.mob, this.mob.method_5829().method_1014(radius), e -> {
            class_1309 le;
            return e instanceof class_1309 && (le = (class_1309)e).method_5805() && le != this.mob && !(e instanceof DraugrEntity);
        }).forEach(entity -> {
            class_1309 nearby = (class_1309)entity;
            nearby.method_5643(world.method_48963().method_48812((class_1309)this.mob), aoeDamage);
            class_243 push = nearby.method_19538().method_1020(this.mob.method_19538()).method_1029().method_1021(0.35);
            nearby.method_5762(push.field_1352, 0.15, push.field_1350);
            world.method_8406((class_2394)class_2398.field_11227, nearby.method_23317(), nearby.method_23323(0.5), nearby.method_23321(), 0.0, 0.05, 0.0);
        });
    }
}

