/*
 * Decompiled with CFR 0.152.
 */
package net.mebahelcreaturesdraugr.entity.ai;

import java.util.List;
import java.util.Objects;
import net.mebahelcreaturesdraugr.entity.ModEntities;
import net.mebahelcreaturesdraugr.entity.custom.DraugrEntity;
import net.mebahelcreaturesdraugr.entity.custom.DraugrOverlordEntity;
import net.mebahelcreaturesdraugr.sound.ModSounds;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public class DraugrOverlordSpecialAttackGoal
extends class_1352 {
    private final DraugrOverlordEntity overlord;

    public DraugrOverlordSpecialAttackGoal(DraugrOverlordEntity overlord) {
        this.overlord = overlord;
    }

    public boolean method_6264() {
        class_1657 playerEntity;
        class_1309 livingEntity = this.overlord.method_5968();
        if (livingEntity instanceof class_1657 && ((playerEntity = (class_1657)livingEntity).method_7337() || playerEntity.method_7325())) {
            return false;
        }
        return livingEntity != null && livingEntity.method_5805() && !this.overlord.method_6039() && !this.overlord.isSpinning();
    }

    public void method_6269() {
        if (this.overlord.getSpecialCooldown() < 60) {
            this.overlord.setSpecialCooldown(60);
        }
    }

    public void method_6270() {
        Objects.requireNonNull(this.overlord.method_5996(class_5134.field_23719)).method_6192(this.overlord.speed);
        this.overlord.setSpecial(false);
        this.overlord.setSpecialCooldown(80 + this.overlord.method_59922().method_43048(40));
    }

    public boolean method_6266() {
        class_1657 playerEntity;
        class_1309 livingEntity = this.overlord.method_5968();
        if (livingEntity instanceof class_1657 && ((playerEntity = (class_1657)livingEntity).method_7337() || playerEntity.method_7325())) {
            return false;
        }
        return livingEntity != null && livingEntity.method_5805() && this.overlord.getSpecialCooldown() != 0 && !this.overlord.method_6039() && !this.overlord.isSpinning();
    }

    public void method_6268() {
        if (!this.overlord.isSwinging()) {
            this.overlord.setSpecialCooldown(this.overlord.getSpecialCooldown() - 1);
        }
        switch (this.overlord.getSpecialCooldown()) {
            case 0: {
                this.method_6270();
                break;
            }
            case 4: {
                if (this.overlord.method_59922().method_43048(2) != 0) break;
                if (this.overlord.method_59922().method_43056()) {
                    this.overlord.method_5783(ModSounds.DRAUGR_TAUNT_1, 1.0f, 1.0f);
                    break;
                }
                this.overlord.method_5783(ModSounds.DRAUGR_TAUNT_2, 1.0f, 1.0f);
                break;
            }
            case 10: {
                this.executeSpecialAttack(10, 1.0f);
                DraugrOverlordEntity.AreaCrackedGround((class_1309)this.overlord, this.overlord.method_37908(), this.overlord.method_24515(), 12);
                this.overlord.method_5783(ModSounds.WEAPON_GROUND_IMPACT, 1.0f, 0.8f);
                this.spawnReinforcements(10);
                break;
            }
            case 17: {
                this.executeSpecialAttack(6, 0.3f);
                DraugrOverlordEntity.AreaCrackedGround((class_1309)this.overlord, this.overlord.method_37908(), this.overlord.method_24515(), 6);
                this.overlord.method_5783(ModSounds.WEAPON_CRACKED_GROUND, 1.0f, 0.8f);
                break;
            }
            case 25: {
                Objects.requireNonNull(this.overlord.method_5996(class_5134.field_23719)).method_6192(0.0);
                this.overlord.triggerAnim("attacking", "sl_attack_quake");
                this.overlord.setSpecial(true);
            }
        }
    }

    private void executeSpecialAttack(int radius, float velocity) {
        List entities = this.overlord.method_37908().method_8390(class_1309.class, this.overlord.method_5829().method_1014((double)radius), entity -> !(entity instanceof DraugrEntity) && entity.method_5805());
        for (class_1309 entity2 : entities) {
            double deltaZ;
            entity2.method_5643(this.overlord.method_37908().method_48963().method_48812((class_1309)this.overlord), 20.0f);
            entity2.method_6092(new class_1293(class_1294.field_5909, 120, 2));
            double deltaX = entity2.method_23317() - this.overlord.method_23317();
            double distance = Math.sqrt(deltaX * deltaX + (deltaZ = entity2.method_23321() - this.overlord.method_23321()) * deltaZ);
            if (!(distance > 0.0)) continue;
            entity2.method_18800(0.0, (double)velocity, 0.0);
        }
    }

    private void spawnReinforcements(int radius) {
        class_1937 world = this.overlord.method_37908();
        if (world.field_9236) {
            return;
        }
        float hpRatio = this.overlord.method_6032() / this.overlord.method_6063();
        class_5819 random = this.overlord.method_59922();
        int count = hpRatio > 0.7f ? (random.method_43056() ? 1 : 0) : (hpRatio > 0.4f ? 1 : 1 + random.method_43048(2));
        if (count <= 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            float roll = random.method_43057();
            Object entityType = hpRatio > 0.7f ? ModEntities.DRAUGR : (hpRatio > 0.4f ? (roll < 0.5f ? ModEntities.DRAUGR : (roll < 0.8f ? ModEntities.DRAUGR_WIGHT : ModEntities.DRAUGR_SCOURGE)) : (roll < 0.25f ? ModEntities.DRAUGR : (roll < 0.65f ? ModEntities.DRAUGR_WIGHT : ModEntities.DRAUGR_SCOURGE)));
            DraugrEntity draugr = (DraugrEntity)entityType.method_5883(world);
            if (draugr == null) continue;
            double angle = random.method_43058() * Math.PI * 2.0;
            double distance = 2.0 + random.method_43058() * (double)(radius - 2);
            double x = this.overlord.method_23317() + Math.cos(angle) * distance;
            double z = this.overlord.method_23321() + Math.sin(angle) * distance;
            double y = this.overlord.method_23318();
            class_2338 spawnPos = new class_2338((int)x, (int)y, (int)z);
            draugr.method_5808(x, y, z, random.method_43057() * 360.0f, 0.0f);
            draugr.method_5943((class_5425)world, world.method_8404(spawnPos), class_3730.field_16471, null);
            draugr.setHasSpawned(false);
            world.method_8649((class_1297)draugr);
            class_1309 target = this.overlord.method_5968();
            if (target == null) continue;
            draugr.method_5980(target);
        }
    }
}

