/*
 * Decompiled with CFR 0.152.
 */
package net.mebahelcreaturesdraugr.entity.ai;

import java.util.EnumSet;
import java.util.Objects;
import net.mebahelcreaturesdraugr.config.ModCombatBalancingConfig;
import net.mebahelcreaturesdraugr.entity.custom.DraugrEntity;
import net.mebahelcreaturesdraugr.sound.ModSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class DraugrMeleeAttackGoal
extends class_1352 {
    protected final DraugrEntity mob;
    private final double speed;
    private final int max_cooldown;
    private final int damage_time;
    private final int dash_time;
    private int cooldown;
    private boolean hasDashed = false;
    private final double originalSpeed = 0.3;
    private int attackTicks = 0;
    private AttackVariant currentAttack = AttackVariant.NONE;
    private static final int COMBO1_DURATION = 44;
    private static final int COMBO1_HIT_1_TICK = 10;
    private static final int COMBO1_HIT_2_TICK = 31;
    private static final int COMBO2_DURATION = 50;
    private static final int COMBO2_HIT_1_TICK = 11;
    private static final int COMBO2_HIT_2_TICK = 33;
    private static final double ATTACK_RANGE = 5.0;

    public DraugrMeleeAttackGoal(DraugrEntity mob, double speed, int max_cooldown, int damage_time, int dash_time) {
        this.mob = mob;
        this.speed = speed;
        this.max_cooldown = max_cooldown;
        this.damage_time = damage_time;
        this.cooldown = this.max_cooldown + 1;
        this.dash_time = dash_time;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1657 player;
        class_1309 target = this.mob.method_5968();
        if (target instanceof class_1657 && ((player = (class_1657)target).method_7337() || player.method_7325())) {
            return false;
        }
        return target != null && target.method_5805() && this.mob.getHasSpawned();
    }

    public boolean method_6266() {
        class_1657 player;
        class_1309 target = this.mob.method_5968();
        if (target instanceof class_1657 && ((player = (class_1657)target).method_7337() || player.method_7325())) {
            return false;
        }
        return target != null && target.method_5805() && this.mob.getHasSpawned();
    }

    public void method_6269() {
        this.mob.method_19540(true);
        this.hasDashed = false;
        this.currentAttack = AttackVariant.NONE;
        this.attackTicks = 0;
        this.mob.setBlocking(false);
        this.mob.setUsingPotion(false);
        this.mob.clearBlockRequest();
        this.mob.clearPotionUseRequest();
        class_1309 target = this.mob.method_5968();
        if (target != null) {
            this.mob.method_5942().method_6335((class_1297)target, this.speed);
        }
    }

    public void method_6270() {
        this.mob.method_19540(false);
        this.mob.setSwinging(false);
        this.hasDashed = false;
        this.currentAttack = AttackVariant.NONE;
        this.attackTicks = 0;
        this.mob.setHealTicks(0);
        this.mob.setBlocking(false);
        this.mob.setUsingPotion(false);
        this.mob.clearBlockRequest();
        this.mob.clearPotionUseRequest();
        Objects.requireNonNull(this.mob.method_5996(class_5134.field_23719)).method_6192(0.3);
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        if (this.mob.isUsingPotion() || this.mob.getHealTicks() > 0) {
            this.mob.setSwinging(false);
            this.mob.method_5942().method_6340();
            return;
        }
        class_1309 target = this.mob.method_5968();
        if (target != null && target.method_5805()) {
            this.mob.method_5988().method_6226((class_1297)target, 15.0f, 15.0f);
            this.attack(target);
        } else {
            this.method_6270();
        }
    }

    protected void attack(class_1309 target) {
        if (this.mob.method_6039() || this.mob.isUsingPotion()) {
            this.mob.setSwinging(false);
            return;
        }
        float hpRatio = this.mob.method_6032() / this.mob.method_6063();
        if (this.shouldRequestPotion(hpRatio)) {
            this.mob.requestPotionUse();
            this.mob.setSwinging(false);
            this.hasDashed = false;
            this.currentAttack = AttackVariant.NONE;
            this.attackTicks = 0;
            Objects.requireNonNull(this.mob.method_5996(class_5134.field_23719)).method_6192(0.3);
            return;
        }
        double squaredDistance = this.mob.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        if (!this.mob.isSwinging() && this.cooldown > 0) {
            this.cooldown = Math.max(this.cooldown - 1, 0);
        }
        if (!this.mob.isSwinging()) {
            class_1324 attr = Objects.requireNonNull(this.mob.method_5996(class_5134.field_23719));
            if (attr.method_6201() == 0.0) {
                attr.method_6192(0.3);
            }
            this.mob.method_5942().method_6335((class_1297)target, this.speed);
        }
        if (this.mob.isSwinging()) {
            class_243 dir = target.method_19538().method_1020(this.mob.method_19538()).method_1029();
            float yaw = (float)(class_3532.method_15349((double)dir.field_1350, (double)dir.field_1352) * 57.29577951308232) - 90.0f;
            this.mob.method_36456(yaw);
            this.mob.method_5847(yaw);
            this.mob.field_5982 = yaw;
        }
        if (!this.mob.isSwinging() && squaredDistance <= 6.0 && this.cooldown == 0) {
            this.startNewAttackPattern();
        }
        if (this.mob.isSwinging()) {
            ++this.attackTicks;
            switch (this.currentAttack.ordinal()) {
                case 1: 
                case 2: {
                    this.handleSimpleAttack(target);
                    break;
                }
                case 3: {
                    this.handleCombo1(target);
                    break;
                }
                case 4: {
                    this.handleCombo2(target);
                    break;
                }
                case 0: {
                    this.endAttack(target);
                }
            }
        }
    }

    private void startNewAttackPattern() {
        this.mob.setSwinging(true);
        this.hasDashed = false;
        this.attackTicks = 0;
        Objects.requireNonNull(this.mob.method_5996(class_5134.field_23719)).method_6192(0.0);
        double r = Math.random();
        if (r < 0.3) {
            this.currentAttack = AttackVariant.SIMPLE1;
            this.mob.setAttackName("attack");
        } else if (r < 0.6) {
            this.currentAttack = AttackVariant.SIMPLE2;
            this.mob.setAttackName("attack2");
        } else if (r < 0.8) {
            this.currentAttack = AttackVariant.COMBO1;
            this.mob.setAttackName("attack_combo1");
        } else {
            this.currentAttack = AttackVariant.COMBO2;
            this.mob.setAttackName("attack_combo2");
        }
        this.mob.triggerAnim("attacking", this.mob.getAttackName());
        this.cooldown = this.max_cooldown;
    }

    private void handleSimpleAttack(class_1309 target) {
        double distSq = this.mob.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        if (this.attackTicks == this.damage_time - 4) {
            this.dashToward(target, 0.8);
        }
        if (this.attackTicks == this.damage_time) {
            if (distSq <= 6.0) {
                this.mob.method_6121((class_1297)target);
            }
            this.playSwingSound();
        }
        if (this.attackTicks >= this.max_cooldown) {
            this.endAttack(target);
        }
    }

    private void handleCombo1(class_1309 target) {
        double distSq = this.mob.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        if (this.attackTicks == 6 || this.attackTicks == 27) {
            this.dashToward(target, 0.8);
        }
        if (this.attackTicks == 10) {
            if (distSq <= 6.0) {
                this.mob.method_6121((class_1297)target);
            }
            this.playSwingSound();
        }
        if (this.attackTicks == 31) {
            if (distSq <= 6.0) {
                this.mob.method_6121((class_1297)target);
            }
            this.playSwingSound();
        }
        if (this.attackTicks >= 44) {
            this.endAttack(target);
        }
    }

    private void handleCombo2(class_1309 target) {
        double distSq = this.mob.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        if (this.attackTicks == 7 || this.attackTicks == 29) {
            this.dashToward(target, 0.8);
        }
        if (this.attackTicks == 11) {
            if (distSq <= 6.0) {
                this.mob.method_6121((class_1297)target);
            }
            this.playSwingSound();
        }
        if (this.attackTicks == 33) {
            if (distSq <= 6.0) {
                this.mob.method_6121((class_1297)target);
            }
            this.playSwingSound();
        }
        if (this.attackTicks >= 50) {
            this.endAttack(target);
        }
    }

    private void endAttack(class_1309 target) {
        this.mob.setSwinging(false);
        this.hasDashed = false;
        this.currentAttack = AttackVariant.NONE;
        this.attackTicks = 0;
        Objects.requireNonNull(this.mob.method_5996(class_5134.field_23719)).method_6192(0.3);
        this.cooldown = this.max_cooldown + 2;
        if (target != null && target.method_5805()) {
            this.tryStartBlockAfterAttack(target);
        }
    }

    private void tryStartBlockAfterAttack(class_1309 target) {
        float targetHpRatio;
        if (target.method_6063() > 0.0f && (targetHpRatio = target.method_6032() / target.method_6063()) < 0.3f) {
            return;
        }
        float hpRatio = this.mob.method_6032() / this.mob.method_6063();
        hpRatio = class_3532.method_15363((float)hpRatio, (float)0.3f, (float)1.0f);
        float t = (1.0f - hpRatio) / 0.7f;
        float minChance = ModCombatBalancingConfig.draugrMinBlockProbability / 100.0f;
        float maxChance = ModCombatBalancingConfig.draugrMaxBlockProbability / 100.0f;
        float chance = minChance + t * (maxChance - minChance);
        float roll = this.mob.method_59922().method_43057();
        if (roll < chance) {
            this.mob.requestBlock();
            this.mob.setSwinging(false);
            this.hasDashed = false;
            this.currentAttack = AttackVariant.NONE;
            this.attackTicks = 0;
            Objects.requireNonNull(this.mob.method_5996(class_5134.field_23719)).method_6192(0.3);
            this.cooldown = this.max_cooldown + 5;
        }
    }

    private boolean shouldRequestPotion(float hpRatio) {
        if (!this.mob.hasPotion()) {
            return false;
        }
        if (this.mob.wantsToDrinkPotion()) {
            return false;
        }
        if (this.mob.getHealTicks() > 0) {
            return false;
        }
        int type = this.mob.getPotionType();
        return switch (type) {
            case 1 -> {
                if (hpRatio < 0.4f) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (hpRatio < 0.8f) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (this.mob.method_5809() || hpRatio < 0.7f) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private void playSwingSound() {
        this.mob.method_37908().method_43128(null, this.mob.method_23317(), this.mob.method_23318(), this.mob.method_23321(), ModSounds.SWING, this.mob.method_5634(), 0.75f + this.mob.method_59922().method_43057() * 0.2f, 0.8f + this.mob.method_59922().method_43057() * 0.4f);
    }

    private void dashToward(class_1309 target, double basePower) {
        class_243 dir = target.method_19538().method_1020(this.mob.method_19538()).method_1029();
        float yaw = (float)(class_3532.method_15349((double)dir.field_1350, (double)dir.field_1352) * 57.29577951308232) - 90.0f;
        this.mob.method_36456(yaw);
        this.mob.method_5847(yaw);
        this.mob.method_5636(yaw);
        this.mob.field_5982 = yaw;
        this.mob.field_6220 = yaw;
        double dist = this.mob.method_5739((class_1297)target);
        double minDist = 2.0;
        double maxDist = 10.0;
        double minPower = basePower * 0.7;
        double maxPower = basePower * 2.2;
        double clamped = class_3532.method_15350((double)((dist - minDist) / (maxDist - minDist)), (double)0.0, (double)1.0);
        double scaledPower = class_3532.method_16436((double)clamped, (double)minPower, (double)maxPower);
        class_243 dash = new class_243((double)(-class_3532.method_15374((float)(this.mob.method_36454() * ((float)Math.PI / 180)))) * scaledPower, 0.05, (double)class_3532.method_15362((float)(this.mob.method_36454() * ((float)Math.PI / 180))) * scaledPower);
        this.mob.method_5762(dash.field_1352, dash.field_1351, dash.field_1350);
        this.mob.field_6007 = true;
    }

    private static enum AttackVariant {
        NONE,
        SIMPLE1,
        SIMPLE2,
        COMBO1,
        COMBO2;

    }
}

