/*
 * Decompiled with CFR 0.152.
 */
package net.mebahelcreaturesdraugr.entity.ai;

import net.mebahelcreaturesdraugr.entity.ai.util.MovementUtil;
import net.mebahelcreaturesdraugr.entity.ai.util.ProjectileUtil;
import net.mebahelcreaturesdraugr.entity.custom.DraugrScourgeEntity;
import net.mebahelcreaturesdraugr.sound.ModSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_243;

public class DraugrIceSpikeSpellGoal
extends class_1352 {
    private final DraugrScourgeEntity actor;
    private final float iceSpikeDamage;
    private final float frostBiteDamage;
    private final ProjectileUtil projectileUtil;
    private final MovementUtil movementUtil;
    private boolean castIceSpike = true;
    private static final int COOLDOWN_TICKS = 140;
    private static final int SHOOT_START = 60;
    private static final int SHOOT_END = 10;
    private static final int SHOOT_INTERVAL = 5;

    public DraugrIceSpikeSpellGoal(DraugrScourgeEntity actor, float frostbiteDamage, float iceSpikeDamage) {
        this.actor = actor;
        this.frostBiteDamage = frostbiteDamage;
        this.iceSpikeDamage = iceSpikeDamage;
        this.movementUtil = new MovementUtil((class_1308)this.actor);
        this.projectileUtil = new ProjectileUtil();
    }

    public boolean method_6264() {
        class_1657 playerEntity;
        class_1309 livingEntity = this.actor.method_5968();
        if (livingEntity instanceof class_1657 && ((playerEntity = (class_1657)livingEntity).method_7337() || playerEntity.method_7325())) {
            return false;
        }
        return livingEntity != null && livingEntity.method_5805() && this.actor.getHasSpawned();
    }

    public void method_6269() {
        this.actor.setCooldown(140);
        this.actor.setShooting(false);
    }

    public void method_6270() {
        this.actor.setCooldown(141);
        this.actor.setShooting(false);
        this.actor.method_5962().method_6243(0.0f, 0.0f);
    }

    public boolean method_38846() {
        return true;
    }

    public boolean method_6266() {
        class_1657 playerEntity;
        class_1309 livingEntity = this.actor.method_5968();
        if (livingEntity instanceof class_1657 && ((playerEntity = (class_1657)livingEntity).method_7337() || playerEntity.method_7325())) {
            return false;
        }
        return livingEntity != null && livingEntity.method_5805() && this.actor.getHasSpawned();
    }

    public void method_6268() {
        if (this.actor.isUsingPotion() || this.actor.getHealTicks() > 0) {
            this.actor.setShooting(false);
            this.actor.method_5942().method_6340();
            return;
        }
        class_1309 target = this.actor.method_5968();
        if (target == null || !target.method_5805()) {
            this.method_6270();
            return;
        }
        double distanceToTarget = this.actor.method_5739((class_1297)target);
        this.movementUtil.lookAtTarget(target, (class_1309)this.actor);
        this.movementUtil.checkIfStuck(target, (class_1309)this.actor);
        if (!this.movementUtil.isSkyVisibleAbove((class_1308)this.actor)) {
            this.movementUtil.strafeUnderground(target, (class_1308)this.actor);
        } else if (distanceToTarget <= 8.0) {
            this.movementUtil.moveBackward(target, (class_1308)this.actor);
        } else {
            this.movementUtil.strafeAroundTarget(target, (class_1308)this.actor);
        }
        if (!this.actor.method_5985().method_6369((class_1297)target)) {
            this.actor.setShooting(false);
            this.actor.setCooldown(140);
            return;
        }
        this.actor.setCooldown(Math.max(this.actor.getCooldown() - 1, 0));
        int cd = this.actor.getCooldown();
        if (this.castIceSpike) {
            this.handleIceSpike(target, cd);
        } else {
            this.handleFrostbite(target, cd);
        }
    }

    private void handleIceSpike(class_1309 target, int cd) {
        if (cd == 60) {
            this.actor.setAttackName("ice_spike");
            this.actor.setShooting(true);
            this.actor.triggerAnim("attacking", this.actor.getAttackName());
        }
        if (cd == 30) {
            this.projectileUtil.shootProjectile(target, (class_1309)this.actor, this.iceSpikeDamage, new class_243(0.0, 0.0, 0.0));
            this.actor.method_37908().method_43128(null, this.actor.method_23317(), this.actor.method_23318(), this.actor.method_23321(), ModSounds.DRAUGR_ICE_SPIKE, this.actor.method_5634(), 0.75f + this.actor.method_59922().method_43057() * 0.2f, 0.8f + this.actor.method_59922().method_43057() * 0.4f);
        }
        if (cd == 0) {
            this.castIceSpike = Math.random() < 0.65;
            this.actor.setCooldown(140);
            this.actor.setShooting(false);
        }
    }

    private void handleFrostbite(class_1309 target, int cd) {
        if (cd == 60) {
            this.actor.setAttackName("frostbite");
            this.actor.setShooting(true);
            this.actor.triggerAnim("attacking", this.actor.getAttackName());
        }
        if (cd == 50) {
            this.actor.method_37908().method_43128(null, this.actor.method_23317(), this.actor.method_23318(), this.actor.method_23321(), ModSounds.DRAUGR_FROST_SPELL, this.actor.method_5634(), 0.75f + this.actor.method_59922().method_43057() * 0.2f, 0.8f + this.actor.method_59922().method_43057() * 0.4f);
        }
        if (cd <= 50 && cd >= 10 && cd % 5 == 0) {
            this.projectileUtil.shootFrostBiteProjectile(target, (class_1309)this.actor, this.frostBiteDamage, new class_243(0.0, 0.0, 0.0));
        }
        if (cd == 0) {
            this.castIceSpike = Math.random() < 0.65;
            this.actor.setShooting(false);
            this.actor.setCooldown(140);
        }
    }
}

