/*
 * Decompiled with CFR 0.152.
 */
package net.mebahelcreaturesdraugr.entity.ai;

import java.util.EnumSet;
import java.util.Objects;
import net.mebahelcreaturesdraugr.entity.ai.util.MovementUtil;
import net.mebahelcreaturesdraugr.entity.custom.DraugrEntity;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_5134;

public class DraugrDrinkPotionGoal
extends class_1352 {
    private final DraugrEntity mob;
    private final MovementUtil movementUtil;
    private static final int STRAFE_DISTANCE = 2;
    private static final int DRINK_DURATION_TICKS = 60;
    private int drinkTicks = 0;

    public DraugrDrinkPotionGoal(DraugrEntity mob) {
        this.mob = mob;
        this.movementUtil = new MovementUtil((class_1308)this.mob);
        this.movementUtil.setStrafeDistance(2);
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    private void log(String msg) {
        System.out.println("[DRAUGR_POTION] " + msg);
    }

    public boolean method_6264() {
        boolean isBuffPotion;
        class_1309 target = this.mob.method_5968();
        if (target == null || !target.method_5805()) {
            return false;
        }
        if (!this.mob.hasPotion()) {
            return false;
        }
        if (this.mob.method_6039()) {
            return false;
        }
        if (this.mob.isUsingPotion() || this.mob.getHealTicks() > 0) {
            return false;
        }
        int type = this.mob.getPotionType();
        float hpRatio = this.mob.method_6032() / this.mob.method_6063();
        if (type == 5) {
            if (hpRatio < 0.65f) {
                this.log("HP<65%, USING INVIS potion, type=" + type);
                return true;
            }
            return false;
        }
        boolean bl = isBuffPotion = type == 2 || type == 3 || type == 4;
        if (isBuffPotion && target instanceof class_1657) {
            this.log("AUTO-START potion buff vs player, type=" + type);
            return true;
        }
        return this.mob.wantsToDrinkPotion();
    }

    public boolean method_6266() {
        class_1309 target = this.mob.method_5968();
        if (target == null || !target.method_5805()) {
            return false;
        }
        return this.drinkTicks > 0 && this.mob.isUsingPotion();
    }

    public void method_6269() {
        this.mob.method_5942().method_6340();
        this.mob.method_5962().method_6243(0.0f, 0.0f);
        this.mob.setUsingPotion(true);
        this.mob.clearPotionUseRequest();
        this.drinkTicks = 60;
        this.mob.setHealTicks(60);
        Objects.requireNonNull(this.mob.method_5996(class_5134.field_23719)).method_6192(0.3);
        this.mob.setAttackName("drink_potion");
        this.mob.triggerAnim("attacking", this.mob.getAttackName());
        this.log("POTION START type=" + this.mob.getPotionType());
    }

    public void method_6270() {
        this.mob.setHasPotion(false);
        this.mob.setUsingPotion(false);
        this.mob.setHealTicks(0);
        this.drinkTicks = 0;
        this.mob.method_5942().method_6340();
        this.mob.method_5962().method_6243(0.0f, 0.0f);
        class_243 vel = this.mob.method_18798();
        this.mob.method_18800(vel.field_1352 * 0.2, vel.field_1351, vel.field_1350 * 0.2);
        this.log("POTION END");
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        class_1309 target = this.mob.method_5968();
        if (target == null || !target.method_5805()) {
            this.drinkTicks = 0;
            this.mob.setHealTicks(0);
            return;
        }
        --this.drinkTicks;
        int healTicks = this.mob.getHealTicks();
        if (healTicks > 0) {
            this.mob.setHealTicks(healTicks - 1);
        }
        if (this.drinkTicks <= 0) {
            this.mob.method_5942().method_6340();
            this.mob.method_5962().method_6243(0.0f, 0.0f);
            class_243 vel = this.mob.method_18798();
            this.mob.method_18800(vel.field_1352 * 0.2, vel.field_1351, vel.field_1350 * 0.2);
            return;
        }
        int t = this.mob.getHealTicks();
        if (t == 45 || t == 40 || t == 35 || t == 30 || t == 25 || t == 20) {
            this.mob.method_5783(class_3417.field_20613, 1.0f, 0.9f + this.mob.method_59922().method_43057() * 0.2f);
        } else if (t == 15) {
            this.applyPotionEffect();
        }
        double distanceToTarget = this.mob.method_5739((class_1297)target);
        this.movementUtil.lookAtTarget(target, (class_1309)this.mob);
        this.movementUtil.checkIfStuck(target, (class_1309)this.mob);
        if (!this.movementUtil.isSkyVisibleAbove((class_1308)this.mob)) {
            this.movementUtil.strafeUnderground(target, (class_1308)this.mob);
        } else if (distanceToTarget <= 2.0) {
            this.movementUtil.moveBackward(target, (class_1308)this.mob);
        } else {
            this.movementUtil.strafeAroundTarget(target, (class_1308)this.mob);
        }
    }

    private void applyPotionEffect() {
        int type = this.mob.getPotionType();
        System.out.println("[DRAUGR_POTION_EFFECT] type=" + type);
        switch (type) {
            case 1: {
                System.out.println("[DRAUGR_POTION_EFFECT] HEAL");
                this.mob.method_6025(30.0f);
                break;
            }
            case 2: {
                System.out.println("[DRAUGR_POTION_EFFECT] STRENGTH");
                this.mob.method_6092(new class_1293(class_1294.field_5910, 2400, 0));
                break;
            }
            case 3: {
                System.out.println("[DRAUGR_POTION_EFFECT] FIRE_RES");
                this.mob.method_6092(new class_1293(class_1294.field_5907, 2400, 0));
                break;
            }
            case 4: {
                System.out.println("[DRAUGR_POTION_EFFECT] SPEED");
                this.mob.method_6092(new class_1293(class_1294.field_5904, 2400, 0));
                break;
            }
            case 5: {
                System.out.println("[DRAUGR_POTION_EFFECT] INVIS");
                this.mob.method_6092(new class_1293(class_1294.field_5905, 2400, 0));
                break;
            }
            default: {
                System.out.println("[DRAUGR_POTION_EFFECT] NONE");
            }
        }
    }
}

