/*
 * Decompiled with CFR 0.152.
 */
package net.mebahelcreaturesdraugr.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ModCombatBalancingConfig {
    private static final String CONFIG_FILE_NAME = "combat_balancing_config.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static float draugrMinBlockProbability = 8.0f;
    public static float draugrMaxBlockProbability = 16.0f;
    public static float draugrOverlordMinBlockProbability = 10.0f;
    public static float draugrOverlordMaxBlockProbability = 20.0f;
    public static float draugrSpawnWithPotionProbability = 5.0f;
    public static boolean draugrRaidScalingDifficulty = true;

    public static void loadConfig(File configDir) {
        File configFile;
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        if ((configFile = new File(configDir, CONFIG_FILE_NAME)).exists()) {
            try (FileReader reader = new FileReader(configFile);){
                ConfigData data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                boolean updated = false;
                if (data.draugrMinBlockProbability <= 0.0f) {
                    data.draugrMinBlockProbability = 8.0f;
                    updated = true;
                }
                if (data.draugrMaxBlockProbability <= 0.0f) {
                    data.draugrMaxBlockProbability = 16.0f;
                    updated = true;
                }
                if (data.draugrOverlordMinBlockProbability <= 0.0f) {
                    data.draugrOverlordMinBlockProbability = 10.0f;
                    updated = true;
                }
                if (data.draugrOverlordMaxBlockProbability <= 0.0f) {
                    data.draugrOverlordMaxBlockProbability = 20.0f;
                    updated = true;
                }
                if (data.draugrSpawnWithPotionProbability <= 0.0f || data.draugrSpawnWithPotionProbability > 100.0f) {
                    data.draugrSpawnWithPotionProbability = 5.0f;
                    updated = true;
                }
                if (data.draugrRaidScalingDifficulty == null) {
                    data.draugrRaidScalingDifficulty = true;
                    updated = true;
                }
                draugrMinBlockProbability = data.draugrMinBlockProbability;
                draugrMaxBlockProbability = data.draugrMaxBlockProbability;
                draugrOverlordMinBlockProbability = data.draugrOverlordMinBlockProbability;
                draugrOverlordMaxBlockProbability = data.draugrOverlordMaxBlockProbability;
                draugrSpawnWithPotionProbability = data.draugrSpawnWithPotionProbability;
                draugrRaidScalingDifficulty = data.draugrRaidScalingDifficulty;
                if (updated) {
                    ModCombatBalancingConfig.saveConfig(configDir);
                }
            }
            catch (IOException e) {
                System.err.println("Failed to load config file: " + e.getMessage());
            }
        } else {
            ModCombatBalancingConfig.saveConfig(configDir);
        }
    }

    public static void saveConfig(File configDir) {
        File configFile = new File(configDir, CONFIG_FILE_NAME);
        ConfigData data = new ConfigData(draugrMinBlockProbability, draugrMaxBlockProbability, draugrOverlordMinBlockProbability, draugrOverlordMaxBlockProbability, draugrSpawnWithPotionProbability, draugrRaidScalingDifficulty);
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("Failed to save config file: " + e.getMessage());
        }
    }

    private static class ConfigData {
        float draugrMinBlockProbability;
        float draugrMaxBlockProbability;
        float draugrOverlordMinBlockProbability;
        float draugrOverlordMaxBlockProbability;
        float draugrSpawnWithPotionProbability;
        Boolean draugrRaidScalingDifficulty;

        ConfigData(float draugrMinBlockProbability, float draugrMaxBlockProbability, float draugrOverlordMinBlockProbability, float draugrOverlordMaxBlockProbability, float draugrSpawnWithPotionProbability, boolean draugrRaidScalingDifficulty) {
            this.draugrMinBlockProbability = draugrMinBlockProbability;
            this.draugrMaxBlockProbability = draugrMaxBlockProbability;
            this.draugrOverlordMinBlockProbability = draugrOverlordMinBlockProbability;
            this.draugrOverlordMaxBlockProbability = draugrOverlordMaxBlockProbability;
            this.draugrSpawnWithPotionProbability = draugrSpawnWithPotionProbability;
            this.draugrRaidScalingDifficulty = draugrRaidScalingDifficulty;
        }
    }
}

