/*
 * Decompiled with CFR 0.152.
 */
package net.mebahelcreaturesdraugr;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.mebahelcreaturesdraugr.block.block.ModBlocks;
import net.mebahelcreaturesdraugr.block.entity.ModBlockEntities;
import net.mebahelcreaturesdraugr.config.ModBonusHealthConfig;
import net.mebahelcreaturesdraugr.config.ModCombatBalancingConfig;
import net.mebahelcreaturesdraugr.config.ModConfigReadmeGenerator;
import net.mebahelcreaturesdraugr.config.ModSpawnRateConfig;
import net.mebahelcreaturesdraugr.entity.ModEntities;
import net.mebahelcreaturesdraugr.entity.custom.DraugrArcherEntity;
import net.mebahelcreaturesdraugr.entity.custom.DraugrEntity;
import net.mebahelcreaturesdraugr.entity.custom.DraugrOverlordEntity;
import net.mebahelcreaturesdraugr.entity.custom.DraugrScourgeEntity;
import net.mebahelcreaturesdraugr.entity.custom.DraugrWightEntity;
import net.mebahelcreaturesdraugr.entity.custom.SkeletonWarriorEntity;
import net.mebahelcreaturesdraugr.entity.custom.SkeletonWarriorHeadEntity;
import net.mebahelcreaturesdraugr.item.ModItemGroups;
import net.mebahelcreaturesdraugr.item.ModItems;
import net.mebahelcreaturesdraugr.item.ModLootModifiers;
import net.mebahelcreaturesdraugr.item.ModSpawnEggs;
import net.mebahelcreaturesdraugr.network.ChestOpenPayload;
import net.mebahelcreaturesdraugr.network.FrostStopSoundPayload;
import net.mebahelcreaturesdraugr.network.UpdateChestPayload;
import net.mebahelcreaturesdraugr.particle.ModParticles;
import net.mebahelcreaturesdraugr.raid.DraugrRaid;
import net.mebahelcreaturesdraugr.raid.DraugrRaidDifficultyState;
import net.mebahelcreaturesdraugr.raid.DraugrRaidManager;
import net.mebahelcreaturesdraugr.raid.DraugrRaidPersistentData;
import net.mebahelcreaturesdraugr.screenhandler.ModScreenHandlers;
import net.mebahelcreaturesdraugr.sound.ModSounds;
import net.mebahelcreaturesdraugr.util.ModNetworking;
import net.mebahelcreaturesdraugr.util.MyProcessors;
import net.mebahelcreaturesdraugr.util.TickScheduler;
import net.mebahelcreaturesdraugr.util.WaterRemovalScheduler;
import net.mebahelcreaturesdraugr.world.gen.ModWorldGen;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MebahelCreaturesDraugr
implements ModInitializer {
    public static final String MOD_ID = "mebahelcreaturesdraugr";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"mebahelcreaturesdraugr");
    public static final Map<class_3218, Integer> worldDifficultyLevels = new HashMap<class_3218, Integer>();
    private static final DraugrRaidDifficultyState draugrRaidDifficultyState = new DraugrRaidDifficultyState(1);
    private static final WaterRemovalScheduler waterRemovalScheduler = new WaterRemovalScheduler();
    private static final Map<class_3218, ServerTickEvents.EndTick> registeredListeners = new HashMap<class_3218, ServerTickEvents.EndTick>();
    private static final Map<class_3218, ServerPlayConnectionEvents.Join> registeredJoinEventListeners = new HashMap<class_3218, ServerPlayConnectionEvents.Join>();
    public static final List<DraugrRaid> ongoingRaids = new ArrayList<DraugrRaid>();
    private static final TickScheduler tickScheduler = new TickScheduler();
    private boolean playerHasArrived = false;
    private boolean shouldEnableLoad = true;

    public void onInitialize() {
        File configDir = new File(FabricLoader.getInstance().getConfigDir().toFile(), MOD_ID);
        ModSpawnRateConfig.loadConfig(configDir);
        ModCombatBalancingConfig.loadConfig(configDir);
        ModBonusHealthConfig.loadConfig(configDir);
        ModConfigReadmeGenerator.generate(configDir);
        ModItemGroups.registerItemGroups();
        FabricDefaultAttributeRegistry.register(ModEntities.DRAUGR_OVERLORD, (class_5132.class_5133)DraugrOverlordEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.SKELETON_WARRIOR_HEAD, (class_5132.class_5133)SkeletonWarriorHeadEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.SKELETON_WARRIOR, (class_5132.class_5133)SkeletonWarriorEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DRAUGR_SCOURGE, (class_5132.class_5133)DraugrScourgeEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DRAUGR_WIGHT, (class_5132.class_5133)DraugrWightEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DRAUGR_ARCHER, (class_5132.class_5133)DraugrArcherEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DRAUGR, (class_5132.class_5133)DraugrEntity.setAttributes());
        ModSounds.registerSounds();
        ModBlocks.registerModBlocks();
        ModBlockEntities.registerModBlockEntities();
        ModWorldGen.generateWorldGen();
        ModScreenHandlers.registerScreenHandlers();
        DraugrRaidManager.registerEvents();
        ModItems.registerModItems();
        ModSpawnEggs.registerModItems();
        ModParticles.registerParticles();
        MyProcessors.init();
        ModLootModifiers.init();
        PayloadTypeRegistry.playS2C().register(ChestOpenPayload.ID, ChestOpenPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(UpdateChestPayload.ID, UpdateChestPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(FrostStopSoundPayload.ID, FrostStopSoundPayload.CODEC);
        ModNetworking.registerReceivers();
        ServerWorldEvents.LOAD.register((server, world) -> {
            waterRemovalScheduler.addWorld(world);
            draugrRaidDifficultyState.registerDifficultyState(world);
            ServerPlayConnectionEvents.Join joinEventListener = (handler, sender, server2) -> {
                if (world.method_27983().equals(class_1937.field_25179)) {
                    this.playerHasArrived = true;
                }
            };
            registeredJoinEventListeners.put(world, joinEventListener);
            ServerTickEvents.EndTick listener = serverTick -> {
                if (serverTick.method_3847(class_1937.field_25179) == world && this.playerHasArrived && this.shouldEnableLoad) {
                    tickScheduler.schedule(world, 20, w -> DraugrRaidPersistentData.get(world));
                    this.shouldEnableLoad = false;
                    this.playerHasArrived = false;
                }
                draugrRaidDifficultyState.updateDifficultyState(world);
                tickScheduler.tick();
            };
            ServerPlayConnectionEvents.JOIN.register((Object)joinEventListener);
            ServerTickEvents.END_SERVER_TICK.register((Object)listener);
        });
        ServerWorldEvents.UNLOAD.register((server, world) -> {
            waterRemovalScheduler.removeWorld(world);
            registeredListeners.remove(world);
            registeredJoinEventListeners.remove(world);
        });
    }

    public static TickScheduler getTickScheduler() {
        return tickScheduler;
    }

    public static WaterRemovalScheduler getWaterRemovalScheduler() {
        return waterRemovalScheduler;
    }
}

