/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.almanac;

import com.frikinjay.almanac.command.ReloadCommand;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Almanac {
    public static final String MOD_ID = "almanac";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"almanac");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final List<Consumer<CommandDispatcher<class_2168>>> COMMAND_REGISTRATIONS = new ArrayList<Consumer<CommandDispatcher<class_2168>>>();
    private static final Map<String, ConfigEntry<?>> CONFIG_ENTRIES = new ConcurrentHashMap();
    public static Boolean pickedItems = false;

    public static void init() {
        Almanac.addCommandRegistration(ReloadCommand::register);
    }

    public static <T> T loadConfig(File configFile, Class<T> configClass) {
        T config = Almanac.loadConfigFromFile(configFile, configClass);
        if (config != null) {
            CONFIG_ENTRIES.put(configFile.getName(), new ConfigEntry<T>(config, configClass, configFile));
        }
        return config;
    }

    public static Object getConfigEntry(String configName) {
        return CONFIG_ENTRIES.get(configName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T loadConfigFromFile(File configFile, Class<T> configClass) {
        if (!configFile.exists()) return Almanac.createDefaultConfig(configClass);
        try (FileReader reader = new FileReader(configFile);){
            Object object = GSON.fromJson((Reader)reader, configClass);
            return (T)object;
        }
        catch (IOException e) {
            LOGGER.error("Failed to load config", (Throwable)e);
        }
        return Almanac.createDefaultConfig(configClass);
    }

    private static <T> T createDefaultConfig(Class<T> configClass) {
        try {
            return configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create default config", (Throwable)e);
            return null;
        }
    }

    public static void saveConfig(File configFile, Object config) {
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson(config, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static void addCommandRegistration(Consumer<CommandDispatcher<class_2168>> registration) {
        COMMAND_REGISTRATIONS.add(registration);
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        for (Consumer<CommandDispatcher<class_2168>> registration : COMMAND_REGISTRATIONS) {
            registration.accept(dispatcher);
        }
    }

    public static <T> void reloadConfig(String configName) {
        ConfigEntry<?> configEntry = CONFIG_ENTRIES.get(configName);
        if (configEntry != null) {
            Object newConfig = Almanac.loadConfigFromFile(configEntry.getConfigFile(), configEntry.getConfigClass());
            if (newConfig != null) {
                configEntry.updateConfig(newConfig);
                configEntry.repopulateEntries(newConfig);
                configEntry.notifyListeners(newConfig);
                LOGGER.info("Reloaded and repopulated config: {}", (Object)configName);
            } else {
                LOGGER.warn("Failed to load config: {}", (Object)configName);
            }
        } else {
            LOGGER.warn("Config not found: {}", (Object)configName);
        }
    }

    public static <T> void addConfigChangeListener(File configFile, Consumer<T> listener) {
        ConfigEntry<?> entry = CONFIG_ENTRIES.get(configFile.getName());
        if (entry != null) {
            entry.addListener(listener);
        }
    }

    public static Set<String> getConfigEntryNames() {
        return CONFIG_ENTRIES.keySet();
    }

    public static File getConfigFile(String configName) {
        ConfigEntry<?> entry = CONFIG_ENTRIES.get(configName);
        return entry != null ? entry.getConfigFile() : null;
    }

    public static Class<?> getConfigClass(String configName) {
        ConfigEntry<?> entry = CONFIG_ENTRIES.get(configName);
        return entry != null ? entry.getConfigClass() : null;
    }

    public static void dropEquipmentOnDiscard(class_1309 entity) {
        for (class_1304 equipmentSlot : class_1304.values()) {
            class_1799 itemStack = entity.method_6118(equipmentSlot);
            if (itemStack.method_7960() || !((class_9279)itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57450("picked") || class_1890.method_60142((class_1799)itemStack, (class_9331)class_9701.field_51655)) continue;
            entity.method_5775(itemStack);
            entity.method_5673(equipmentSlot, class_1799.field_8037);
        }
    }

    public static boolean hasNonCustomName(class_1309 entity) {
        if (entity.method_16914()) {
            String customName = entity.method_5797().getString();
            return Almanac.matchesStackedName(customName, (class_1297)entity);
        }
        return true;
    }

    public static boolean matchesStackedName(String customName, class_1297 entity) {
        return Pattern.compile(Pattern.quote(Almanac.getLocalizedEntityName(entity.method_5864()).getString()) + " x\\d+").matcher(customName).find();
    }

    public static class_2561 getLocalizedEntityName(class_1299<?> entityType) {
        String translationKey = entityType.method_5882();
        return class_2561.method_43471((String)translationKey);
    }

    private static class ConfigEntry<T> {
        private T config;
        private final Class<T> configClass;
        private final File configFile;
        private final List<Consumer<T>> listeners = new ArrayList<Consumer<T>>();

        public ConfigEntry(T config, Class<T> configClass, File configFile) {
            this.config = config;
            this.configClass = configClass;
            this.configFile = configFile;
        }

        public void updateConfig(T newConfig) {
            this.config = newConfig;
        }

        public void repopulateEntries(T newConfig) {
            if (this.config instanceof Set && newConfig instanceof Set) {
                ((Set)this.config).clear();
                ((Set)this.config).addAll((Set)newConfig);
            } else if (this.config instanceof List && newConfig instanceof List) {
                ((List)this.config).clear();
                ((List)this.config).addAll((List)newConfig);
            } else if (this.config instanceof Map && newConfig instanceof Map) {
                ((Map)this.config).clear();
                ((Map)this.config).putAll((Map)newConfig);
            }
        }

        public void addListener(Consumer<T> listener) {
            this.listeners.add(listener);
        }

        public void notifyListeners(T newConfig) {
            for (Consumer<T> listener : this.listeners) {
                listener.accept(newConfig);
            }
        }

        public Class<T> getConfigClass() {
            return this.configClass;
        }

        public File getConfigFile() {
            return this.configFile;
        }
    }
}

