/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.maelstrom.general.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.maelstrom.general.event.EventScheduler;
import net.barribob.maelstrom.general.event.IEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0011\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lnet/barribob/maelstrom/general/event/EventScheduler;", "", "<init>", "()V", "Lnet/barribob/maelstrom/general/event/IEvent;", "event", "", "addEvent", "(Lnet/barribob/maelstrom/general/event/IEvent;)V", "updateEvents", "", "eventQueue", "Ljava/util/List;", "", "eventsToAdd", "Ljava/util/Set;", "", "ticks", "I", "BOMD"})
public final class EventScheduler {
    private int ticks;
    @NotNull
    private final List<IEvent> eventQueue = new ArrayList();
    @NotNull
    private final Set<IEvent> eventsToAdd = new LinkedHashSet();

    public final void updateEvents() {
        this.eventQueue.addAll((Collection<IEvent>)this.eventsToAdd);
        this.eventsToAdd.clear();
        for (IEvent iEvent : this.eventQueue) {
            if (this.ticks % iEvent.tickSize() != 0 || !iEvent.shouldDoEvent()) continue;
            iEvent.doEvent();
        }
        CollectionsKt.removeAll(this.eventQueue, (Function1)updateEvents.1.INSTANCE);
        int n = this.ticks;
        this.ticks = n + 1;
    }

    public final void addEvent(@NotNull IEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.eventsToAdd.add(event);
    }
}

