/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.boss.mob.damage;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.boss.mob.damage.IDamageHandler;
import net.barribob.boss.mob.utils.IEntityStats;
import net.barribob.maelstrom.static_utilities.MathUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ/\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0017R\"\u0010\u0018\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lnet/barribob/boss/mob/damage/StagedDamageHandler;", "Lnet/barribob/boss/mob/damage/IDamageHandler;", "", "", "hpPercentRageModes", "Lkotlin/Function0;", "", "whenHpBelowThreshold", "<init>", "(Ljava/util/List;Lkotlin/jvm/functions/Function0;)V", "Lnet/barribob/boss/mob/utils/IEntityStats;", "stats", "Lnet/minecraft/class_1282;", "damageSource", "amount", "", "result", "afterDamage", "(Lnet/barribob/boss/mob/utils/IEntityStats;Lnet/minecraft/class_1282;FZ)V", "beforeDamage", "(Lnet/barribob/boss/mob/utils/IEntityStats;Lnet/minecraft/class_1282;F)V", "hpPercent", "(Lnet/barribob/boss/mob/utils/IEntityStats;)F", "Ljava/util/List;", "previousHpRatio", "F", "getPreviousHpRatio", "()F", "setPreviousHpRatio", "(F)V", "Lkotlin/jvm/functions/Function0;", "BOMD"})
public final class StagedDamageHandler
implements IDamageHandler {
    @NotNull
    private final List<Float> hpPercentRageModes;
    @NotNull
    private final Function0<Unit> whenHpBelowThreshold;
    private float previousHpRatio;

    public StagedDamageHandler(@NotNull List<Float> hpPercentRageModes, @NotNull Function0<Unit> whenHpBelowThreshold) {
        Intrinsics.checkNotNullParameter(hpPercentRageModes, (String)"hpPercentRageModes");
        Intrinsics.checkNotNullParameter(whenHpBelowThreshold, (String)"whenHpBelowThreshold");
        this.hpPercentRageModes = hpPercentRageModes;
        this.whenHpBelowThreshold = whenHpBelowThreshold;
        this.previousHpRatio = 1.0f;
    }

    public final float getPreviousHpRatio() {
        return this.previousHpRatio;
    }

    public final void setPreviousHpRatio(float f) {
        this.previousHpRatio = f;
    }

    @Override
    public void beforeDamage(@NotNull IEntityStats stats, @NotNull class_1282 damageSource, float amount) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        this.previousHpRatio = this.hpPercent(stats);
    }

    @Override
    public void afterDamage(@NotNull IEntityStats stats, @NotNull class_1282 damageSource, float amount, boolean result) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        float newHpRatio = this.hpPercent(stats);
        float firstRageMode = MathUtils.roundedStep$default(MathUtils.INSTANCE, this.previousHpRatio, this.hpPercentRageModes, false, 4, null);
        float secondRageMode = MathUtils.roundedStep$default(MathUtils.INSTANCE, newHpRatio, this.hpPercentRageModes, false, 4, null);
        if (!(firstRageMode == secondRageMode)) {
            this.whenHpBelowThreshold.invoke();
        }
    }

    private final float hpPercent(IEntityStats stats) {
        return stats.getHealth() / stats.getMaxHealth();
    }

    @Override
    public boolean shouldDamage(@NotNull class_1309 actor, @NotNull class_1282 damageSource, float amount) {
        return IDamageHandler.DefaultImpls.shouldDamage(this, actor, damageSource, amount);
    }
}

