/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.boss.animation;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.boss.animation.IAnimationTimer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u000b\u001a\u0004\b\u0006\u0010\fR\u0016\u0010\r\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u000eR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000b\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0011"}, d2={"Lnet/barribob/boss/animation/PauseAnimationTimer;", "Lnet/barribob/boss/animation/IAnimationTimer;", "Lkotlin/Function0;", "", "sysTimeProvider", "", "isPaused", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getCurrentTick", "()D", "Lkotlin/jvm/functions/Function0;", "()Lkotlin/jvm/functions/Function0;", "pauseStart", "D", "pauseTime", "getSysTimeProvider", "BOMD"})
public final class PauseAnimationTimer
implements IAnimationTimer {
    @NotNull
    private final Function0<Double> sysTimeProvider;
    @NotNull
    private final Function0<Boolean> isPaused;
    private double pauseTime;
    private double pauseStart;

    public PauseAnimationTimer(@NotNull Function0<Double> sysTimeProvider, @NotNull Function0<Boolean> isPaused) {
        Intrinsics.checkNotNullParameter(sysTimeProvider, (String)"sysTimeProvider");
        Intrinsics.checkNotNullParameter(isPaused, (String)"isPaused");
        this.sysTimeProvider = sysTimeProvider;
        this.isPaused = isPaused;
    }

    @NotNull
    public final Function0<Double> getSysTimeProvider() {
        return this.sysTimeProvider;
    }

    @NotNull
    public final Function0<Boolean> isPaused() {
        return this.isPaused;
    }

    @Override
    public double getCurrentTick() {
        double sysTime = ((Number)this.sysTimeProvider.invoke()).doubleValue();
        if (((Boolean)this.isPaused.invoke()).booleanValue()) {
            if (this.pauseStart == 0.0) {
                this.pauseStart = sysTime;
            }
            return this.pauseStart - this.pauseTime;
        }
        if (!(this.pauseStart == 0.0)) {
            double timeElapsed = sysTime - this.pauseStart;
            this.pauseTime += timeElapsed;
            this.pauseStart = 0.0;
        }
        return sysTime - this.pauseTime;
    }
}

