/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.GuiControlRect;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.event.GuiTooltipEvent;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.mc.LanguageUtils;
import team.creative.creativecore.common.util.text.TextBuilder;

public abstract class GuiControl {
    public final GuiControlRect rect = new GuiControlRect(this);
    private IGuiParent parent;
    public final String name;
    public boolean enabled = true;
    public GuiSizeRule preferred;
    public boolean expandableX = false;
    public boolean expandableY = false;
    public boolean visible = true;
    private List<class_2561> customTooltip;

    public GuiControl(String name) {
        this.name = name;
    }

    public class_7225.class_7874 provider() {
        class_1657 player = this.getPlayer();
        return player != null ? player.method_56673() : null;
    }

    public boolean isClient() {
        if (this.parent != null) {
            return this.parent.isClient();
        }
        return CreativeCore.loader().getEffectiveSide().isClient();
    }

    public GuiControl setTooltip(List<class_2561> tooltip) {
        this.customTooltip = tooltip != null && tooltip.isEmpty() ? null : tooltip;
        return this;
    }

    public GuiControl setTooltip(String translate) {
        this.setTooltip(new TextBuilder().translate(translate).build());
        return this;
    }

    public GuiControl setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public GuiControl setFixed() {
        this.expandableX = false;
        this.expandableY = false;
        return this;
    }

    public GuiControl setFixedX() {
        this.expandableX = false;
        return this;
    }

    public GuiControl setFixedY() {
        this.expandableY = false;
        return this;
    }

    public GuiControl setExpandable() {
        this.expandableX = true;
        this.expandableY = true;
        return this;
    }

    public GuiControl setUnexpandable() {
        this.expandableX = false;
        this.expandableY = false;
        return this;
    }

    public GuiControl setExpandableX() {
        this.expandableX = true;
        return this;
    }

    public GuiControl setUnexpandableX() {
        this.expandableX = false;
        return this;
    }

    public GuiControl setExpandableY() {
        this.expandableY = true;
        return this;
    }

    public GuiControl setUnexpandableY() {
        this.expandableY = false;
        return this;
    }

    public GuiControl setDim(int width, int height) {
        this.preferred = new GuiSizeRule.GuiFixedDimension(width, height);
        return this;
    }

    public GuiControl setDim(GuiSizeRule dim) {
        this.preferred = dim;
        return this;
    }

    public GuiControl setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean hasGui() {
        if (this.parent != null) {
            return this.parent.hasGui();
        }
        return false;
    }

    public void setParent(IGuiParent parent) {
        this.parent = parent;
    }

    public boolean isParent(IGuiParent parent) {
        if (this.parent == parent) {
            return true;
        }
        return this.parent.isParent(parent);
    }

    public IGuiParent getParent() {
        return this.parent;
    }

    public IGuiIntegratedParent getIntegratedParent() {
        return this.parent.getIntegratedParent();
    }

    public boolean isExpandableX() {
        return this.expandableX;
    }

    public boolean isExpandableY() {
        return this.expandableY;
    }

    public String getNestedName() {
        IGuiParent iGuiParent = this.getParent();
        if (iGuiParent instanceof GuiControl) {
            GuiControl control = (GuiControl)((Object)iGuiParent);
            return control.getNestedName() + "." + this.name;
        }
        return this.name;
    }

    public boolean hasLayer() {
        IGuiParent iGuiParent = this.parent;
        if (iGuiParent instanceof GuiControl) {
            GuiControl control = (GuiControl)((Object)iGuiParent);
            return control.hasLayer();
        }
        return false;
    }

    public GuiLayer getLayer() {
        IGuiParent iGuiParent = this.parent;
        if (iGuiParent instanceof GuiControl) {
            GuiControl control = (GuiControl)((Object)iGuiParent);
            return control.getLayer();
        }
        throw new RuntimeException("Invalid layer control");
    }

    @Environment(value=EnvType.CLIENT)
    public GuiStyle getStyle() {
        IGuiParent iGuiParent = this.parent;
        if (iGuiParent instanceof GuiControl) {
            GuiControl control = (GuiControl)((Object)iGuiParent);
            return control.getStyle();
        }
        throw new RuntimeException("Invalid layer control");
    }

    public abstract void init();

    public abstract void closed();

    public abstract void tick();

    public boolean is(String name) {
        return this.name.equalsIgnoreCase(name);
    }

    public boolean is(String ... name) {
        for (String s : name) {
            if (!this.name.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public Rect createChildRect(Rect contentRect, double scale, double xOffset, double yOffset) {
        return contentRect.child(this.rect, scale, xOffset, yOffset);
    }

    protected abstract void flowX(int var1, int var2);

    protected abstract void flowY(int var1, int var2, int var3);

    public void reflow() {
        if (this.parent != null) {
            this.parent.reflow();
        }
    }

    protected int minWidth(int availableWidth) {
        return -1;
    }

    protected abstract int preferredWidth(int var1);

    protected int maxWidth(int availableWidth) {
        return -1;
    }

    protected int minHeight(int width, int availableHeight) {
        return -1;
    }

    protected abstract int preferredHeight(int var1, int var2);

    protected int maxHeight(int width, int availableHeight) {
        return -1;
    }

    public Rect toLayerRect(Rect rect) {
        return this.getParent().toLayerRect(this, rect);
    }

    public Rect toScreenRect(Rect rect) {
        return this.getParent().toScreenRect(this, rect);
    }

    public boolean testForDoubleClick(double x, double y, int button) {
        return false;
    }

    public boolean isInteractable() {
        return this.enabled && this.visible;
    }

    public void mouseMoved(double x, double y) {
    }

    public boolean mouseClicked(double x, double y, int button) {
        return false;
    }

    public boolean mouseDoubleClicked(double x, double y, int button) {
        return this.mouseClicked(x, y, button);
    }

    public void mouseReleased(double x, double y, int button) {
    }

    public void mouseDragged(double x, double y, int button, double dragX, double dragY, double time) {
    }

    public boolean mouseScrolled(double x, double y, double delta) {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return false;
    }

    public void looseFocus() {
    }

    public void raiseEvent(GuiEvent event) {
        if (this.parent != null) {
            this.parent.raiseEvent(event);
        }
    }

    public abstract ControlFormatting getControlFormatting();

    @Environment(value=EnvType.CLIENT)
    public int getContentOffset() {
        return this.getStyle().getContentOffset(this.getControlFormatting());
    }

    public GuiTooltipEvent getTooltipEvent(double x, double y) {
        String langTooltip;
        List<class_2561> toolTip = this.getTooltip();
        if (this.customTooltip != null) {
            if (toolTip == null) {
                toolTip = this.customTooltip;
            } else if (toolTip != this.customTooltip) {
                toolTip.addAll(this.customTooltip);
            }
        }
        if (toolTip == null && (langTooltip = GuiControl.translateOrDefault(this.getNestedName() + ".tooltip", null)) != null) {
            toolTip = new TextBuilder(langTooltip).build();
        }
        if (toolTip != null) {
            return new GuiTooltipEvent(this, toolTip);
        }
        return null;
    }

    public List<class_2561> getTooltip() {
        return this.customTooltip;
    }

    @Environment(value=EnvType.CLIENT)
    public StyleDisplay getBorder(GuiStyle style, StyleDisplay display) {
        return display;
    }

    @Environment(value=EnvType.CLIENT)
    public StyleDisplay getBackground(GuiStyle style, StyleDisplay display) {
        return display;
    }

    @Environment(value=EnvType.CLIENT)
    public void render(class_332 graphics, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        RenderSystem.clear((int)256, (boolean)class_310.field_1703);
        Rect rectCopy = null;
        if (!this.enabled) {
            rectCopy = controlRect.copy();
        }
        int width = this.rect.getWidth();
        int height = this.rect.getHeight();
        GuiStyle style = this.getStyle();
        ControlFormatting formatting = this.getControlFormatting();
        this.getBorder(style, style.get(formatting.border)).render(graphics, 0.0, 0.0, width, height);
        int borderSize = style.getBorder(formatting.border);
        this.getBackground(style, style.get(formatting.face, this.enabled && realRect.inside(mouseX, mouseY))).render(graphics, borderSize, borderSize, width -= borderSize * 2, height -= borderSize * 2);
        controlRect.shrink((double)borderSize * scale);
        this.renderContent(graphics, formatting, borderSize, controlRect, realRect, scale, mouseX, mouseY);
        if (!this.enabled && formatting.hasDisabledEffect) {
            realRect.scissor();
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            style.disabled.render(graphics, null, rectCopy);
            RenderSystem.enableDepthTest();
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderContent(class_332 graphics, ControlFormatting formatting, int borderWidth, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        class_4587 pose = graphics.method_51448();
        controlRect.shrink((double)formatting.padding * scale);
        if (!this.enabled) {
            pose.method_22903();
        }
        pose.method_46416((float)(borderWidth + formatting.padding), (float)(borderWidth + formatting.padding), 0.0f);
        this.renderContent(graphics, controlRect, controlRect.intersection(realRect), scale, mouseX, mouseY);
        if (!this.enabled) {
            pose.method_22909();
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderContent(class_332 graphics, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        this.renderContent(graphics, mouseX, mouseY);
    }

    @Environment(value=EnvType.CLIENT)
    protected abstract void renderContent(class_332 var1, int var2, int var3);

    public class_1657 getPlayer() {
        return this.parent.getPlayer();
    }

    public static class_5250 translatable(String text) {
        return class_2561.method_43470((String)GuiControl.translate(text));
    }

    public static class_5250 translatable(String text, Object ... parameters) {
        return class_2561.method_43470((String)GuiControl.translate(text, parameters));
    }

    public static String translate(String text) {
        return LanguageUtils.translate(text);
    }

    public static String translate(String text, Object ... parameters) {
        return LanguageUtils.translate(text, parameters);
    }

    public static String translateOrDefault(String text, String defaultText) {
        return LanguageUtils.translateOr(text, defaultText);
    }

    @Environment(value=EnvType.CLIENT)
    public static void playSound(class_1113 sound) {
        class_310.method_1551().method_1483().method_4873(sound);
    }

    @Environment(value=EnvType.CLIENT)
    public static void playSound(class_6880.class_6883<class_3414> sound) {
        GuiControl.playSound((class_3414)sound.comp_349());
    }

    @Environment(value=EnvType.CLIENT)
    public static void playSound(class_3414 event) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)event, (float)1.0f));
    }

    @Environment(value=EnvType.CLIENT)
    public static void playSound(class_3414 event, float volume, float pitch) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)event, (float)pitch, (float)volume));
    }

    @Environment(value=EnvType.CLIENT)
    public static void playSound(class_6880.class_6883<class_3414> event, float volume, float pitch) {
        GuiControl.playSound((class_3414)event.comp_349(), volume, pitch);
    }
}

