/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.box;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.client.render.box.QuadGeneratorContext;
import team.creative.creativecore.client.render.face.RenderBoxFace;
import team.creative.creativecore.client.render.model.CreativeBakedQuad;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.geo.VectorFan;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.creativecore.common.util.mc.ColorUtils;

@Environment(value=EnvType.CLIENT)
public class RenderBox
extends AlignedBox {
    private static final VectorFan DOWN = new VectorFanSimple(new Vec3f[]{new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(1.0f, 0.0f, 1.0f)});
    private static final VectorFan UP = new VectorFanSimple(new Vec3f[]{new Vec3f(0.0f, 1.0f, 0.0f), new Vec3f(0.0f, 1.0f, 1.0f), new Vec3f(1.0f, 1.0f, 1.0f), new Vec3f(1.0f, 1.0f, 0.0f)});
    private static final VectorFan NORTH = new VectorFanSimple(new Vec3f[]{new Vec3f(1.0f, 1.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(0.0f, 1.0f, 0.0f)});
    private static final VectorFan SOUTH = new VectorFanSimple(new Vec3f[]{new Vec3f(0.0f, 1.0f, 1.0f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(1.0f, 0.0f, 1.0f), new Vec3f(1.0f, 1.0f, 1.0f)});
    private static final VectorFan WEST = new VectorFanSimple(new Vec3f[]{new Vec3f(0.0f, 1.0f, 0.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 1.0f, 1.0f)});
    private static final VectorFan EAST = new VectorFanSimple(new Vec3f[]{new Vec3f(1.0f, 1.0f, 1.0f), new Vec3f(1.0f, 0.0f, 1.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(1.0f, 1.0f, 0.0f)});
    public class_2680 state;
    public int color = -1;
    public boolean keepVU = false;
    public boolean allowOverlap = false;
    public boolean doesNeedQuadUpdate = true;
    public boolean needsResorting = false;
    public boolean emissive = false;
    private RenderBoxFace renderEast = RenderBoxFace.RENDER;
    private RenderBoxFace renderWest = RenderBoxFace.RENDER;
    private RenderBoxFace renderUp = RenderBoxFace.RENDER;
    private RenderBoxFace renderDown = RenderBoxFace.RENDER;
    private RenderBoxFace renderSouth = RenderBoxFace.RENDER;
    private RenderBoxFace renderNorth = RenderBoxFace.RENDER;
    private Object quadEast = null;
    private Object quadWest = null;
    private Object quadUp = null;
    private Object quadDown = null;
    private Object quadSouth = null;
    private Object quadNorth = null;
    public Object customData;

    public RenderBox(AlignedBox cube) {
        super(cube);
    }

    public RenderBox(AlignedBox cube, RenderBox box) {
        super(cube);
        this.state = box.state;
        this.color = box.color;
        this.renderEast = box.renderEast;
        this.renderWest = box.renderWest;
        this.renderUp = box.renderUp;
        this.renderDown = box.renderDown;
        this.renderSouth = box.renderSouth;
        this.renderNorth = box.renderNorth;
    }

    public RenderBox(AlignedBox cube, class_2680 state) {
        super(cube);
        this.state = state;
    }

    public RenderBox(AlignedBox cube, class_2248 block) {
        this(cube, block.method_9564());
    }

    public RenderBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, class_2680 state) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.state = state;
    }

    public RenderBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, class_2248 block) {
        this(minX, minY, minZ, maxX, maxY, maxZ, block.method_9564());
    }

    public RenderBox setColor(int color) {
        this.color = color;
        return this;
    }

    public RenderBox setKeepUV(boolean keep) {
        this.keepVU = keep;
        return this;
    }

    public void setQuad(Facing facing, List<class_777> quads) {
        class_777 quad = quads == null || quads.isEmpty() ? null : (quads.size() == 1 ? quads.get(0) : quads);
        switch (facing) {
            case DOWN: {
                this.quadDown = quad;
                break;
            }
            case EAST: {
                this.quadEast = quad;
                break;
            }
            case NORTH: {
                this.quadNorth = quad;
                break;
            }
            case SOUTH: {
                this.quadSouth = quad;
                break;
            }
            case UP: {
                this.quadUp = quad;
                break;
            }
            case WEST: {
                this.quadWest = quad;
            }
        }
    }

    public Object getQuad(Facing facing) {
        switch (facing) {
            case DOWN: {
                return this.quadDown;
            }
            case EAST: {
                return this.quadEast;
            }
            case NORTH: {
                return this.quadNorth;
            }
            case SOUTH: {
                return this.quadSouth;
            }
            case UP: {
                return this.quadUp;
            }
            case WEST: {
                return this.quadWest;
            }
        }
        return null;
    }

    public int countQuads() {
        int quads = 0;
        if (this.quadUp != null) {
            quads += this.quadUp instanceof List ? ((List)this.quadUp).size() : 1;
        }
        if (this.quadDown != null) {
            quads += this.quadDown instanceof List ? ((List)this.quadDown).size() : 1;
        }
        if (this.quadEast != null) {
            quads += this.quadEast instanceof List ? ((List)this.quadEast).size() : 1;
        }
        if (this.quadWest != null) {
            quads += this.quadWest instanceof List ? ((List)this.quadWest).size() : 1;
        }
        if (this.quadSouth != null) {
            quads += this.quadSouth instanceof List ? ((List)this.quadSouth).size() : 1;
        }
        if (this.quadNorth != null) {
            quads += this.quadNorth instanceof List ? ((List)this.quadNorth).size() : 1;
        }
        return quads;
    }

    public void setFace(Facing facing, RenderBoxFace face) {
        switch (facing) {
            case DOWN: {
                this.renderDown = face;
                break;
            }
            case EAST: {
                this.renderEast = face;
                break;
            }
            case NORTH: {
                this.renderNorth = face;
                break;
            }
            case SOUTH: {
                this.renderSouth = face;
                break;
            }
            case UP: {
                this.renderUp = face;
                break;
            }
            case WEST: {
                this.renderWest = face;
            }
        }
    }

    public RenderBoxFace getFace(Facing facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Facing.EAST -> this.renderEast;
            case Facing.WEST -> this.renderWest;
            case Facing.UP -> this.renderUp;
            case Facing.DOWN -> this.renderDown;
            case Facing.SOUTH -> this.renderSouth;
            case Facing.NORTH -> this.renderNorth;
        };
    }

    public boolean shouldRenderFace(Facing facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Facing.EAST -> this.renderEast.shouldRender();
            case Facing.WEST -> this.renderWest.shouldRender();
            case Facing.UP -> this.renderUp.shouldRender();
            case Facing.DOWN -> this.renderDown.shouldRender();
            case Facing.SOUTH -> this.renderSouth.shouldRender();
            case Facing.NORTH -> this.renderNorth.shouldRender();
        };
    }

    public boolean intersectsWithFace(Facing facing, QuadGeneratorContext holder, class_2338 offset) {
        switch (facing.axis) {
            case X: {
                return holder.maxY > this.minY - (float)offset.method_10264() && holder.minY < this.maxY - (float)offset.method_10264() && holder.maxZ > this.minZ - (float)offset.method_10260() && holder.minZ < this.maxZ - (float)offset.method_10260();
            }
            case Y: {
                return holder.maxX > this.minX - (float)offset.method_10263() && holder.minX < this.maxX - (float)offset.method_10263() && holder.maxZ > this.minZ - (float)offset.method_10260() && holder.minZ < this.maxZ - (float)offset.method_10260();
            }
            case Z: {
                return holder.maxX > this.minX - (float)offset.method_10263() && holder.minX < this.maxX - (float)offset.method_10263() && holder.maxY > this.minY - (float)offset.method_10264() && holder.minY < this.maxY - (float)offset.method_10264();
            }
        }
        return false;
    }

    protected Object getRenderQuads(Facing facing) {
        if (this.getFace(facing).hasCachedFans()) {
            return this.getFace(facing).getCachedFans();
        }
        switch (facing) {
            case DOWN: {
                return DOWN;
            }
            case EAST: {
                return EAST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case UP: {
                return UP;
            }
            case WEST: {
                return WEST;
            }
        }
        return null;
    }

    protected float getOffsetX() {
        return this.minX;
    }

    protected float getOffsetY() {
        return this.minY;
    }

    protected float getOffsetZ() {
        return this.minZ;
    }

    protected float getOverallScale(Facing facing) {
        return this.getFace(facing).getScale();
    }

    protected float getScaleX() {
        return this.maxX - this.minX;
    }

    protected float getScaleY() {
        return this.maxY - this.minY;
    }

    protected float getScaleZ() {
        return this.maxZ - this.minZ;
    }

    protected boolean scaleAndOffsetQuads(Facing facing) {
        return true;
    }

    protected boolean onlyScaleOnceNoOffset(Facing facing) {
        return this.getFace(facing).hasCachedFans();
    }

    public void deleteQuadCache() {
        this.doesNeedQuadUpdate = true;
        this.quadEast = null;
        this.quadWest = null;
        this.quadUp = null;
        this.quadDown = null;
        this.quadSouth = null;
        this.quadNorth = null;
    }

    protected boolean previewScalingAndOffset() {
        return true;
    }

    public float getPreviewOffX() {
        return this.minX;
    }

    public float getPreviewOffY() {
        return this.minY;
    }

    public float getPreviewOffZ() {
        return this.minZ;
    }

    public float getPreviewScaleX() {
        return this.maxX - this.minX;
    }

    public float getPreviewScaleY() {
        return this.maxY - this.minY;
    }

    public float getPreviewScaleZ() {
        return this.maxZ - this.minZ;
    }

    public void renderPreview(class_4587 pose, class_4588 consumer, int alpha) {
        int red = ColorUtils.red(this.color);
        int green = ColorUtils.green(this.color);
        int blue = ColorUtils.blue(this.color);
        if (this.previewScalingAndOffset()) {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    List list = (List)renderQuads;
                    for (int j = 0; j < list.size(); ++j) {
                        ((VectorFan)list.get(j)).renderPreview(pose.method_23760().method_23761(), consumer, this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                VectorFan fan = (VectorFan)renderQuads;
                fan.renderPreview(pose.method_23760().method_23761(), consumer, this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha);
            }
        } else {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    List list = (List)renderQuads;
                    for (int j = 0; j < list.size(); ++j) {
                        ((VectorFan)list.get(j)).renderPreview(pose.method_23760().method_23761(), consumer, red, green, blue, alpha);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                VectorFan fan = (VectorFan)renderQuads;
                fan.renderPreview(pose.method_23760().method_23761(), consumer, red, green, blue, alpha);
            }
        }
    }

    public void renderLines(class_4587 pose, class_4588 consumer, int alpha) {
        int red = ColorUtils.red(this.color);
        int green = ColorUtils.green(this.color);
        int blue = ColorUtils.blue(this.color);
        if (red == 1 && green == 1 && blue == 1) {
            blue = 0;
            green = 0;
            red = 0;
        }
        if (this.previewScalingAndOffset()) {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    List list = (List)renderQuads;
                    for (int j = 0; j < list.size(); ++j) {
                        ((VectorFan)list.get(j)).renderLines(pose.method_23760(), consumer, this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                VectorFan fan = (VectorFan)renderQuads;
                fan.renderLines(pose.method_23760(), consumer, this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha);
            }
        } else {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                        ((VectorFan)((List)renderQuads).get(j)).renderLines(pose.method_23760(), consumer, red, green, blue, alpha);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                VectorFan fan = (VectorFan)renderQuads;
                fan.renderLines(pose.method_23760(), consumer, red, green, blue, alpha);
            }
        }
    }

    public void renderLines(class_4587 pose, class_4588 consumer, int alpha, Vec3d center, double grow) {
        int red = ColorUtils.red(this.color);
        int green = ColorUtils.green(this.color);
        int blue = ColorUtils.blue(this.color);
        if (red == 1 && green == 1 && blue == 1) {
            blue = 0;
            green = 0;
            red = 0;
        }
        if (this.previewScalingAndOffset()) {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    List list = (List)renderQuads;
                    for (int j = 0; j < list.size(); ++j) {
                        ((VectorFan)list.get(j)).renderLines(pose.method_23760(), consumer, this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha, center, grow);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                VectorFan fan = (VectorFan)renderQuads;
                fan.renderLines(pose.method_23760(), consumer, this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha, center, grow);
            }
        } else {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    List list = (List)renderQuads;
                    for (int j = 0; j < list.size(); ++j) {
                        ((VectorFan)list.get(j)).renderLines(pose.method_23760(), consumer, red, green, blue, alpha, center, grow);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                VectorFan fan = (VectorFan)renderQuads;
                fan.renderLines(pose.method_23760(), consumer, red, green, blue, alpha, center, grow);
            }
        }
    }

    public boolean isTranslucent() {
        if (ColorUtils.isTransparent(this.color)) {
            return true;
        }
        return !this.state.method_51367();
    }

    public List<class_777> getBakedQuad(QuadGeneratorContext holder, class_1936 level, @Nullable class_2338 pos, class_2338 offset, class_2680 state, class_1087 blockModel, Facing facing, class_1921 layer, class_5819 rand, boolean overrideTint, int defaultColor) {
        List blockQuads;
        if (pos != null) {
            rand.method_43052(state.method_26190(pos));
        }
        if ((blockQuads = blockModel.method_4707(state, facing.toVanilla(), rand)).isEmpty()) {
            return Collections.emptyList();
        }
        holder.set(class_290.field_1590, this, facing, this.color != -1 ? this.color : defaultColor);
        holder.offset = offset;
        ArrayList<class_777> quads = new ArrayList<class_777>();
        for (int i = 0; i < blockQuads.size(); ++i) {
            holder.setQuad((class_777)blockQuads.get(i), overrideTint, defaultColor);
            if (!this.needsResorting) {
                this.needsResorting = true;
            }
            int[] data = holder.quad.method_3357();
            int index = 0;
            int uvIndex = index + holder.uvOffset;
            float tempMinX = Float.intBitsToFloat(data[index]);
            float tempMinY = Float.intBitsToFloat(data[index + 1]);
            float tempMinZ = Float.intBitsToFloat(data[index + 2]);
            float tempU = Float.intBitsToFloat(data[uvIndex]);
            holder.uvInverted = false;
            index = 1 * holder.format.method_1362() / 4;
            uvIndex = index + holder.uvOffset;
            holder.uvInverted = tempMinX != Float.intBitsToFloat(data[index]) ? (tempU != Float.intBitsToFloat(data[uvIndex]) ? Axis.X != facing.getUAxis() : Axis.X != facing.getVAxis()) : (tempMinY != Float.intBitsToFloat(data[index + 1]) ? (tempU != Float.intBitsToFloat(data[uvIndex]) ? Axis.Y != facing.getUAxis() : Axis.Y != facing.getVAxis()) : (tempU != Float.intBitsToFloat(data[uvIndex]) ? Axis.Z != facing.getUAxis() : Axis.Z != facing.getVAxis()));
            index = 2 * holder.format.method_1362() / 4;
            float tempMaxX = Float.intBitsToFloat(data[index]);
            float tempMaxY = Float.intBitsToFloat(data[index + 1]);
            float tempMaxZ = Float.intBitsToFloat(data[index + 2]);
            holder.setBounds(tempMinX, tempMinY, tempMinZ, tempMaxX, tempMaxY, tempMaxZ);
            if (!this.intersectsWithFace(facing, holder, offset)) continue;
            uvIndex = holder.uvOffset;
            float u1 = Float.intBitsToFloat(data[uvIndex]);
            float v1 = Float.intBitsToFloat(data[uvIndex + 1]);
            uvIndex = 2 * holder.format.method_1362() / 4 + holder.uvOffset;
            float u2 = Float.intBitsToFloat(data[uvIndex]);
            float v2 = Float.intBitsToFloat(data[uvIndex + 1]);
            if (holder.uvInverted) {
                holder.sizeU = facing.getV(tempMinX, tempMinY, tempMinZ) < facing.getV(tempMaxX, tempMaxY, tempMaxZ) ? u2 - u1 : u1 - u2;
                holder.sizeV = facing.getU(tempMinX, tempMinY, tempMinZ) < facing.getU(tempMaxX, tempMaxY, tempMaxZ) ? v2 - v1 : v1 - v2;
            } else {
                holder.sizeU = facing.getU(tempMinX, tempMinY, tempMinZ) < facing.getU(tempMaxX, tempMaxY, tempMaxZ) ? u2 - u1 : u1 - u2;
                holder.sizeV = facing.getV(tempMinX, tempMinY, tempMinZ) < facing.getV(tempMaxX, tempMaxY, tempMaxZ) ? v2 - v1 : v1 - v2;
            }
            Object renderQuads = this.getRenderQuads(holder.facing);
            if (renderQuads instanceof List) {
                List list = (List)renderQuads;
                for (int j = 0; j < list.size(); ++j) {
                    ((VectorFan)list.get(j)).generate(holder, quads);
                }
                continue;
            }
            if (!(renderQuads instanceof VectorFan)) continue;
            VectorFan fan = (VectorFan)renderQuads;
            fan.generate(holder, quads);
        }
        for (class_777 quad : quads) {
            if (!(quad instanceof CreativeBakedQuad)) continue;
            CreativeBakedQuad c = (CreativeBakedQuad)quad;
            c.updateAlpha();
        }
        return quads;
    }

    private static class VectorFanSimple
    extends VectorFan {
        public VectorFanSimple(Vec3f[] coords) {
            super(coords);
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void generate(QuadGeneratorContext holder, List<class_777> quads) {
            int index;
            for (index = 0; index < this.coords.length - 3; index += 2) {
                this.generate(holder, this.coords[0], this.coords[index + 1], this.coords[index + 2], this.coords[index + 3], quads);
            }
            if (index < this.coords.length - 2) {
                this.generate(holder, this.coords[0], this.coords[index + 1], this.coords[index + 2], this.coords[index + 2], quads);
            }
        }

        @Override
        protected boolean doMinMaxLate() {
            return true;
        }
    }
}

