/*
 * Decompiled with CFR 0.152.
 */
package net.hyper_pigeon.eldritch_mobs.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.hyper_pigeon.eldritch_mobs.EldritchMobsMod;
import net.hyper_pigeon.eldritch_mobs.ability.Ability;
import net.hyper_pigeon.eldritch_mobs.ability.AbilityHelper;
import net.hyper_pigeon.eldritch_mobs.component.interfaces.ModifierComponent;
import net.hyper_pigeon.eldritch_mobs.persistent_state.SoothingLanternPersistentState;
import net.hyper_pigeon.eldritch_mobs.rank.MobRank;
import net.hyper_pigeon.eldritch_mobs.register.EldritchMobTagKeys;
import net.hyper_pigeon.eldritch_mobs.register.EldritchMobsAttributeModifiers;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_7225;

public class MobModifierComponent
implements ModifierComponent {
    private MobRank rank = MobRank.UNDECIDED;
    private List<Ability> modifiers = new ArrayList<Ability>();
    private final class_1308 provider;
    private int numMaxAbilities = 0;
    private final class_3213 bossBar;
    private boolean healthIncreased = false;
    private boolean checkedIfSpawnedInSoothingLanternChunk = false;
    private boolean titleSet = false;
    private boolean setName = false;

    public MobModifierComponent(class_1308 provider) {
        this.provider = provider;
        this.bossBar = new class_3213(class_2561.method_30163((String)""), class_1259.class_1260.field_5785, class_1259.class_1261.field_5795);
        if (this.canBeBuffed(provider)) {
            this.randomlySetRank();
        } else {
            this.rank = MobRank.NONE;
        }
    }

    public boolean canBeBuffed(class_1308 mobEntity) {
        return this.rank == MobRank.UNDECIDED && mobEntity.method_5864().method_20210(EldritchMobTagKeys.ALLOWED) && !mobEntity.method_5864().method_20210(EldritchMobTagKeys.BLACKLIST) && (!mobEntity.method_16914() || !EldritchMobsMod.ELDRITCH_MOBS_CONFIG.ignoreNamedMobs);
    }

    @Override
    public void randomlySetRank() {
        if (this.rank == MobRank.UNDECIDED) {
            Random random = new Random();
            double value = random.nextDouble();
            this.rank = MobRank.NONE;
            if (this.provider.method_5864().method_20210(EldritchMobTagKeys.ALWAYS_ELITE) || value <= EldritchMobsMod.ELDRITCH_MOBS_CONFIG.EliteSpawnRates && value > EldritchMobsMod.ELDRITCH_MOBS_CONFIG.UltraSpawnRates) {
                this.setRank(MobRank.ELITE);
            } else if (this.provider.method_5864().method_20210(EldritchMobTagKeys.ALWAYS_ULTRA) || value <= EldritchMobsMod.ELDRITCH_MOBS_CONFIG.UltraSpawnRates && value > EldritchMobsMod.ELDRITCH_MOBS_CONFIG.EldritchSpawnRates) {
                this.setRank(MobRank.ULTRA);
            } else if (this.provider.method_5864().method_20210(EldritchMobTagKeys.ALWAYS_ELDRITCH) || value <= EldritchMobsMod.ELDRITCH_MOBS_CONFIG.EldritchSpawnRates) {
                this.setRank(MobRank.ELDRITCH);
            }
        }
    }

    @Override
    public void randomlySetModifiers() {
        if (this.rank != MobRank.NONE && this.rank != MobRank.UNDECIDED) {
            this.modifiers = AbilityHelper.pickNRandomForEntity(AbilityHelper.getAbilities(), this.numMaxAbilities, this.provider.method_5864());
        }
    }

    @Override
    public void setTitle() {
        if (!this.provider.method_16914() && !EldritchMobsMod.ELDRITCH_MOBS_CONFIG.turnOffTitles && this.rank != MobRank.NONE) {
            StringBuilder output = new StringBuilder();
            if (EldritchMobsMod.ELDRITCH_MOBS_CONFIG.genericTitles) {
                String tier = this.getRank().name().toLowerCase();
                output.append(tier.substring(0, 1).toUpperCase()).append(tier.substring(1)).append(" ").append(this.provider.method_5476().getString());
                this.provider.method_5665(class_2561.method_30163((String)output.toString()));
            } else {
                for (Ability ability : this.modifiers) {
                    output.append(ability.getName()).append(" ");
                }
                output.append(this.provider.method_5476().getString());
                this.provider.method_5665(class_2561.method_30163((String)output.toString()));
            }
        }
    }

    public class_2561 getTitle() {
        StringBuilder output = new StringBuilder();
        if (EldritchMobsMod.ELDRITCH_MOBS_CONFIG.genericTitles) {
            String tier = this.getRank().name().toLowerCase();
            output.append(tier.substring(0, 1).toUpperCase()).append(tier.substring(1)).append(" ").append(this.provider.method_5476().getString());
        } else {
            for (Ability ability : this.modifiers) {
                output.append(ability.getName()).append(" ");
            }
            output.append(this.provider.method_5476().getString());
        }
        return class_2561.method_30163((String)output.toString());
    }

    @Override
    public List<Ability> getModifiers() {
        return this.modifiers;
    }

    @Override
    public void clearModifiers() {
        this.modifiers.clear();
        this.numMaxAbilities = 0;
    }

    @Override
    public MobRank getRank() {
        return this.rank;
    }

    @Override
    public void setRank(MobRank mobRank) {
        this.rank = mobRank;
        switch (mobRank) {
            case ELITE: {
                this.numMaxAbilities = AbilityHelper.RANDOM.nextInt(EldritchMobsMod.ELDRITCH_MOBS_CONFIG.EliteMinModifiers, EldritchMobsMod.ELDRITCH_MOBS_CONFIG.EliteMaxModifiers + 1);
                this.bossBar.method_5416(class_1259.class_1260.field_5782);
                break;
            }
            case ULTRA: {
                this.numMaxAbilities = AbilityHelper.RANDOM.nextInt(EldritchMobsMod.ELDRITCH_MOBS_CONFIG.UltraMinModifiers, EldritchMobsMod.ELDRITCH_MOBS_CONFIG.UltraMaxModifiers + 1);
                this.bossBar.method_5416(class_1259.class_1260.field_5784);
                break;
            }
            case ELDRITCH: {
                this.numMaxAbilities = AbilityHelper.RANDOM.nextInt(EldritchMobsMod.ELDRITCH_MOBS_CONFIG.EldritchMinModifiers, EldritchMobsMod.ELDRITCH_MOBS_CONFIG.EldritchMaxModifiers + 1);
                this.bossBar.method_5416(class_1259.class_1260.field_5783);
                break;
            }
        }
    }

    private void increaseMaxHealthForModifier(class_1322 modifier) {
        class_1324 entityAttributeInstance = this.provider.method_5996(class_5134.field_23716);
        assert (entityAttributeInstance != null);
        if (!entityAttributeInstance.method_6196(modifier.comp_2447())) {
            entityAttributeInstance.method_26837(modifier);
        }
        this.provider.method_6033((float)this.provider.method_45325(class_5134.field_23716));
    }

    @Override
    public void increaseHealth() {
        if (!this.healthIncreased) {
            switch (this.rank) {
                case ELITE: {
                    this.increaseMaxHealthForModifier(EldritchMobsAttributeModifiers.ELITE_HEALTH_BOOST);
                    break;
                }
                case ULTRA: {
                    this.increaseMaxHealthForModifier(EldritchMobsAttributeModifiers.ULTRA_HEALTH_BOOST);
                    break;
                }
                case ELDRITCH: {
                    this.increaseMaxHealthForModifier(EldritchMobsAttributeModifiers.ELDRITCH_HEALTH_BOOST);
                    break;
                }
            }
            this.healthIncreased = true;
        }
    }

    @Override
    public class_3213 getBossBar() {
        return this.bossBar;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.healthIncreased = tag.method_10577("healthIncreased");
        this.numMaxAbilities = tag.method_10550("numMaxAbilities");
        this.checkedIfSpawnedInSoothingLanternChunk = tag.method_10577("checkedIfSpawnedInSoothingLanternChunk");
        this.titleSet = tag.method_10577("titleSet");
        switch (this.numMaxAbilities) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.rank = MobRank.ELITE;
                this.bossBar.method_5416(class_1259.class_1260.field_5782);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.rank = MobRank.ULTRA;
                this.bossBar.method_5416(class_1259.class_1260.field_5784);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.rank = MobRank.ELDRITCH;
                this.bossBar.method_5416(class_1259.class_1260.field_5783);
                break;
            }
            default: {
                this.rank = MobRank.NONE;
            }
        }
        if (this.modifiers != null) {
            this.modifiers.clear();
        }
        for (String name : tag.method_10562("abilities").method_10541()) {
            AbilityHelper.getAbilityRecordByName(name).ifPresent(record -> this.modifiers.add(record.ability));
        }
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10556("healthIncreased", this.healthIncreased);
        tag.method_10569("numMaxAbilities", this.numMaxAbilities);
        tag.method_10556("checkedIfSpawnedInSoothingLanternChunk", this.checkedIfSpawnedInSoothingLanternChunk);
        tag.method_10556("titleSet", this.titleSet);
        class_2487 mobAbilities = new class_2487();
        if (this.modifiers != null) {
            for (Ability ability : this.modifiers) {
                mobAbilities.method_10582(ability.getName(), ability.getName());
            }
        }
        tag.method_10566("abilities", (class_2520)mobAbilities);
    }

    public void makeMobNormal() {
        this.rank = MobRank.NONE;
        this.clearModifiers();
        this.provider.method_5665(null);
        this.bossBar.method_14094();
    }

    boolean isPlayerStaring(class_3222 player) {
        class_243 vec3d = player.method_33571();
        class_243 vec3d2 = player.method_5828(1.0f);
        class_243 vec3d3 = vec3d.method_1031(vec3d2.field_1352 * 100.0, vec3d2.field_1351 * 100.0, vec3d2.field_1350 * 100.0);
        class_3966 entityHitResult = class_1675.method_37226((class_1937)player.method_5770(), (class_1297)player, (class_243)vec3d, (class_243)vec3d3, (class_238)new class_238(vec3d, vec3d3).method_1014(1.0), entityX -> !entityX.method_7325() && entityX instanceof class_1308, (float)0.0f);
        if (entityHitResult != null && entityHitResult.method_17783() == class_239.class_240.field_1331) {
            class_1308 mobEntity = (class_1308)entityHitResult.method_17782();
            return mobEntity.equals((Object)this.provider);
        }
        return false;
    }

    public void serverTick() {
        if (!this.checkedIfSpawnedInSoothingLanternChunk) {
            if (this.rank != MobRank.NONE && !this.provider.method_5770().field_9236) {
                if (SoothingLanternPersistentState.get((class_3218)this.provider.method_5770()).containsChunk(this.provider.method_31476())) {
                    this.makeMobNormal();
                } else {
                    this.randomlySetModifiers();
                }
            }
            this.checkedIfSpawnedInSoothingLanternChunk = true;
        }
        if (!this.setName) {
            this.bossBar.method_5413(this.provider.method_5476());
            this.setName = true;
        }
        if (this.getRank() != MobRank.NONE) {
            if (!(this.provider.method_16914() || this.titleSet || EldritchMobsMod.ELDRITCH_MOBS_CONFIG.turnOffTitles)) {
                this.setTitle();
                this.titleSet = true;
            }
            if (!EldritchMobsMod.ELDRITCH_MOBS_CONFIG.turnOffBossBars) {
                if (!this.provider.method_16914()) {
                    this.bossBar.method_5413(this.getTitle());
                } else {
                    this.bossBar.method_5413(this.provider.method_5797());
                }
                this.bossBar.method_5408(this.provider.method_6032() / this.provider.method_6063());
                if (EldritchMobsMod.ELDRITCH_MOBS_CONFIG.crosshairBossBars) {
                    List bossBarPlayers = this.bossBar.method_14092().stream().toList();
                    bossBarPlayers.forEach(player -> {
                        if (!this.isPlayerStaring((class_3222)player)) {
                            this.bossBar.method_14089(player);
                        }
                    });
                }
            }
            this.increaseHealth();
        }
    }

    public boolean isCheckedIfSpawnedInSoothingLanternChunk() {
        return this.checkedIfSpawnedInSoothingLanternChunk;
    }
}

