/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.blocks;

import com.github.teamfusion.rottencreatures.common.level.blockentities.TreasureChestBlockEntity;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_10;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class TreasureChestBlock
extends class_2237 {
    private static final int MAX = 15;
    private static final int ROTATIONS = 16;
    public static final class_2758 ROTATION = class_2741.field_12532;
    public static final class_2746 OPEN = class_2741.field_12537;
    private static final class_265 SHAPE = TreasureChestBlock.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0);

    protected MapCodec<? extends class_2237> method_53969() {
        return TreasureChestBlock.method_54094(TreasureChestBlock::new);
    }

    public TreasureChestBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(0))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_265 method_9571(class_2680 state, class_1922 level, class_2338 pos) {
        return class_259.method_1073();
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof TreasureChestBlockEntity) {
            class_9279 customData;
            TreasureChestBlockEntity chest = (TreasureChestBlockEntity)class_25862;
            if (placer instanceof class_1657) {
                class_1657 player = (class_1657)placer;
                chest.setOwnerUUID(player.method_5667());
            }
            if ((customData = (class_9279)stack.method_57824(class_9334.field_49628)) == null || customData.method_57458()) {
                return;
            }
            class_2487 tag = customData.method_57461();
            if (tag.method_10573("Items", 9)) {
                class_2499 itemsList = tag.method_10554("Items", 10);
                for (int i = 0; i < itemsList.size(); ++i) {
                    class_2487 itemTag = itemsList.method_10602(i);
                    if (!itemTag.method_10573("id", 8)) continue;
                    try {
                        String id = itemTag.method_10558("id");
                        int count = itemTag.method_10573("Count", 3) ? itemTag.method_10550("Count") : 1;
                        class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)id));
                        class_1799 itemStack = new class_1799((class_1935)item, count);
                        if (itemTag.method_10573("tag", 10)) {
                            itemStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)itemTag.method_10562("tag")));
                        }
                        if (itemStack.method_7960()) continue;
                        chest.getItems().add((Object)itemStack);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                chest.recalculateTotalCount();
            }
            if (chest.getOwnerUUID() == null && tag.method_25928("OwnerUUID")) {
                chest.setOwnerUUID(tag.method_25926("OwnerUUID"));
            }
            chest.method_5431();
        }
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        return TreasureChestBlock.method_20044((class_4538)level, (class_2338)pos.method_10074(), (class_2350)class_2350.field_11036);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        return direction == class_2350.field_11033 && !state.method_26184((class_4538)level, currentPos) ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        if (!TreasureChestBlock.method_20044((class_4538)context.method_8045(), (class_2338)context.method_8037().method_10074(), (class_2350)class_2350.field_11036)) {
            return null;
        }
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(class_3532.method_15357((double)((double)(context.method_8044() * 16.0f / 360.0f) + 0.5)) & 0xF))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false));
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (level.field_9236) {
            return class_9062.field_47728;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof TreasureChestBlockEntity)) {
            return class_9062.field_47731;
        }
        TreasureChestBlockEntity chest = (TreasureChestBlockEntity)class_25862;
        if (!chest.isOwner(player.method_5667())) {
            UUID ownerUUID = chest.getOwnerUUID();
            if (ownerUUID != null && level.method_8503() != null) {
                String ownerName = level.method_8503().method_3793().method_14512(ownerUUID).map(GameProfile::getName).orElse("someone");
                player.method_7353((class_2561)class_2561.method_43469((String)"block.rottencreatures.treasure_chest.cannot_open", (Object[])new Object[]{class_2561.method_43470((String)ownerName).method_27692(class_124.field_1065)}), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"block.rottencreatures.treasure_chest.locked"), true);
            }
            return class_9062.field_47731;
        }
        boolean isOpen = (Boolean)state.method_11654((class_2769)OPEN);
        if (!isOpen) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(true)), 3);
            level.method_8396(null, pos, class_3417.field_14982, class_3419.field_15245, 0.5f, level.field_9229.method_43057() * 0.1f + 0.9f);
            if (chest.hasContents()) {
                class_2371<class_1799> storedItems = chest.removeAllItems();
                for (class_1799 items : storedItems) {
                    this.spawnItemEntity(level, pos, items);
                }
            }
        } else {
            if (!stack.method_7960()) {
                class_1747 block;
                class_1792 class_17922 = stack.method_7909();
                if (class_17922 instanceof class_1747 && !(block = (class_1747)class_17922).method_31568()) {
                    return class_9062.field_47731;
                }
                int amountToAdd = TreasureChestBlock.addItemsToContainer(chest, stack);
                class_2371<class_1799> replacedItems = chest.addItemsWithReplacement(stack.method_7972(), amountToAdd);
                for (class_1799 replacedItem : replacedItems) {
                    this.spawnItemEntity(level, pos, replacedItem);
                }
                stack.method_7934(amountToAdd);
                level.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 0.5f, level.field_9229.method_43057() * 0.1f + 0.9f);
                return class_9062.field_47729;
            }
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false)), 3);
            level.method_8396(null, pos, class_3417.field_14823, class_3419.field_15245, 0.5f, level.field_9229.method_43057() * 0.1f + 0.9f);
        }
        player.method_7281(class_3468.field_15395);
        return class_9062.field_47729;
    }

    private static int addItemsToContainer(TreasureChestBlockEntity chest, class_1799 heldItem) {
        class_2371<class_1799> items = chest.getItems();
        int totalCount = 0;
        for (class_1799 item : items) {
            totalCount += item.method_7947();
        }
        int maxStackSize = chest.maxStackSize;
        int spaceLeft = maxStackSize - totalCount;
        int amountToAdd = spaceLeft <= 0 ? heldItem.method_7947() : Math.min(spaceLeft, heldItem.method_7947());
        return amountToAdd;
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        TreasureChestBlockEntity chest;
        class_2586 blockEntity = (class_2586)builder.method_51876(class_181.field_1228);
        if (blockEntity instanceof TreasureChestBlockEntity && (chest = (TreasureChestBlockEntity)blockEntity).hasContents()) {
            class_1799 drop = new class_1799((class_1935)this);
            class_2487 customTag = new class_2487();
            class_2499 itemsList = new class_2499();
            for (class_1799 stack : chest.getItems()) {
                if (stack.method_7960()) continue;
                class_2487 itemTag = new class_2487();
                itemTag.method_10582("id", class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
                itemTag.method_10569("Count", stack.method_7947());
                class_9279 data = (class_9279)stack.method_57824(class_9334.field_49628);
                if (data != null && !data.method_57458()) {
                    itemTag.method_10566("tag", (class_2520)data.method_57461());
                }
                itemsList.add((Object)itemTag);
            }
            if (!itemsList.isEmpty()) {
                customTag.method_10566("Items", (class_2520)itemsList);
            }
            if (chest.getOwnerUUID() != null) {
                customTag.method_25927("OwnerUUID", chest.getOwnerUUID());
            }
            if (!customTag.method_33133()) {
                drop.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)customTag));
            }
            return Collections.singletonList(drop);
        }
        return super.method_9560(state, builder);
    }

    private void spawnItemEntity(class_1937 level, class_2338 pos, class_1799 stack) {
        if (!stack.method_7960()) {
            class_2680 state = level.method_8320(pos);
            int rotation = (Integer)state.method_11654((class_2769)ROTATION);
            double angle = Math.toRadians(((float)rotation * 22.5f + 180.0f) % 360.0f);
            double offsetX = -Math.sin(angle) * 0.7;
            double offsetZ = Math.cos(angle) * 0.7;
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + 0.5;
            double z = (double)pos.method_10260() + 0.5;
            class_1542 itemEntity = new class_1542(level, x, y, z, stack);
            double speed = 0.1 + level.field_9229.method_43058() * 0.05;
            itemEntity.method_18800(offsetX * speed, 0.2 + level.field_9229.method_43058() * 0.1, offsetZ * speed);
            level.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 0.5f, level.field_9229.method_43057() * 0.1f + 0.9f);
            itemEntity.method_6988();
            level.method_8649((class_1297)itemEntity);
        }
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 level, class_2338 pos) {
        TreasureChestBlockEntity chest;
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof TreasureChestBlockEntity && (chest = (TreasureChestBlockEntity)blockEntity).isOwner(player.method_5667())) {
            return super.method_9594(state, player, level, pos);
        }
        return 0.0f;
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof TreasureChestBlockEntity) {
            TreasureChestBlockEntity chest = (TreasureChestBlockEntity)blockEntity;
            if ((player.method_7337() || chest.isOwner(player.method_5667())) && chest.hasContents()) {
                class_1799 itemStack = new class_1799((class_1935)this);
                class_2487 customTag = new class_2487();
                if (!chest.getItems().isEmpty()) {
                    class_2499 itemsList = new class_2499();
                    for (class_1799 stack : chest.getItems()) {
                        if (stack.method_7960()) continue;
                        class_2487 itemTag = new class_2487();
                        itemTag.method_10582("id", class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
                        itemTag.method_10569("Count", stack.method_7947());
                        class_9279 data = (class_9279)stack.method_57824(class_9334.field_49628);
                        if (data != null && !data.method_57458()) {
                            itemTag.method_10566("tag", (class_2520)data.method_57461());
                        }
                        itemsList.add((Object)itemTag);
                    }
                    if (!itemsList.isEmpty()) {
                        customTag.method_10566("Items", (class_2520)itemsList);
                    }
                }
                if (chest.getOwnerUUID() != null) {
                    customTag.method_25927("OwnerUUID", chest.getOwnerUUID());
                }
                if (!customTag.method_33133()) {
                    itemStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)customTag));
                }
                class_1542 itemEntity = new class_1542(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, itemStack);
                itemEntity.method_6988();
                level.method_8649((class_1297)itemEntity);
                chest.removeAllItems();
            }
        }
        return super.method_9576(level, pos, state, player);
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (!state.method_27852(newState.method_26204())) {
            super.method_9536(state, level, pos, newState, isMoving);
        }
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(rotation.method_10502(((Integer)state.method_11654((class_2769)ROTATION)).intValue(), 16)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(mirror.method_10344(((Integer)state.method_11654((class_2769)ROTATION)).intValue(), 16)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{ROTATION, OPEN});
    }

    @Nullable
    public class_2586 method_10123(class_2338 origin, class_2680 state) {
        return new TreasureChestBlockEntity(origin, state);
    }
}

