/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.io.mod;

import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.io.mod.FabricModInfoProvider;
import io.github.thecsdev.tcdcommons.api.util.io.mod.ModInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public abstract class ModInfoProvider {
    private static ModInfoProvider INSTANCE = new FabricModInfoProvider();

    public static final ModInfoProvider getInstance() {
        return INSTANCE;
    }

    public static final void setInstance(ModInfoProvider instance) throws NullPointerException {
        INSTANCE = Objects.requireNonNull(instance);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static final ModInfo getModInfoS(String modId) throws NullPointerException, IllegalStateException {
        if (INSTANCE == null) {
            throw new IllegalStateException(ModInfoProvider.class.getSimpleName() + " instance is missing.");
        }
        return INSTANCE.getModInfo(modId);
    }

    @Nullable
    public abstract ModInfo getModInfo(String var1) throws NullPointerException;

    public abstract String[] getLoadedModIDs();

    @Virtual
    public boolean isModLoaded(String modId) throws NullPointerException {
        return Arrays.asList(this.getLoadedModIDs()).contains(Objects.requireNonNull(modId));
    }

    public final Map<Character, Collection<String>> getLoadedModIDsGrouped() {
        return this.getLoadedModIDsGrouped(null);
    }

    public final Map<Character, Collection<String>> getLoadedModIDsGrouped(@Nullable Predicate<String> predicate) {
        return Arrays.stream(this.getLoadedModIDs()).filter(mod -> !StringUtils.isBlank((CharSequence)mod) && (predicate == null || predicate.test((String)mod))).sorted().collect(Collectors.toMap(mod -> Character.valueOf(mod.substring(0, 1).toUpperCase().charAt(0)), mod -> new ArrayList<String>(Collections.singletonList(mod)), (list1, list2) -> {
            ArrayList combinedList = new ArrayList(list1);
            combinedList.addAll(list2);
            return combinedList;
        }, TreeMap::new));
    }
}

