/*
 * Decompiled with CFR 0.152.
 */
package ljfa.tntutils.fabric;

import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.StringConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import ljfa.tntutils.TNTUtils;
import ljfa.tntutils.TNTUtilsConfigAccess;
import net.fabricmc.loader.api.FabricLoader;

public class FiberTNTUtilsConfig {
    public static final Common COMMON = new Common();

    public static void init() {
        ConfigTree configTree = COMMON.buildConfig();
        Path configFile = FabricLoader.getInstance().getConfigDir().resolve("tntutils.json5");
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        try (BufferedInputStream reader2 = new BufferedInputStream(Files.newInputStream(configFile, new OpenOption[0]));){
            FiberSerialization.deserialize((ConfigTree)configTree, (InputStream)reader2, (ValueSerializer)serializer);
        }
        catch (NoSuchFileException reader2) {
        }
        catch (ValueDeserializationException | IOException e) {
            TNTUtils.logger.error("Error reading config file, will create a backup", e);
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss"));
            Path backupFile = configFile.resolveSibling("tntutils-" + timestamp + ".json5.bak");
            try {
                Files.move(configFile, backupFile, new CopyOption[0]);
            }
            catch (IOException e1) {
                TNTUtils.logger.error("Error backing up config file", (Throwable)e1);
                return;
            }
        }
        try (BufferedOutputStream writer = new BufferedOutputStream(Files.newOutputStream(configFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));){
            FiberSerialization.serialize((ConfigTree)configTree, (OutputStream)writer, (ValueSerializer)serializer);
        }
        catch (IOException e) {
            TNTUtils.logger.error("Error writing config file", (Throwable)e);
        }
    }

    public static class Common
    implements TNTUtilsConfigAccess {
        public final PropertyMirror<Boolean> addExplodeCommand = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> disableExplosions = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Float> sizeMultiplier = PropertyMirror.create((ConfigType)ConfigTypes.FLOAT);
        public final PropertyMirror<Boolean> preventChainExplosions = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> disableTNT = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Float> dropChanceMultiplier = PropertyMirror.create((ConfigType)ConfigTypes.FLOAT);
        public final PropertyMirror<Boolean> disableBlockDamage = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> disableCreeperBlockDamage = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> disableBlockTriggering = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> spareBlockEntities = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Map<String, Float>> modifyExplosionResistances = PropertyMirror.create((ConfigType)ConfigTypes.makeMap((StringConfigType)ConfigTypes.STRING, (ConfigType)ConfigTypes.FLOAT.withMinimum((Object)Float.valueOf(0.0f))));
        public final PropertyMirror<Boolean> disableEntityDamage = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> disablePlayerDamage = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> disableItemDamage = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> disableMobDamage = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);

        public ConfigTree buildConfig() {
            return ConfigTree.builder().fork("general").withComment("General options").beginValue("addExplodeCommand", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Adds the '/explode' command").finishValue(arg_0 -> this.addExplodeCommand.mirror(arg_0)).beginValue("disableExplosions", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Disables all effects from explosions").finishValue(arg_0 -> this.disableExplosions.mirror(arg_0)).beginValue("sizeMultiplier", (ConfigType)ConfigTypes.FLOAT.withMinimum((Object)Float.valueOf(0.0f)).withMaximum((Object)Float.valueOf(50.0f)), (Object)Float.valueOf(1.0f)).withComment("Multiplies the size of all explosions by this value").finishValue(arg_0 -> this.sizeMultiplier.mirror(arg_0)).beginValue("preventChainExplosions", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Prevents explosions from triggering TNT (blocks and minecarts), thus preventing chain explosions").finishValue(arg_0 -> this.preventChainExplosions.mirror(arg_0)).beginValue("disableTNT", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Disables TNT (block and minecart) explosions").finishValue(arg_0 -> this.disableTNT.mirror(arg_0)).finishBranch().fork("blockDamage").withComment("Block damage options").beginValue("dropChanceMultiplier", (ConfigType)ConfigTypes.FLOAT.withMinimum((Object)Float.valueOf(0.0f)), (Object)Float.valueOf(1.0f)).withComment("Multiplies the drop chance of blocks destroyed by explosions by this value (up to a maximum of 100%).\n0 = drop nothing, 1 = vanilla behavior, 2 = twice as many drops, etc.\n\nWill not affect explosions without block drop decay (i.e. TNT explosions by default).\nTo get a drop chance of 100%, set the game rules \"mobExplosionDropDecay\", \"tntExplosionDropDecay\" and\n\"blockExplosionDropDecay\" to \"false\".").finishValue(arg_0 -> this.dropChanceMultiplier.mirror(arg_0)).beginValue("disableBlockDamage", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Prevents explosions from destroying blocks. Will not affect blocks tagged with #tntutils:explosion_whitelist.\nIndividual blocks can be exempted from explosion damage by tagging them with #tntutils:explosion_blacklist.").finishValue(arg_0 -> this.disableBlockDamage.mirror(arg_0)).beginValue("disableCreeperBlockDamage", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("\"Environmentally Friendly Creepers\": Prevents Creeper explosions from destroying blocks. Will not affect\nblocks tagged with #tntutils:explosion_whitelist.").finishValue(arg_0 -> this.disableCreeperBlockDamage.mirror(arg_0)).beginValue("disableBlockTriggering", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Prevents explosions from triggering blocks (e.g. Wind Charge explosions flipping levers, etc.). Will not\naffect blocks tagged with #tntutils:trigger_whitelist.\nIndividual blocks can be exempted from triggering by tagging them with #tntutils:trigger_whitelist.").finishValue(arg_0 -> this.disableBlockTriggering.mirror(arg_0)).beginValue("spareBlockEntities", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Prevents explosions from destroying blocks with block entities. Will not affect blocks tagged with\n#tntutils:explosion_whitelist.").finishValue(arg_0 -> this.spareBlockEntities.mirror(arg_0)).beginValue("modifyExplosionResistances", this.modifyExplosionResistances.getMirroredType(), Map.of()).withComment("Changes the explosion resistance of individual blocks.\nThis is an object of entries of the form \"mod_id:block_id\": value").finishValue(arg_0 -> this.modifyExplosionResistances.mirror(arg_0)).finishBranch().fork("entityDamage").withComment("Entity damage options").beginValue("disableEntityDamage", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Disables explosion damage to all entities (also includes minecarts, paintings, etc.). Will not affect entities\ntagged with #tntutils:explosion_whitelist.\nIndividual entities can be exempted from explosion damage by tagging them with #tntutils:explosion_blacklist.").finishValue(arg_0 -> this.disableEntityDamage.mirror(arg_0)).beginValue("disablePlayerDamage", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Disables explosion damage to players").finishValue(arg_0 -> this.disablePlayerDamage.mirror(arg_0)).beginValue("disableItemDamage", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Disables explosion damage to items laying on the ground. Will not affect items tagged with #tntutils:explosion_whitelist.\nIndividual items can be exempted from explosion damage by tagging them with #tntutils:explosion_blacklist.").finishValue(arg_0 -> this.disableItemDamage.mirror(arg_0)).beginValue("disableMobDamage", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Disables explosion damage to mobs and animals. Will not affect entities tagged with #tntutils:explosion_whitelist.").finishValue(arg_0 -> this.disableMobDamage.mirror(arg_0)).finishBranch().build();
        }

        @Override
        public boolean addExplodeCommand() {
            return (Boolean)this.addExplodeCommand.getValue();
        }

        @Override
        public boolean disableExplosions() {
            return (Boolean)this.disableExplosions.getValue();
        }

        @Override
        public float sizeMultiplier() {
            return ((Float)this.sizeMultiplier.getValue()).floatValue();
        }

        @Override
        public boolean preventChainExplosions() {
            return (Boolean)this.preventChainExplosions.getValue();
        }

        @Override
        public boolean disableTNT() {
            return (Boolean)this.disableTNT.getValue();
        }

        @Override
        public float dropChanceMultiplier() {
            return ((Float)this.dropChanceMultiplier.getValue()).floatValue();
        }

        @Override
        public boolean disableBlockDamage() {
            return (Boolean)this.disableBlockDamage.getValue();
        }

        @Override
        public boolean disableCreeperBlockDamage() {
            return (Boolean)this.disableCreeperBlockDamage.getValue();
        }

        @Override
        public boolean disableBlockTriggering() {
            return (Boolean)this.disableBlockTriggering.getValue();
        }

        @Override
        public boolean spareBlockEntities() {
            return (Boolean)this.spareBlockEntities.getValue();
        }

        @Override
        public boolean disableEntityDamage() {
            return (Boolean)this.disableEntityDamage.getValue();
        }

        @Override
        public boolean disablePlayerDamage() {
            return (Boolean)this.disablePlayerDamage.getValue();
        }

        @Override
        public boolean disableItemDamage() {
            return (Boolean)this.disableItemDamage.getValue();
        }

        @Override
        public boolean disableMobDamage() {
            return (Boolean)this.disableMobDamage.getValue();
        }
    }
}

