/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.structure.grid.generator;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.structure.grid.GridPiecesGenerator;
import com.github.mim1q.minecells.structure.grid.SpecialPointIds;
import com.github.mim1q.minecells.structure.grid.generator.MultipartGridGenerator;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2960;
import net.minecraft.class_5819;

public class RampartsGridGenerator
extends MultipartGridGenerator {
    private static final class_2960 BASE = MineCells.createId("ramparts/base");
    private static final class_2960 BOTTOM = MineCells.createId("ramparts/bottom");
    private static final class_2960 TOP = MineCells.createId("ramparts/top");
    private static final class_2960 TOP_ENTRY = MineCells.createId("ramparts/top_entry");
    private static final class_2960 ROOM_ENTRY = MineCells.createId("ramparts/room_entry");
    private static final class_2960 ROOM = MineCells.createId("ramparts/room");
    private static final class_2960 ROOM_END = MineCells.createId("ramparts/room_end");
    private static final class_2960 ROOM_EXIT = MineCells.createId("ramparts/room_exit");
    private static final class_2960 END = MineCells.createId("ramparts/end");
    private static final class_2960 BOTTOM_END = MineCells.createId("ramparts/bottom_end");
    private static final class_2960 SPAWN = MineCells.createId("ramparts/spawn");
    private static final class_2960 SPAWN_END = MineCells.createId("ramparts/spawn_end");
    private static final class_2960 TOWER_BOTTOM = MineCells.createId("ramparts/tower/bottom");
    private static final class_2960 TOWER_BASE = MineCells.createId("ramparts/tower/base");
    private static final class_2960 TOWER_ROOM = MineCells.createId("ramparts/tower/room");
    private static final class_2960 TOWER_ENTRY_ROOM = MineCells.createId("ramparts/tower/entry_room");
    private static final class_2960 TOWER_TOP = MineCells.createId("ramparts/tower/top");
    private static final class_2960 END_TOWER_ENTRANCE = MineCells.createId("ramparts/end_tower/entrance");
    private static final class_2960 END_TOWER_ELEVATOR_SHAFT = MineCells.createId("ramparts/end_tower/elevator_shaft");
    private static final class_2960 END_TOWER_EXIT = MineCells.createId("ramparts/end_tower/exit");
    private static final class_2960 PLATFORM = MineCells.createId("ramparts/platform");
    private static final class_2960 PLATFORM_UP = MineCells.createId("ramparts/platform_up");
    private static final int LOWER_BASE_HEIGHT = 6;
    private static final int BASE_HEIGHT = 14;

    public RampartsGridGenerator(int x, int z) {
        super(x, z);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    protected void addRooms(class_5819 random) {
        boolean[] turns = new boolean[]{random.method_43056(), random.method_43056(), random.method_43056(), random.method_43056()};
        if (turns[0] && turns[1] && turns[2] && turns[3] || !turns[0] && !turns[1] && !turns[2] && !turns[3]) {
            int n = random.method_43048(4);
            turns[n] = turns[n] ^ true;
        }
        this.addWall(40, 24, 14, 3, true);
        int x = 40;
        int z = 26;
        int height = 14;
        for (int i = 0; i < 4; ++i) {
            int startZ;
            boolean up = random.method_43056();
            class_2470 rot = turns[i] ? class_2470.field_11465 : class_2470.field_11463;
            int length = 3 + random.method_43048(4);
            this.addRoom(new class_2382((x += turns[i] ? 2 : -2) - rot.method_10503(class_2350.field_11035).method_10148(), height - 1, z + 1), rot, up ? PLATFORM_UP : PLATFORM);
            if (up) {
                ++height;
            }
            this.addWall(x, z, height, length, false);
            boolean[] sideTowers = new boolean[]{(double)random.method_43057() < 0.75, (double)random.method_43057() < 0.75};
            if (!sideTowers[0] && !sideTowers[1]) {
                sideTowers[random.method_43048((int)2)] = true;
            }
            if (sideTowers[0]) {
                boolean prevRight = turns[i];
                startZ = z + (prevRight ? 2 : 1);
                this.addTower(x - 2, height, startZ + random.method_43048(length - 2), random, class_2470.field_11463);
            }
            if (sideTowers[1]) {
                boolean prevLeft = !turns[i];
                startZ = z + (prevLeft ? 2 : 1);
                this.addTower(x + 2, height, startZ + random.method_43048(length - 2), random, class_2470.field_11465);
            }
            z += length - 1;
        }
        this.addRoom(new class_2382(x, height - 1, z + 2), class_2470.field_11467, PLATFORM_UP);
        this.addEndTower(x, height + 1, z + 3);
    }

    private void addWall(int x, int z, int height, int length, boolean spawn) {
        int i;
        boolean rooms = length >= 4 && !spawn;
        this.addColumn(x, z, 0, height, 0, BOTTOM_END, null, spawn ? SPAWN_END : END, class_2470.field_11467, class_2470.field_11467);
        if (spawn) {
            this.addColumn(x, z, 1, height, 0, BOTTOM, null, SPAWN, class_2470.field_11467, class_2470.field_11467);
        }
        int n = i = spawn ? 2 : 1;
        while (i <= length) {
            this.addColumn(x, z, i, height, rooms && i > 1 && i < length ? 1 : 0, BOTTOM, rooms && i == 1 ? TOP_ENTRY : TOP, (class_2960)(rooms && i > 1 && i < length ? null : BOTTOM), class_2470.field_11467, class_2470.field_11467);
            ++i;
        }
        if (rooms) {
            this.addDungeonRooms(x, height - 1, z + 1, length, 2, class_2470.field_11467);
        }
        this.addColumn(x, z, length + 1, height, 0, BOTTOM_END, null, END, class_2470.field_11464, class_2470.field_11467);
    }

    private void addDungeonRooms(int startX, int startY, int startZ, int length, int height, class_2470 offsetRotation) {
        for (int y = startY; y > startY - height; --y) {
            for (int offset = 0; offset < length; ++offset) {
                int x = startX + offset * offsetRotation.method_10503(class_2350.field_11035).method_10148();
                int z = startZ + offset * offsetRotation.method_10503(class_2350.field_11035).method_10165();
                boolean reversed = y % 2 == 1 ^ startY % 2 == 1;
                class_2960 roomType = ROOM;
                if (reversed && offset == length - 1 || !reversed && offset == 0) {
                    roomType = ROOM_ENTRY;
                }
                if (reversed && offset == 0 || !reversed && offset == length - 1) {
                    roomType = y == startY - height + 1 ? ROOM_EXIT : ROOM_END;
                }
                this.addRoom(new class_2382(x, y, z), reversed ? class_2470.field_11464 : class_2470.field_11467, roomType);
            }
        }
    }

    private void addTower(int x, int y, int z, class_5819 random, class_2470 rotation) {
        int i;
        if (this.isPositionUsed(new class_2382(x, 0, z))) {
            return;
        }
        boolean floating = random.method_43056();
        int height = 2 + random.method_43048(3);
        this.addRoom(new class_2382(x - rotation.method_10503(class_2350.field_11035).method_10148(), y - 1, z), rotation, PLATFORM);
        if (floating) {
            int underY = random.method_43048(1) + 2;
            this.addRoom(new class_2382(x, y - underY, z), rotation, TOWER_BOTTOM);
            for (int i2 = y - underY + 1; i2 < y; ++i2) {
                this.addRoom(new class_2382(x, i2, z), rotation, TOWER_BASE);
            }
        } else {
            for (i = 0; i < y; ++i) {
                this.addRoom(new class_2382(x, i, z), rotation, TOWER_BASE);
            }
        }
        for (i = y; i < y + height; ++i) {
            this.addRoom(new class_2382(x, i, z), rotation, i == y ? TOWER_ENTRY_ROOM : TOWER_ROOM);
        }
        this.addRoom(new class_2382(x, y + height, z), rotation, TOWER_TOP);
    }

    private void addEndTower(int x, int y, int z) {
        int i;
        int height = 13;
        for (i = 0; i < height; ++i) {
            this.addRoom(new class_2382(x, i, z), class_2470.field_11467, TOWER_BASE);
        }
        this.addRoom(GridPiecesGenerator.RoomData.create(new class_2382(x, height, z), END_TOWER_EXIT).specialPoint(SpecialPointIds.EXIT, new class_2382(4, 0, 4), class_2470.field_11467));
        for (i = height + 1; i < y; ++i) {
            this.addRoom(new class_2382(x, i, z), class_2470.field_11467, END_TOWER_ELEVATOR_SHAFT);
        }
        this.addRoom(new class_2382(x, y, z), class_2470.field_11467, END_TOWER_ENTRANCE);
        this.addRoom(new class_2382(x, y + 1, z), class_2470.field_11467, TOWER_TOP);
    }

    private void addColumn(int startX, int startZ, int offset, int height, int freeY, class_2960 bottom, class_2960 top, class_2960 second, class_2470 rotation, class_2470 offsetRotation) {
        int i;
        int x = startX + offset * offsetRotation.method_10503(class_2350.field_11035).method_10148();
        int z = startZ + offset * offsetRotation.method_10503(class_2350.field_11035).method_10165();
        for (i = 0; i < 6; ++i) {
            this.addRoom(new class_2382(x, i, z), rotation, BASE);
        }
        for (i = 6; i <= height - 2 - freeY; ++i) {
            this.addRoom(new class_2382(x, i, z), rotation, bottom);
        }
        if (second != null) {
            GridPiecesGenerator.RoomData room = GridPiecesGenerator.RoomData.create(new class_2382(x, height - 1, z), second).rotation(rotation);
            if (second == SPAWN) {
                room.specialPoint(SpecialPointIds.ENTRANCE, new class_2382(10, 3, 8), class_2470.field_11464);
            }
            this.addRoom(room);
        }
        if (top != null) {
            this.addRoom(RampartsGridGenerator.room(new class_2382(x, height, z), top).rotation(rotation).specialPoint(SpecialPointIds.CHECKPOINT, new class_2382(8, 0, 4), class_2470.field_11467));
        }
    }
}

