/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.structure.grid.generator;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.structure.grid.GridPiecesGenerator;
import com.github.mim1q.minecells.structure.grid.SpecialPointIds;
import com.github.mim1q.minecells.structure.grid.generator.MultipartGridGenerator;
import com.github.mim1q.minecells.structure.grid.util.Vec3iCursor;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class PrisonGridGenerator
extends MultipartGridGenerator {
    private static final class_2960 SPAWN = PrisonGridGenerator.id("spawn/spawn");
    private static final class_2960 SPAWN_OUTSIDE_NEAR = PrisonGridGenerator.id("spawn/outside_near");
    private static final class_2960 SPAWN_OUTSIDE_FAR = PrisonGridGenerator.id("spawn/outside_far");
    private static final class_2960 STAIRS = PrisonGridGenerator.id("stairs");
    private static final class_2960 STRAIGHT = PrisonGridGenerator.id("straight");
    private static final class_2960 TURN = PrisonGridGenerator.id("turn");
    private static final class_2960 CURVE = PrisonGridGenerator.id("curve");
    private static final class_2960 TERMINAL = PrisonGridGenerator.id("terminal");
    private static final class_2960 PROMENADE = PrisonGridGenerator.id("promenade");

    public PrisonGridGenerator(int xPart, int zPart) {
        super(xPart, zPart);
    }

    @Override
    protected void addRooms(class_5819 random) {
        Vec3iCursor cursor = new Vec3iCursor(new class_2382(32, 15, 32), class_2350.field_11035);
        Vec3iCursor spawnCursor = cursor.split();
        this.addRoom(PrisonGridGenerator.room((class_2382)spawnCursor, SPAWN).offset(0, -2, 0).specialPoint(SpecialPointIds.ENTRANCE, new class_2382(12, 1, 1), class_2470.field_11467));
        this.addRoom(PrisonGridGenerator.room((class_2382)spawnCursor.stepLeft(), SPAWN_OUTSIDE_NEAR).offset(0, -2, 0));
        this.addRoom(PrisonGridGenerator.room((class_2382)spawnCursor.stepLeft(), SPAWN_OUTSIDE_FAR).offset(0, -2, 0));
        this.addFloor(random, cursor, 3);
    }

    private Vec3iCursor addCorridor(class_5819 random, Vec3iCursor cursor, boolean allowTurns, @Nullable class_2960 end, int length) {
        for (int i = 0; i < length; ++i) {
            if (random.method_43057() < 0.2f && allowTurns && i < length - 1 && i > 0) {
                boolean left = random.method_43056();
                if (left) {
                    this.addRoom(PrisonGridGenerator.room((class_2382)cursor.forward(), CURVE).rotation(cursor.getRotation().method_10501(class_2470.field_11465)));
                    for (int j = 0; j < random.method_43048(3); ++j) {
                        this.addRoom(PrisonGridGenerator.room((class_2382)cursor.stepLeft(), STRAIGHT).rotation(cursor.getRotation().method_10501(class_2470.field_11463)));
                    }
                    this.addRoom(PrisonGridGenerator.room((class_2382)cursor.stepLeft(), CURVE).rotation(cursor.getRotation().method_10501(class_2470.field_11463)));
                    continue;
                }
                this.addRoom(PrisonGridGenerator.room((class_2382)cursor.forward(), CURVE).rotation(cursor.getRotation().method_10501(class_2470.field_11464)));
                for (int j = 0; j < random.method_43048(3); ++j) {
                    this.addRoom(PrisonGridGenerator.room((class_2382)cursor.stepRight(), STRAIGHT).rotation(cursor.getRotation().method_10501(class_2470.field_11465)));
                }
                this.addRoom(PrisonGridGenerator.room((class_2382)cursor.stepRight(), CURVE).rotation(cursor.getRotation().method_10501(class_2470.field_11467)));
                continue;
            }
            boolean turn = allowTurns && random.method_43056();
            class_2470 rotation = random.method_43056() ? class_2470.field_11467 : class_2470.field_11464;
            this.addRoom(PrisonGridGenerator.room((class_2382)cursor.forward(), turn ? TURN : STRAIGHT).rotation(rotation.method_10501(cursor.getRotation())));
            if (!turn) continue;
            this.addCorridor(random, cursor.split().turn(rotation).turnRight(), false, TERMINAL, random.method_39332(2, 4));
        }
        if (end != null) {
            GridPiecesGenerator.RoomData endRoom = PrisonGridGenerator.room((class_2382)cursor.forward(), end).rotation(cursor.getRotation().method_10501(class_2470.field_11464));
            if (end == PROMENADE) {
                endRoom.specialPoint(SpecialPointIds.EXIT, new class_2382(9, 0, 14), class_2470.field_11464);
            }
            this.addRoom(endRoom);
        }
        return cursor.split();
    }

    private void addFloor(class_5819 random, Vec3iCursor cursor, int index) {
        Vec3iCursor endCursor = this.addCorridor(random, cursor, true, null, random.method_39332(3, 5));
        endCursor.forward();
        if (index > 0) {
            Vec3iCursor newCursor = endCursor.split();
            this.addRoom(PrisonGridGenerator.room((class_2382)newCursor.down(), STAIRS));
            this.addCorridor(random, newCursor.split(), true, TERMINAL, random.method_39332(0, 2));
            this.addFloor(random, newCursor.turn(class_2470.field_11464), index - 1);
            this.addCorridor(random, endCursor, true, TERMINAL, random.method_39332(0, 2));
        } else {
            this.addCorridor(random, endCursor.back(), true, PROMENADE, random.method_39332(0, 2));
        }
    }

    @Override
    public int getVersion() {
        return 1;
    }

    private static class_2960 id(String path) {
        return MineCells.createId("better_prison/" + path);
    }
}

