/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.structure.grid.generator;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.structure.grid.SpecialPointIds;
import com.github.mim1q.minecells.structure.grid.generator.MultipartGridGenerator;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5819;

public class BetterPromenadeGridGenerator
extends MultipartGridGenerator {
    private static final class_2960 PATH_STRAIGHT = BetterPromenadeGridGenerator.pool("path/straight");
    private static final class_2960 PATH_TURN = BetterPromenadeGridGenerator.pool("path/turn");
    private static final class_2960 PATH_CROSSROADS = BetterPromenadeGridGenerator.pool("path/crossroads");
    private static final class_2960 PATH_BUILDING = BetterPromenadeGridGenerator.pool("path/building");
    private static final class_2960 PATH_HALF = BetterPromenadeGridGenerator.pool("path/half");
    private static final class_2960 BUILDING_OVERGROUND = BetterPromenadeGridGenerator.pool("overground");
    private static final class_2960 BUILDING_OVERGROUND_END = BetterPromenadeGridGenerator.pool("overground_end");
    private static final class_2960 BUILDING_OVERGROUND_BASE = BetterPromenadeGridGenerator.pool("overground_base");
    private static final class_2960 BUILDING_OVERGROUND_ELEVATOR = BetterPromenadeGridGenerator.pool("overground_elevator");
    private static final class_2960 BUILDING_UNDERGROUND = BetterPromenadeGridGenerator.pool("underground");
    private static final class_2960 BUILDING_UNDERGROUND_END = BetterPromenadeGridGenerator.pool("underground_end");
    private static final class_2960 VINE_RUNE = BetterPromenadeGridGenerator.pool("special/vine_rune");
    private static final class_2960 SPAWN = BetterPromenadeGridGenerator.pool("spawn");
    private static final class_2960 SPAWN_STAIRS = BetterPromenadeGridGenerator.pool("stairs/spawn");
    private static final class_2960 END_STAIRS = BetterPromenadeGridGenerator.pool("stairs/end");
    private static final class_2960 END_BOTTOM = BetterPromenadeGridGenerator.pool("end/bottom");
    private static final class_2960 END_TOP = BetterPromenadeGridGenerator.pool("end/top");
    private static final class_2960 CROSSROADS_POST = BetterPromenadeGridGenerator.pool("path/crossroads_post");
    private static final class_2960 VINE_RUNE_POST = BetterPromenadeGridGenerator.pool("path/post/vine_rune");
    private static final class_2960 BEFORE_CROSSROADS_POST = BetterPromenadeGridGenerator.pool("path/post/before_crossroads");
    private static final class_2960 AFTER_CROSSROADS_POST = BetterPromenadeGridGenerator.pool("path/post/after_crossroads");

    public BetterPromenadeGridGenerator(int xPart, int zPart) {
        super(xPart, zPart);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    protected void addRooms(class_5819 random) {
        this.addRoom(BetterPromenadeGridGenerator.room(32, 4, 31, SPAWN).offset(0, -2, 0).specialPoint(SpecialPointIds.ENTRANCE, new class_2382(14, 13, 5), class_2470.field_11463).rotation(class_2470.field_11464));
        this.addRoom(BetterPromenadeGridGenerator.room(32, 4, 32, SPAWN_STAIRS).offset(0, -2, 0).rotation(class_2470.field_11464));
        this.addRoom(BetterPromenadeGridGenerator.room(32, 0, 32, PATH_HALF).terrainFit().rotation(class_2470.field_11464));
        class_3545<class_2382, class_2382> mainRoad = this.addPath(new class_2382(32, 0, 33), class_2470.field_11467, 22, random, 3, BEFORE_CROSSROADS_POST, AFTER_CROSSROADS_POST);
        class_2382 mainRoadEnd = (class_2382)mainRoad.method_15442();
        class_2382 mainRoadSkipped = (class_2382)mainRoad.method_15441();
        this.addRoom(BetterPromenadeGridGenerator.room(mainRoadSkipped, PATH_CROSSROADS));
        this.addRoom(BetterPromenadeGridGenerator.room(mainRoadSkipped, CROSSROADS_POST).terrainFit().terrainFitOffset(5, 0, 6));
        class_3545<class_2382, class_2382> sideRoad = this.addPath(mainRoadSkipped.method_34592(1, 0, 0), class_2470.field_11465, 9, random, -1, VINE_RUNE_POST, VINE_RUNE_POST);
        class_2382 sideRoadEnd = (class_2382)sideRoad.method_15442();
        this.addRoom(BetterPromenadeGridGenerator.room(mainRoadEnd.method_34592(0, 4, 1), END_STAIRS).offset(0, -2, 0));
        this.addRoom(BetterPromenadeGridGenerator.room(mainRoadEnd.method_34592(0, 4, 2), END_BOTTOM).offset(0, -2, 0));
        this.addRoom(BetterPromenadeGridGenerator.room(mainRoadEnd.method_34592(0, 7, 2), END_TOP).offset(0, -2, 0).specialPoint(SpecialPointIds.EXIT, new class_2382(4, 36, 12), class_2470.field_11464));
        this.addRoom(BetterPromenadeGridGenerator.room(mainRoadEnd.method_34592(0, 0, 1), PATH_HALF).terrainFit());
        this.addRoom(BetterPromenadeGridGenerator.room(sideRoadEnd, VINE_RUNE).terrainFit().terrainSampleOffset(14, 0, 8).offset(0, -21, 0).rotation(class_2470.field_11463));
        this.tryPlaceBuildingsBetween(new class_2382(1, 0, 32), new class_2382(63, 0, 58), random, 32, class_2470.field_11464);
        this.tryPlaceBuildingsBetween(new class_2382(1, 0, 1), new class_2382(63, 0, 30), random, 48, class_2470.field_11467);
    }

    private void addBuilding(class_2382 start, int length, class_2470 rotation, class_5819 random) {
        if (length < 1) {
            return;
        }
        boolean underground = length > 3 && (double)random.method_43057() < 0.66;
        class_2382 direction = rotation.method_10503(class_2350.field_11035).method_10163();
        class_2382 fitPos = start.method_35853(direction.method_35862(length / 2));
        this.addRoom(BetterPromenadeGridGenerator.room(start.method_35852(direction), BUILDING_OVERGROUND_END).rotation(rotation).terrainFit(fitPos));
        int skipped = underground ? random.method_43048(length - 1) : -1;
        for (int i = 0; i < length; ++i) {
            if (i == skipped) {
                this.addRoom(BetterPromenadeGridGenerator.room(start.method_35853(direction.method_35862(i)).method_23227(2), BUILDING_OVERGROUND_ELEVATOR).rotation(rotation).terrainFit(fitPos));
                continue;
            }
            class_2470 randomRotation = random.method_43056() ? rotation : class_2470.field_11464.method_10501(rotation);
            this.addRoom(BetterPromenadeGridGenerator.room(start.method_35853(direction.method_35862(i)), BUILDING_OVERGROUND).rotation(randomRotation).terrainFit(fitPos));
            this.addRoom(BetterPromenadeGridGenerator.room(start.method_35853(direction.method_35862(i)).method_23228(), BUILDING_OVERGROUND_BASE).rotation(rotation).terrainFit(fitPos));
            if (underground) {
                if (i == length - 1 && (double)random.method_43057() < 0.67) {
                    this.addRoom(BetterPromenadeGridGenerator.room(start.method_35853(direction.method_35862(i).method_23227(3)), BUILDING_UNDERGROUND_END).rotation(rotation).terrainFit(fitPos));
                    continue;
                }
                this.addRoom(BetterPromenadeGridGenerator.room(start.method_35853(direction.method_35862(i)).method_23227(2), BUILDING_UNDERGROUND).rotation(rotation).terrainFit(fitPos));
                continue;
            }
            this.addRoom(BetterPromenadeGridGenerator.room(start.method_35853(direction.method_35862(i)).method_23227(2), BUILDING_OVERGROUND_BASE).rotation(rotation).terrainFit(fitPos));
        }
        this.addRoom(BetterPromenadeGridGenerator.room(start.method_35853(direction.method_35862(length)), BUILDING_OVERGROUND_END).rotation(class_2470.field_11464.method_10501(rotation)).terrainFit(fitPos));
    }

    private void tryPlaceBuildingsBetween(class_2382 start, class_2382 end, class_5819 random, int count, class_2470 excludedRotation) {
        block0: for (int i = 0; i < count; ++i) {
            int attempts = 4;
            for (int j = 0; j < attempts; ++j) {
                int x = random.method_43048(end.method_10263() - start.method_10263() + 1) + start.method_10263();
                int z = random.method_43048(end.method_10260() - start.method_10260() + 1) + start.method_10260();
                class_2382 pos = new class_2382(x, start.method_10264(), z);
                if (this.tryPlaceBuilding(pos, random, excludedRotation)) continue block0;
            }
        }
    }

    private boolean tryPlaceBuilding(class_2382 start, class_5819 random, class_2470 excludedRotation) {
        List rotations = class_2470.method_16547((class_5819)random);
        int maxLength = 3 + random.method_43048(6);
        boolean result = false;
        for (class_2470 rotation : rotations) {
            if (rotation == excludedRotation) continue;
            class_2382 pos = new class_2382(start.method_10263(), start.method_10264(), start.method_10260());
            boolean valid = true;
            class_2382 direction = rotation.method_10503(class_2350.field_11035).method_10163();
            for (int i = -1; i < maxLength + 1; ++i) {
                if (!this.isPositionUsed(pos = pos.method_35853(direction)) && pos.method_10263() > 0 && pos.method_10260() > 0 && pos.method_10263() < 63 && pos.method_10260() < 56) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            this.addBuilding(start.method_35853(direction), maxLength - 2, rotation, random);
            result = true;
            break;
        }
        return result;
    }

    private class_3545<class_2382, class_2382> addPath(class_2382 start, class_2470 rotation, int length, class_5819 random, int skippedTurn, class_2960 beforeCrossroadsPost, class_2960 afterCrossroadsPost) {
        class_2382 direction = rotation.method_10503(class_2350.field_11035).method_10163();
        class_2382 sideDirection = rotation.method_10503(class_2350.field_11034).method_10163();
        class_2382 skippedVec = null;
        class_2382 pos = start;
        int turns = 0;
        int nextLength = 3 + random.method_43048(2);
        boolean nextLeft = random.method_43056();
        this.addBuilding(pos.method_35853(sideDirection).method_35853(direction.method_35862(2)), nextLength - 2, rotation, random);
        this.addBuilding(pos.method_35852(sideDirection).method_35853(direction.method_35862(2)), nextLength - 2, rotation, random);
        for (int i = 0; i < length; ++i) {
            if (nextLength <= 0) {
                if (turns == skippedTurn) {
                    skippedVec = pos;
                } else if (nextLeft) {
                    this.addRoom(BetterPromenadeGridGenerator.room(pos, PATH_TURN).rotation(rotation));
                    pos = pos.method_35853(sideDirection);
                    this.addRoom(BetterPromenadeGridGenerator.room(pos, PATH_TURN).rotation(rotation.method_10501(class_2470.field_11464)));
                } else {
                    this.addRoom(BetterPromenadeGridGenerator.room(pos, PATH_TURN).rotation(rotation.method_10501(class_2470.field_11465)));
                    pos = pos.method_35852(sideDirection);
                    this.addRoom(BetterPromenadeGridGenerator.room(pos, PATH_TURN).rotation(rotation.method_10501(class_2470.field_11463)));
                }
                nextLength = Math.min(2 + random.method_43048(3), length - i);
                int leftMultipler = Math.max(nextLeft ? 0 : 1, skippedTurn == turns ? 1 : 0);
                int rightMultipler = Math.max(nextLeft ? 1 : 0, skippedTurn == turns ? 1 : 0);
                this.addBuilding(pos.method_35853(sideDirection).method_35853(direction.method_35862(leftMultipler)), nextLength, rotation, random);
                this.addBuilding(pos.method_35852(sideDirection).method_35853(direction.method_35862(rightMultipler)), nextLength, rotation, random);
                ++turns;
                nextLeft = random.method_43056();
            } else {
                this.addRoom(BetterPromenadeGridGenerator.room(pos, PATH_STRAIGHT).rotation(rotation));
                if ((double)random.method_43057() < 0.6) {
                    if ((double)random.method_43057() < 0.33) {
                        class_2382 offset = direction.method_35862(5).method_35853(sideDirection.method_35862(6));
                        this.addRoom(BetterPromenadeGridGenerator.room(pos, turns < skippedTurn + 1 ? beforeCrossroadsPost : afterCrossroadsPost).terrainFitOffset(offset.method_10263(), offset.method_10264(), offset.method_10260()).rotation(rotation));
                    } else {
                        this.addRoom(BetterPromenadeGridGenerator.room(pos, PATH_BUILDING).rotation(rotation).terrainFit());
                    }
                }
                --nextLength;
            }
            pos = pos.method_35853(direction);
        }
        return new class_3545((Object)pos.method_35852(direction), (Object)skippedVec);
    }

    private static class_2960 pool(String path) {
        return MineCells.createId("promenade/" + path);
    }
}

