/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.network;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.block.blockentity.CellCrafterBlockEntity;
import com.github.mim1q.minecells.block.portal.DoorwayPortalBlock;
import com.github.mim1q.minecells.block.portal.DoorwayPortalBlockEntity;
import com.github.mim1q.minecells.cc.MineCellsLevelCC;
import com.github.mim1q.minecells.entity.nonliving.TentacleWeaponEntity;
import com.github.mim1q.minecells.network.c2s.CellCrafterCraftRequestC2SPacket;
import com.github.mim1q.minecells.network.c2s.RequestUnlockedCellCrafterRecipesC2SPacket;
import com.github.mim1q.minecells.network.c2s.UpdateDoorwayC2SPacket;
import com.github.mim1q.minecells.network.c2s.UseTentacleWeaponC2SPacket;
import com.github.mim1q.minecells.network.s2c.CritS2CPacket;
import com.github.mim1q.minecells.network.s2c.ExplosionS2CPacket;
import com.github.mim1q.minecells.network.s2c.ObeliskActivationS2CPacket;
import com.github.mim1q.minecells.network.s2c.OpenDoorwayScreenS2CPacket;
import com.github.mim1q.minecells.network.s2c.SendUnlockedCellCrafterRecipesS2CPacket;
import com.github.mim1q.minecells.network.s2c.ShockwaveClientEventS2CPacket;
import com.github.mim1q.minecells.network.s2c.SpawnRuneParticlesS2CPacket;
import com.github.mim1q.minecells.network.s2c.SpawnerRuneUpdateS2CPacket;
import com.github.mim1q.minecells.network.s2c.UpdateConjunctiviusBossBarS2CPacket;
import com.github.mim1q.minecells.recipe.CellForgeRecipe;
import com.github.mim1q.minecells.recipe.PlayerInventoryInput;
import com.github.mim1q.minecells.registry.MineCellsBlocks;
import com.github.mim1q.minecells.registry.MineCellsItems;
import com.github.mim1q.minecells.world.processor.SwitchBlockStructureProcessor;
import io.wispforest.owo.network.OwoNetChannel;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;

public class ServerPacketHandler {
    public static OwoNetChannel CHANNEL = OwoNetChannel.create((class_2960)MineCells.createId("main"));

    public static void init() {
        CHANNEL.registerClientboundDeferred(SpawnerRuneUpdateS2CPacket.class);
        CHANNEL.registerClientboundDeferred(OpenDoorwayScreenS2CPacket.class);
        CHANNEL.registerClientboundDeferred(SpawnRuneParticlesS2CPacket.class);
        CHANNEL.registerClientboundDeferred(ObeliskActivationS2CPacket.class);
        CHANNEL.registerClientboundDeferred(ShockwaveClientEventS2CPacket.class);
        CHANNEL.registerClientboundDeferred(SendUnlockedCellCrafterRecipesS2CPacket.class);
        CHANNEL.registerClientboundDeferred(UpdateConjunctiviusBossBarS2CPacket.class);
        CHANNEL.registerClientboundDeferred(CritS2CPacket.class);
        CHANNEL.registerClientboundDeferred(ExplosionS2CPacket.class);
        CHANNEL.registerServerbound(UpdateDoorwayC2SPacket.class, (msg, ctx) -> {
            class_1937 world = ctx.player().method_37908();
            class_2680 newState = MineCellsBlocks.DOORWAY_PORTALS.get(msg.dimensionId()).method_9564();
            class_2680 state = world.method_8320(msg.doorwayPos());
            if (!(state.method_26204() instanceof DoorwayPortalBlock)) {
                MineCells.LOGGER.error("{} tried to modify a Doorway that doesn't exist at x={}, y={}, z={} in {}", (Object)ctx.player().method_5477().getString(), (Object)msg.doorwayPos().method_10263(), (Object)msg.doorwayPos().method_10264(), (Object)msg.doorwayPos().method_10260(), (Object)world.method_27983().method_29177().toString());
                return;
            }
            world.method_8501(msg.doorwayPos(), SwitchBlockStructureProcessor.copyAllProperties(state, newState));
            class_2586 entity = world.method_8321(msg.doorwayPos());
            if (entity instanceof DoorwayPortalBlockEntity) {
                DoorwayPortalBlockEntity doorway = (DoorwayPortalBlockEntity)entity;
                class_2338 pos = MineCellsLevelCC.PortalsCC.getOrCreatePortal(ctx.player()).runCenter();
                if (doorway.canEdit((class_1657)ctx.player())) {
                    doorway.update((class_1657)ctx.player(), pos, msg.onlyOwnerCanUse());
                } else {
                    MineCells.LOGGER.warn("{} tried to illegally edit portal at x={}, y={}, z={} in {}", (Object)ctx.player().method_5477().getString(), (Object)msg.doorwayPos().method_10263(), (Object)msg.doorwayPos().method_10264(), (Object)msg.doorwayPos().method_10260(), (Object)world.method_27983().method_29177().toString());
                }
            }
        });
        CHANNEL.registerServerbound(UseTentacleWeaponC2SPacket.class, (msg, handler) -> {
            class_243 targetPos = msg.targetPos();
            class_3222 player = handler.player();
            class_1799 playerItem = player.method_6047();
            double maxDistance = (double)MineCells.COMMON_CONFIG.baseTentacleMaxDistance() + 2.0;
            if (!playerItem.method_31574((class_1792)MineCellsItems.TENTACLE) || targetPos.method_1025(player.method_19538()) > maxDistance * maxDistance) {
                MineCells.LOGGER.warn("Invalid tentacle weapon use packet from player {}", (Object)player.method_5477().getString());
                return;
            }
            MinecraftServer server = handler.runtime();
            server.execute(() -> {
                TentacleWeaponEntity tentacle = TentacleWeaponEntity.create(player.method_37908(), (class_1657)player, targetPos, playerItem);
                player.method_37908().method_8649((class_1297)tentacle);
                player.method_7357().method_7906((class_1792)MineCellsItems.TENTACLE, MineCellsItems.TENTACLE.getAbilityCooldown(playerItem, (class_1309)player));
            });
        });
        CHANNEL.registerServerbound(RequestUnlockedCellCrafterRecipesC2SPacket.class, (msg, handler) -> CHANNEL.serverHandle((class_1657)handler.player()).send((Record)new SendUnlockedCellCrafterRecipesS2CPacket(handler.player())));
        CHANNEL.registerServerbound(CellCrafterCraftRequestC2SPacket.class, (msg, handler) -> {
            class_2338 pos = msg.pos();
            class_2960 recipeId = msg.recipeId();
            class_3222 player = handler.player();
            MinecraftServer server = handler.runtime();
            server.execute(() -> {
                class_2586 blockEntity = player.method_37908().method_8321(pos);
                class_1860 recipe = ((class_8786)server.method_3772().method_8130(recipeId).get()).comp_1933();
                if (blockEntity instanceof CellCrafterBlockEntity) {
                    CellCrafterBlockEntity cellCrafter = (CellCrafterBlockEntity)blockEntity;
                    if (recipe instanceof CellForgeRecipe) {
                        CellForgeRecipe cellForgeRecipe = (CellForgeRecipe)recipe;
                        boolean canCraft = cellForgeRecipe.matches(new PlayerInventoryInput(player.method_31548()), player.method_37908());
                        if (!canCraft) {
                            MineCells.LOGGER.warn("Player {} tried to craft {} without having the required items", (Object)player.method_5477().getString(), (Object)cellForgeRecipe.id().toString());
                            return;
                        }
                        class_1799 output = cellForgeRecipe.craft(new PlayerInventoryInput(player.method_31548()), (class_7225.class_7874)player.method_37908().method_30349());
                        if (output == null) {
                            MineCells.LOGGER.warn("Player {} tried to craft {} but failed", (Object)player.method_5477().getString(), (Object)cellForgeRecipe.id().toString());
                            return;
                        }
                        cellCrafter.setCooldown(10);
                        cellCrafter.addStack(output);
                    }
                }
            });
        });
    }
}

