/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.network;

import com.github.mim1q.minecells.block.ShockwaveBlock;
import com.github.mim1q.minecells.block.blockentity.SpawnerRuneBlockEntity;
import com.github.mim1q.minecells.client.gui.ConjunctiviusClientBossBar;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.entity.nonliving.SpawnerRuneEntity;
import com.github.mim1q.minecells.entity.nonliving.obelisk.ObeliskEntity;
import com.github.mim1q.minecells.network.ServerPacketHandler;
import com.github.mim1q.minecells.network.s2c.ConnectS2CPacket;
import com.github.mim1q.minecells.network.s2c.CritS2CPacket;
import com.github.mim1q.minecells.network.s2c.ElevatorDestroyedS2CPacket;
import com.github.mim1q.minecells.network.s2c.ExplosionS2CPacket;
import com.github.mim1q.minecells.network.s2c.ObeliskActivationS2CPacket;
import com.github.mim1q.minecells.network.s2c.OpenDoorwayScreenS2CPacket;
import com.github.mim1q.minecells.network.s2c.SendUnlockedCellCrafterRecipesS2CPacket;
import com.github.mim1q.minecells.network.s2c.ShockwaveClientEventS2CPacket;
import com.github.mim1q.minecells.network.s2c.SpawnRuneParticlesS2CPacket;
import com.github.mim1q.minecells.network.s2c.SpawnerRuneUpdateS2CPacket;
import com.github.mim1q.minecells.network.s2c.UpdateConjunctiviusBossBarS2CPacket;
import com.github.mim1q.minecells.recipe.CellForgeRecipe;
import com.github.mim1q.minecells.registry.MineCellsParticles;
import com.github.mim1q.minecells.screen.ScreenUtils;
import com.github.mim1q.minecells.screen.cellcrafter.CellCrafterRecipeList;
import com.github.mim1q.minecells.screen.cellcrafter.CellCrafterScreen;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.ParticleUtils;
import io.wispforest.owo.network.ClientAccess;
import io.wispforest.owo.network.OwoNetChannel;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_345;
import net.minecraft.class_437;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8786;

@Environment(value=EnvType.CLIENT)
public class ClientPacketHandler {
    public static final OwoNetChannel CHANNEL = ServerPacketHandler.CHANNEL;

    public static void init() {
        CHANNEL.registerClientbound(SpawnerRuneUpdateS2CPacket.class, ClientPacketHandler::handleSpawnerRuneUpdate);
        CHANNEL.registerClientbound(OpenDoorwayScreenS2CPacket.class, (msg, handler) -> ScreenUtils.openDoorwaySelectionScreen(msg.pos(), msg.posOverride()));
        CHANNEL.registerClientbound(SpawnRuneParticlesS2CPacket.class, ClientPacketHandler::applySpawnRuneParticles);
        CHANNEL.registerClientbound(ObeliskActivationS2CPacket.class, ClientPacketHandler::applyObeliskActivation);
        CHANNEL.registerClientbound(ShockwaveClientEventS2CPacket.class, ClientPacketHandler::applyShockwaveClientEvent);
        CHANNEL.registerClientbound(SendUnlockedCellCrafterRecipesS2CPacket.class, ClientPacketHandler::applySendUnlockedCellCrafterRecipes);
        CHANNEL.registerClientbound(UpdateConjunctiviusBossBarS2CPacket.class, ClientPacketHandler::handleUpdateConjunctiviusBossBar);
        CHANNEL.registerClientbound(CritS2CPacket.class, ClientPacketHandler::handleCrit);
        CHANNEL.registerClientbound(ExplosionS2CPacket.class, ClientPacketHandler::handleExplosion);
    }

    private static void handleCrit(CritS2CPacket msg, ClientAccess handler) {
        class_243 pos = msg.pos();
        handler.runtime().execute(() -> {
            if (handler.runtime().field_1724 != null) {
                ParticleUtils.addAura((class_1937)handler.runtime().field_1687, pos, (class_2394)class_2398.field_11205, 8, 0.0, 1.0);
            }
        });
    }

    private static void handleExplosion(ExplosionS2CPacket msg, ClientAccess handler) {
        class_243 pos = msg.pos();
        double radius = msg.radius();
        class_310 client = handler.runtime();
        client.execute(() -> {
            if (client.field_1724 != null && client.field_1687 != null) {
                client.field_1687.method_8466((class_2394)MineCellsParticles.EXPLOSION, true, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
                client.field_1687.method_8466((class_2394)class_2398.field_11236, true, pos.field_1352 + 0.01, pos.field_1351 + 0.01, pos.field_1350 + 0.01, 0.0, 0.0, 0.0);
                class_5819 random = client.field_1687.field_9229;
                for (int i = 0; i < 20; ++i) {
                    double vx = (random.method_43058() - 0.5) * radius;
                    double vy = (random.method_43058() - 0.5) * radius;
                    double vz = (random.method_43058() - 0.5) * radius;
                    client.field_1687.method_8466((class_2394)class_2398.field_11205, true, pos.field_1352, pos.field_1351, pos.field_1350, vx, vy, vz);
                }
            }
        });
    }

    private static void handleConnect(ConnectS2CPacket msg, ClientAccess handler) {
        class_243 pos0 = msg.pos0();
        class_243 pos1 = msg.pos1();
        class_310 client = handler.runtime();
        client.execute(() -> {
            if (client.field_1724 != null && client.field_1687 != null) {
                double amount = pos0.method_1022(pos1);
                class_243 vel = pos1.method_1020(pos0).method_1029();
                int i = 0;
                while ((double)i < amount) {
                    class_243 pos = MathUtils.lerp(pos0, pos1, (float)i / (float)amount);
                    ParticleUtils.addParticle((class_1937)client.field_1687, (class_2394)class_2398.field_11208, pos, vel);
                    ++i;
                }
            }
        });
    }

    private static void handleElevatorDestroyed(ElevatorDestroyedS2CPacket msg, ClientAccess handler) {
        class_243 pos = msg.pos();
        class_310 client = handler.runtime();
        client.execute(() -> {
            if (client.field_1687 != null) {
                class_2388 particle = new class_2388(class_2398.field_11217, class_2246.field_10161.method_9564());
                class_238 box = new class_238(pos.method_1031(-1.0, 0.0, -1.0), pos.method_1031(1.0, 0.5, 1.0));
                ParticleUtils.addInBox((class_1937)client.field_1687, (class_2394)particle, box, 25, new class_243(0.1, 0.1, 0.1));
            }
        });
    }

    private static void handleUpdateConjunctiviusBossBar(UpdateConjunctiviusBossBarS2CPacket msg, ClientAccess handler) {
        UUID barUuid = msg.uuid();
        int tentacleCount = msg.tentacleCount();
        int maxTentacleCount = msg.maxTentacleCount();
        handler.runtime().execute(() -> {
            class_345 bar = (class_345)handler.runtime().field_1705.method_1740().field_2060.get(barUuid);
            if (bar instanceof ConjunctiviusClientBossBar) {
                ConjunctiviusClientBossBar conjunctiviusBar = (ConjunctiviusClientBossBar)bar;
                conjunctiviusBar.setTentacleCount(tentacleCount, maxTentacleCount);
            }
        });
    }

    public static void applySpawnRuneParticles(SpawnRuneParticlesS2CPacket msg, ClientAccess handler) {
        double minX = msg.minX();
        double minY = msg.minY();
        double minZ = msg.minZ();
        double maxX = msg.maxX();
        double maxY = msg.maxY();
        double maxZ = msg.maxZ();
        class_238 box = new class_238(minX, minY, minZ, maxX, maxY, maxZ);
        handler.runtime().execute(() -> {
            class_638 world = handler.player().field_17892;
            int color = 16738816;
            MineCellsDimension dimension = MineCellsDimension.of((class_1937)world);
            if (dimension != null) {
                color = dimension.getColor();
            }
            ParticleUtils.addInBox((class_1937)world, MineCellsParticles.SPECKLE.get(color), box, 10, new class_243(-0.1, -0.1, -0.1).method_1021(world.field_9229.method_43058() * 0.5 + 0.5));
            ParticleUtils.addInBox((class_1937)world, (class_2394)class_2398.field_11204, box.method_1002(0.1, 0.1, 0.1), 10, new class_243(-0.02, -0.02, -0.02).method_1021(world.field_9229.method_43058() * 0.5 + 0.5));
        });
    }

    public static void applyObeliskActivation(ObeliskActivationS2CPacket msg, ClientAccess handler) {
        int entityId = msg.entityId();
        handler.runtime().execute(() -> {
            class_1297 entity = handler.player().field_17892.method_8469(entityId);
            if (entity instanceof ObeliskEntity) {
                ObeliskEntity obelisk = (ObeliskEntity)entity;
                obelisk.resetActivatedTicks();
            }
        });
    }

    public static void applyShockwaveClientEvent(ShockwaveClientEventS2CPacket msg, ClientAccess handler) {
        int blockId = msg.blockId();
        class_2338 blockPos = msg.pos();
        boolean end = msg.end();
        handler.runtime().execute(() -> {
            Object patt0$temp;
            class_638 world = handler.runtime().field_1687;
            if (world == null) {
                return;
            }
            Optional block = class_7923.field_41175.method_40265(blockId);
            if (block.isPresent() && (patt0$temp = ((class_6880.class_6883)block.get()).comp_349()) instanceof ShockwaveBlock) {
                ShockwaveBlock shockwaveBlock = (ShockwaveBlock)((Object)((Object)patt0$temp));
                if (end) {
                    shockwaveBlock.onClientEndShockwave((class_1937)world, blockPos);
                } else {
                    shockwaveBlock.onClientStartShockwave((class_1937)world, blockPos);
                }
            }
        });
    }

    public static void applySendUnlockedCellCrafterRecipes(SendUnlockedCellCrafterRecipesS2CPacket msg, ClientAccess handler) {
        Map<class_2960, Boolean> recipes = msg.requiredAdvancements();
        class_1863 recipeManager = handler.netHandler().method_2877();
        handler.runtime().execute(() -> {
            class_437 screen = handler.runtime().field_1755;
            if (screen instanceof CellCrafterScreen) {
                CellCrafterScreen cellCrafterScreen = (CellCrafterScreen)screen;
                cellCrafterScreen.updateRecipes(recipes.entrySet().stream().map(entry -> {
                    CellForgeRecipe recipe = (CellForgeRecipe)((class_8786)recipeManager.method_8130((class_2960)entry.getKey()).get()).comp_1933();
                    recipe = recipe.withId((class_2960)entry.getKey());
                    return new CellCrafterRecipeList.DisplayedRecipe(recipe, (Boolean)entry.getValue());
                }).toList());
            }
        });
    }

    private static void handleSpawnerRuneUpdate(SpawnerRuneUpdateS2CPacket msg, ClientAccess handler) {
        class_638 world = handler.netHandler().method_2890();
        class_2586 blockEntity = world.method_8321(msg.pos());
        if (blockEntity instanceof SpawnerRuneBlockEntity) {
            SpawnerRuneBlockEntity spawner = (SpawnerRuneBlockEntity)blockEntity;
            spawner.controller.setLastActivationTime(msg.lastActivationTime());
            spawner.controller.setDummyData(msg.cooldown());
            return;
        }
        class_238 box = class_238.method_30048((class_243)class_243.method_24953((class_2382)msg.pos()), (double)1.5, (double)1.5, (double)1.5);
        Optional entity = world.method_8390(SpawnerRuneEntity.class, box, it -> it.method_24515().equals((Object)msg.pos())).stream().findFirst();
        entity.ifPresent(it -> {
            it.controller.setLastActivationTime(msg.lastActivationTime());
            it.controller.setDummyData(msg.cooldown());
        });
    }
}

