/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.misc;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.minecraft.class_5338;
import net.minecraft.class_75;
import net.minecraft.class_79;
import net.minecraft.class_82;
import net.minecraft.class_8779;

public class SpecialWeaponLootEntry
extends class_79 {
    public static final MapCodec<SpecialWeaponLootEntry> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Entry.CODEC.codec().listOf().fieldOf("entries").forGetter(it -> it.entryList)).apply((Applicative)instance, SpecialWeaponLootEntry::new));
    private final List<Entry> entryList;

    private SpecialWeaponLootEntry(List<Entry> entryList) {
        super(List.of());
        this.entryList = entryList;
    }

    public class_5338 method_29318() {
        return MineCells.SPECIAL_WEAPON_LOOT_ENTRY;
    }

    public boolean expand(class_47 context, Consumer<class_82> choiceConsumer) {
        choiceConsumer.accept(new Choice());
        return true;
    }

    private class Choice
    implements class_82 {
        private Choice() {
        }

        public int method_427(float luck) {
            return 1;
        }

        public void method_426(Consumer<class_1799> lootConsumer, class_47 context) {
            class_1297 entity = (class_1297)context.method_296(class_181.field_1226);
            if (!(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            HashMap<Entry, Integer> map = new HashMap<Entry, Integer>();
            int totalWeight = 0;
            for (Entry entry : SpecialWeaponLootEntry.this.entryList) {
                if (!this.shouldUseEntry(entry.advancement(), player)) continue;
                int weight = entry.weight();
                int dimensionLevel = entry.dimensionLevel();
                MineCellsDimension dimension = MineCellsDimension.of(player.method_37908());
                if (dimension == null) break;
                int currentDimensionLevel = dimension.getDimensionLevel();
                if (dimensionLevel > currentDimensionLevel) continue;
                if (dimensionLevel == currentDimensionLevel) {
                    weight *= 2;
                }
                map.put(entry, weight);
                totalWeight += weight;
            }
            int randomWeight = player.method_59922().method_43048(totalWeight);
            for (Entry entry : map.keySet()) {
                if ((randomWeight -= ((Integer)map.get(entry)).intValue()) >= 0) continue;
                entry.method_426(lootConsumer, context);
                return;
            }
        }

        private boolean shouldUseEntry(Optional<class_2960> advancementId, class_3222 player) {
            if (advancementId.isEmpty()) {
                return true;
            }
            class_8779 advancement = player.field_13995.method_3851().method_12896(advancementId.get());
            return advancement == null || player.method_14236().method_12882(advancement).method_740();
        }
    }

    private record Entry(class_79 loot, int weight, int dimensionLevel, Optional<class_2960> advancement) implements class_82
    {
        public static final MapCodec<Entry> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_75.field_45802.fieldOf("loot").forGetter(Entry::loot), (App)Codec.INT.fieldOf("weight").orElse((Object)1).forGetter(Entry::weight), (App)Codec.INT.fieldOf("dimension_level").orElse((Object)0).forGetter(Entry::dimensionLevel), (App)class_2960.field_25139.optionalFieldOf("advancement").orElse(null).forGetter(Entry::advancement)).apply((Applicative)instance, Entry::new));

        public int method_427(float luck) {
            return this.weight;
        }

        public void method_426(Consumer<class_1799> lootConsumer, class_47 context) {
            ArrayList choices = new ArrayList();
            this.loot.expand(context, choices::add);
            choices.forEach(choice -> choice.method_426(lootConsumer, context));
        }
    }
}

