/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.item.weapon.melee;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.item.weapon.interfaces.CrittingWeapon;
import com.github.mim1q.minecells.registry.MineCellsItems;
import com.github.mim1q.minecells.valuecalculators.ModValueCalculators;
import dev.mim1q.gimm1q.valuecalculators.ValueCalculator;
import dev.mim1q.gimm1q.valuecalculators.parameters.ValueCalculatorContext;
import dev.mim1q.gimm1q.valuecalculators.parameters.ValueCalculatorParameter;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import org.jetbrains.annotations.Nullable;

public class CustomMeleeWeapon
extends class_1829
implements CrittingWeapon {
    private static final Set<CustomMeleeWeapon> ALL_MELEE_WEAPONS = new HashSet<CustomMeleeWeapon>();
    private class_9285 attributeModifiers = class_9285.field_49326;
    private static final ValueCalculator GLOBAL_DAMAGE_MULTIPLIER = ModValueCalculators.of("melee/global", "global_damage_multiplier", 1.0);
    private static final ValueCalculator GLOBAL_SPEED_MULTIPLIER = ModValueCalculators.of("melee/global", "global_speed_multiplier", 1.0);
    private double damage = 0.0;
    private double speed = 0.0;
    private final ValueCalculator damageCalculator;
    private final ValueCalculator extraDamageCalculator;
    private final ValueCalculator critDamageCalculator;
    private final ValueCalculator speedCalculator;

    public CustomMeleeWeapon(String valueCalculatorName, class_1792.class_1793 settings) {
        super(MineCellsItems.CELL_INFUSED_STEEL_MATERIAL, settings);
        ALL_MELEE_WEAPONS.add(this);
        this.damageCalculator = ModValueCalculators.of("melee/" + valueCalculatorName, "damage", 0.0);
        this.speedCalculator = ModValueCalculators.of("melee/" + valueCalculatorName, "speed", 0.0);
        this.extraDamageCalculator = ModValueCalculators.of("melee/" + valueCalculatorName, "extra_damage", 0.0);
        this.critDamageCalculator = ModValueCalculators.of("melee/" + valueCalculatorName, "crit_damage", 0.0);
    }

    public class_9285 method_7844() {
        return this.attributeModifiers;
    }

    @Override
    public float getExtraDamage(class_1799 stack, @Nullable class_1309 target, class_1309 attacker) {
        return (float)this.extraDamageCalculator.calculate(ValueCalculatorContext.create().with(ValueCalculatorParameter.HOLDER, (Object)attacker).with(ValueCalculatorParameter.TARGET, (Object)target).with(ValueCalculatorParameter.HOLDER_STACK, (Object)stack));
    }

    @Override
    public boolean canCrit(class_1799 stack, @Nullable class_1309 target, class_1309 attacker) {
        return false;
    }

    @Override
    public float getAdditionalCritDamage(class_1799 stack, @Nullable class_1309 target, @Nullable class_1309 attacker) {
        return (float)this.critDamageCalculator.calculate(ValueCalculatorContext.create().with(ValueCalculatorParameter.HOLDER, (Object)attacker).with(ValueCalculatorParameter.TARGET, (Object)target).with(ValueCalculatorParameter.HOLDER_STACK, (Object)stack));
    }

    public static void updateAttributes() {
        ALL_MELEE_WEAPONS.forEach(it -> {
            it.damage = (it.damageCalculator.calculate() - 1.0) * GLOBAL_DAMAGE_MULTIPLIER.calculate();
            it.speed = (it.speedCalculator.calculate() - 4.0) * GLOBAL_SPEED_MULTIPLIER.calculate();
            it.attributeModifiers = class_9285.method_57480().method_57487(class_5134.field_23721, new class_1322(MineCells.createId("attack_damage"), it.damage, class_1322.class_1323.field_6328), class_9274.field_49219).method_57487(class_5134.field_23723, new class_1322(MineCells.createId("attack_speed"), it.speed, class_1322.class_1323.field_6328), class_9274.field_49219).method_57486();
        });
    }

    public static Set<class_1792> getAllMeleeWeapons() {
        return Set.copyOf(ALL_MELEE_WEAPONS);
    }
}

