/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.item;

import com.github.mim1q.minecells.block.portal.DoorwayPortalBlock;
import com.github.mim1q.minecells.block.portal.DoorwayPortalBlockEntity;
import com.github.mim1q.minecells.cc.MineCellsLevelCC;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.network.ServerPacketHandler;
import com.github.mim1q.minecells.network.s2c.OpenDoorwayScreenS2CPacket;
import com.github.mim1q.minecells.registry.MineCellsBlocks;
import com.github.mim1q.minecells.util.LegacyUtil;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1798;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;

public class DoorwayItem
extends class_1798 {
    private static final String TOOLTIP_VISITED = "item.minecells.prison_doorway.visited";
    private static final String TOOLTIP_NOT_VISITED = "item.minecells.prison_doorway.not_visited";
    private static final String TOOLTIP_BOUND = "item.minecells.prison_doorway.bound";
    private static final String TOOLTIP_NOT_BOUND = "item.minecells.prison_doorway.not_bound";
    private static final String DESCRIPTION = "item.minecells.prison_doorway.description";
    private final DoorwayPortalBlock doorwayBlock;

    public DoorwayItem(class_1792.class_1793 settings, DoorwayPortalBlock doorwayBlock) {
        super((class_2248)doorwayBlock, settings);
        this.doorwayBlock = doorwayBlock;
    }

    protected boolean method_7709(class_1750 context, class_2680 state) {
        class_1937 world = context.method_8045();
        if (MineCellsDimension.of(world) != MineCellsDimension.OVERWORLD) {
            return false;
        }
        class_2338 pos = context.method_8037();
        if (world.method_8320(pos.method_10074()).method_26216((class_1922)world, pos) || world.method_8320(pos.method_10087(2)).method_26216((class_1922)world, pos)) {
            class_2350 side = context.method_8038().method_10166().method_10178() ? context.method_8042().method_10153() : context.method_8038();
            int dy = world.method_8320(pos.method_10074()).method_26216((class_1922)world, pos) ? 1 : 0;
            int x = side.method_10166() == class_2350.class_2351.field_11048 ? 0 : 1;
            int z = side.method_10166() == class_2350.class_2351.field_11051 ? 0 : 1;
            for (int y = -1; y <= 1; ++y) {
                for (int xz = -1; xz <= 1; ++xz) {
                    class_2338 newPos = pos.method_10059(side.method_10163()).method_10069(xz * x, y + dy, xz * z);
                    class_2680 blockState = world.method_8320(newPos);
                    if (!blockState.method_26216((class_1922)world, pos)) {
                        return false;
                    }
                    if (world.method_8320(newPos.method_10081(side.method_10163())).method_26166(context)) continue;
                    return false;
                }
            }
            return super.method_7709(context, state);
        }
        return false;
    }

    protected boolean method_7708(class_1750 context, class_2680 state) {
        if (context.method_8045().field_9236) {
            return true;
        }
        DoorwayPortalBlock.Frame frameBlock = context.method_8036() != null && context.method_8036().method_7337() ? MineCellsBlocks.UNBREAKABLE_DOORWAY_FRAME : MineCellsBlocks.DOORWAY_FRAME;
        class_2350 direction = context.method_8038().method_10166().method_10178() ? context.method_8042().method_10153() : context.method_8038();
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        int dy = world.method_8320(pos.method_10074()).method_26216((class_1922)world, pos) ? 0 : -1;
        class_2382 rightVec = direction.method_10160().method_10163();
        class_2382 leftVec = direction.method_10170().method_10163();
        world.method_8501(pos.method_10069(0, dy + 1, 0), (class_2680)this.doorwayBlock.method_9564().method_11657((class_2769)DoorwayPortalBlock.FACING, (Comparable)direction));
        DoorwayItem.method_7714((class_1937)world, (class_1657)context.method_8036(), (class_2338)pos.method_10069(0, dy + 1, 0), (class_1799)context.method_8041());
        class_2586 blockEntity = world.method_8321(pos.method_10069(0, dy + 1, 0));
        if (blockEntity instanceof DoorwayPortalBlockEntity) {
            DoorwayPortalBlockEntity doorway = (DoorwayPortalBlockEntity)blockEntity;
            if (context.method_8036() != null) {
                class_2338 posOverride = MineCellsLevelCC.PortalsCC.getOrCreatePortal((class_3222)context.method_8036()).runCenter();
                doorway.update(context.method_8036(), posOverride, true);
                ServerPacketHandler.CHANNEL.serverHandle(context.method_8036()).send((Record)new OpenDoorwayScreenS2CPacket(pos.method_10069(0, dy + 1, 0), posOverride));
            }
        }
        world.method_8501(pos.method_10069(0, dy, 0), frameBlock.getState(DoorwayPortalBlock.Frame.FillerType.MIDDLE, direction));
        world.method_8501(pos.method_10069(0, dy + 2, 0), frameBlock.getState(DoorwayPortalBlock.Frame.FillerType.TOP, direction));
        world.method_8501(pos.method_10081(leftVec).method_10069(0, dy, 0), frameBlock.getState(DoorwayPortalBlock.Frame.FillerType.LEFT, direction));
        world.method_8501(pos.method_10081(leftVec).method_10069(0, dy + 1, 0), frameBlock.getState(DoorwayPortalBlock.Frame.FillerType.LEFT, direction));
        world.method_8501(pos.method_10081(leftVec).method_10069(0, dy + 2, 0), frameBlock.getState(DoorwayPortalBlock.Frame.FillerType.TOP_LEFT, direction));
        world.method_8501(pos.method_10081(rightVec).method_10069(0, dy, 0), frameBlock.getState(DoorwayPortalBlock.Frame.FillerType.RIGHT, direction));
        world.method_8501(pos.method_10081(rightVec).method_10069(0, dy + 1, 0), frameBlock.getState(DoorwayPortalBlock.Frame.FillerType.RIGHT, direction));
        world.method_8501(pos.method_10081(rightVec).method_10069(0, dy + 2, 0), frameBlock.getState(DoorwayPortalBlock.Frame.FillerType.TOP_RIGHT, direction));
        return true;
    }

    public boolean method_7886(class_1799 stack) {
        return super.method_7886(stack) || LegacyUtil.getOrCreateSubNbt(stack, "BlockEntityTag").method_10545("posOverride");
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        tooltip.add((class_2561)class_2561.method_43471((String)DESCRIPTION).method_27692(class_124.field_1063));
        if (LegacyUtil.getOrCreateSubNbt(stack, "BlockEntityTag").method_10545("posOverride")) {
            class_2338 posOverride = class_2338.method_10092((long)LegacyUtil.getOrCreateSubNbt(stack, "BlockEntityTag").method_10537("posOverride"));
            int x = posOverride.method_10263();
            int z = posOverride.method_10260();
            String area = "[x: " + x + ", z: " + z + "]";
            tooltip.add((class_2561)class_2561.method_43469((String)TOOLTIP_BOUND, (Object[])new Object[]{area}).method_27692(class_124.field_1060));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)TOOLTIP_NOT_BOUND).method_27692(class_124.field_1063));
        }
    }
}

