/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity.boss;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.entity.ai.goal.ShockwaveGoal;
import com.github.mim1q.minecells.entity.ai.goal.TargetRandomPlayerGoal;
import com.github.mim1q.minecells.entity.ai.goal.TimedAuraGoal;
import com.github.mim1q.minecells.entity.ai.goal.TimedDashGoal;
import com.github.mim1q.minecells.entity.ai.goal.WalkTowardsTargetGoal;
import com.github.mim1q.minecells.entity.ai.goal.concierge.ConciergePunchGoal;
import com.github.mim1q.minecells.entity.boss.MineCellsBossEntity;
import com.github.mim1q.minecells.registry.MineCellsBlocks;
import com.github.mim1q.minecells.registry.MineCellsParticles;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.registry.MineCellsStatusEffects;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.ParticleUtils;
import com.github.mim1q.minecells.util.animation.AnimationProperty;
import dev.mim1q.gimm1q.screenshake.ScreenShakeUtils;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1399;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4135;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_8779;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ConciergeEntity
extends MineCellsBossEntity {
    private static final class_2940<Boolean> LEAP_CHARGING = class_2945.method_12791(ConciergeEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> LEAP_RELEASING = class_2945.method_12791(ConciergeEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHOCKWAVE_CHARGING = class_2945.method_12791(ConciergeEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHOCKWAVE_RELEASING = class_2945.method_12791(ConciergeEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> AURA_CHARGING = class_2945.method_12791(ConciergeEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> AURA_RELEASING = class_2945.method_12791(ConciergeEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> PUNCH_CHARGING = class_2945.method_12791(ConciergeEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> PUNCH_RELEASING = class_2945.method_12791(ConciergeEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SCREAMING = class_2945.method_12791(ConciergeEntity.class, (class_2941)class_2943.field_13323);
    private int leapCooldown = 0;
    private int shockwaveCooldown = 0;
    private int auraCooldown = 0;
    private int punchCooldown = 0;
    private int sharedCooldown = 100;
    private class_2338 spawnPos = null;
    private int stage = 0;
    private int stageTimer = 20000;
    private boolean canAttack = false;
    private boolean goalsInit = false;
    public AnimationProperty leapChargeAnimation = new AnimationProperty(0.0f, MathUtils::easeOutQuad);
    public AnimationProperty leapReleaseAnimation = new AnimationProperty(0.0f);
    public AnimationProperty waveChargeAnimation = new AnimationProperty(0.0f);
    public AnimationProperty waveReleaseAnimation = new AnimationProperty(0.0f);
    public AnimationProperty punchChargeAnimation = new AnimationProperty(0.0f);
    public AnimationProperty punchReleaseAnimation = new AnimationProperty(0.0f);
    public AnimationProperty deathStartAnimation = new AnimationProperty(0.0f);
    public AnimationProperty deathFallAnimation = new AnimationProperty(0.0f);
    public AnimationProperty screamAnimation = new AnimationProperty(0.0f);
    private final Set<AnimationProperty> aliveAnimations = Set.of(this.leapChargeAnimation, this.leapReleaseAnimation, this.waveChargeAnimation, this.waveReleaseAnimation, this.punchChargeAnimation, this.punchReleaseAnimation, this.screamAnimation);

    public ConciergeEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    protected void method_5959() {
        this.goalsInit = true;
        if (this.field_6185.method_35115().isEmpty()) {
            this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
            this.field_6185.method_6277(0, new TargetRandomPlayerGoal<ConciergeEntity>(this));
        }
        if (this.stage == 0) {
            return;
        }
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 32.0f));
        this.field_6201.method_6277(3, (class_1352)new WalkTowardsTargetGoal((class_1314)this, 1.0 + (double)this.stage * 0.15, false, 2.0));
        if (this.stage > 1) {
            this.field_6201.method_6277(0, new TimedDashGoal<ConciergeEntity>(this, settings -> {
                settings.onGround = true;
                settings.jumpHeight = 0.6;
                settings.cooldownGetter = () -> this.leapCooldown + this.sharedCooldown;
                settings.cooldownSetter = cooldown -> {
                    this.leapCooldown = this.getStageAdjustedValue(160, 120, 80);
                    this.sharedCooldown = this.getStageAdjustedValue(80, 60, 20);
                };
                settings.defaultCooldown = 160;
                settings.stateSetter = this.handleStateChange(LEAP_CHARGING, LEAP_RELEASING);
                settings.chargeSound = MineCellsSounds.CONCIERGE_LEAP_CHARGE;
                settings.landSound = MineCellsSounds.CONCIERGE_LEAP_LAND;
                settings.chance = 0.3f;
                settings.alignTick = this.getStageAdjustedValue(30, 30, 25);
                settings.actionTick = this.getStageAdjustedValue(40, 35, 25);
                settings.speed = 1.25f;
                settings.minDistance = 5.0;
                settings.overshoot = 1.5;
                settings.length = 60;
                settings.margin = 1.0;
                settings.damage = this.getDamage(2.5f);
                settings.particle = MineCellsParticles.SPECKLE.get(0xFF4000);
                settings.onLand = this::shakeScreenAfterLeap;
            }, e -> e.canAttack() && e.method_5968() != null && e.method_5739((class_1297)e.method_5968()) > 8.0f || this.stage == 3));
        }
        this.field_6201.method_6277(0, new ShockwaveGoal<ConciergeEntity>(this, settings -> {
            settings.cooldownGetter = () -> this.shockwaveCooldown + this.sharedCooldown;
            settings.cooldownSetter = cooldown -> {
                this.shockwaveCooldown = this.getStageAdjustedValue(200, 180, 160);
                this.sharedCooldown = this.getStageAdjustedValue(100, 80, 20);
            };
            settings.defaultCooldown = 160;
            settings.stateSetter = this.handleStateChange(SHOCKWAVE_CHARGING, SHOCKWAVE_RELEASING);
            settings.shockwaveBlock = MineCellsBlocks.SHOCKWAVE_FLAME;
            settings.shockwaveRadius = 20;
            settings.shockwaveInterval = this.getStageAdjustedValue(Float.valueOf(2.0f), Float.valueOf(1.5f), Float.valueOf(1.0f)).floatValue();
            settings.shockwaveType = ShockwaveGoal.ShockwaveType.CIRCLE;
            settings.chargeSound = MineCellsSounds.CONCIERGE_SHOCKWAVE_CHARGE;
            settings.releaseSound = MineCellsSounds.CONCIERGE_SHOCKWAVE_RELEASE;
            settings.chance = 0.2f;
            settings.length = 50;
            settings.shockwaveDamage = this.getDamage(1.5f);
            settings.actionTick = 30;
        }, ConciergeEntity::canAttack));
        this.field_6201.method_6277(0, new TimedAuraGoal<ConciergeEntity>(this, settings -> {
            settings.cooldownGetter = () -> this.auraCooldown + this.sharedCooldown;
            settings.cooldownSetter = cooldown -> {
                this.auraCooldown = this.getStageAdjustedValue(400, 320, 160);
                this.sharedCooldown = this.getStageAdjustedValue(40, 40, 0);
            };
            settings.defaultCooldown = 600;
            settings.stateSetter = this.handleStateChange(AURA_CHARGING, AURA_RELEASING);
            settings.chargeSound = MineCellsSounds.CONCIERGE_AURA_CHARGE;
            settings.endSound = MineCellsSounds.CONCIERGE_AURA_RELEASE;
            settings.length = 120;
            settings.actionTick = 60;
            settings.radius = 4.0;
            settings.damage = this.getDamage(1.5f);
            settings.chance = 0.02f;
        }, e -> e.method_37908().method_18460((class_1297)e, 5.0) != null));
        this.field_6201.method_6277(0, (class_1352)new ConciergePunchGoal(this, settings -> {
            settings.cooldownGetter = () -> this.punchCooldown;
            settings.cooldownSetter = cooldown -> {
                this.punchCooldown = this.getStageAdjustedValue(80, 40, 10);
            };
            settings.defaultCooldown = 80;
            settings.stateSetter = this.handleStateChange(PUNCH_CHARGING, PUNCH_RELEASING);
            settings.chargeSound = MineCellsSounds.CONCIERGE_PUNCH_CHARGE;
            settings.releaseSound = MineCellsSounds.CONCIERGE_PUNCH_RELEASE;
            settings.length = 30;
            settings.actionTick = 20;
            settings.damage = this.getDamage(2.5f);
            settings.knockback = this.getStageAdjustedValue(2.0, 3.0, 4.0);
        }));
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LEAP_CHARGING, (Object)false);
        builder.method_56912(LEAP_RELEASING, (Object)false);
        builder.method_56912(SHOCKWAVE_CHARGING, (Object)false);
        builder.method_56912(SHOCKWAVE_RELEASING, (Object)false);
        builder.method_56912(AURA_CHARGING, (Object)false);
        builder.method_56912(AURA_RELEASING, (Object)false);
        builder.method_56912(PUNCH_CHARGING, (Object)false);
        builder.method_56912(PUNCH_RELEASING, (Object)false);
        builder.method_56912(SCREAMING, (Object)false);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.spawnPos = this.method_24515();
        this.method_36456(180.0f);
        this.method_5636(180.0f);
        this.field_6259 = 180.0f;
        this.field_6220 = 180.0f;
        this.field_5982 = 180.0f;
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            class_243 pos = this.method_19538().method_1031(0.0, 1.0, 0.0);
            if (((Boolean)this.field_6011.method_12789(AURA_CHARGING)).booleanValue()) {
                ParticleUtils.addAura(this.method_37908(), pos, (class_2394)MineCellsParticles.AURA, 5, 4.5, -0.03);
            } else if (((Boolean)this.field_6011.method_12789(AURA_RELEASING)).booleanValue()) {
                ParticleUtils.addAura(this.method_37908(), pos, (class_2394)MineCellsParticles.AURA, 40, 4.0, 0.01);
                ParticleUtils.addAura(this.method_37908(), pos, (class_2394)MineCellsParticles.AURA, 10, 1.0, 0.3);
            }
        } else {
            if (this.spawnPos != null && this.method_5968() == null && this.canChangeStage()) {
                this.method_5942().method_6337((double)this.spawnPos.method_10263(), (double)this.spawnPos.method_10264(), (double)this.spawnPos.method_10260(), 1.3);
            }
            ++this.stageTimer;
            if (this.stage == 0 && this.method_5968() != null) {
                this.setStage(1);
            }
            if (this.stage == 1 && (double)(this.method_6032() / this.method_6063()) <= 0.66 && this.canChangeStage()) {
                this.setStage(2);
            }
            if (this.stage == 2 && (double)(this.method_6032() / this.method_6063()) <= 0.33 && this.canChangeStage()) {
                this.setStage(3);
            }
            this.field_6011.method_12778(SCREAMING, (Object)(this.stageTimer <= 60 ? 1 : 0));
            this.canAttack = true;
            if (this.stageTimer <= 80) {
                this.method_5942().method_6340();
                class_1657 nearestPlayer = this.method_37908().method_18460((class_1297)this, 100.0);
                if (nearestPlayer != null) {
                    this.method_5988().method_6226((class_1297)nearestPlayer, 360.0f, 360.0f);
                }
                this.canAttack = false;
            } else if (!this.goalsInit && this.method_5805()) {
                this.method_5959();
            }
        }
    }

    private void setStage(int stage) {
        if (this.stage == stage) {
            return;
        }
        this.stage = stage;
        this.stageTimer = 0;
        this.clearGoals();
        this.method_6092(new class_1293(MineCellsStatusEffects.PROTECTED, 100, 0, false, false, false));
        this.method_5783(MineCellsSounds.CONCIERGE_SHOUT, 2.0f, 1.0f);
        ScreenShakeUtils.shakeAround((class_3218)((class_3218)this.method_37908()), (class_243)this.method_19538(), (float)1.0f, (int)80, (double)40.0, (double)60.0, (String)"minecells:concierge_roar");
    }

    private void clearGoals() {
        this.goalsInit = false;
        this.field_6201.method_35115().forEach(class_4135::method_6270);
        this.field_6201.method_35113(Objects::nonNull);
    }

    protected void method_6108() {
        this.clearGoals();
        ++this.field_6213;
        if (this.method_37908().method_8608()) {
            this.aliveAnimations.forEach(animation -> animation.setupTransitionTo(0.0f, 5.0f, class_3532::method_16439));
            this.deathStartAnimation.setupTransitionTo(1.0f, 30.0f);
            if (this.field_6213 >= 60) {
                this.deathFallAnimation.setupTransitionTo(1.0f, 60.0f);
            }
            if (this.field_6213 >= 155) {
                this.method_37908().method_8406((class_2394)class_2398.field_11221, this.method_23317(), this.method_23318() - 1.0, this.method_23321(), 0.0, 0.0, 0.0);
            }
        } else {
            if (this.field_6213 == 15) {
                this.shakeScreenOnDeath(0.25f, 10);
                this.method_5783(MineCellsSounds.CONCIERGE_LEAP_LAND, 0.8f, 1.1f);
            }
            if (this.field_6213 == 85) {
                this.shakeScreenOnDeath(0.5f, 20);
                this.method_5783(MineCellsSounds.CONCIERGE_LEAP_LAND, 1.0f, 0.1f);
            }
            if (this.field_6213 >= 160 && !this.method_31481()) {
                this.shakeScreenOnDeath(1.0f, 60);
                this.method_5783(MineCellsSounds.CONJUNCTIVIUS_DEATH, 0.8f, 0.9f);
                this.method_37908().method_8421((class_1297)this, (byte)60);
                this.method_5650(class_1297.class_5529.field_26998);
            }
        }
    }

    private void shakeScreenOnDeath(float intensity, int duration) {
        ScreenShakeUtils.shakeAround((class_3218)((class_3218)this.method_37908()), (class_243)this.method_19538(), (float)intensity, (int)duration, (double)10.0, (double)30.0, (String)"minecells:concierge_death");
    }

    @Override
    protected void decrementCooldowns() {
        --this.leapCooldown;
        --this.shockwaveCooldown;
        --this.auraCooldown;
        --this.punchCooldown;
        if (this.sharedCooldown > 0) {
            --this.sharedCooldown;
        }
    }

    @Override
    protected void processAnimations() {
        if (this.method_29504()) {
            return;
        }
        this.setupTransition(LEAP_CHARGING, this.leapChargeAnimation, 8.0f, 3.0f, MathUtils::lerp);
        this.setupTransition(LEAP_RELEASING, this.leapReleaseAnimation, 12.0f, 20.0f, MathUtils::lerp);
        this.setupTransition(SHOCKWAVE_CHARGING, this.waveChargeAnimation, 10.0f, 30.0f, MathUtils::lerp);
        this.setupTransition(SHOCKWAVE_RELEASING, this.waveReleaseAnimation, 10.0f, 20.0f, MathUtils::easeOutBack);
        this.setupTransition(PUNCH_CHARGING, this.punchChargeAnimation, 10.0f, 3.0f, MathUtils::easeOutQuad);
        this.setupTransition(PUNCH_RELEASING, this.punchReleaseAnimation, 10.0f, 6.0f, MathUtils::easeOutBack);
        this.setupTransition(SCREAMING, this.screamAnimation, 5.0f, 20.0f, MathUtils::easeOutQuad);
    }

    private boolean canChangeStage() {
        return (Boolean)this.field_6011.method_12789(LEAP_CHARGING) == false && (Boolean)this.field_6011.method_12789(LEAP_RELEASING) == false && (Boolean)this.field_6011.method_12789(SHOCKWAVE_CHARGING) == false && (Boolean)this.field_6011.method_12789(SHOCKWAVE_RELEASING) == false && (Boolean)this.field_6011.method_12789(PUNCH_CHARGING) == false && (Boolean)this.field_6011.method_12789(PUNCH_RELEASING) == false;
    }

    private void setupTransition(class_2940<Boolean> data, AnimationProperty animation, float onDuration, float offDuration, AnimationProperty.EasingFunction onEasing) {
        if (((Boolean)this.field_6011.method_12789(data)).booleanValue()) {
            animation.setupTransitionTo(1.0f, onDuration, onEasing);
        } else {
            animation.setupTransitionTo(0.0f, offDuration);
        }
    }

    public void method_48922(class_1282 damageSource) {
        super.method_48922(damageSource);
        this.field_42108.method_48567(0.5f);
    }

    public boolean method_5643(class_1282 source, float amount) {
        Float percentage = this.getStageAdjustedValue(Float.valueOf(1.0f), Float.valueOf(0.75f), Float.valueOf(0.5f));
        return super.method_5643(source, amount * percentage.floatValue());
    }

    public boolean canAttack() {
        return this.canAttack && !this.method_29504();
    }

    @SafeVarargs
    private <T> T getStageAdjustedValue(T ... stages) {
        return stages[Math.min(this.stage, stages.length - 1)];
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        super.method_5712(pos, state);
        this.method_5783(MineCellsSounds.CONCIERGE_STEP, 0.8f, this.field_5974.method_43057() * 0.2f + 0.8f);
        if (this.method_37908().method_8608()) {
            return;
        }
        ScreenShakeUtils.shakeAround((class_3218)((class_3218)this.method_37908()), (class_243)this.method_19538(), (float)1.0f, (int)5, (double)2.0, (double)20.0, (String)"minecells:concierge_step");
    }

    private void shakeScreenAfterLeap() {
        if (this.method_37908().method_8608()) {
            return;
        }
        ScreenShakeUtils.shakeAround((class_3218)((class_3218)this.method_37908()), (class_243)this.method_19538(), (float)1.0f, (int)20, (double)10.0, (double)30.0, (String)"minecells:concierge_leap");
    }

    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
        if (this.method_37908().field_9236 || this.method_37908().method_8503() == null) {
            return;
        }
        MinecraftServer server = this.method_37908().method_8503();
        class_8779 advancement = server.method_3851().method_12896(MineCells.createId("concierge"));
        if (advancement == null) {
            return;
        }
        this.method_37908().method_8390(class_1657.class, class_238.method_30048((class_243)this.method_19538(), (double)128.0, (double)128.0, (double)128.0), Objects::nonNull).forEach(player -> ((class_3222)player).method_14236().method_12878(advancement, "concierge_killed"));
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("leapCooldown", this.leapCooldown);
        nbt.method_10569("shockwaveCooldown", this.shockwaveCooldown);
        nbt.method_10569("auraCooldown", this.auraCooldown);
        nbt.method_10569("punchCooldown", this.punchCooldown);
        nbt.method_10569("sharedCooldown", this.sharedCooldown);
        if (this.spawnPos != null) {
            nbt.method_10544("spawnPos", this.spawnPos.method_10063());
        }
        nbt.method_10569("stage", this.stage);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.leapCooldown = nbt.method_10550("leapCooldown");
        this.shockwaveCooldown = nbt.method_10550("shockwaveCooldown");
        this.auraCooldown = nbt.method_10550("auraCooldown");
        this.punchCooldown = nbt.method_10550("punchCooldown");
        this.sharedCooldown = nbt.method_10550("sharedCooldown");
        if (nbt.method_10545("spawnPos")) {
            this.spawnPos = class_2338.method_10092((long)nbt.method_10537("spawnPos"));
        }
        this.stage = nbt.method_10550("stage");
        this.clearGoals();
        this.method_5959();
    }

    public static class_5132.class_5133 createConciergeAttributes() {
        return ConciergeEntity.method_26918().method_26868(class_5134.field_23716, 300.0).method_26868(class_5134.field_23717, 40.0).method_26868(class_5134.field_23724, 5.0).method_26868(class_5134.field_23719, 0.18).method_26868(class_5134.field_23721, 4.0).method_26868(class_5134.field_23718, 1.0);
    }
}

