/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity;

import com.github.mim1q.minecells.entity.MineCellsEntity;
import com.github.mim1q.minecells.entity.ai.goal.TimedActionGoal;
import com.github.mim1q.minecells.entity.ai.goal.TimedShootGoal;
import com.github.mim1q.minecells.entity.nonliving.projectile.ScorpionSpitEntity;
import com.github.mim1q.minecells.registry.MineCellsEntities;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.MathUtils;
import com.github.mim1q.minecells.util.ParticleUtils;
import com.github.mim1q.minecells.util.animation.AnimationProperty;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1400;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class ScorpionEntity
extends MineCellsEntity {
    public AnimationProperty buriedProgress = new AnimationProperty(1.0f, MathUtils::lerp);
    public AnimationProperty swingProgress = new AnimationProperty(0.0f, MathUtils::easeInOutQuad);
    protected int shootCooldown = 0;
    public static final class_2940<Boolean> SLEEPING = class_2945.method_12791(ScorpionEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SHOOT_CHARGING = class_2945.method_12791(ScorpionEntity.class, (class_2941)class_2943.field_13323);

    public ScorpionEntity(class_1299<ScorpionEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SLEEPING, (Object)true);
        builder.method_56912(SHOOT_CHARGING, (Object)false);
    }

    @Override
    protected void method_5959() {
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, 0, false, false, null));
    }

    protected void initGoalsLate() {
        this.field_6201.method_35113(x -> true);
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new class_1366((class_1314)this, 1.2, true));
        this.field_6201.method_6277(0, new TimedShootGoal<ScorpionEntity>(this, s -> {
            s.cooldownSetter = cooldown -> {
                this.shootCooldown = cooldown;
            };
            s.cooldownGetter = () -> this.shootCooldown;
            s.stateSetter = this::handleShootState;
            s.projectileCreator = (pos, targetPos) -> {
                ScorpionSpitEntity entity = new ScorpionSpitEntity(MineCellsEntities.SCORPION_SPIT, this.method_37908());
                pos = pos.method_1031(0.0, 0.25, 0.0);
                entity.method_33574((class_243)pos);
                entity.method_18799(targetPos.method_1020(pos).method_1029().method_1021(0.8));
                return entity;
            };
            s.chargeSound = MineCellsSounds.SCORPION_CHARGE;
            s.actionTick = 20;
            s.length = 20;
            s.defaultCooldown = 40;
            s.chance = 0.1f;
        }, (Predicate<ScorpionEntity>)null));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_6113() && this.method_5968() != null) {
            this.field_6011.method_12778(SLEEPING, (Object)false);
            this.method_5783(MineCellsSounds.RISE, 1.0f, 1.0f);
            this.initGoalsLate();
        }
        if (this.method_37908().method_8608()) {
            if (!this.method_6113()) {
                this.buriedProgress.setupTransitionTo(0.0f, 20.0f);
            }
            if (((Boolean)this.method_5841().method_12789(SHOOT_CHARGING)).booleanValue()) {
                this.swingProgress.setupTransitionTo(1.0f, 15.0f);
            } else {
                this.swingProgress.setupTransitionTo(0.0f, 10.0f);
            }
            if (this.method_6113() || this.buriedProgress.getProgress() > 0.0f && this.buriedProgress.getProgress() < 1.0f) {
                this.spawnUnburyingParticles();
            }
        }
        this.shootCooldown = Math.max(0, --this.shootCooldown);
    }

    public void spawnUnburyingParticles() {
        class_2680 blockState = this.method_37908().method_8320(class_2338.method_49638((class_2374)this.method_19538().method_1023(0.0, (double)0.01f, 0.0)));
        if (blockState != null && blockState.method_26225()) {
            class_2388 particle = new class_2388(class_2398.field_11217, blockState);
            ParticleUtils.addInBox(this.method_37908(), (class_2394)particle, class_238.method_30048((class_243)this.method_19538().method_1031(0.0, 0.125, 0.0), (double)1.0, (double)0.25, (double)1.0), 5, new class_243(-0.01, -0.01, -0.01));
        }
    }

    public void handleShootState(TimedActionGoal.State state, boolean value) {
        if (state == TimedActionGoal.State.CHARGE) {
            this.field_6011.method_12778(SHOOT_CHARGING, (Object)value);
        }
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    public static class_5132.class_5133 createScorpionAttributes() {
        return ScorpionEntity.method_26918().method_26868(class_5134.field_23716, 25.0).method_26868(class_5134.field_23724, 5.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23721, 8.0);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("shootCooldown", this.shootCooldown);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.shootCooldown = nbt.method_10550("shootCooldown");
    }
}

