/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity;

import com.github.mim1q.minecells.entity.MineCellsEntity;
import com.github.mim1q.minecells.entity.ai.goal.LeapGoal;
import com.github.mim1q.minecells.entity.interfaces.ILeapEntity;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.animation.AnimationProperty;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class LeapingZombieEntity
extends MineCellsEntity
implements ILeapEntity {
    public AnimationProperty additionalRotation = new AnimationProperty(0.0f);
    private static final class_2940<Integer> LEAP_COOLDOWN = class_2945.method_12791(LeapingZombieEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> LEAP_CHARGING = class_2945.method_12791(LeapingZombieEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> LEAP_RELEASING = class_2945.method_12791(LeapingZombieEntity.class, (class_2941)class_2943.field_13323);

    public LeapingZombieEntity(class_1299<? extends class_1588> type, class_1937 world) {
        super(type, world);
        this.field_5985 = true;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LEAP_COOLDOWN, (Object)50);
        builder.method_56912(LEAP_CHARGING, (Object)false);
        builder.method_56912(LEAP_RELEASING, (Object)false);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.clientTick();
        } else {
            this.decrementCooldown(LEAP_COOLDOWN);
        }
    }

    protected void clientTick() {
        if (this.isLeapCharging()) {
            this.additionalRotation.setupTransitionTo(90.0f, 15.0f);
        } else {
            this.additionalRotation.setupTransitionTo(0.0f, 15.0f);
        }
    }

    @Override
    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, new LeapGoal<LeapingZombieEntity>(this, 15, 20, 0.1f));
        this.field_6201.method_6277(1, (class_1352)new class_1366((class_1314)this, 1.3, false));
    }

    @Override
    public boolean isLeapCharging() {
        return (Boolean)this.field_6011.method_12789(LEAP_CHARGING);
    }

    @Override
    public void setLeapCharging(boolean charging) {
        this.field_6011.method_12778(LEAP_CHARGING, (Object)charging);
    }

    @Override
    public boolean isLeapReleasing() {
        return (Boolean)this.field_6011.method_12789(LEAP_RELEASING);
    }

    @Override
    public void setLeapReleasing(boolean releasing) {
        this.field_6011.method_12778(LEAP_RELEASING, (Object)releasing);
    }

    @Override
    public int getLeapCooldown() {
        return (Integer)this.field_6011.method_12789(LEAP_COOLDOWN);
    }

    @Override
    public void setLeapCooldown(int ticks) {
        this.field_6011.method_12778(LEAP_COOLDOWN, (Object)ticks);
    }

    @Override
    public int getLeapMaxCooldown() {
        return 20 + this.method_59922().method_43048(60);
    }

    @Override
    public float getLeapDamage() {
        return 6.0f;
    }

    @Override
    public double getLeapRange() {
        return 15.0;
    }

    @Override
    public class_3414 getLeapChargeSoundEvent() {
        return MineCellsSounds.LEAPING_ZOMBIE_CHARGE;
    }

    @Override
    public class_3414 getLeapReleaseSoundEvent() {
        return MineCellsSounds.LEAPING_ZOMBIE_RELEASE;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("leapCooldown", this.getLeapCooldown());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setLeapCooldown(nbt.method_10550("leapCooldown"));
    }

    public static class_5132.class_5133 createLeapingZombieAttributes() {
        return LeapingZombieEntity.method_26827().method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23717, 20.0).method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23724, 3.0).method_26868(class_5134.field_23721, 4.0).method_26868(class_5134.field_23722, 1.0);
    }
}

