/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.datagen;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.block.FlagBlock;
import com.github.mim1q.minecells.block.MineCellsBlockTags;
import com.github.mim1q.minecells.block.RunicVineBlock;
import com.github.mim1q.minecells.block.SkeletonDecorationBlock;
import com.github.mim1q.minecells.datagen.util.AllDatagenUtils;
import com.github.mim1q.minecells.datagen.util.DatagenModelUtils;
import com.github.mim1q.minecells.datagen.util.specific.ItemConversionUtils;
import com.github.mim1q.minecells.item.DoorwayItem;
import com.github.mim1q.minecells.item.MineCellsItemTags;
import com.github.mim1q.minecells.item.weapon.melee.CustomMeleeWeapon;
import com.github.mim1q.minecells.registry.MineCellsBlocks;
import com.github.mim1q.minecells.registry.MineCellsEntities;
import com.github.mim1q.minecells.registry.MineCellsItems;
import com.github.mim1q.minecells.registry.featureset.StoneSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class MineCellsDatagen
extends AllDatagenUtils {
    @Override
    public void initialize() {
        this.initializeSimpleBlocks();
        this.initializeWoodSets();
        this.initializeStoneSets();
        this.initializeLeavesSets();
        this.initializeTorches();
        this.initializeDoorways();
        this.initializeMiscBlocks();
        this.initializeCustomItemModels();
        this.initializeTags();
    }

    private void initializeSimpleBlocks() {
        List<class_2248> blocks = List.of(MineCellsBlocks.ELEVATOR_ASSEMBLER, MineCellsBlocks.CRATE, MineCellsBlocks.HARDSTONE, MineCellsBlocks.CHAIN_PILE_BLOCK, MineCellsBlocks.RUNIC_VINE_STONE);
        this.getInitializers().blockState().add(it -> {
            blocks.forEach(arg_0 -> ((class_4910)it).method_25641(arg_0));
            it.method_25708(MineCellsBlocks.CELL_CRAFTER);
            it.field_22830.accept(class_4925.method_25770((class_2248)MineCellsBlocks.UNBREAKABLE_CELL_CRAFTER, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)DatagenModelUtils.getBlockId(MineCellsBlocks.CELL_CRAFTER))).method_25775(class_4910.method_25599()));
        });
        this.getInitializers().blockLootTable().add(it -> blocks.forEach(arg_0 -> ((FabricBlockLootTableProvider)it).method_46025(arg_0)));
    }

    private void initializeWoodSets() {
        this.addWoodSet(MineCellsBlocks.PUTRID_WOOD);
    }

    private void initializeStoneSets() {
        this.addSimpleSet(MineCellsBlocks.PUTRID_BOARD);
        this.addFullStoneSet(MineCellsBlocks.PRISON_STONE, false, new StoneSet[0]);
        this.addSilkTouchDrop(MineCellsBlocks.PRISON_STONE.block, MineCellsBlocks.PRISON_COBBLESTONE.block);
        this.addStoneSet(MineCellsBlocks.PRISON_BRICKS, true, new StoneSet[0]);
        this.addStoneSet(MineCellsBlocks.PRISON_COBBLESTONE, true, new StoneSet[0]);
        this.addStoneSet(MineCellsBlocks.CRACKED_PRISON_BRICKS, true, new StoneSet[0]);
        this.addStoneSet(MineCellsBlocks.SMALL_PRISON_BRICKS, true, new StoneSet[0]);
        class_2960 grassOverlay = MineCells.createId("block/wilted_grass_block_overlay");
        this.addGrass(MineCellsBlocks.WILTED_GRASS_BLOCK, MineCellsBlocks.PRISON_STONE.block, grassOverlay);
        this.addStoneSet(MineCellsBlocks.BLOOMROCK, true, new StoneSet[0]);
        this.addStoneSet(MineCellsBlocks.BLOOMROCK_BRICKS, true, new StoneSet[]{MineCellsBlocks.BLOOMROCK});
        this.addStoneSet(MineCellsBlocks.BLOOMROCK_TILES, true, new StoneSet[]{MineCellsBlocks.BLOOMROCK});
        this.addStoneSet(MineCellsBlocks.CRACKED_BLOOMROCK_BRICKS, true, new StoneSet[]{MineCellsBlocks.BLOOMROCK});
        this.addGrass(MineCellsBlocks.BLOOMROCK_WILTED_GRASS_BLOCK, MineCellsBlocks.BLOOMROCK.block, grassOverlay);
        this.addStoneSet(MineCellsBlocks.SEPTITE, false, new StoneSet[0]);
        this.addSilkTouchDrop(MineCellsBlocks.SEPTITE.block, MineCellsBlocks.COBBLED_SEPTITE.block);
        this.addStoneSet(MineCellsBlocks.COBBLED_SEPTITE, true, new StoneSet[]{MineCellsBlocks.SEPTITE});
        this.addStoneSet(MineCellsBlocks.SEPTITE_BRICKS, true, new StoneSet[]{MineCellsBlocks.SEPTITE});
        this.addStoneSet(MineCellsBlocks.POLISHED_SEPTITE, true, new StoneSet[]{MineCellsBlocks.SEPTITE});
        this.addStoneSet(MineCellsBlocks.SMALL_SEPTITE_BRICKS, true, new StoneSet[]{MineCellsBlocks.SEPTITE});
        this.addStoneSet(MineCellsBlocks.ANCIENT_SEPTITE, false, new StoneSet[0]);
        this.addSilkTouchDrop(MineCellsBlocks.ANCIENT_SEPTITE.block, MineCellsBlocks.COBBLED_ANCIENT_SEPTITE.block);
        this.addStoneSet(MineCellsBlocks.COBBLED_ANCIENT_SEPTITE, true, new StoneSet[]{MineCellsBlocks.ANCIENT_SEPTITE});
        this.addStoneSet(MineCellsBlocks.ANCIENT_SEPTITE_BRICKS, true, new StoneSet[]{MineCellsBlocks.ANCIENT_SEPTITE});
        this.addStoneSet(MineCellsBlocks.POLISHED_ANCIENT_SEPTITE, true, new StoneSet[]{MineCellsBlocks.ANCIENT_SEPTITE});
        this.addStoneSet(MineCellsBlocks.SMALL_ANCIENT_SEPTITE_BRICKS, true, new StoneSet[]{MineCellsBlocks.ANCIENT_SEPTITE});
        this.addCorpse(MineCellsBlocks.CORPSE, MineCellsBlocks.HANGED_CORPSE, class_1802.field_8511, MineCellsItems.GUTS);
        this.addCorpse(MineCellsBlocks.SKELETON, MineCellsBlocks.HANGED_SKELETON, class_1802.field_8606, class_1802.field_8398);
        this.addCorpse(MineCellsBlocks.ROTTING_CORPSE, MineCellsBlocks.HANGED_ROTTING_CORPSE, class_1802.field_8511, MineCellsItems.GUTS);
    }

    private void initializeMiscBlocks() {
        this.getInitializers().blockState().add(it -> it.method_31063((class_2248)MineCellsBlocks.UNBREAKABLE_CHAIN, DatagenModelUtils.getBlockId(class_2246.field_23985)));
        this.addSingleBlockstate(MineCellsBlocks.RETURN_STONE);
        this.addSingleBlockstate(MineCellsBlocks.RUNIC_VINE_PLANT);
        this.addInvisibleBlock(MineCellsBlocks.BARRIER_RUNE);
        this.addInvisibleBlock(MineCellsBlocks.SOLID_BARRIER);
        this.addInvisibleBlock(MineCellsBlocks.CONDITIONAL_BARRIER);
        this.addInvisibleBlock(MineCellsBlocks.BOSS_ENTRY_BARRIER_CONTROLLER);
        this.addInvisibleBlock(MineCellsBlocks.BOSS_BARRIER_CONTROLLER);
        this.addInvisibleBlock(MineCellsBlocks.PLAYER_BARRIER_CONTROLLER);
        this.addInvisibleBlock(MineCellsBlocks.CONJUNCTIVIUS_BOX);
        this.addInvisibleBlock(MineCellsBlocks.CONCIERGE_BOX);
        this.addInvisibleBlock((class_2248)MineCellsBlocks.RIFT);
        this.addInvisibleBlock(MineCellsBlocks.DOORWAY_FRAME);
        this.addInvisibleBlock(MineCellsBlocks.UNBREAKABLE_DOORWAY_FRAME);
        this.addInvisibleBlock((class_2248)MineCellsBlocks.ARROW_SIGN);
        this.addInvisibleBlock(MineCellsBlocks.BEAM_PLACER);
        this.addInvisibleBlock((class_2248)MineCellsBlocks.SEWAGE);
        this.addInvisibleBlock((class_2248)MineCellsBlocks.ANCIENT_SEWAGE);
        this.addInvisibleBlock(MineCellsBlocks.KINGDOM_PORTAL_CORE);
        this.addCrossModel(MineCells.createId("block/runic_vine"));
        this.addCrossModel(MineCells.createId("block/runic_vine_top"));
        this.getInitializers().blockState().add(it -> {
            it.field_22830.accept(class_4925.method_25770((class_2248)MineCellsBlocks.SPAWNER_RUNE, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)DatagenModelUtils.getBlockId((class_2248)MineCellsBlocks.SPAWNER_RUNE))));
            it.field_22830.accept(class_4925.method_25769((class_2248)MineCellsBlocks.RUNIC_VINE).method_25775((class_4926)class_4926.method_25783((class_2769)RunicVineBlock.TOP).method_25793((Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)MineCells.createId("block/runic_vine"))).method_25793((Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)MineCells.createId("block/runic_vine_top")))));
        });
    }

    private void initializeLeavesSets() {
        this.addLeavesSet(MineCellsBlocks.WILTED_LEAVES, MineCellsBlocks.PUTRID_SAPLING);
        this.addLeavesSet(MineCellsBlocks.ORANGE_WILTED_LEAVES, MineCellsBlocks.ORANGE_PUTRID_SAPLING);
        this.addLeavesSet(MineCellsBlocks.RED_WILTED_LEAVES, MineCellsBlocks.RED_PUTRID_SAPLING);
    }

    private void initializeTorches() {
        this.addColoredTorch(MineCellsBlocks.PRISON_TORCH, "prison");
        this.addColoredTorch(MineCellsBlocks.PROMENADE_TORCH, "promenade");
        this.addColoredTorch(MineCellsBlocks.RAMPARTS_TORCH, "ramparts");
        this.addColoredTorch(MineCellsBlocks.SEWERS_TORCH, "sewers");
        this.addColoredTorch(MineCellsBlocks.ANCIENT_SEWERS_TORCH, "ancient_sewers");
    }

    private void initializeDoorways() {
        this.addDoorway(MineCellsBlocks.OVERWORLD_DOORWAY);
        this.addDoorway(MineCellsBlocks.PRISON_DOORWAY);
        this.addDoorway(MineCellsBlocks.PROMENADE_DOORWAY);
        this.addDoorway(MineCellsBlocks.RAMPARTS_DOORWAY);
        this.addDoorway(MineCellsBlocks.BLACK_BRIDGE_DOORWAY);
        this.addDoorway(MineCellsBlocks.INSUFFERABLE_CRYPT_DOORWAY);
    }

    private void initializeCustomItemModels() {
        this.initializeGeneratedItemModels();
        this.initializeHandheldItemModels();
        this.initializeWeaponCopies();
        MineCellsItems.BOWS.forEach(this::addBow);
        MineCellsItems.CROSSBOWS.forEach(this::addCrossbow);
        MineCellsItems.SHIELDS.forEach(this::addShield);
        List<SkeletonDecorationBlock> parented = List.of(MineCellsBlocks.FLAG_POLE, MineCellsBlocks.BRITTLE_BARREL, MineCellsBlocks.CELL_CRAFTER, MineCellsBlocks.SKELETON, MineCellsBlocks.CORPSE, MineCellsBlocks.ROTTING_CORPSE);
        this.getInitializers().blockState().add(it -> {
            parented.forEach(block -> it.method_25538(block.method_8389(), DatagenModelUtils.getBlockId(block)));
            it.method_25600(MineCellsBlocks.SPIKES);
            it.method_25623(MineCellsBlocks.UNBREAKABLE_CELL_CRAFTER, DatagenModelUtils.getBlockId(MineCellsBlocks.CELL_CRAFTER));
        });
    }

    private void initializeWeaponCopies() {
        Set<class_1792> handheldItems = CustomMeleeWeapon.getAllMeleeWeapons();
        this.getInitializers().itemModel().add(it -> {
            for (class_1792 item : handheldItems) {
                class_2960 id = DatagenModelUtils.getItemId((class_1935)item);
                class_2960 newId = class_2960.method_60655((String)id.method_12836(), (String)id.method_12832().replace("item/", "item/weapon/"));
                new class_4942(Optional.of(newId), Optional.empty(), new class_4945[0]).method_25852(id, new class_4944(), it.field_22844);
            }
        });
    }

    private void initializeGeneratedItemModels() {
        Set<DoorwayItem> doorways = MineCellsItems.DOORWAY_COLORS.keySet();
        Set<class_1826> spawnEggs = MineCellsEntities.SPAWN_EGGS;
        List<class_1792> misc = List.of(MineCellsBlocks.CAGE.method_8389(), MineCellsBlocks.BROKEN_CAGE.method_8389(), MineCellsItems.CONJUNCTIVIUS_RESPAWN_RUNE, MineCellsItems.VINE_RUNE, MineCellsItems.GUTS, MineCellsItems.MONSTERS_EYE, MineCellsItems.SEWAGE_BUCKET, MineCellsItems.ANCIENT_SEWAGE_BUCKET, MineCellsItems.HEALTH_FLASK, MineCellsBlocks.KING_STATUE.method_8389(), MineCellsBlocks.BARRIER_RUNE.method_8389(), MineCellsItems.ELEVATOR_MECHANISM, MineCellsItems.RESET_RUNE, MineCellsItems.CONCIERGE_RESPAWN_RUNE, MineCellsItems.MONSTER_CELL, MineCellsItems.BOSS_STEM_CELL, MineCellsBlocks.ARROW_SIGN.method_8389(), MineCellsItems.ELECTRIC_WHIP, MineCellsItems.THROWING_KNIFE, MineCellsItems.FIREBRANDS, MineCellsItems.EXPLOSIVE_BOLT, MineCellsItems.ICE_ARROW, MineCellsItems.EXPLOSIVE_BULB, MineCellsItems.INFECTED_FLESH, MineCellsItems.CELL_INFUSED_STEEL, MineCellsItems.METAL_SHARDS, MineCellsItems.BUZZCUTTER_FANG, MineCellsItems.MOLTEN_CHUNK, MineCellsItems.SEWER_CALAMARI, MineCellsItems.COOKED_SEWER_CALAMARI, MineCellsItems.TRANSPOSITION_CORE, MineCellsItems.BLOOD_BOTTLE, MineCellsItems.ARCANE_GOO, MineCellsItems.PHASER, MineCellsItems.FROST_BLAST);
        this.addGeneratedTexture(MineCells.createId("item/cell_holder/1"));
        this.addGeneratedTexture(MineCells.createId("item/cell_holder/2"));
        this.addGeneratedTexture(MineCells.createId("item/cell_holder/3"));
        this.addGeneratedItem((class_1935)MineCellsBlocks.SOLID_BARRIER, DatagenModelUtils.getItemId((class_1935)MineCellsBlocks.BARRIER_RUNE));
        this.getInitializers().itemModel().add(it -> {
            doorways.forEach(item -> {
                class_4942 model = new class_4942(Optional.of(MineCells.createId("item/doorway")), Optional.of("inventory"), new class_4945[0]);
                model.method_25852(class_4941.method_25840((class_1792)item), new class_4944(), it.field_22844);
            });
            class_4943.field_22938.method_25852(MineCells.createId("item/guidebook"), class_4944.method_25895((class_2960)MineCells.createId("item/guidebook")), it.field_22844);
        });
        misc.forEach(this::addGeneratedItem);
        MineCellsBlocks.LARGE_RIBBON_FLAGS.forEach((dye, it) -> this.addFlag((FlagBlock)((Object)it), (class_1935)ItemConversionUtils.DYE_TO_WOOL.get(dye), null));
        MineCellsBlocks.RIBBON_FLAGS.forEach((dye, it) -> this.addFlag((FlagBlock)((Object)it), (class_1935)ItemConversionUtils.DYE_TO_WOOL.get(dye), null));
        this.addFlag(MineCellsBlocks.KINGS_CREST_FLAG, (class_1935)class_2246.field_10514, null);
        this.addFlag(MineCellsBlocks.TORN_KINGS_CREST_FLAG, (class_1935)class_2246.field_10514, null);
        this.addFlag(MineCellsBlocks.PROMENADE_OF_THE_CONDEMNED_FLAG, (class_1935)class_2246.field_10514, MineCells.createId("promenade"));
        this.addFlag(MineCellsBlocks.RAMPARTS_FLAG, (class_1935)class_2246.field_10490, MineCells.createId("ramparts"));
        this.addFlag(MineCellsBlocks.INSUFFERABLE_CRYPT_FLAG, (class_1935)class_2246.field_10170, MineCells.createId("insufferable_crypt"));
        this.addFlag(MineCellsBlocks.BLACK_BRIDGE_FLAG, (class_1935)class_2246.field_10259, MineCells.createId("black_bridge"));
        for (class_1826 egg : spawnEggs) {
            class_2960 id = DatagenModelUtils.getItemId((class_1935)egg, "spawn_eggs/");
            this.addGeneratedItem((class_1935)egg, class_2960.method_60655((String)id.method_12836(), (String)id.method_12832().substring(0, id.method_12832().lastIndexOf("_spawn_egg"))));
        }
    }

    private void initializeHandheldItemModels() {
        List<class_1792> handheldItems = List.of(MineCellsItems.LIGHTNING_BOLT);
        handheldItems.forEach(this::addHandheldItem);
    }

    private void initializeTags() {
        this.addBlockTag(MineCellsBlockTags.TREE_ROOT_REPLACEABLE, new class_2248[]{class_2246.field_10124, MineCellsBlocks.PRISON_STONE.block, MineCellsBlocks.PRISON_COBBLESTONE.block, MineCellsBlocks.WILTED_GRASS_BLOCK, MineCellsBlocks.BLOOMROCK_WILTED_GRASS_BLOCK});
        this.addItemTag(MineCellsItemTags.BOWS_ACCEPTING_INFINITY, new class_1935[]{MineCellsItems.MULTIPLE_NOCKS_BOW, MineCellsItems.MARKSMANS_BOW, MineCellsItems.INFANTRY_BOW, MineCellsItems.NERVES_OF_STEEL});
        this.addItemTag(MineCellsItemTags.BOWS_ACCEPTING_FLAME, new class_1935[]{MineCellsItems.MULTIPLE_NOCKS_BOW, MineCellsItems.BOW_AND_ENDLESS_QUIVER, MineCellsItems.MARKSMANS_BOW, MineCellsItems.INFANTRY_BOW, MineCellsItems.QUICK_BOW, MineCellsItems.NERVES_OF_STEEL});
        this.addItemTag(MineCellsItemTags.BOWS_ACCEPTING_POWER, new class_1935[]{MineCellsItems.MULTIPLE_NOCKS_BOW, MineCellsItems.BOW_AND_ENDLESS_QUIVER, MineCellsItems.MARKSMANS_BOW, MineCellsItems.INFANTRY_BOW, MineCellsItems.QUICK_BOW, MineCellsItems.ICE_BOW, MineCellsItems.NERVES_OF_STEEL});
        this.addItemTag(MineCellsItemTags.BOWS_ACCEPTING_PUNCH, new class_1935[]{MineCellsItems.MULTIPLE_NOCKS_BOW, MineCellsItems.BOW_AND_ENDLESS_QUIVER, MineCellsItems.MARKSMANS_BOW, MineCellsItems.INFANTRY_BOW, MineCellsItems.QUICK_BOW, MineCellsItems.ICE_BOW, MineCellsItems.NERVES_OF_STEEL});
        this.addItemTag(MineCellsItemTags.BOWS_ACCEPTING_QUICK_CHARGE, new class_1935[]{MineCellsItems.MULTIPLE_NOCKS_BOW, MineCellsItems.BOW_AND_ENDLESS_QUIVER, MineCellsItems.MARKSMANS_BOW, MineCellsItems.INFANTRY_BOW, MineCellsItems.ICE_BOW, MineCellsItems.HEAVY_CROSSBOW, MineCellsItems.EXPLOSIVE_CROSSBOW});
        this.addItemTag(class_3489.field_23802, new class_1935[]{MineCellsBlocks.PRISON_COBBLESTONE.block, MineCellsBlocks.BLOOMROCK.block});
        this.addItemTag(class_3489.field_25808, new class_1935[]{MineCellsBlocks.PRISON_COBBLESTONE.block, MineCellsBlocks.BLOOMROCK.block});
    }
}

