/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.data.spawner_runes;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.data.spawner_runes.SpawnerRuneData;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.entity.MineCellsEntity;
import com.github.mim1q.minecells.entity.boss.MineCellsBossEntity;
import com.github.mim1q.minecells.network.ServerPacketHandler;
import com.github.mim1q.minecells.network.s2c.SpawnRuneParticlesS2CPacket;
import com.github.mim1q.minecells.network.s2c.SpawnerRuneUpdateS2CPacket;
import com.github.mim1q.minecells.registry.MineCellsParticles;
import com.github.mim1q.minecells.util.ParticleUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class SpawnerRuneController {
    private class_2960 dataId = null;
    private SpawnerRuneData data = null;
    private boolean isVisible = false;
    private long lastActivationTime = -100000000L;

    public void tick(class_2338 pos, class_1937 world) {
        if (!world.field_9236 && this.data != null) {
            float d = this.data.playerDistance();
            for (class_3222 player : world.method_8390(class_3222.class, class_238.method_30048((class_243)class_243.method_24953((class_2382)pos), (double)d, (double)d, (double)d), class_1301.field_6156)) {
                if (!this.canPlayerActivate((class_1657)player, world, pos)) continue;
                this.spawnEntities(this.data, pos, (class_1657)player);
                break;
            }
            this.sendUpdatePacket(world, pos);
        }
        if (world.field_9236) {
            boolean visible = this.canClientPlayerActivate(world, pos);
            int particleAmount = 2;
            float particleSpeed = 0.1f;
            if (this.isVisible != visible) {
                particleAmount = 15;
                this.isVisible = visible;
            } else if (!this.isVisible) {
                particleAmount = 1;
            }
            int color = MineCellsDimension.getColor(world, 16738816);
            ParticleUtils.addInBox(world, MineCellsParticles.SPECKLE.get(color), class_238.method_30048((class_243)class_243.method_24953((class_2382)pos), (double)0.5, (double)0.5, (double)0.5), particleAmount, class_243.field_1353.method_49272(world.field_9229, particleSpeed));
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public long getLastActivationTime() {
        return this.lastActivationTime;
    }

    public void setLastActivationTime(long lastActivationTime) {
        this.lastActivationTime = lastActivationTime;
    }

    private void spawnEntities(SpawnerRuneData data, class_2338 pos, class_1657 spawningPlayer) {
        class_1937 world = spawningPlayer.method_37908();
        List<SpawnerRuneData.EntitySpawnData> entities = data.getSelectedEntities(world.method_8409());
        for (SpawnerRuneData.EntitySpawnData entityData : entities) {
            class_1588 hostile;
            class_1297 entity = SpawnerRuneController.spawnEntity((class_3218)world, entityData, SpawnerRuneController.findPos(world, pos, data.spawnDistance()), pos, e -> {
                if (e instanceof MineCellsEntity) {
                    MineCellsEntity mineCellsEntity = (MineCellsEntity)((Object)e);
                    if (!(e instanceof MineCellsBossEntity) && !mineCellsEntity.isElite()) {
                        mineCellsEntity.setDisappearTime(world.method_8510() + (long)(data.cooldown() * 20.0f));
                    }
                }
            });
            if (!(entity instanceof class_1588) || !(hostile = (class_1588)entity).method_6057((class_1297)spawningPlayer)) continue;
            hostile.method_5980((class_1309)spawningPlayer);
        }
        this.lastActivationTime = world.method_8510();
        this.sendUpdatePacket(world, pos);
    }

    public static List<class_1297> spawnEntities(class_3218 world, class_2960 dataId, class_2338 pos, Consumer<class_1297> entityConsumer) {
        SpawnerRuneData data = MineCells.SPAWNER_RUNE_DATA.get(dataId);
        if (data == null) {
            return List.of();
        }
        List<SpawnerRuneData.EntitySpawnData> entities = data.getSelectedEntities(world.field_9229);
        ArrayList<class_1297> result = new ArrayList<class_1297>();
        for (SpawnerRuneData.EntitySpawnData entityData : entities) {
            class_1297 entity = SpawnerRuneController.spawnEntity(world, entityData, SpawnerRuneController.findPos((class_1937)world, pos, data.spawnDistance()), pos, entityConsumer);
            result.add(entity);
        }
        return result;
    }

    private boolean canPlayerActivate(class_1657 player, class_1937 world, class_2338 pos) {
        if (this.data == null) {
            return false;
        }
        return (float)(world.method_8510() - this.lastActivationTime) > this.data.cooldown() * 20.0f;
    }

    private boolean canClientPlayerActivate(class_1937 world, class_2338 pos) {
        return this.canPlayerActivate(null, world, pos);
    }

    private static class_1297 spawnEntity(class_3218 world, SpawnerRuneData.EntitySpawnData entityData, class_2338 pos, class_2338 runePos, Consumer<class_1297> entityConsumer) {
        class_1297 spawnedEntity = entityData.entityType().method_5883((class_1937)world);
        if (spawnedEntity == null) {
            return null;
        }
        spawnedEntity.method_23327((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        if (spawnedEntity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)spawnedEntity;
            for (Object player : PlayerLookup.tracking((class_3218)world, (class_2338)runePos)) {
                ServerPacketHandler.CHANNEL.serverHandle((class_1657)player).send((Record)new SpawnRuneParticlesS2CPacket(livingEntity.method_5829().method_1014(0.5)));
            }
            entityData.attributeOverrides().forEach((attribute, value) -> {
                class_6880 entry = class_7923.field_41190.method_47983(attribute);
                class_1324 instance = livingEntity.method_5996(entry);
                if (instance != null) {
                    instance.method_6192(value.doubleValue());
                }
            });
            class_2487 currentEntityNbt = new class_2487();
            livingEntity.method_5652(currentEntityNbt);
            for (String entry : entityData.nbt().method_10541()) {
                currentEntityNbt.method_10566(entry, entityData.nbt().method_10580(entry));
            }
            livingEntity.method_5749(currentEntityNbt);
            entityConsumer.accept((class_1297)livingEntity);
            livingEntity.method_6025(livingEntity.method_6063());
            class_5819 random = world.method_8409();
            livingEntity.method_5762((random.method_43058() - 0.5) * 0.1, 0.05 + random.method_43058() * 0.05, (random.method_43058() - 0.5) * 0.1);
            if (livingEntity instanceof class_1308) {
                class_1308 mob = (class_1308)livingEntity;
                mob.method_5943((class_5425)world, world.method_8404(pos), class_3730.field_16469, null);
            }
        }
        world.method_8649(spawnedEntity);
        return spawnedEntity;
    }

    private static class_2338 findPos(class_1937 world, class_2338 pos, float radius) {
        int x = pos.method_10263() + (int)((double)radius * ((double)world.field_9229.method_43057() - 0.5));
        int z = pos.method_10260() + (int)((double)radius * ((double)world.field_9229.method_43057() - 0.5));
        int y = pos.method_10264();
        for (int i = 0; i < 4; ++i) {
            class_2680 state = world.method_8320(new class_2338(x, y, z));
            class_2680 stateBelow = world.method_8320(new class_2338(x, y - 1, z));
            class_2680 stateAbove = world.method_8320(new class_2338(x, y + 1, z));
            boolean solidBelow = stateBelow.method_26206((class_1922)world, new class_2338(x, y - 1, z), class_2350.field_11036);
            boolean empty = state.method_26220((class_1922)world, new class_2338(x, y, z)).method_1110();
            boolean emptyAbove = stateAbove.method_26220((class_1922)world, new class_2338(x, y + 1, z)).method_1110();
            if (solidBelow && empty && emptyAbove) {
                return new class_2338(x, y, z);
            }
            ++y;
        }
        return pos;
    }

    public void setDummyData(float cooldown) {
        this.data = new SpawnerRuneData(cooldown, 0.0f, 0.0f, List.of());
    }

    public void setDataId(class_1937 world, class_2338 pos, class_2960 id) {
        SpawnerRuneData newData = MineCells.SPAWNER_RUNE_DATA.get(id);
        this.dataId = id;
        if (newData == null) {
            MineCells.LOGGER.warn("Tried to load unknown spawner rune data with id: {} at pos {} in dimension {}", (Object)id, (Object)pos.method_23854(), (Object)world.method_27983().method_29177().toString());
        }
        this.data = newData;
        if (world == null || world.field_9236) {
            return;
        }
        this.sendUpdatePacket(world, pos);
    }

    private void sendUpdatePacket(class_1937 world, class_2338 pos) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            SpawnerRuneUpdateS2CPacket packet = new SpawnerRuneUpdateS2CPacket(pos, this.lastActivationTime, this.data.cooldown());
            ServerPacketHandler.CHANNEL.serverHandle((Collection)serverWorld.method_18456()).send((Record)packet);
        }
    }

    public class_2960 getDataId() {
        return this.dataId;
    }
}

