/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.command;

import com.github.mim1q.minecells.command.MineCellsTeleportCommand;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.structure.grid.GridBasedStructureUtils;
import com.github.mim1q.minecells.structure.grid.GridPiecesGenerator;
import com.github.mim1q.minecells.util.MathUtils;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7157;

public class SpecialPointCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"minecells:special_point").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).executes(SpecialPointCommand.specialPointAllArgs(false, false, false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)StringArgumentType.string()).suggests(MineCellsTeleportCommand.suggestDimension()).executes(SpecialPointCommand.specialPointAllArgs(true, false, false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(SpecialPointCommand.specialPointAllArgs(true, true, false))).then(class_2170.method_9244((String)"clear", (ArgumentType)BoolArgumentType.bool()).executes(SpecialPointCommand.specialPointAllArgs(true, true, true)))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"minecells:clear_special_point_cache").requires(source -> source.method_9259(2))).executes(ctx -> {
            GridBasedStructureUtils.clearSpecialPointsCache();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Cleared special point cache"), true);
            return 0;
        }));
    }

    private static Command<class_2168> specialPointAllArgs(boolean hasDimension, boolean hasPos, boolean hasClear) {
        return ctx -> {
            class_2338 searchPos;
            Optional<MineCellsDimension> dimension;
            class_2960 id = class_2232.method_9443((CommandContext)ctx, (String)"id");
            Optional<MineCellsDimension> optional = dimension = hasDimension ? MineCellsTeleportCommand.getDimensionFromString((CommandContext<class_2168>)ctx, "dimension") : Optional.ofNullable(MineCellsDimension.of((class_1937)((class_2168)ctx.getSource()).method_9225()));
            if (dimension.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid dimension"));
                return 1;
            }
            class_2338 class_23382 = searchPos = hasPos ? class_2262.method_48299((CommandContext)ctx, (String)"pos") : class_2338.method_49638((class_2374)((class_2168)ctx.getSource()).method_9222());
            if (!hasClear || BoolArgumentType.getBool((CommandContext)ctx, (String)"clear")) {
                GridBasedStructureUtils.clearSpecialPointsCache();
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Cleared special point cache"), true);
            }
            return SpecialPointCommand.findSpecialPoint((CommandContext<class_2168>)ctx, dimension.get(), id, (class_2382)searchPos);
        };
    }

    private static int findSpecialPoint(CommandContext<class_2168> ctx, MineCellsDimension dimension, class_2960 id, class_2382 searchPos) {
        Optional<GridPiecesGenerator.RoomGridGenerator.SpecialPoint> posOpt = GridBasedStructureUtils.getSpecialPoint(((class_2168)ctx.getSource()).method_9225(), searchPos, id);
        if (posOpt.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Not found"));
            return 1;
        }
        class_2382 pos = posOpt.get().offset().method_35853(MathUtils.getClosestMultiplePosition(searchPos, 1024));
        String dimensionKey = dimension.key.method_29177().toString();
        String command = "/execute in " + dimensionKey + " run tp @s " + pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260();
        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Found " + String.valueOf(id) + " at " + String.valueOf(pos) + ", rotation: " + String.valueOf(posOpt.get().facing()) + " in " + dimensionKey)).method_27694(it -> it.method_10958(new class_2558(class_2558.class_2559.field_11745, command))));
        return 0;
    }
}

