/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.client.render.conjunctivius;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.client.render.model.conjunctivius.ConjunctiviusEntityModel;
import com.github.mim1q.minecells.entity.boss.ConjunctiviusEntity;
import com.github.mim1q.minecells.util.RenderUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_7833;

public class ConjunctiviusEyeRenderer
extends class_3887<ConjunctiviusEntity, ConjunctiviusEntityModel> {
    private static final class_2960[] TEXTURES = new class_2960[]{MineCells.createId("textures/entity/conjunctivius/eye_pink.png"), MineCells.createId("textures/entity/conjunctivius/eye_yellow.png"), MineCells.createId("textures/entity/conjunctivius/eye_green.png"), MineCells.createId("textures/entity/conjunctivius/eye_blue.png")};
    private static final class_2960 EYELID_TEXTURE = MineCells.createId("textures/entity/conjunctivius/eyelid.png");
    private final ConjunctiviusEyeModel model;

    public ConjunctiviusEyeRenderer(class_3883<ConjunctiviusEntity, ConjunctiviusEntityModel> context, class_630 eyeRoot) {
        super(context);
        this.model = new ConjunctiviusEyeModel(eyeRoot);
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, ConjunctiviusEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        this.renderEyelid(matrices, vertexConsumers, light, entity, animationProgress);
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.2f, -0.96875f);
        this.model.setAngles(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
        class_1921 renderLayer = class_1921.method_23576((class_2960)this.getTexture(entity));
        class_4588 vertexConsumer = vertexConsumers.getBuffer(renderLayer);
        this.model.method_2828(matrices, vertexConsumer, 0xF000F0, class_4608.field_21444, -1);
        matrices.method_22909();
    }

    public class_2960 getTexture(ConjunctiviusEntity entity) {
        ConjunctiviusEntity.EyeState state = entity.getEyeState();
        if (state == ConjunctiviusEntity.EyeState.SHAKING) {
            return TEXTURES[entity.field_6012 / 2 % TEXTURES.length];
        }
        return TEXTURES[state.index];
    }

    private void renderEyelid(class_4587 matrices, class_4597 vertexConsumers, int light, ConjunctiviusEntity entity, float animationProgress) {
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.25f, -1.0f);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        int frame = entity.getEyelidFrame(animationProgress);
        float minV = (float)frame * 0.2f;
        float maxV = minV + 0.2f;
        class_4588 buffer = vertexConsumers.getBuffer(class_1921.method_23578((class_2960)EYELID_TEXTURE));
        int overlay = class_4608.method_23624((float)0.0f, (entity.field_6235 > 0 ? 1 : 0) != 0);
        RenderUtils.drawBillboard(buffer, matrices, light, 2.0f, 2.0f, 0.0f, 1.0f, minV, maxV, -1, overlay);
        matrices.method_22909();
    }

    public static class ConjunctiviusEyeModel
    extends class_583<ConjunctiviusEntity> {
        private final class_630 eye;
        private final class_630 highlight;

        public ConjunctiviusEyeModel(class_630 root) {
            super(class_1921::method_23026);
            this.eye = root.method_32086("eye");
            this.highlight = root.method_32086("highlight");
        }

        public static class_5607 getTexturedModelData() {
            class_5609 modelData = new class_5609();
            class_5610 modelPartData = modelData.method_32111();
            modelPartData.method_32117("eye", class_5606.method_32108().method_32101(0, 0).method_32097(-5.5f, -5.5f, 0.0f, 11.0f, 11.0f, 0.0f), class_5603.field_27701);
            modelPartData.method_32117("highlight", class_5606.method_32108().method_32101(0, 11).method_32097(0.0f, 0.0f, 0.0f, 5.0f, 4.0f, 0.0f), class_5603.method_32090((float)1.0f, (float)-5.0f, (float)-0.25f));
            return class_5607.method_32110((class_5609)modelData, (int)32, (int)16);
        }

        public void setAngles(ConjunctiviusEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
            if (entity.isForDisplay()) {
                this.eye.method_2851(2.5f, 0.0f, -0.01f);
                this.highlight.method_2851(1.0f, -5.0f, -0.25f);
                return;
            }
            class_1297 player = class_310.method_1551().method_1560();
            if (player != null) {
                class_243 rotatedDiff = entity.getEyeOffset(class_310.method_1551().method_60646().method_60637(false));
                this.eye.field_3657 = (float)rotatedDiff.field_1352;
                this.eye.field_3656 = (float)rotatedDiff.field_1351;
                this.highlight.field_3655 = -0.25f;
            }
        }

        public void method_2828(class_4587 matrices, class_4588 vertices, int light, int overlay, int color) {
            matrices.method_22903();
            this.eye.method_22699(matrices, vertices, light, overlay, color);
            this.highlight.method_22699(matrices, vertices, light, overlay, color);
            matrices.method_22909();
        }
    }
}

