/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.block.portal;

import com.github.mim1q.minecells.block.portal.DoorwayPortalBlock;
import com.github.mim1q.minecells.cc.MineCellsLevelCC;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.registry.MineCellsBlockEntities;
import com.github.mim1q.minecells.structure.grid.SpecialPointIds;
import com.github.mim1q.minecells.util.MathUtils;
import dev.mim1q.gimm1q.client.tooltip.TooltipResolverRegistry;
import dev.mim1q.gimm1q.interpolation.AnimatedProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class DoorwayPortalBlockEntity
extends class_2586 {
    public final AnimatedProperty closedBarsAnimation = new AnimatedProperty((Boolean)this.method_11010().method_11654((class_2769)DoorwayPortalBlock.CLOSED) != false ? 1.0f : 0.0f);
    private class_2960 specialPointTarget = SpecialPointIds.ENTRANCE;
    @Nullable
    private class_2338 posOverride = null;
    @Nullable
    private UUID ownerId = null;
    @Nullable
    private String ownerName = null;
    private boolean onlyOwnerCanEnter = false;

    public DoorwayPortalBlockEntity(class_2338 pos, class_2680 state) {
        this(MineCellsBlockEntities.DOORWAY, pos, state);
    }

    protected DoorwayPortalBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public class_2960 getTexture() {
        return ((DoorwayPortalBlock)this.method_11010().method_26204()).type.texture;
    }

    private DoorwayPortalBlock.DoorwayType getDoorwayType() {
        return ((DoorwayPortalBlock)this.method_11010().method_26204()).type;
    }

    public class_2960 getBackgroundTexture() {
        return ((DoorwayPortalBlock)this.method_11010().method_26204()).type.backgroundTexture;
    }

    public class_2338 getOverridePos() {
        return this.posOverride == null ? this.field_11867 : this.posOverride;
    }

    public List<class_5250> getLabel() {
        MineCellsDimension dimension = this.getDoorwayType().dimension;
        ArrayList<class_5250> list = new ArrayList<class_5250>();
        if (this.ownerName != null) {
            list.add(class_2561.method_43470((String)this.ownerName).method_27694(it -> it.method_10977(class_124.field_1080)));
        }
        class_5250 dimensionName = class_2561.method_43471((String)dimension.translationKey).method_27694(it -> it.method_36139(dimension.getColor()));
        List dimensionTooltip = TooltipResolverRegistry.TooltipHelper.splitTextIfExceeds((class_2561)dimensionName, (int)20);
        for (class_2561 text : dimensionTooltip) {
            list.add(text.method_27661());
        }
        return list;
    }

    public boolean canPlayerEnter(class_1657 player) {
        if (this.ownerId == null || !this.onlyOwnerCanEnter) {
            return true;
        }
        return player.method_5667().equals(this.ownerId);
    }

    public void teleportPlayer(class_3222 player, class_3218 world, MineCellsDimension targetDimension) {
        if (!this.canPlayerEnter((class_1657)player)) {
            return;
        }
        Optional<MineCellsLevelCC.PortalData> data = MineCellsLevelCC.PortalsCC.findDataOfPosition((class_1937)world, this.getTargetPos());
        if (data.isPresent() && data.get().owner().equals(player.method_5667())) {
            MineCellsLevelCC.PortalsCC.visitDimension(world, this.getTargetPos(), targetDimension);
        }
        if (world.method_27983().equals(class_1937.field_25179)) {
            MineCellsLevelCC.OverworldEntriesCC.setPlayerEntrancePoint(player, this.method_11016(), this.getTargetPos(), ((class_2350)this.method_11010().method_11654((class_2769)DoorwayPortalBlock.FACING)).method_10144(), world);
        }
        targetDimension.teleportPlayer(player, world, this.getTargetPos(), this.specialPointTarget);
    }

    private class_2338 getTargetPos() {
        return this.posOverride == null ? new class_2338(MathUtils.getClosestMultiplePosition((class_2382)this.method_11016(), 1024)) : this.posOverride;
    }

    public float getRotation() {
        return ((class_2350)this.method_11010().method_11654((class_2769)DoorwayPortalBlock.FACING)).method_10144();
    }

    public void update(class_1657 owner, class_2338 posOverride, boolean onlyOwnerCanEnter) {
        this.ownerId = owner.method_5667();
        this.ownerName = owner.method_5477().getString();
        this.posOverride = posOverride;
        this.onlyOwnerCanEnter = onlyOwnerCanEnter;
        this.method_5431();
        owner.method_37908().method_8413(this.field_11867, this.method_11010(), this.method_11010(), 0);
    }

    public boolean canEdit(class_1657 player) {
        return player.method_37908().method_27983().equals(MineCellsDimension.OVERWORLD.key) && (this.ownerId == null || this.ownerId.equals(player.method_5667()));
    }

    public class_2487 method_16887(class_7225.class_7874 lookup) {
        return this.method_38244(lookup);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11014(nbt, lookup);
        if (nbt.method_10545("special_point_target")) {
            this.specialPointTarget = class_2960.method_12829((String)nbt.method_10558("special_point_target"));
        } else if (nbt.method_10545("upstream")) {
            class_2960 class_29602 = this.specialPointTarget = nbt.method_10577("upstream") ? SpecialPointIds.EXIT : SpecialPointIds.ENTRANCE;
        }
        if (nbt.method_10545("pos_override")) {
            this.posOverride = class_2338.method_10092((long)nbt.method_10537("pos_override"));
        }
        if (nbt.method_10545("owner_id")) {
            this.ownerId = UUID.fromString(nbt.method_10558("owner_id"));
        }
        if (nbt.method_10545("owner_name")) {
            this.ownerName = nbt.method_10558("owner_name");
        }
        if (nbt.method_10545("only_owner_can_enter")) {
            this.onlyOwnerCanEnter = nbt.method_10577("only_owner_can_enter");
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11007(nbt, lookup);
        nbt.method_10582("special_point_target", this.specialPointTarget.toString());
        if (this.posOverride != null) {
            nbt.method_10544("pos_override", this.posOverride.method_10063());
        }
        if (this.ownerId != null) {
            nbt.method_10582("owner_id", this.ownerId.toString());
        }
        if (this.ownerName != null) {
            nbt.method_10582("owner_name", this.ownerName);
        }
        nbt.method_10556("only_owner_can_enter", this.onlyOwnerCanEnter);
    }
}

