/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.util;

import dev.muon.dynamic_resource_bars.util.StaminaProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class StaminaProviderRegistry {
    private static final List<Supplier<StaminaProvider>> registeredProviders = new ArrayList<Supplier<StaminaProvider>>();
    private static StaminaProvider activeProvider = null;

    public static void registerProvider(Supplier<StaminaProvider> providerSupplier) {
        registeredProviders.add(providerSupplier);
        if (activeProvider == null) {
            StaminaProviderRegistry.setActiveProvider(providerSupplier.get());
        }
    }

    public static void setActiveProvider(@Nullable StaminaProvider provider) {
        activeProvider = provider;
    }

    @Nullable
    public static StaminaProvider getActiveProvider() {
        if (activeProvider == null && !registeredProviders.isEmpty()) {
            StaminaProviderRegistry.setActiveProvider(registeredProviders.get(0).get());
        }
        return activeProvider;
    }

    public static boolean hasProviders() {
        return !registeredProviders.isEmpty();
    }

    public static List<Supplier<StaminaProvider>> getRegisteredProviders() {
        return List.copyOf(registeredProviders);
    }

    public static void clear() {
        registeredProviders.clear();
        activeProvider = null;
    }
}

