/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.util;

import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.util.Position;
import dev.muon.dynamic_resource_bars.util.StaminaBarBehavior;
import lombok.Generated;
import net.minecraft.class_310;

public class HUDPositioning {
    private static int vanillaHealthHeight = 9;
    private static int vanillaHungerHeight = 9;

    public static Position getPositionFromAnchor(BarPlacement anchor) {
        return switch (anchor.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> HUDPositioning.getHealthAnchor();
            case 1 -> HUDPositioning.getArmorAnchor();
            case 2 -> HUDPositioning.getHungerAnchor();
            case 3 -> HUDPositioning.getAirAnchor();
            case 4 -> HUDPositioning.getAboveUtilitiesAnchor();
        };
    }

    public static Position getHealthAnchor() {
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int screenHeight = class_310.method_1551().method_22683().method_4502();
        return new Position(screenWidth / 2 - 91, screenHeight - 40);
    }

    public static Position getArmorAnchor() {
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int screenHeight = class_310.method_1551().method_22683().method_4502();
        int healthHeight = ModConfigManager.getClient().enableHealthBar ? ModConfigManager.getClient().healthBackgroundHeight : HUDPositioning.getVanillaHealthHeight();
        return new Position(screenWidth / 2 - 91, HUDPositioning.getHealthAnchor().y() - healthHeight - 1);
    }

    public static Position getHungerAnchor() {
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int screenHeight = class_310.method_1551().method_22683().method_4502();
        return new Position(screenWidth / 2 + 91, screenHeight - 40);
    }

    public static Position getAirAnchor() {
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int screenHeight = class_310.method_1551().method_22683().method_4502();
        int staminaHeight = !ModConfigManager.getClient().staminaBarBehavior.equals((Object)StaminaBarBehavior.OFF) ? ModConfigManager.getClient().staminaBackgroundHeight : HUDPositioning.getVanillaHungerHeight();
        return new Position(screenWidth / 2 + 91, HUDPositioning.getHungerAnchor().y() - staminaHeight - 1);
    }

    public static Position getAboveUtilitiesAnchor() {
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int screenHeight = class_310.method_1551().method_22683().method_4502();
        return new Position(screenWidth / 2, screenHeight - 65);
    }

    @Generated
    public static void setVanillaHealthHeight(int vanillaHealthHeight) {
        HUDPositioning.vanillaHealthHeight = vanillaHealthHeight;
    }

    @Generated
    public static int getVanillaHealthHeight() {
        return vanillaHealthHeight;
    }

    @Generated
    public static void setVanillaHungerHeight(int vanillaHungerHeight) {
        HUDPositioning.vanillaHungerHeight = vanillaHungerHeight;
    }

    @Generated
    public static int getVanillaHungerHeight() {
        return vanillaHungerHeight;
    }

    public static enum BarPlacement {
        HEALTH(AnchorSide.LEFT),
        ARMOR(AnchorSide.LEFT),
        HUNGER(AnchorSide.RIGHT),
        AIR(AnchorSide.RIGHT),
        ABOVE_UTILITIES(AnchorSide.LEFT);

        private final AnchorSide side;

        private BarPlacement(AnchorSide side) {
            this.side = side;
        }

        public AnchorSide getSide() {
            return this.side;
        }
    }

    public static enum AnchorSide {
        LEFT,
        RIGHT;

    }
}

