/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.muon.dynamic_resource_bars.DynamicResourceBars;
import dev.muon.dynamic_resource_bars.config.ClientConfig;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.util.DraggableElement;
import dev.muon.dynamic_resource_bars.util.EditModeManager;
import dev.muon.dynamic_resource_bars.util.FillDirection;
import dev.muon.dynamic_resource_bars.util.HUDPositioning;
import dev.muon.dynamic_resource_bars.util.HorizontalAlignment;
import dev.muon.dynamic_resource_bars.util.ManaProvider;
import dev.muon.dynamic_resource_bars.util.Position;
import dev.muon.dynamic_resource_bars.util.RenderUtil;
import dev.muon.dynamic_resource_bars.util.ScreenRect;
import dev.muon.dynamic_resource_bars.util.SubElementType;
import dev.muon.dynamic_resource_bars.util.TextBehavior;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;

public class ManaBarRenderer {
    private static float lastMana = -1.0f;
    private static long fullManaStartTime = 0L;
    private static long barEnabledStartTime = 0L;
    private static long barDisabledStartTime = 0L;
    private static boolean barSetVisible = false;
    private static final int RESERVED_MANA_COLOR = 0x232323;
    private static final long CHUNK_FADEOUT_DURATION = 500L;
    private static final List<FadingChunk> fadingChunks = new ArrayList<FadingChunk>();
    private static double previousMana = -1.0;
    private static float previousMaxMana = -1.0f;

    public static ScreenRect getScreenRect(class_1657 player) {
        if (player == null && class_310.method_1551().field_1724 == null) {
            return new ScreenRect(0, 0, 0, 0);
        }
        Position manaPosBase = HUDPositioning.getPositionFromAnchor(ModConfigManager.getClient().manaBarAnchor);
        Position manaPos = manaPosBase.offset(ModConfigManager.getClient().manaTotalXOffset, ModConfigManager.getClient().manaTotalYOffset);
        int backgroundWidth = ModConfigManager.getClient().manaBackgroundWidth;
        int backgroundHeight = ModConfigManager.getClient().manaBackgroundHeight;
        return new ScreenRect(manaPos.x(), manaPos.y(), backgroundWidth, backgroundHeight);
    }

    public static ScreenRect getSubElementRect(SubElementType type, class_1657 player) {
        ScreenRect complexRect = ManaBarRenderer.getScreenRect(player);
        if (complexRect == null || complexRect.width() == 0 && complexRect.height() == 0) {
            return new ScreenRect(0, 0, 0, 0);
        }
        int x = complexRect.x();
        int y = complexRect.y();
        switch (type) {
            case BACKGROUND: {
                return new ScreenRect(x + ModConfigManager.getClient().manaBackgroundXOffset, y + ModConfigManager.getClient().manaBackgroundYOffset, ModConfigManager.getClient().manaBackgroundWidth, ModConfigManager.getClient().manaBackgroundHeight);
            }
            case BAR_MAIN: {
                return new ScreenRect(x + ModConfigManager.getClient().manaBarXOffset, y + ModConfigManager.getClient().manaBarYOffset, ModConfigManager.getClient().manaBarWidth, ModConfigManager.getClient().manaBarHeight);
            }
            case FOREGROUND_DETAIL: {
                return new ScreenRect(x + ModConfigManager.getClient().manaOverlayXOffset, y + ModConfigManager.getClient().manaOverlayYOffset, ModConfigManager.getClient().manaOverlayWidth, ModConfigManager.getClient().manaOverlayHeight);
            }
            case TEXT: {
                return new ScreenRect(x + ModConfigManager.getClient().manaTextXOffset, y + ModConfigManager.getClient().manaTextYOffset, ModConfigManager.getClient().manaBarWidth, ModConfigManager.getClient().manaBarHeight);
            }
        }
        return new ScreenRect(0, 0, 0, 0);
    }

    public static void render(class_332 graphics, class_9779 deltaTracker, ManaProvider manaProvider, class_1657 player) {
        boolean isRightAnchored;
        boolean visibilityDecision;
        if (!class_310.method_1551().field_1761.method_2908() && !EditModeManager.isEditModeEnabled()) {
            return;
        }
        ClientConfig clientConfig = ModConfigManager.getClient();
        if (!clientConfig.fadeManaWhenFull) {
            visibilityDecision = true;
        } else if (manaProvider.hasSpecificVisibilityLogic()) {
            visibilityDecision = manaProvider.shouldDisplayBarOverride(player);
        } else {
            boolean providerForcesShow = manaProvider.forceShowBarConditions(player);
            boolean manaIsNotFull = manaProvider.getCurrentMana() < (double)manaProvider.getMaxMana();
            visibilityDecision = providerForcesShow || manaIsNotFull;
        }
        ManaBarRenderer.setBarVisibility(visibilityDecision);
        ManaBarRenderer.updateChunkTracking(player, manaProvider, deltaTracker.method_60636());
        if (!ManaBarRenderer.isVisible() && !EditModeManager.isEditModeEnabled()) {
            return;
        }
        float currentAlphaForRender = ManaBarRenderer.getCurrentAlpha();
        if (EditModeManager.isEditModeEnabled() && !ManaBarRenderer.isVisible()) {
            currentAlphaForRender = 1.0f;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)currentAlphaForRender);
        ScreenRect complexRect = ManaBarRenderer.getScreenRect(player);
        int animationCycles = ModConfigManager.getClient().manaBarAnimationCycles;
        int frameHeight = ModConfigManager.getClient().manaBarFrameHeight;
        int animOffset = (int)(((float)player.field_6012 + deltaTracker.method_60636()) / 3.0f % (float)animationCycles) * frameHeight;
        boolean bl = isRightAnchored = ModConfigManager.getClient().manaBarAnchor.getSide() == HUDPositioning.AnchorSide.RIGHT;
        if (ModConfigManager.getClient().enableManaBackground) {
            ScreenRect bgRect = ManaBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
            graphics.method_25290(DynamicResourceBars.loc("textures/gui/mana_background.png"), bgRect.x(), bgRect.y(), 0.0f, 0.0f, bgRect.width(), bgRect.height(), 256, 256);
        }
        ScreenRect barRect = ManaBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
        ManaBarRenderer.renderManaBar(graphics, manaProvider, animOffset, barRect, isRightAnchored);
        ManaBarRenderer.renderFadingChunks(graphics, barRect, manaProvider, isRightAnchored, currentAlphaForRender);
        ManaBarRenderer.renderReservedOverlay(graphics, manaProvider, animOffset, barRect);
        if (ModConfigManager.getClient().enableManaForeground) {
            ScreenRect fgRect = ManaBarRenderer.getSubElementRect(SubElementType.FOREGROUND_DETAIL, player);
            graphics.method_25290(DynamicResourceBars.loc("textures/gui/mana_foreground.png"), fgRect.x(), fgRect.y(), 0.0f, 0.0f, fgRect.width(), fgRect.height(), 256, 256);
        }
        if (ManaBarRenderer.shouldRenderManaText(manaProvider.getCurrentMana(), manaProvider.getMaxMana())) {
            ScreenRect textRect = ManaBarRenderer.getSubElementRect(SubElementType.TEXT, player);
            int textX = textRect.x() + textRect.width() / 2;
            int textY = textRect.y() + textRect.height() / 2;
            int color = ManaBarRenderer.getManaTextColor(manaProvider.getCurrentMana(), manaProvider.getMaxMana(), currentAlphaForRender);
            HorizontalAlignment alignment = ModConfigManager.getClient().manaTextAlign;
            int baseX = textRect.x();
            if (alignment == HorizontalAlignment.CENTER) {
                baseX = textX;
            } else if (alignment == HorizontalAlignment.RIGHT) {
                baseX = textRect.x() + textRect.width();
            }
            RenderUtil.renderText((float)manaProvider.getCurrentMana(), manaProvider.getMaxMana(), graphics, baseX, textY, color, alignment);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        if (EditModeManager.isEditModeEnabled()) {
            DraggableElement currentBarType = DraggableElement.MANA_BAR;
            if (EditModeManager.getFocusedElement() == currentBarType) {
                int focusedBorderColor = -1593835776;
                ScreenRect bgRect = ManaBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                if (ModConfigManager.getClient().enableManaBackground) {
                    graphics.method_49601(bgRect.x() - 1, bgRect.y() - 1, bgRect.width() + 2, bgRect.height() + 2, focusedBorderColor);
                }
                ScreenRect barRectOutline = ManaBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                graphics.method_49601(barRectOutline.x() - 1, barRectOutline.y() - 1, barRectOutline.width() + 2, barRectOutline.height() + 2, -1610547201);
                if (ModConfigManager.getClient().enableManaForeground) {
                    ScreenRect fgRect = ManaBarRenderer.getSubElementRect(SubElementType.FOREGROUND_DETAIL, player);
                    graphics.method_49601(fgRect.x() - 1, fgRect.y() - 1, fgRect.width() + 2, fgRect.height() + 2, -1593900801);
                }
                graphics.method_49601(complexRect.x() - 2, complexRect.y() - 2, complexRect.width() + 4, complexRect.height() + 4, -2130706433);
            } else {
                int borderColor = -2130706433;
                graphics.method_49601(complexRect.x() - 1, complexRect.y() - 1, complexRect.width() + 2, complexRect.height() + 2, borderColor);
            }
        }
    }

    private static float getCurrentAlpha() {
        if (barSetVisible) {
            return 1.0f;
        }
        long timeSinceHide = System.currentTimeMillis() - barDisabledStartTime;
        return Math.max(0.0f, 1.0f - (float)timeSinceHide / 1500.0f);
    }

    public static void setBarVisibility(boolean visible) {
        if (barSetVisible != visible) {
            if (visible) {
                barEnabledStartTime = System.currentTimeMillis();
            } else {
                barDisabledStartTime = System.currentTimeMillis();
            }
            barSetVisible = visible;
        }
    }

    private static void renderManaBar(class_332 graphics, ManaProvider manaProvider, int animOffset, ScreenRect barAreaRect, boolean isRightAnchored) {
        float maxManaTotal = manaProvider.getMaxMana() * (1.0f + manaProvider.getReservedMana());
        if (maxManaTotal <= 0.0f) {
            maxManaTotal = 1.0f;
        }
        double currentMana = manaProvider.getCurrentMana();
        int totalBarWidth = barAreaRect.width();
        int barHeight = barAreaRect.height();
        FillDirection fillDirection = ModConfigManager.getClient().manaFillDirection;
        if (fillDirection == FillDirection.VERTICAL) {
            int filledHeight = (int)((double)barHeight * (currentMana / (double)maxManaTotal));
            if (filledHeight <= 0 && currentMana > 0.0) {
                filledHeight = 1;
            }
            if (filledHeight > barHeight) {
                filledHeight = barHeight;
            }
            int barX = barAreaRect.x();
            int barY = barAreaRect.y() + (barHeight - filledHeight);
            int textureVOffset = animOffset + (barHeight - filledHeight);
            if (filledHeight > 0) {
                graphics.method_25290(DynamicResourceBars.loc("textures/gui/mana_bar.png"), barX, barY, 0.0f, (float)textureVOffset, totalBarWidth, filledHeight, 256, 1024);
            }
        } else {
            int filledWidth = (int)((double)totalBarWidth * (currentMana / (double)maxManaTotal));
            if (filledWidth <= 0 && currentMana > 0.0) {
                filledWidth = 1;
            }
            if (filledWidth > totalBarWidth) {
                filledWidth = totalBarWidth;
            }
            int barX = barAreaRect.x();
            int barY = barAreaRect.y();
            int uTexOffset = 0;
            if (isRightAnchored) {
                barX = barAreaRect.x() + totalBarWidth - filledWidth;
                uTexOffset = totalBarWidth - filledWidth;
            }
            if (uTexOffset < 0) {
                uTexOffset = 0;
            }
            if (filledWidth > 0) {
                graphics.method_25290(DynamicResourceBars.loc("textures/gui/mana_bar.png"), barX, barY, (float)uTexOffset, (float)animOffset, filledWidth, barHeight, 256, 1024);
            }
        }
    }

    private static void renderReservedOverlay(class_332 graphics, ManaProvider manaProvider, int animOffset, ScreenRect barAreaRect) {
        float reservedManaFraction = manaProvider.getReservedMana();
        if (reservedManaFraction <= 0.0f) {
            return;
        }
        float maxManaWithoutReserved = manaProvider.getMaxMana();
        if (maxManaWithoutReserved <= 0.0f) {
            maxManaWithoutReserved = 1.0f;
        }
        float maxManaTotal = maxManaWithoutReserved * (1.0f + reservedManaFraction);
        int totalBarWidth = barAreaRect.width();
        int barHeight = barAreaRect.height();
        int reserveManaPixelWidth = (int)((float)totalBarWidth * (reservedManaFraction / (1.0f + reservedManaFraction)));
        if (reserveManaPixelWidth <= 0) {
            return;
        }
        int reserveStartX = barAreaRect.x() + totalBarWidth - reserveManaPixelWidth;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)0.13725491f, (float)0.13725491f, (float)0.13725491f, (float)1.0f);
        graphics.method_25290(DynamicResourceBars.loc("textures/gui/mana_bar.png"), reserveStartX, barAreaRect.y(), 0.0f, (float)animOffset, reserveManaPixelWidth, barHeight, 256, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public static boolean isVisible() {
        return barSetVisible || System.currentTimeMillis() - barDisabledStartTime <= 1500L;
    }

    private static int getManaTextColor(double currentMana, float maxMana, float barRenderAlpha) {
        TextBehavior textBehavior = ModConfigManager.getClient().showManaText;
        ClientConfig config = ModConfigManager.getClient();
        int baseColor = config.manaTextColor & 0xFFFFFF;
        int alpha = config.manaTextOpacity;
        if (textBehavior == TextBehavior.WHEN_NOT_FULL && currentMana >= (double)maxMana) {
            long timeSinceFull = class_310.method_1551().field_1687.method_8510() - fullManaStartTime;
            float textOwnFadeMultiplier = (float)RenderUtil.calculateTextAlpha(timeSinceFull) / 200.0f;
            alpha = (int)((float)alpha * textOwnFadeMultiplier);
        }
        alpha = (int)((float)alpha * barRenderAlpha);
        alpha = Math.min(255, Math.max(0, alpha));
        return alpha << 24 | baseColor;
    }

    private static int getManaTextColor(double currentMana, float maxMana) {
        return ManaBarRenderer.getManaTextColor(currentMana, maxMana, ManaBarRenderer.getCurrentAlpha());
    }

    private static boolean shouldRenderManaText(double currentMana, float maxMana) {
        boolean isFull;
        TextBehavior behavior = ModConfigManager.getClient().showManaText;
        if (EditModeManager.isEditModeEnabled() && (behavior == TextBehavior.ALWAYS || behavior == TextBehavior.WHEN_NOT_FULL)) {
            return true;
        }
        if (behavior == TextBehavior.NEVER) {
            return false;
        }
        if (behavior == TextBehavior.ALWAYS) {
            return true;
        }
        boolean bl = isFull = currentMana >= (double)maxMana;
        if (isFull) {
            if (lastMana < maxMana || lastMana == -1.0f) {
                fullManaStartTime = class_310.method_1551().field_1687.method_8510();
            }
            lastMana = (float)currentMana;
            return class_310.method_1551().field_1687.method_8510() - fullManaStartTime < 2000L;
        }
        lastMana = (float)currentMana;
        return true;
    }

    private static void updateChunkTracking(class_1657 player, ManaProvider manaProvider, float partialTicks) {
        double currentMana = manaProvider.getCurrentMana();
        float maxMana = manaProvider.getMaxMana();
        Iterator<FadingChunk> it = fadingChunks.iterator();
        while (it.hasNext()) {
            FadingChunk chunk = it.next();
            if (!chunk.isExpired() && !(currentMana >= chunk.endValue)) continue;
            it.remove();
        }
        if (previousMana > 0.0 && currentMana < previousMana && previousMaxMana == maxMana) {
            int animationCycles = ModConfigManager.getClient().manaBarAnimationCycles;
            int frameHeight = ModConfigManager.getClient().manaBarFrameHeight;
            int animOffset = (int)(((float)player.field_6012 + partialTicks) / 3.0f % (float)animationCycles) * frameHeight;
            double chunkStart = Math.max(0.0, currentMana);
            fadingChunks.add(new FadingChunk(chunkStart, previousMana, maxMana, animOffset));
        }
        previousMana = currentMana;
        previousMaxMana = maxMana;
    }

    private static void renderFadingChunks(class_332 graphics, ScreenRect barRect, ManaProvider manaProvider, boolean isRightAnchored, float parentAlpha) {
        if (fadingChunks.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        FillDirection fillDirection = ModConfigManager.getClient().manaFillDirection;
        float maxManaTotal = manaProvider.getMaxMana() * (1.0f + manaProvider.getReservedMana());
        for (FadingChunk chunk : fadingChunks) {
            int uOffset;
            int xPos;
            float endRatio;
            float startRatio;
            float alpha = chunk.getAlpha() * parentAlpha;
            if (alpha <= 0.0f) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            float effectiveMaxForChunk = chunk.maxValue * (1.0f + manaProvider.getReservedMana());
            if (fillDirection == FillDirection.VERTICAL) {
                startRatio = (float)(chunk.startValue / (double)effectiveMaxForChunk);
                endRatio = (float)(chunk.endValue / (double)effectiveMaxForChunk);
                int startHeight = (int)((float)barRect.height() * startRatio);
                int endHeight = (int)((float)barRect.height() * endRatio);
                int chunkHeight = endHeight - startHeight;
                if (chunkHeight <= 0) continue;
                int yPos = barRect.y() + (barRect.height() - endHeight);
                int textureVOffset = chunk.animOffset + (barRect.height() - endHeight);
                graphics.method_25290(DynamicResourceBars.loc("textures/gui/mana_bar.png"), barRect.x(), yPos, 0.0f, (float)textureVOffset, barRect.width(), chunkHeight, 256, 1024);
                continue;
            }
            startRatio = (float)(chunk.startValue / (double)effectiveMaxForChunk);
            endRatio = (float)(chunk.endValue / (double)effectiveMaxForChunk);
            int startWidth = (int)((float)barRect.width() * startRatio);
            int endWidth = (int)((float)barRect.width() * endRatio);
            int chunkWidth = endWidth - startWidth;
            if (chunkWidth <= 0) continue;
            if (isRightAnchored) {
                xPos = barRect.x() + barRect.width() - endWidth;
                uOffset = barRect.width() - endWidth;
            } else {
                xPos = barRect.x() + startWidth;
                uOffset = startWidth;
            }
            graphics.method_25290(DynamicResourceBars.loc("textures/gui/mana_bar.png"), xPos, barRect.y(), (float)uOffset, (float)chunk.animOffset, chunkWidth, barRect.height(), 256, 1024);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static class FadingChunk {
        final double startValue;
        final double endValue;
        final float maxValue;
        final long creationTime;
        final int animOffset;

        FadingChunk(double startValue, double endValue, float maxValue, int animOffset) {
            this.startValue = startValue;
            this.endValue = endValue;
            this.maxValue = maxValue;
            this.creationTime = System.currentTimeMillis();
            this.animOffset = animOffset;
        }

        float getAlpha() {
            long elapsed = System.currentTimeMillis() - this.creationTime;
            if (elapsed >= 500L) {
                return 0.0f;
            }
            return 1.0f - (float)elapsed / 500.0f;
        }

        boolean isExpired() {
            return this.getAlpha() <= 0.0f;
        }
    }
}

