/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.muon.dynamic_resource_bars.DynamicResourceBars;
import dev.muon.dynamic_resource_bars.compat.AppleSkinCompat;
import dev.muon.dynamic_resource_bars.config.ClientConfig;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.util.DraggableElement;
import dev.muon.dynamic_resource_bars.util.EditModeManager;
import dev.muon.dynamic_resource_bars.util.FillDirection;
import dev.muon.dynamic_resource_bars.util.HUDPositioning;
import dev.muon.dynamic_resource_bars.util.HorizontalAlignment;
import dev.muon.dynamic_resource_bars.util.PlatformUtil;
import dev.muon.dynamic_resource_bars.util.Position;
import dev.muon.dynamic_resource_bars.util.RenderUtil;
import dev.muon.dynamic_resource_bars.util.ScreenRect;
import dev.muon.dynamic_resource_bars.util.SubElementType;
import dev.muon.dynamic_resource_bars.util.TextBehavior;
import dev.muon.dynamic_resource_bars.util.TickHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_6880;
import net.minecraft.class_9779;
import vectorwing.farmersdelight.common.registry.ModEffects;

public class HealthBarRenderer {
    private static float lastHealth = -1.0f;
    private static long fullHealthStartTime = 0L;
    private static boolean healthBarSetVisible = true;
    private static long healthBarDisabledStartTime = 0L;
    private static final long CHUNK_FADEOUT_DURATION = 500L;
    private static final List<FadingChunk> fadingChunks = new ArrayList<FadingChunk>();
    private static float previousHealth = -1.0f;
    private static float previousMaxHealth = -1.0f;

    public static ScreenRect getScreenRect(class_1657 player) {
        if (player == null) {
            return new ScreenRect(0, 0, 0, 0);
        }
        Position healthPos = HUDPositioning.getPositionFromAnchor(ModConfigManager.getClient().healthBarAnchor).offset(ModConfigManager.getClient().healthTotalXOffset, ModConfigManager.getClient().healthTotalYOffset);
        int backgroundWidth = ModConfigManager.getClient().healthBackgroundWidth;
        int backgroundHeight = ModConfigManager.getClient().healthBackgroundHeight;
        return new ScreenRect(healthPos.x(), healthPos.y(), backgroundWidth, backgroundHeight);
    }

    public static ScreenRect getSubElementRect(SubElementType type, class_1657 player) {
        ScreenRect complexRect = HealthBarRenderer.getScreenRect(player);
        if (complexRect == null || complexRect.width() == 0 && complexRect.height() == 0) {
            return new ScreenRect(0, 0, 0, 0);
        }
        int x = complexRect.x();
        int y = complexRect.y();
        switch (type) {
            case BACKGROUND: {
                return new ScreenRect(x + ModConfigManager.getClient().healthBackgroundXOffset, y + ModConfigManager.getClient().healthBackgroundYOffset, ModConfigManager.getClient().healthBackgroundWidth, ModConfigManager.getClient().healthBackgroundHeight);
            }
            case BAR_MAIN: {
                return new ScreenRect(x + ModConfigManager.getClient().healthBarXOffset, y + ModConfigManager.getClient().healthBarYOffset, ModConfigManager.getClient().healthBarWidth, ModConfigManager.getClient().healthBarHeight);
            }
            case FOREGROUND_DETAIL: {
                return new ScreenRect(x + ModConfigManager.getClient().healthOverlayXOffset, y + ModConfigManager.getClient().healthOverlayYOffset, ModConfigManager.getClient().healthOverlayWidth, ModConfigManager.getClient().healthOverlayHeight);
            }
            case TEXT: {
                return new ScreenRect(x + ModConfigManager.getClient().healthTextXOffset, y + ModConfigManager.getClient().healthTextYOffset, ModConfigManager.getClient().healthBarWidth, ModConfigManager.getClient().healthBarHeight);
            }
            case ABSORPTION_TEXT: {
                return new ScreenRect(x + ModConfigManager.getClient().healthAbsorptionTextXOffset, y + ModConfigManager.getClient().healthAbsorptionTextYOffset, 50, ModConfigManager.getClient().healthBarHeight);
            }
        }
        return new ScreenRect(0, 0, 0, 0);
    }

    public static void render(class_332 graphics, class_1657 player, float maxHealth, float actualHealth, int absorptionAmount, class_9779 deltaTracker) {
        class_1799 heldFood;
        HealthBarRenderer.updateChunkTracking(player, actualHealth, maxHealth, deltaTracker.method_60636());
        boolean shouldFade = ModConfigManager.getClient().fadeHealthWhenFull && actualHealth >= maxHealth && absorptionAmount == 0;
        HealthBarRenderer.setHealthBarVisibility(!shouldFade || EditModeManager.isEditModeEnabled());
        if (!HealthBarRenderer.isHealthBarVisible() && !EditModeManager.isEditModeEnabled() && System.currentTimeMillis() - healthBarDisabledStartTime > 1500L) {
            return;
        }
        if (!class_310.method_1551().field_1761.method_2908() && !EditModeManager.isEditModeEnabled()) {
            return;
        }
        float currentAlphaForRender = HealthBarRenderer.getHealthBarAlpha();
        if (EditModeManager.isEditModeEnabled() && !HealthBarRenderer.isHealthBarVisible()) {
            currentAlphaForRender = 1.0f;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)currentAlphaForRender);
        ScreenRect complexRect = HealthBarRenderer.getScreenRect(player);
        int xPos = complexRect.x();
        int yPos = complexRect.y();
        int backgroundWidth = ModConfigManager.getClient().healthBackgroundWidth;
        int backgroundHeight = ModConfigManager.getClient().healthBackgroundHeight;
        int animationCycles = ModConfigManager.getClient().healthBarAnimationCycles;
        int frameHeight = ModConfigManager.getClient().healthBarFrameHeight;
        if (ModConfigManager.getClient().enableHealthBackground) {
            ScreenRect bgRect = HealthBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
            graphics.method_25290(DynamicResourceBars.loc("textures/gui/health_background.png"), bgRect.x(), bgRect.y(), 0.0f, 0.0f, bgRect.width(), bgRect.height(), 256, 256);
        }
        int animOffset = (int)(((float)player.field_6012 + deltaTracker.method_60636()) / 3.0f % (float)animationCycles) * frameHeight;
        ScreenRect mainBarRect = HealthBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
        boolean isRightAnchored = ModConfigManager.getClient().healthBarAnchor.getSide() == HUDPositioning.AnchorSide.RIGHT;
        HealthBarRenderer.renderBaseBar(graphics, player, maxHealth, actualHealth, mainBarRect.x(), mainBarRect.y(), mainBarRect.width(), mainBarRect.height(), 0, 0, animOffset, isRightAnchored);
        HealthBarRenderer.renderFadingChunks(graphics, mainBarRect, actualHealth, maxHealth, isRightAnchored, currentAlphaForRender);
        if (PlatformUtil.isModLoaded("appleskin") && !(heldFood = HealthBarRenderer.getHeldFood(player)).method_7960()) {
            HealthBarRenderer.renderHealthRestoredOverlay(graphics, player, heldFood, actualHealth, maxHealth, mainBarRect, animOffset, isRightAnchored);
        }
        HealthBarRenderer.renderBarOverlays(graphics, player, absorptionAmount, mainBarRect.x(), mainBarRect.y(), mainBarRect.width(), mainBarRect.height(), 0, 0);
        HealthBarRenderer.renderBackgroundOverlays(graphics, player, xPos, yPos, backgroundWidth, backgroundHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (HealthBarRenderer.shouldRenderHealthText(actualHealth, maxHealth, player)) {
            ScreenRect textRect = HealthBarRenderer.getSubElementRect(SubElementType.TEXT, player);
            int textX = textRect.x() + textRect.width() / 2;
            int textY = textRect.y() + textRect.height() / 2;
            int color = HealthBarRenderer.getHealthTextColor(actualHealth, maxHealth);
            HorizontalAlignment alignment = ModConfigManager.getClient().healthTextAlign;
            int baseX = textRect.x();
            if (alignment == HorizontalAlignment.CENTER) {
                baseX = textX;
            } else if (alignment == HorizontalAlignment.RIGHT) {
                baseX = textRect.x() + textRect.width();
            }
            RenderUtil.renderText(actualHealth, maxHealth, graphics, baseX, textY, color, alignment);
        }
        if (absorptionAmount > 0 || EditModeManager.isEditModeEnabled()) {
            String absorptionText = "+" + String.valueOf(EditModeManager.isEditModeEnabled() && absorptionAmount == 0 ? "8" : Integer.valueOf(absorptionAmount));
            ScreenRect absorptionRect = HealthBarRenderer.getSubElementRect(SubElementType.ABSORPTION_TEXT, player);
            int absorptionTextX = absorptionRect.x();
            int absorptionTextY = absorptionRect.y() + absorptionRect.height() / 2;
            ClientConfig config = ModConfigManager.getClient();
            int baseAbsorptionColor = config.healthTextColor & 0xFFFFFF;
            int absorptionAlpha = (int)((float)config.healthTextOpacity * currentAlphaForRender);
            absorptionAlpha = Math.max(10, Math.min(255, absorptionAlpha));
            int absorptionFinalColor = absorptionAlpha << 24 | baseAbsorptionColor;
            RenderUtil.renderAdditionText(absorptionText, graphics, absorptionTextX, absorptionTextY, absorptionFinalColor);
        }
        if (EditModeManager.isEditModeEnabled()) {
            DraggableElement currentBarType = DraggableElement.HEALTH_BAR;
            if (EditModeManager.getFocusedElement() == currentBarType) {
                ScreenRect absorptionRect;
                int focusedBorderColor = -1593835776;
                ScreenRect bgRect = HealthBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                graphics.method_49601(bgRect.x() - 1, bgRect.y() - 1, bgRect.width() + 2, bgRect.height() + 2, focusedBorderColor);
                ScreenRect barRect = HealthBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                graphics.method_49601(barRect.x() - 1, barRect.y() - 1, barRect.width() + 2, barRect.height() + 2, -1610547456);
                if (ModConfigManager.getClient().enableHealthForeground) {
                    ScreenRect fgRect = HealthBarRenderer.getSubElementRect(SubElementType.FOREGROUND_DETAIL, player);
                    graphics.method_49601(fgRect.x() - 1, fgRect.y() - 1, fgRect.width() + 2, fgRect.height() + 2, -1593900801);
                }
                if ((absorptionRect = HealthBarRenderer.getSubElementRect(SubElementType.ABSORPTION_TEXT, player)) != null && absorptionRect.width() > 0 && absorptionRect.height() > 0) {
                    graphics.method_49601(absorptionRect.x() - 1, absorptionRect.y() - 1, absorptionRect.width() + 2, absorptionRect.height() + 2, 0x60FFFFFF);
                }
                graphics.method_49601(complexRect.x() - 2, complexRect.y() - 2, complexRect.width() + 4, complexRect.height() + 4, -2130706433);
            } else {
                int borderColor = -2130706433;
                graphics.method_49601(complexRect.x() - 1, complexRect.y() - 1, complexRect.width() + 2, complexRect.height() + 2, borderColor);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void updateChunkTracking(class_1657 player, float currentHealth, float maxHealth, float partialTicks) {
        Iterator<FadingChunk> it = fadingChunks.iterator();
        while (it.hasNext()) {
            FadingChunk chunk = it.next();
            if (!chunk.isExpired() && !(currentHealth >= chunk.endValue)) continue;
            it.remove();
        }
        if (previousHealth > 0.0f && currentHealth < previousHealth && previousMaxHealth == maxHealth) {
            BarType barType = BarType.fromPlayerState(player);
            String texture = barType.getTexture();
            int animationCycles = ModConfigManager.getClient().healthBarAnimationCycles;
            int frameHeight = ModConfigManager.getClient().healthBarFrameHeight;
            int animOffset = (int)(((float)player.field_6012 + partialTicks) / 3.0f % (float)animationCycles) * frameHeight;
            float chunkStart = Math.max(0.0f, currentHealth);
            fadingChunks.add(new FadingChunk(chunkStart, previousHealth, maxHealth, texture, animOffset));
        }
        previousHealth = currentHealth;
        previousMaxHealth = maxHealth;
    }

    private static void renderFadingChunks(class_332 graphics, ScreenRect barRect, float currentHealth, float maxHealth, boolean isRightAnchored, float parentAlpha) {
        if (fadingChunks.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        FillDirection fillDirection = ModConfigManager.getClient().healthFillDirection;
        for (FadingChunk chunk : fadingChunks) {
            int uOffset;
            int xPos;
            float endRatio;
            float startRatio;
            float alpha = chunk.getAlpha() * parentAlpha;
            if (alpha <= 0.0f) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            if (fillDirection == FillDirection.VERTICAL) {
                startRatio = chunk.startValue / chunk.maxValue;
                endRatio = chunk.endValue / chunk.maxValue;
                int startHeight = (int)((float)barRect.height() * startRatio);
                int endHeight = (int)((float)barRect.height() * endRatio);
                int chunkHeight = endHeight - startHeight;
                if (chunkHeight <= 0) continue;
                int yPos = barRect.y() + (barRect.height() - endHeight);
                int textureVOffset = chunk.animOffset + (barRect.height() - endHeight);
                graphics.method_25290(DynamicResourceBars.loc("textures/gui/" + chunk.texture + ".png"), barRect.x(), yPos, 0.0f, (float)textureVOffset, barRect.width(), chunkHeight, 256, 1024);
                continue;
            }
            startRatio = chunk.startValue / chunk.maxValue;
            endRatio = chunk.endValue / chunk.maxValue;
            int startWidth = (int)((float)barRect.width() * startRatio);
            int endWidth = (int)((float)barRect.width() * endRatio);
            int chunkWidth = endWidth - startWidth;
            if (chunkWidth <= 0) continue;
            if (isRightAnchored) {
                xPos = barRect.x() + barRect.width() - endWidth;
                uOffset = barRect.width() - endWidth;
            } else {
                xPos = barRect.x() + startWidth;
                uOffset = startWidth;
            }
            graphics.method_25290(DynamicResourceBars.loc("textures/gui/" + chunk.texture + ".png"), xPos, barRect.y(), (float)uOffset, (float)chunk.animOffset, chunkWidth, barRect.height(), 256, 1024);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static void renderBaseBar(class_332 graphics, class_1657 player, float maxHealth, float actualHealth, int barAbsX, int barAbsY, int barAbsWidth, int barAbsHeight, int barXOffsetWithinTexture, int barYOffsetWithinTexture, int animOffset, boolean isRightAnchored) {
        BarType barType = BarType.fromPlayerState(player);
        float currentHealthRatio = maxHealth == 0.0f ? 0.0f : actualHealth / maxHealth;
        FillDirection fillDirection = ModConfigManager.getClient().healthFillDirection;
        if (fillDirection == FillDirection.VERTICAL) {
            int partialBarHeight = (int)((float)barAbsHeight * currentHealthRatio);
            if (partialBarHeight <= 0 && actualHealth > 0.0f) {
                partialBarHeight = 1;
            }
            if (partialBarHeight > 0) {
                graphics.method_25290(DynamicResourceBars.loc("textures/gui/" + barType.getTexture() + ".png"), barAbsX, barAbsY + (barAbsHeight - partialBarHeight), (float)barXOffsetWithinTexture, (float)(animOffset + barYOffsetWithinTexture + (barAbsHeight - partialBarHeight)), barAbsWidth, partialBarHeight, 256, 1024);
            }
        } else {
            int partialBarWidth = (int)((float)barAbsWidth * currentHealthRatio);
            if (partialBarWidth <= 0 && actualHealth > 0.0f) {
                partialBarWidth = 1;
            }
            if (partialBarWidth > 0) {
                int renderBarX = barAbsX;
                int uTexOffset = barXOffsetWithinTexture;
                if (isRightAnchored) {
                    renderBarX = barAbsX + barAbsWidth - partialBarWidth;
                    uTexOffset = barXOffsetWithinTexture + barAbsWidth - partialBarWidth;
                }
                graphics.method_25290(DynamicResourceBars.loc("textures/gui/" + barType.getTexture() + ".png"), renderBarX, barAbsY, (float)uTexOffset, (float)(animOffset + barYOffsetWithinTexture), partialBarWidth, barAbsHeight, 256, 1024);
            }
        }
    }

    private static void renderBarOverlays(class_332 graphics, class_1657 player, int absorptionAmount, int barAbsX, int barAbsY, int barAbsWidth, int barAbsHeight, int barXOffset, int barYOffset) {
        float pulseAlpha;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float tempScale = HealthBarRenderer.getTemperatureScale(player);
        HealthBarRenderer.renderTemperatureOverlay(graphics, tempScale, barAbsX + barXOffset, barAbsY + barYOffset, barAbsWidth, barAbsHeight, 0, 0);
        if (absorptionAmount > 0) {
            pulseAlpha = 0.5f + TickHandler.getOverlayFlashAlpha() * 0.5f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)pulseAlpha);
            graphics.method_25290(DynamicResourceBars.loc("textures/gui/absorption_overlay.png"), barAbsX + barXOffset, barAbsY + barYOffset, 0.0f, 0.0f, barAbsWidth, barAbsHeight, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (PlatformUtil.isModLoaded("farmersdelight") && HealthBarRenderer.hasComfortEffect(player) && player.method_7344().method_7589() == 0.0f && player.method_7317() && !player.method_6059(class_1294.field_5924)) {
            pulseAlpha = TickHandler.getOverlayFlashAlpha();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)pulseAlpha);
            graphics.method_25290(DynamicResourceBars.loc("textures/gui/comfort_overlay.png"), barAbsX + barXOffset, barAbsY + barYOffset, 0.0f, 0.0f, barAbsWidth, barAbsHeight, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (player.method_6059(class_1294.field_5924)) {
            pulseAlpha = TickHandler.getOverlayFlashAlpha();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)pulseAlpha);
            graphics.method_25290(DynamicResourceBars.loc("textures/gui/regeneration_overlay.png"), barAbsX + barXOffset, barAbsY + barYOffset, 0.0f, 0.0f, barAbsWidth, barAbsHeight, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.disableBlend();
    }

    private static void renderBackgroundOverlays(class_332 graphics, class_1657 player, int complexX, int complexY, int backgroundWidth, int backgroundHeight) {
        float wetScale;
        if (player.method_37908().method_8401().method_152()) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            graphics.method_25290(DynamicResourceBars.loc("textures/gui/hardcore_overlay.png"), complexX, complexY, 0.0f, 0.0f, backgroundWidth, backgroundHeight, 256, 256);
            RenderSystem.disableBlend();
        }
        if ((wetScale = HealthBarRenderer.getWetnessScale(player)) > 0.0f) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)wetScale);
            graphics.method_25290(DynamicResourceBars.loc("textures/gui/wetness_overlay.png"), complexX, complexY, 0.0f, 0.0f, backgroundWidth, backgroundHeight, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
        if (ModConfigManager.getClient().enableHealthForeground) {
            ScreenRect fgRect = HealthBarRenderer.getSubElementRect(SubElementType.FOREGROUND_DETAIL, player);
            graphics.method_25290(DynamicResourceBars.loc("textures/gui/health_foreground.png"), fgRect.x(), fgRect.y(), 0.0f, 0.0f, fgRect.width(), fgRect.height(), 256, 256);
        }
    }

    private static void renderTemperatureOverlay(class_332 graphics, float tempScale, int xPos, int yPos, int barWidth, int barHeight, int barXOffset, int barYOffset) {
        if (tempScale > 0.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)HealthBarRenderer.getHealthBarAlpha());
            int heatWidth = (int)((float)barWidth * tempScale);
            graphics.method_25290(DynamicResourceBars.loc("textures/gui/heat_overlay.png"), xPos + barXOffset, yPos + barYOffset, 0.0f, 0.0f, heatWidth, barHeight, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else if (tempScale < 0.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)HealthBarRenderer.getHealthBarAlpha());
            int coldWidth = (int)((float)barWidth * -tempScale);
            graphics.method_25290(DynamicResourceBars.loc("textures/gui/cold_overlay.png"), xPos + barXOffset, yPos + barYOffset, 0.0f, 0.0f, coldWidth, barHeight, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static float getWetnessScale(class_1657 player) {
        if (PlatformUtil.isModLoaded("thermoo")) {
            try {
                Method getWetScale = player.getClass().getMethod("thermoo$getSoakedScale", new Class[0]);
                return ((Float)getWetScale.invoke((Object)player, new Object[0])).floatValue();
            }
            catch (Exception e) {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    private static boolean isScorched(class_1657 player) {
        if (PlatformUtil.isModLoaded("thermoo")) {
            try {
                Method getMaxTemp = player.getClass().getMethod("thermoo$getMaxTemperature", new Class[0]);
                Method getTemp = player.getClass().getMethod("thermoo$getTemperature", new Class[0]);
                int maxTemperature = (Integer)getMaxTemp.invoke((Object)player, new Object[0]);
                int temperature = (Integer)getTemp.invoke((Object)player, new Object[0]);
                return (double)temperature > 0.5 && temperature >= maxTemperature - 1;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private static boolean isFrozen(class_1657 player) {
        if (player.method_32314()) {
            return true;
        }
        if (PlatformUtil.isModLoaded("thermoo")) {
            try {
                Method getTemp = player.getClass().getMethod("thermoo$getTemperature", new Class[0]);
                Method getTempScale = player.getClass().getMethod("thermoo$getTemperatureScale", new Class[0]);
                int minTemperature = (Integer)getTemp.invoke((Object)player, new Object[0]);
                if (minTemperature < 0) {
                    float tempScale = ((Float)getTempScale.invoke((Object)player, new Object[0])).floatValue();
                    return tempScale <= -0.99f;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static float getTemperatureScale(class_1657 player) {
        try {
            Method getTempScale = player.getClass().getMethod("thermoo$getTemperatureScale", new Class[0]);
            return ((Float)getTempScale.invoke((Object)player, new Object[0])).floatValue();
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    private static int getHealthTextColor(float currentHealth, float maxHealth) {
        TextBehavior behavior = ModConfigManager.getClient().showHealthText;
        ClientConfig config = ModConfigManager.getClient();
        int baseColor = config.healthTextColor & 0xFFFFFF;
        int alpha = config.healthTextOpacity;
        if (behavior == TextBehavior.WHEN_NOT_FULL && currentHealth >= maxHealth) {
            long timeSinceFull = System.currentTimeMillis() - fullHealthStartTime;
            alpha = (int)((float)alpha * ((float)RenderUtil.calculateTextAlpha(timeSinceFull) / 200.0f));
        }
        alpha = (int)((float)alpha * HealthBarRenderer.getHealthBarAlpha());
        alpha = Math.max(10, Math.min(255, alpha));
        return alpha << 24 | baseColor;
    }

    private static boolean shouldRenderHealthText(float currentHealth, float maxHealth, class_1657 player) {
        boolean isFull;
        TextBehavior behavior = ModConfigManager.getClient().showHealthText;
        if (EditModeManager.isEditModeEnabled() && (behavior == TextBehavior.ALWAYS || behavior == TextBehavior.WHEN_NOT_FULL)) {
            return true;
        }
        if (behavior == TextBehavior.NEVER) {
            return false;
        }
        if (behavior == TextBehavior.ALWAYS) {
            return true;
        }
        boolean bl = isFull = currentHealth >= maxHealth;
        if (isFull) {
            if (lastHealth < maxHealth || lastHealth == -1.0f) {
                fullHealthStartTime = System.currentTimeMillis();
            }
            lastHealth = currentHealth;
            return System.currentTimeMillis() - fullHealthStartTime < 2000L;
        }
        lastHealth = currentHealth;
        return true;
    }

    private static void setHealthBarVisibility(boolean visible) {
        if (healthBarSetVisible != visible) {
            if (!visible) {
                healthBarDisabledStartTime = System.currentTimeMillis();
            }
            healthBarSetVisible = visible;
        }
    }

    private static boolean isHealthBarVisible() {
        return healthBarSetVisible;
    }

    private static float getHealthBarAlpha() {
        if (HealthBarRenderer.isHealthBarVisible()) {
            return 1.0f;
        }
        long timeSinceDisabled = System.currentTimeMillis() - healthBarDisabledStartTime;
        if (timeSinceDisabled >= 1500L) {
            return 0.0f;
        }
        return Math.max(0.0f, 1.0f - (float)timeSinceDisabled / 1500.0f);
    }

    private static class_1799 getHeldFood(class_1657 player) {
        class_1799 mainHand = player.method_5998(class_1268.field_5808);
        if (AppleSkinCompat.canConsume(mainHand, player)) {
            return mainHand;
        }
        class_1799 offHand = player.method_5998(class_1268.field_5810);
        if (AppleSkinCompat.canConsume(offHand, player)) {
            return offHand;
        }
        return class_1799.field_8037;
    }

    private static void renderHealthRestoredOverlay(class_332 graphics, class_1657 player, class_1799 heldFood, float currentHealth, float maxHealth, ScreenRect barRect, int animOffset, boolean isRightAnchored) {
        if (!PlatformUtil.isModLoaded("appleskin")) {
            return;
        }
        float healthRestoration = AppleSkinCompat.getEstimatedHealthRestoration(heldFood, player);
        if (healthRestoration <= 0.0f || currentHealth >= maxHealth) {
            return;
        }
        float restoredHealth = Math.min(maxHealth, currentHealth + healthRestoration);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)TickHandler.getOverlayFlashAlpha());
        FillDirection fillDirection = ModConfigManager.getClient().healthFillDirection;
        BarType barType = BarType.fromPlayerState(player);
        if (fillDirection == FillDirection.VERTICAL) {
            int currentHeight = (int)((float)barRect.height() * (currentHealth / maxHealth));
            int restoredHeight = (int)((float)barRect.height() * (restoredHealth / maxHealth));
            int overlayHeight = restoredHeight - currentHeight;
            if (overlayHeight > 0) {
                int yPos = barRect.y() + (barRect.height() - restoredHeight);
                int textureVOffset = animOffset + (barRect.height() - restoredHeight);
                graphics.method_25290(DynamicResourceBars.loc("textures/gui/" + barType.getTexture() + ".png"), barRect.x(), yPos, 0.0f, (float)textureVOffset, barRect.width(), overlayHeight, 256, 1024);
            }
        } else {
            int currentWidth = (int)((float)barRect.width() * (currentHealth / maxHealth));
            int restoredWidth = (int)((float)barRect.width() * (restoredHealth / maxHealth));
            int overlayWidth = restoredWidth - currentWidth;
            if (overlayWidth > 0) {
                int uTexOffset;
                int xDrawPos;
                if (isRightAnchored) {
                    xDrawPos = barRect.x() + barRect.width() - restoredWidth;
                    uTexOffset = barRect.width() - restoredWidth;
                } else {
                    xDrawPos = barRect.x() + currentWidth;
                    uTexOffset = currentWidth;
                }
                graphics.method_25290(DynamicResourceBars.loc("textures/gui/" + barType.getTexture() + ".png"), xDrawPos, barRect.y(), (float)uTexOffset, (float)animOffset, overlayWidth, barRect.height(), 256, 1024);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static boolean hasComfortEffect(class_1657 player) {
        class_6880 comfortEffect = ModEffects.COMFORT;
        return player.method_6059(comfortEffect);
    }

    private static class FadingChunk {
        final float startValue;
        final float endValue;
        final float maxValue;
        final long creationTime;
        final String texture;
        final int animOffset;

        FadingChunk(float startValue, float endValue, float maxValue, String texture, int animOffset) {
            this.startValue = startValue;
            this.endValue = endValue;
            this.maxValue = maxValue;
            this.creationTime = System.currentTimeMillis();
            this.texture = texture;
            this.animOffset = animOffset;
        }

        float getAlpha() {
            long elapsed = System.currentTimeMillis() - this.creationTime;
            if (elapsed >= 500L) {
                return 0.0f;
            }
            return 1.0f - (float)elapsed / 500.0f;
        }

        boolean isExpired() {
            return this.getAlpha() <= 0.0f;
        }
    }

    private static enum BarType {
        NORMAL("health_bar"),
        POISON("health_bar_poisoned"),
        WITHER("health_bar_withered"),
        FROZEN("health_bar_frozen"),
        SCORCHED("health_bar_scorched");

        private final String texture;

        private BarType(String texture) {
            this.texture = texture;
        }

        private BarType() {
            this.texture = this.name().toLowerCase();
        }

        public String getTexture() {
            return this.texture;
        }

        public static BarType fromPlayerState(class_1657 player) {
            if (player.method_6059(class_1294.field_5899)) {
                return POISON;
            }
            if (player.method_6059(class_1294.field_5920)) {
                return WITHER;
            }
            if (HealthBarRenderer.isFrozen(player)) {
                return FROZEN;
            }
            if (HealthBarRenderer.isScorched(player)) {
                return SCORCHED;
            }
            return NORMAL;
        }
    }
}

