/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.config.gui;

import dev.muon.dynamic_resource_bars.compat.ManaProviderManager;
import dev.muon.dynamic_resource_bars.compat.StaminaProviderManager;
import dev.muon.dynamic_resource_bars.config.ClientConfig;
import dev.muon.dynamic_resource_bars.config.ModConfigManager;
import dev.muon.dynamic_resource_bars.config.gui.ConfirmResetScreen;
import dev.muon.dynamic_resource_bars.render.AirBarRenderer;
import dev.muon.dynamic_resource_bars.render.ArmorBarRenderer;
import dev.muon.dynamic_resource_bars.render.HealthBarRenderer;
import dev.muon.dynamic_resource_bars.render.ManaBarRenderer;
import dev.muon.dynamic_resource_bars.render.StaminaBarRenderer;
import dev.muon.dynamic_resource_bars.util.BarRenderBehavior;
import dev.muon.dynamic_resource_bars.util.DraggableElement;
import dev.muon.dynamic_resource_bars.util.EditModeManager;
import dev.muon.dynamic_resource_bars.util.FillDirection;
import dev.muon.dynamic_resource_bars.util.HUDPositioning;
import dev.muon.dynamic_resource_bars.util.HorizontalAlignment;
import dev.muon.dynamic_resource_bars.util.ManaBarBehavior;
import dev.muon.dynamic_resource_bars.util.PlatformUtil;
import dev.muon.dynamic_resource_bars.util.Position;
import dev.muon.dynamic_resource_bars.util.ScreenRect;
import dev.muon.dynamic_resource_bars.util.StaminaBarBehavior;
import dev.muon.dynamic_resource_bars.util.SubElementType;
import dev.muon.dynamic_resource_bars.util.TextBehavior;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_7919;

public class HudEditorScreen
extends class_437 {
    private static final int HELP_TEXT_TOP_Y = 15;
    private static final int LINE_SPACING = 2;
    private static final int HANDLE_SIZE = 3;
    private static final int HANDLE_HOVER_COLOR = -1426063616;
    private ResizeMode currentResizeMode = ResizeMode.NONE;
    private int resizeStartX;
    private int resizeStartY;
    private int initialWidth;
    private int initialHeight;
    private SubElementType resizingSubElement = null;
    private DraggableElement focusedElementForResize = null;
    private class_437 previousScreen;
    private long lastClickTime = 0L;
    private double lastClickX = 0.0;
    private double lastClickY = 0.0;
    private static final int DOUBLE_CLICK_TIME_MS = 300;
    private DraggableElement lastDraggedElementForUndo = null;
    private int lastDragInitialXOffset;
    private int lastDragInitialYOffset;
    private boolean canUndoLastDrag = false;
    private DraggableElement lastFocusedElementForSubUndo = null;
    private SubElementType lastDraggedSubElementForUndo = null;
    private int lastSubDragInitialXOffset;
    private int lastSubDragInitialYOffset;
    private boolean canUndoLastSubDrag = false;
    private class_4185 toggleBackgroundButton;
    private class_4185 toggleForegroundButton;
    private class_4185 toggleFadeFullButton;
    private class_4185 cycleTextBehaviorButton;
    private class_4185 cycleTextAlignButton;
    private class_4185 cycleAnchorButton;
    private class_4185 resetPositionButton;
    private class_4185 resetSizeButton;
    private class_4185 cycleFillDirectionButton;
    private class_4185 toggleHealthBarButton;
    private class_4185 toggleStaminaBarButton;
    private class_4185 cycleManaBarBehaviorButton;
    private class_4185 cycleArmorBehaviorButton;
    private class_4185 cycleAirBehaviorButton;
    private class_4185 openHealthSettingsButton;
    private class_4185 openStaminaSettingsButton;
    private class_4185 openManaSettingsButton;
    private class_4185 openArmorSettingsButton;
    private class_4185 openAirSettingsButton;
    private class_4185 resetButtonForAllBars;
    private class_4185 cycleStaminaBarBehaviorButton;

    public HudEditorScreen(class_437 previous) {
        super((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.title"));
        this.previousScreen = previous;
    }

    protected void method_25426() {
        super.method_25426();
        if (!EditModeManager.isEditModeEnabled()) {
            EditModeManager.toggleEditMode();
        }
        this.rebuildEditorWidgets();
        this.canUndoLastDrag = false;
        this.lastDraggedElementForUndo = null;
        this.canUndoLastSubDrag = false;
        this.lastFocusedElementForSubUndo = null;
        this.lastDraggedSubElementForUndo = null;
    }

    private void rebuildEditorWidgets() {
        DraggableElement focused = EditModeManager.getFocusedElement();
        ClientConfig config = ModConfigManager.getClient();
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int fontHeight = 9;
        this.method_37067();
        this.toggleBackgroundButton = null;
        this.toggleForegroundButton = null;
        this.toggleFadeFullButton = null;
        this.cycleTextBehaviorButton = null;
        this.cycleTextAlignButton = null;
        this.cycleAnchorButton = null;
        this.resetPositionButton = null;
        this.resetSizeButton = null;
        this.toggleHealthBarButton = null;
        this.toggleStaminaBarButton = null;
        this.cycleManaBarBehaviorButton = null;
        this.cycleArmorBehaviorButton = null;
        this.cycleAirBehaviorButton = null;
        this.openHealthSettingsButton = null;
        this.openStaminaSettingsButton = null;
        this.openManaSettingsButton = null;
        this.openArmorSettingsButton = null;
        this.openAirSettingsButton = null;
        this.resetButtonForAllBars = null;
        if (focused == null) {
            int twoColStartX;
            int gridButtonHeight = 20;
            int rowSpacing = 5;
            int colSpacing = 5;
            int gridTopY = 40;
            int threeColButtonWidth = 100;
            int threeColContentWidth = 3 * threeColButtonWidth + 2 * colSpacing;
            int threeColStartX = (this.field_22789 - threeColContentWidth) / 2;
            int currentY = gridTopY;
            int currentX = threeColStartX;
            this.toggleHealthBarButton = class_4185.method_46430((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.hud_editor.button.health_toggle_format", (Object[])new Object[]{config.enableHealthBar ? class_2561.method_43471((String)"gui.dynamic_resource_bars.behavior.custom_simple") : class_2561.method_43471((String)"gui.dynamic_resource_bars.behavior.vanilla_simple")}), b -> {
                config.enableHealthBar = !config.enableHealthBar;
                this.rebuildEditorWidgets();
            }).method_46434(currentX, currentY, threeColButtonWidth, gridButtonHeight).method_46431();
            this.method_37063((class_364)this.toggleHealthBarButton);
            boolean hasManaProvider = ManaProviderManager.hasAnyManaMods();
            this.cycleManaBarBehaviorButton = class_4185.method_46430((class_2561)this.getManaBarBehaviorComponent(config.manaBarBehavior), b -> {
                if (b.field_22763) {
                    config.manaBarBehavior = this.getNextAvailableManaBarBehavior(config.manaBarBehavior);
                    ManaProviderManager.updateActiveProvider();
                    this.rebuildEditorWidgets();
                }
            }).method_46434(currentX += threeColButtonWidth + colSpacing, currentY, threeColButtonWidth, gridButtonHeight).method_46431();
            this.cycleManaBarBehaviorButton.field_22763 = hasManaProvider;
            if (!hasManaProvider) {
                this.cycleManaBarBehaviorButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.tooltip.no_mana_provider")));
            }
            this.method_37063((class_364)this.cycleManaBarBehaviorButton);
            this.cycleStaminaBarBehaviorButton = class_4185.method_46430((class_2561)this.getStaminaBarBehaviorComponent(config.staminaBarBehavior), b -> {
                config.staminaBarBehavior = this.getNextAvailableStaminaBarBehavior(config.staminaBarBehavior);
                StaminaProviderManager.updateActiveProvider();
                this.rebuildEditorWidgets();
            }).method_46434(currentX += threeColButtonWidth + colSpacing, currentY, threeColButtonWidth, gridButtonHeight).method_46431();
            this.method_37063((class_364)this.cycleStaminaBarBehaviorButton);
            currentX = threeColStartX;
            this.openHealthSettingsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.button.health_settings"), b -> {
                EditModeManager.setFocusedElement(DraggableElement.HEALTH_BAR);
                this.rebuildEditorWidgets();
            }).method_46434(currentX, currentY += gridButtonHeight + rowSpacing, threeColButtonWidth, gridButtonHeight).method_46431();
            this.openHealthSettingsButton.field_22763 = config.enableHealthBar;
            this.method_37063((class_364)this.openHealthSettingsButton);
            this.openManaSettingsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.button.mana_settings"), b -> {
                if (b.field_22763) {
                    EditModeManager.setFocusedElement(DraggableElement.MANA_BAR);
                    this.rebuildEditorWidgets();
                }
            }).method_46434(currentX += threeColButtonWidth + colSpacing, currentY, threeColButtonWidth, gridButtonHeight).method_46431();
            boolean bl = this.openManaSettingsButton.field_22763 = config.manaBarBehavior != ManaBarBehavior.OFF && hasManaProvider;
            if (!hasManaProvider) {
                this.openManaSettingsButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.tooltip.no_mana_provider")));
            }
            this.method_37063((class_364)this.openManaSettingsButton);
            this.openStaminaSettingsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.button.stamina_settings"), b -> {
                EditModeManager.setFocusedElement(DraggableElement.STAMINA_BAR);
                this.rebuildEditorWidgets();
            }).method_46434(currentX += threeColButtonWidth + colSpacing, currentY, threeColButtonWidth, gridButtonHeight).method_46431();
            this.openStaminaSettingsButton.field_22763 = config.staminaBarBehavior != StaminaBarBehavior.OFF;
            this.method_37063((class_364)this.openStaminaSettingsButton);
            int twoColButtonWidth = 120;
            int twoColContentWidth = 2 * twoColButtonWidth + colSpacing;
            currentX = twoColStartX = (this.field_22789 - twoColContentWidth) / 2;
            this.cycleArmorBehaviorButton = class_4185.method_46430((class_2561)this.getBarBehaviorComponent(config.armorBarBehavior, "armor"), b -> {
                config.armorBarBehavior = this.getNextBarBehavior(config.armorBarBehavior);
                this.rebuildEditorWidgets();
            }).method_46434(currentX, currentY += gridButtonHeight + rowSpacing + 5, twoColButtonWidth, gridButtonHeight).method_46431();
            this.method_37063((class_364)this.cycleArmorBehaviorButton);
            this.cycleAirBehaviorButton = class_4185.method_46430((class_2561)this.getBarBehaviorComponent(config.airBarBehavior, "air"), b -> {
                config.airBarBehavior = this.getNextBarBehavior(config.airBarBehavior);
                this.rebuildEditorWidgets();
            }).method_46434(currentX += twoColButtonWidth + colSpacing, currentY, twoColButtonWidth, gridButtonHeight).method_46431();
            this.method_37063((class_364)this.cycleAirBehaviorButton);
            currentX = twoColStartX;
            this.openArmorSettingsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.button.armor_settings"), b -> {
                if (b.field_22763) {
                    EditModeManager.setFocusedElement(DraggableElement.ARMOR_BAR);
                    this.rebuildEditorWidgets();
                }
            }).method_46434(currentX, currentY += gridButtonHeight + rowSpacing, twoColButtonWidth, gridButtonHeight).method_46431();
            this.openArmorSettingsButton.field_22763 = config.armorBarBehavior == BarRenderBehavior.CUSTOM;
            this.method_37063((class_364)this.openArmorSettingsButton);
            this.openAirSettingsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.button.air_settings"), b -> {
                if (b.field_22763) {
                    EditModeManager.setFocusedElement(DraggableElement.AIR_BAR);
                    this.rebuildEditorWidgets();
                }
            }).method_46434(currentX += twoColButtonWidth + colSpacing, currentY, twoColButtonWidth, gridButtonHeight).method_46431();
            this.openAirSettingsButton.field_22763 = config.airBarBehavior == BarRenderBehavior.CUSTOM;
            this.method_37063((class_364)this.openAirSettingsButton);
            int resetAllButtonWidth = 150;
            this.resetButtonForAllBars = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.button.reset_all_bars"), b -> this.openConfirmScreen((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.confirm.reset_all.title"), (class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.confirm.reset_all.explanation"), this::resetAllDefaultsAction)).method_46434((this.field_22789 - resetAllButtonWidth) / 2, currentY += gridButtonHeight + rowSpacing + 10, resetAllButtonWidth, gridButtonHeight).method_46431();
            this.method_37063((class_364)this.resetButtonForAllBars);
        } else {
            int focusGridStartX;
            Runnable fillDirectionCycler;
            Runnable anchorCycler;
            Runnable textAlignCycler;
            Runnable textCycler;
            Runnable fadeToggler;
            Runnable fgToggler;
            Runnable bgToggler;
            Supplier<Boolean> fadeGetter;
            Supplier<Boolean> fgGetter;
            Supplier<Boolean> bgGetter;
            int focusButtonWidth = 120;
            int focusButtonHeight = 20;
            int focusColSpacing = 5;
            int focusRowSpacing = 5;
            int textBlockHeight = 5 * (fontHeight + 2) + 10;
            int buttonsTopY = 15 + textBlockHeight;
            buttonsTopY = 15 + 4 * (fontHeight + 2) + (fontHeight + 2) + 15;
            boolean fgSupported = false;
            boolean textSupported = false;
            boolean anchorSupported = false;
            boolean fadeSupported = false;
            boolean bgSupported = false;
            boolean fillDirectionSupported = false;
            switch (focused) {
                case HEALTH_BAR: {
                    bgGetter = () -> config.enableHealthBackground;
                    fgGetter = () -> config.enableHealthForeground;
                    fadeGetter = () -> config.fadeHealthWhenFull;
                    bgToggler = () -> {
                        config.enableHealthBackground = !config.enableHealthBackground;
                        this.rebuildEditorWidgets();
                    };
                    fgToggler = () -> {
                        config.enableHealthForeground = !config.enableHealthForeground;
                        this.rebuildEditorWidgets();
                    };
                    fadeToggler = () -> {
                        config.fadeHealthWhenFull = !config.fadeHealthWhenFull;
                        this.rebuildEditorWidgets();
                    };
                    textCycler = () -> {
                        config.showHealthText = this.getNextTextBehavior(config.showHealthText);
                        this.rebuildEditorWidgets();
                    };
                    textAlignCycler = () -> {
                        config.healthTextAlign = this.getNextHorizontalAlignment(config.healthTextAlign);
                        this.rebuildEditorWidgets();
                    };
                    anchorCycler = () -> {
                        HUDPositioning.BarPlacement nextAnchor;
                        config.healthBarAnchor = nextAnchor = this.getNextBarPlacement(config.healthBarAnchor);
                        int bgWidth = config.healthBackgroundWidth;
                        int newDefaultXOffset = 0;
                        if (nextAnchor == HUDPositioning.BarPlacement.ABOVE_UTILITIES) {
                            newDefaultXOffset = -bgWidth / 2;
                        } else if (nextAnchor.getSide() == HUDPositioning.AnchorSide.RIGHT) {
                            newDefaultXOffset = -bgWidth;
                        }
                        config.healthTotalXOffset = newDefaultXOffset;
                        config.healthTotalYOffset = 0;
                        this.rebuildEditorWidgets();
                    };
                    fillDirectionCycler = () -> {
                        config.healthFillDirection = this.getNextFillDirection(config.healthFillDirection);
                        this.rebuildEditorWidgets();
                    };
                    fgSupported = true;
                    textSupported = true;
                    anchorSupported = true;
                    fadeSupported = true;
                    bgSupported = true;
                    fillDirectionSupported = true;
                    break;
                }
                case MANA_BAR: {
                    bgGetter = () -> config.enableManaBackground;
                    fgGetter = () -> config.enableManaForeground;
                    fadeGetter = () -> config.fadeManaWhenFull;
                    bgToggler = () -> {
                        config.enableManaBackground = !config.enableManaBackground;
                        this.rebuildEditorWidgets();
                    };
                    fgToggler = () -> {
                        config.enableManaForeground = !config.enableManaForeground;
                        this.rebuildEditorWidgets();
                    };
                    fadeToggler = () -> {
                        config.fadeManaWhenFull = !config.fadeManaWhenFull;
                        this.rebuildEditorWidgets();
                    };
                    textCycler = () -> {
                        config.showManaText = this.getNextTextBehavior(config.showManaText);
                        this.rebuildEditorWidgets();
                    };
                    textAlignCycler = () -> {
                        config.manaTextAlign = this.getNextHorizontalAlignment(config.manaTextAlign);
                        this.rebuildEditorWidgets();
                    };
                    anchorCycler = () -> {
                        HUDPositioning.BarPlacement nextAnchor;
                        config.manaBarAnchor = nextAnchor = this.getNextBarPlacement(config.manaBarAnchor);
                        int bgWidth = config.manaBackgroundWidth;
                        int newDefaultXOffset = 0;
                        if (nextAnchor == HUDPositioning.BarPlacement.ABOVE_UTILITIES) {
                            newDefaultXOffset = -bgWidth / 2;
                        } else if (nextAnchor.getSide() == HUDPositioning.AnchorSide.RIGHT) {
                            newDefaultXOffset = -bgWidth;
                        }
                        config.manaTotalXOffset = newDefaultXOffset;
                        config.manaTotalYOffset = 0;
                        this.rebuildEditorWidgets();
                    };
                    fillDirectionCycler = () -> {
                        config.manaFillDirection = this.getNextFillDirection(config.manaFillDirection);
                        this.rebuildEditorWidgets();
                    };
                    fgSupported = true;
                    textSupported = true;
                    anchorSupported = true;
                    fadeSupported = true;
                    bgSupported = true;
                    fillDirectionSupported = true;
                    break;
                }
                case STAMINA_BAR: {
                    bgGetter = () -> config.enableStaminaBackground;
                    fgGetter = () -> config.enableStaminaForeground;
                    fadeGetter = () -> config.fadeStaminaWhenFull;
                    bgToggler = () -> {
                        config.enableStaminaBackground = !config.enableStaminaBackground;
                        this.rebuildEditorWidgets();
                    };
                    fgToggler = () -> {
                        config.enableStaminaForeground = !config.enableStaminaForeground;
                        this.rebuildEditorWidgets();
                    };
                    fadeToggler = () -> {
                        config.fadeStaminaWhenFull = !config.fadeStaminaWhenFull;
                        this.rebuildEditorWidgets();
                    };
                    textCycler = () -> {
                        config.showStaminaText = this.getNextTextBehavior(config.showStaminaText);
                        this.rebuildEditorWidgets();
                    };
                    textAlignCycler = () -> {
                        config.staminaTextAlign = this.getNextHorizontalAlignment(config.staminaTextAlign);
                        this.rebuildEditorWidgets();
                    };
                    anchorCycler = () -> {
                        HUDPositioning.BarPlacement nextAnchor;
                        config.staminaBarAnchor = nextAnchor = this.getNextBarPlacement(config.staminaBarAnchor);
                        int bgWidth = config.staminaBackgroundWidth;
                        int newDefaultXOffset = 0;
                        if (nextAnchor == HUDPositioning.BarPlacement.ABOVE_UTILITIES) {
                            newDefaultXOffset = -bgWidth / 2;
                        } else if (nextAnchor.getSide() == HUDPositioning.AnchorSide.RIGHT) {
                            newDefaultXOffset = -bgWidth;
                        }
                        config.staminaTotalXOffset = newDefaultXOffset;
                        config.staminaTotalYOffset = 0;
                        this.rebuildEditorWidgets();
                    };
                    fillDirectionCycler = () -> {
                        config.staminaFillDirection = this.getNextFillDirection(config.staminaFillDirection);
                        this.rebuildEditorWidgets();
                    };
                    fgSupported = true;
                    textSupported = true;
                    anchorSupported = true;
                    fadeSupported = true;
                    bgSupported = true;
                    fillDirectionSupported = true;
                    break;
                }
                case ARMOR_BAR: {
                    bgGetter = () -> true;
                    fgGetter = () -> false;
                    fadeGetter = () -> false;
                    bgToggler = () -> {};
                    fgToggler = () -> {};
                    fadeToggler = () -> {};
                    textCycler = () -> {
                        config.showArmorText = this.getNextTextBehavior(config.showArmorText);
                        this.rebuildEditorWidgets();
                    };
                    textAlignCycler = () -> {
                        config.armorTextAlign = this.getNextHorizontalAlignment(config.armorTextAlign);
                        this.rebuildEditorWidgets();
                    };
                    fillDirectionCycler = () -> {};
                    anchorCycler = () -> {
                        HUDPositioning.BarPlacement nextAnchor;
                        config.armorBarAnchor = nextAnchor = this.getNextBarPlacement(config.armorBarAnchor);
                        int bgWidth = config.armorBackgroundWidth;
                        int newDefaultXOffset = 0;
                        if (nextAnchor == HUDPositioning.BarPlacement.ABOVE_UTILITIES) {
                            newDefaultXOffset = -bgWidth / 2;
                        } else if (nextAnchor.getSide() == HUDPositioning.AnchorSide.RIGHT) {
                            newDefaultXOffset = -bgWidth;
                        }
                        config.armorTotalXOffset = newDefaultXOffset;
                        config.armorTotalYOffset = 0;
                        this.rebuildEditorWidgets();
                    };
                    fgSupported = true;
                    textSupported = true;
                    anchorSupported = true;
                    fadeSupported = true;
                    bgSupported = true;
                    fillDirectionSupported = true;
                    break;
                }
                case AIR_BAR: {
                    bgGetter = () -> true;
                    fgGetter = () -> false;
                    fadeGetter = () -> false;
                    bgToggler = () -> {};
                    fgToggler = () -> {};
                    fadeToggler = () -> {};
                    textCycler = () -> {
                        config.showAirText = this.getNextTextBehavior(config.showAirText);
                        this.rebuildEditorWidgets();
                    };
                    textAlignCycler = () -> {
                        config.airTextAlign = this.getNextHorizontalAlignment(config.airTextAlign);
                        this.rebuildEditorWidgets();
                    };
                    fillDirectionCycler = () -> {};
                    anchorCycler = () -> {
                        HUDPositioning.BarPlacement nextAnchor;
                        config.airBarAnchor = nextAnchor = this.getNextBarPlacement(config.airBarAnchor);
                        int bgWidth = config.airBackgroundWidth;
                        int newDefaultXOffset = 0;
                        if (nextAnchor == HUDPositioning.BarPlacement.ABOVE_UTILITIES) {
                            newDefaultXOffset = -bgWidth / 2;
                        } else if (nextAnchor.getSide() == HUDPositioning.AnchorSide.RIGHT) {
                            newDefaultXOffset = -bgWidth;
                        }
                        config.airTotalXOffset = newDefaultXOffset;
                        config.airTotalYOffset = 0;
                        this.rebuildEditorWidgets();
                    };
                    anchorSupported = true;
                    bgSupported = false;
                    textSupported = true;
                    break;
                }
                default: {
                    return;
                }
            }
            int maxButtonsPerRow = 3;
            int focusGridContentWidth = maxButtonsPerRow * focusButtonWidth + (maxButtonsPerRow - 1) * focusColSpacing;
            int currentX = focusGridStartX = (this.field_22789 - focusGridContentWidth) / 2;
            int currentY = buttonsTopY;
            int buttonsInCurrentRow = 0;
            if (bgSupported) {
                this.toggleBackgroundButton = class_4185.method_46430((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.hud_editor.button.toggle_background_format", (Object[])new Object[]{bgGetter.get() != false ? class_2561.method_43471((String)"options.on") : class_2561.method_43471((String)"options.off")}), b -> bgToggler.run()).method_46434(currentX, currentY, focusButtonWidth, focusButtonHeight).method_46431();
                this.method_37063((class_364)this.toggleBackgroundButton);
                currentX += focusButtonWidth + focusColSpacing;
                ++buttonsInCurrentRow;
            }
            if (fgSupported) {
                if (buttonsInCurrentRow >= maxButtonsPerRow) {
                    currentX = focusGridStartX;
                    currentY += focusButtonHeight + focusRowSpacing;
                    buttonsInCurrentRow = 0;
                }
                this.toggleForegroundButton = class_4185.method_46430((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.hud_editor.button.toggle_foreground_format", (Object[])new Object[]{fgGetter.get() != false ? class_2561.method_43471((String)"options.on") : class_2561.method_43471((String)"options.off")}), b -> fgToggler.run()).method_46434(currentX, currentY, focusButtonWidth, focusButtonHeight).method_46431();
                this.method_37063((class_364)this.toggleForegroundButton);
                currentX += focusButtonWidth + focusColSpacing;
                ++buttonsInCurrentRow;
            }
            if (fadeSupported) {
                if (buttonsInCurrentRow >= maxButtonsPerRow) {
                    currentX = focusGridStartX;
                    currentY += focusButtonHeight + focusRowSpacing;
                    buttonsInCurrentRow = 0;
                }
                this.toggleFadeFullButton = class_4185.method_46430((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.hud_editor.button.toggle_fade_full_format", (Object[])new Object[]{fadeGetter.get() != false ? class_2561.method_43471((String)"options.on") : class_2561.method_43471((String)"options.off")}), b -> fadeToggler.run()).method_46434(currentX, currentY, focusButtonWidth, focusButtonHeight).method_46431();
                this.method_37063((class_364)this.toggleFadeFullButton);
                currentX += focusButtonWidth + focusColSpacing;
                ++buttonsInCurrentRow;
            }
            if (buttonsInCurrentRow > 0 || textSupported || anchorSupported) {
                currentX = focusGridStartX;
                currentY += focusButtonHeight + focusRowSpacing;
                buttonsInCurrentRow = 0;
            }
            if (textSupported) {
                TextBehavior currentTextBehavior = TextBehavior.NEVER;
                HorizontalAlignment currentTextAlign = HorizontalAlignment.CENTER;
                if (focused == DraggableElement.HEALTH_BAR) {
                    currentTextBehavior = config.showHealthText;
                    currentTextAlign = config.healthTextAlign;
                } else if (focused == DraggableElement.MANA_BAR) {
                    currentTextBehavior = config.showManaText;
                    currentTextAlign = config.manaTextAlign;
                } else if (focused == DraggableElement.STAMINA_BAR) {
                    currentTextBehavior = config.showStaminaText;
                    currentTextAlign = config.staminaTextAlign;
                } else if (focused == DraggableElement.ARMOR_BAR) {
                    currentTextBehavior = config.showArmorText;
                    currentTextAlign = config.armorTextAlign;
                } else if (focused == DraggableElement.AIR_BAR) {
                    currentTextBehavior = config.showAirText;
                    currentTextAlign = config.airTextAlign;
                }
                this.cycleTextBehaviorButton = class_4185.method_46430((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.hud_editor.button.cycle_text_behavior_format", (Object[])new Object[]{class_2561.method_43471((String)("text_behavior." + currentTextBehavior.name().toLowerCase()))}), b -> textCycler.run()).method_46434(currentX, currentY, focusButtonWidth, focusButtonHeight).method_46431();
                this.method_37063((class_364)this.cycleTextBehaviorButton);
                currentX += focusButtonWidth + focusColSpacing;
                if (++buttonsInCurrentRow >= maxButtonsPerRow) {
                    currentX = focusGridStartX;
                    currentY += focusButtonHeight + focusRowSpacing;
                    buttonsInCurrentRow = 0;
                }
                this.cycleTextAlignButton = class_4185.method_46430((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.hud_editor.button.cycle_text_align_format", (Object[])new Object[]{class_2561.method_43471((String)("horizontal_alignment." + currentTextAlign.name().toLowerCase()))}), b -> textAlignCycler.run()).method_46434(currentX, currentY, focusButtonWidth, focusButtonHeight).method_46431();
                this.method_37063((class_364)this.cycleTextAlignButton);
                currentX += focusButtonWidth + focusColSpacing;
                ++buttonsInCurrentRow;
            }
            if (anchorSupported) {
                HUDPositioning.BarPlacement currentAnchor = HUDPositioning.BarPlacement.HEALTH;
                FillDirection currentFillDirection = FillDirection.HORIZONTAL;
                if (focused == DraggableElement.HEALTH_BAR) {
                    currentAnchor = config.healthBarAnchor;
                    currentFillDirection = config.healthFillDirection;
                } else if (focused == DraggableElement.MANA_BAR) {
                    currentAnchor = config.manaBarAnchor;
                    currentFillDirection = config.manaFillDirection;
                } else if (focused == DraggableElement.STAMINA_BAR) {
                    currentAnchor = config.staminaBarAnchor;
                    currentFillDirection = config.staminaFillDirection;
                } else if (focused == DraggableElement.ARMOR_BAR) {
                    currentAnchor = config.armorBarAnchor;
                } else if (focused == DraggableElement.AIR_BAR) {
                    currentAnchor = config.airBarAnchor;
                }
                if (buttonsInCurrentRow >= maxButtonsPerRow) {
                    currentX = focusGridStartX;
                    currentY += focusButtonHeight + focusRowSpacing;
                    buttonsInCurrentRow = 0;
                }
                this.cycleAnchorButton = class_4185.method_46430((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.hud_editor.button.cycle_anchor_format", (Object[])new Object[]{class_2561.method_43471((String)("bar_placement." + currentAnchor.name().toLowerCase()))}), b -> anchorCycler.run()).method_46434(currentX, currentY, focusButtonWidth, focusButtonHeight).method_46431();
                this.method_37063((class_364)this.cycleAnchorButton);
                currentX += focusButtonWidth + focusColSpacing;
                ++buttonsInCurrentRow;
                if (fillDirectionSupported) {
                    if (buttonsInCurrentRow >= maxButtonsPerRow) {
                        currentX = focusGridStartX;
                        currentY += focusButtonHeight + focusRowSpacing;
                        buttonsInCurrentRow = 0;
                    }
                    this.cycleFillDirectionButton = class_4185.method_46430((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.hud_editor.button.cycle_fill_direction_format", (Object[])new Object[]{class_2561.method_43471((String)("fill_direction." + currentFillDirection.name().toLowerCase()))}), b -> fillDirectionCycler.run()).method_46434(currentX, currentY, focusButtonWidth, focusButtonHeight).method_46431();
                    this.method_37063((class_364)this.cycleFillDirectionButton);
                    currentX += focusButtonWidth + focusColSpacing;
                    ++buttonsInCurrentRow;
                }
            }
            if (buttonsInCurrentRow > 0) {
                currentX = focusGridStartX;
                currentY += focusButtonHeight + focusRowSpacing;
                buttonsInCurrentRow = 0;
            }
            DraggableElement finalFocusedElement = focused;
            this.resetPositionButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.button.reset_position"), b -> this.openConfirmScreen((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.confirm.reset_position.title", (Object[])new Object[]{this.getFriendlyElementName(finalFocusedElement)}), (class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.confirm.reset_position.explanation"), () -> this.resetPositionDefaultsAction(finalFocusedElement))).method_46434(currentX, currentY += 5, focusButtonWidth, focusButtonHeight).method_46431();
            this.method_37063((class_364)this.resetPositionButton);
            currentX += focusButtonWidth + focusColSpacing;
            if (++buttonsInCurrentRow >= maxButtonsPerRow) {
                currentX = focusGridStartX;
                currentY += focusButtonHeight + focusRowSpacing;
                buttonsInCurrentRow = 0;
            }
            this.resetSizeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.button.reset_size"), b -> this.openConfirmScreen((class_2561)class_2561.method_43469((String)"gui.dynamic_resource_bars.confirm.reset_size.title", (Object[])new Object[]{this.getFriendlyElementName(finalFocusedElement)}), (class_2561)class_2561.method_43471((String)"gui.dynamic_resource_bars.confirm.reset_size.explanation"), () -> this.resetSizeDefaultsAction(finalFocusedElement))).method_46434(currentX, currentY, focusButtonWidth, focusButtonHeight).method_46431();
            this.method_37063((class_364)this.resetSizeButton);
            currentX += focusButtonWidth + focusColSpacing;
            ++buttonsInCurrentRow;
        }
    }

    private TextBehavior getNextTextBehavior(TextBehavior current) {
        TextBehavior[] behaviors = TextBehavior.values();
        int nextIndex = (current.ordinal() + 1) % behaviors.length;
        return behaviors[nextIndex];
    }

    private HorizontalAlignment getNextHorizontalAlignment(HorizontalAlignment current) {
        HorizontalAlignment[] alignments = HorizontalAlignment.values();
        int nextIndex = (current.ordinal() + 1) % alignments.length;
        return alignments[nextIndex];
    }

    private BarRenderBehavior getNextBarBehavior(BarRenderBehavior current) {
        BarRenderBehavior[] behaviors = BarRenderBehavior.values();
        int nextIndex = (current.ordinal() + 1) % behaviors.length;
        return behaviors[nextIndex];
    }

    private HUDPositioning.BarPlacement getNextBarPlacement(HUDPositioning.BarPlacement current) {
        HUDPositioning.BarPlacement[] placements = HUDPositioning.BarPlacement.values();
        int nextIndex = (current.ordinal() + 1) % placements.length;
        return placements[nextIndex];
    }

    private FillDirection getNextFillDirection(FillDirection current) {
        FillDirection[] directions = FillDirection.values();
        int nextIndex = (current.ordinal() + 1) % directions.length;
        return directions[nextIndex];
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        DraggableElement focused = EditModeManager.getFocusedElement();
        DraggableElement dragged = EditModeManager.getDraggedElement();
        class_746 player = class_310.method_1551().field_1724;
        class_327 font = this.field_22793;
        Objects.requireNonNull(font);
        int fontHeight = 9;
        int padding = 5;
        int backgroundColor = -1879048192;
        float minWidgetX = Float.MAX_VALUE;
        float minWidgetY = Float.MAX_VALUE;
        float maxWidgetX = Float.MIN_VALUE;
        float maxWidgetY = Float.MIN_VALUE;
        boolean hasWidgets = false;
        for (class_4068 renderable : this.field_33816) {
            if (!(renderable instanceof class_339)) continue;
            class_339 widget = (class_339)renderable;
            minWidgetX = Math.min(minWidgetX, (float)widget.method_46426());
            minWidgetY = Math.min(minWidgetY, (float)widget.method_46427());
            maxWidgetX = Math.max(maxWidgetX, (float)(widget.method_46426() + widget.method_25368()));
            maxWidgetY = Math.max(maxWidgetY, (float)(widget.method_46427() + widget.method_25364()));
            hasWidgets = true;
        }
        float overallMinX = minWidgetX;
        float overallMinY = 15.0f;
        float overallMaxX = maxWidgetX;
        float overallMaxY = minWidgetY;
        if (!hasWidgets) {
            overallMinX = (float)this.field_22789 / 2.0f - 100.0f;
            overallMaxX = (float)this.field_22789 / 2.0f + 100.0f;
            overallMaxY = 65.0f;
        } else {
            overallMaxY = maxWidgetY;
        }
        int currentTextY = 15;
        if (focused == null) {
            class_5250 helpLine1 = class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.help.main.line1");
            class_5250 helpLine2 = class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.help.main.line2");
            graphics.method_27534(font, (class_2561)helpLine1, this.field_22789 / 2, currentTextY, 0xFFFFFF);
            float textWidth = font.method_27525((class_5348)helpLine1);
            overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
            overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
            graphics.method_27534(font, (class_2561)helpLine2, this.field_22789 / 2, currentTextY += fontHeight + 2, 0xFFFFFF);
            textWidth = font.method_27525((class_5348)helpLine2);
            overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
            overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
            overallMaxY = Math.max(overallMaxY, (float)(currentTextY += fontHeight + 2));
        } else {
            class_5250 helpFocusLine1 = class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.help.focus.line1");
            class_5250 helpFocusLine2 = class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.help.focus.line2.sub_element");
            class_5250 helpFocusLine3 = class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.help.focus.line3");
            class_5250 helpFocusLine4 = class_2561.method_43471((String)"gui.dynamic_resource_bars.hud_editor.help.focus.line4");
            graphics.method_27534(font, (class_2561)helpFocusLine1, this.field_22789 / 2, currentTextY, 0xFFFFFF);
            float textWidth = font.method_27525((class_5348)helpFocusLine1);
            overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
            overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
            graphics.method_27534(font, (class_2561)helpFocusLine2, this.field_22789 / 2, currentTextY += fontHeight + 2, 0xFFFFFF);
            textWidth = font.method_27525((class_5348)helpFocusLine2);
            overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
            overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
            graphics.method_27534(font, (class_2561)helpFocusLine3, this.field_22789 / 2, currentTextY += fontHeight + 2, 0xFFFFFF);
            textWidth = font.method_27525((class_5348)helpFocusLine3);
            overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
            overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
            graphics.method_27534(font, (class_2561)helpFocusLine4, this.field_22789 / 2, currentTextY += fontHeight + 2, 0xFFFFFF);
            textWidth = font.method_27525((class_5348)helpFocusLine4);
            overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
            overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
            currentTextY += fontHeight + 2;
            class_5250 headerText = class_2561.method_43469((String)"gui.dynamic_resource_bars.hud_editor.title_focused", (Object[])new Object[]{this.getFriendlyElementName(focused)});
            graphics.method_27534(font, (class_2561)headerText, this.field_22789 / 2, currentTextY += 5, 0xFFFFFF);
            textWidth = font.method_27525((class_5348)headerText);
            overallMinX = Math.min(overallMinX, ((float)this.field_22789 - textWidth) / 2.0f);
            overallMaxX = Math.max(overallMaxX, ((float)this.field_22789 + textWidth) / 2.0f);
            overallMaxY = Math.max(overallMaxY, (float)(currentTextY += fontHeight + 2));
        }
        if (overallMinX <= overallMaxX && overallMinY <= overallMaxY) {
            graphics.method_25294((int)(overallMinX - (float)padding), (int)(overallMinY - (float)padding), (int)(overallMaxX + (float)padding), (int)(overallMaxY + (float)padding), backgroundColor);
        }
        if (focused == null && dragged != null && player != null) {
            ScreenRect barRect = null;
            HUDPositioning.BarPlacement currentAnchor = null;
            ClientConfig currentConfig = ModConfigManager.getClient();
            switch (dragged) {
                case HEALTH_BAR: {
                    barRect = HealthBarRenderer.getScreenRect((class_1657)player);
                    currentAnchor = currentConfig.healthBarAnchor;
                    break;
                }
                case MANA_BAR: {
                    barRect = ManaBarRenderer.getScreenRect((class_1657)player);
                    currentAnchor = currentConfig.manaBarAnchor;
                    break;
                }
                case STAMINA_BAR: {
                    barRect = StaminaBarRenderer.getScreenRect((class_1657)player);
                    currentAnchor = currentConfig.staminaBarAnchor;
                    break;
                }
                case ARMOR_BAR: {
                    barRect = ArmorBarRenderer.getScreenRect((class_1657)player);
                    currentAnchor = currentConfig.armorBarAnchor;
                    break;
                }
                case AIR_BAR: {
                    barRect = AirBarRenderer.getScreenRect((class_1657)player);
                    currentAnchor = currentConfig.airBarAnchor;
                }
            }
            if (barRect != null && currentAnchor != null && barRect.width() > 0 && barRect.height() > 0) {
                Position anchorPos = HUDPositioning.getPositionFromAnchor(currentAnchor);
                int barCenterX = barRect.x() + barRect.width() / 2;
                int barCenterY = barRect.y() + barRect.height() / 2;
                int lineColor = -1593835521;
                graphics.method_25292(anchorPos.x(), barCenterX, anchorPos.y(), lineColor);
                graphics.method_25301(barCenterX, anchorPos.y(), barCenterY, lineColor);
            }
        }
        if (focused != null && player != null) {
            this.drawResizeHandles(graphics, (class_1657)player, focused, mouseX, mouseY);
            ClientConfig config = ModConfigManager.getClient();
            boolean shouldDrawTextOutline = false;
            switch (focused) {
                case HEALTH_BAR: 
                case MANA_BAR: 
                case STAMINA_BAR: 
                case ARMOR_BAR: 
                case AIR_BAR: {
                    shouldDrawTextOutline = true;
                }
            }
            if (shouldDrawTextOutline) {
                ScreenRect textRect = null;
                switch (focused) {
                    case HEALTH_BAR: {
                        textRect = HealthBarRenderer.getSubElementRect(SubElementType.TEXT, (class_1657)player);
                        break;
                    }
                    case MANA_BAR: {
                        textRect = ManaBarRenderer.getSubElementRect(SubElementType.TEXT, (class_1657)player);
                        break;
                    }
                    case STAMINA_BAR: {
                        textRect = StaminaBarRenderer.getSubElementRect(SubElementType.TEXT, (class_1657)player);
                        break;
                    }
                    case ARMOR_BAR: {
                        textRect = ArmorBarRenderer.getSubElementRect(SubElementType.TEXT, (class_1657)player);
                        break;
                    }
                    case AIR_BAR: {
                        textRect = AirBarRenderer.getSubElementRect(SubElementType.TEXT, (class_1657)player);
                    }
                }
                if (textRect != null && textRect.width() > 0 && textRect.height() > 0) {
                    graphics.method_49601(textRect.x() - 1, textRect.y() - 1, textRect.width() + 2, textRect.height() + 2, 0x60FFFFFF);
                }
            }
            boolean shouldDrawIconOutline = false;
            switch (focused) {
                case ARMOR_BAR: 
                case AIR_BAR: {
                    shouldDrawIconOutline = true;
                }
            }
            if (shouldDrawIconOutline) {
                ScreenRect iconRect = null;
                switch (focused) {
                    case ARMOR_BAR: {
                        if (!config.enableArmorIcon) break;
                        iconRect = ArmorBarRenderer.getSubElementRect(SubElementType.ICON, (class_1657)player);
                        break;
                    }
                    case AIR_BAR: {
                        if (!config.enableAirIcon) break;
                        iconRect = AirBarRenderer.getSubElementRect(SubElementType.ICON, (class_1657)player);
                    }
                }
                if (iconRect != null && iconRect.width() > 0 && iconRect.height() > 0) {
                    int iconOutlineColor = focused == DraggableElement.ARMOR_BAR ? -1597980480 : -1599219482;
                    graphics.method_49601(iconRect.x() - 1, iconRect.y() - 1, iconRect.width() + 2, iconRect.height() + 2, iconOutlineColor);
                }
            }
        }
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
    }

    private void drawResizeHandles(class_332 graphics, class_1657 player, DraggableElement focused, int mouseX, int mouseY) {
        ClientConfig config = ModConfigManager.getClient();
        ScreenRect bgRect = null;
        switch (focused) {
            case HEALTH_BAR: {
                if (config.enableHealthBackground) {
                    bgRect = HealthBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                    this.drawHandlesForRect(graphics, bgRect, focused, SubElementType.BACKGROUND, mouseX, mouseY);
                }
                ScreenRect barRect = HealthBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                this.drawHandlesForRect(graphics, barRect, focused, SubElementType.BAR_MAIN, mouseX, mouseY);
                if (!config.enableHealthForeground) break;
                ScreenRect fgRect = HealthBarRenderer.getSubElementRect(SubElementType.FOREGROUND_DETAIL, player);
                this.drawHandlesForRect(graphics, fgRect, focused, SubElementType.FOREGROUND_DETAIL, mouseX, mouseY);
                break;
            }
            case MANA_BAR: {
                if (config.enableManaBackground) {
                    bgRect = ManaBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                    this.drawHandlesForRect(graphics, bgRect, focused, SubElementType.BACKGROUND, mouseX, mouseY);
                }
                ScreenRect manaBarRect = ManaBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                this.drawHandlesForRect(graphics, manaBarRect, focused, SubElementType.BAR_MAIN, mouseX, mouseY);
                if (!config.enableManaForeground) break;
                ScreenRect fgRect = ManaBarRenderer.getSubElementRect(SubElementType.FOREGROUND_DETAIL, player);
                this.drawHandlesForRect(graphics, fgRect, focused, SubElementType.FOREGROUND_DETAIL, mouseX, mouseY);
                break;
            }
            case STAMINA_BAR: {
                if (config.enableStaminaBackground) {
                    bgRect = StaminaBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                    this.drawHandlesForRect(graphics, bgRect, focused, SubElementType.BACKGROUND, mouseX, mouseY);
                }
                ScreenRect staminaBarRect = StaminaBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                this.drawHandlesForRect(graphics, staminaBarRect, focused, SubElementType.BAR_MAIN, mouseX, mouseY);
                if (!config.enableStaminaForeground) break;
                ScreenRect fgRect = StaminaBarRenderer.getSubElementRect(SubElementType.FOREGROUND_DETAIL, player);
                this.drawHandlesForRect(graphics, fgRect, focused, SubElementType.FOREGROUND_DETAIL, mouseX, mouseY);
                break;
            }
            case ARMOR_BAR: {
                bgRect = ArmorBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                this.drawHandlesForRect(graphics, bgRect, focused, SubElementType.BACKGROUND, mouseX, mouseY);
                ScreenRect armorBarRect = ArmorBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                this.drawHandlesForRect(graphics, armorBarRect, focused, SubElementType.BAR_MAIN, mouseX, mouseY);
                break;
            }
            case AIR_BAR: {
                bgRect = AirBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                this.drawHandlesForRect(graphics, bgRect, focused, SubElementType.BACKGROUND, mouseX, mouseY);
                ScreenRect airBarRect = AirBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                this.drawHandlesForRect(graphics, airBarRect, focused, SubElementType.BAR_MAIN, mouseX, mouseY);
            }
        }
    }

    private void drawHandlesForRect(class_332 graphics, ScreenRect rect, DraggableElement focusedElement, SubElementType elementType, int mouseX, int mouseY) {
        if (rect == null || rect.width() <= 0 || rect.height() <= 0) {
            return;
        }
        int handleColor = this.getOutlineColorForSubElement(focusedElement, elementType);
        int centerY = rect.y() + rect.height() / 2;
        int centerX = rect.x() + rect.width() / 2;
        ScreenRect rightHandle = new ScreenRect(rect.x() + rect.width() - 1, centerY - 1, 3, 3);
        ScreenRect bottomHandle = new ScreenRect(centerX - 1, rect.y() + rect.height() - 1, 3, 3);
        boolean isRightHover = rightHandle.contains(mouseX, mouseY);
        boolean isBottomHover = bottomHandle.contains(mouseX, mouseY);
        if (isRightHover && this.currentResizeMode == ResizeMode.NONE || !isBottomHover || this.currentResizeMode == ResizeMode.NONE) {
            // empty if block
        }
        int rightActualColor = isRightHover ? -1426063616 : handleColor;
        int bottomActualColor = isBottomHover ? -1426063616 : handleColor;
        graphics.method_25294(rightHandle.x(), rightHandle.y(), rightHandle.x() + rightHandle.width(), rightHandle.y() + rightHandle.height(), rightActualColor);
        graphics.method_25294(bottomHandle.x(), bottomHandle.y(), bottomHandle.x() + bottomHandle.width(), bottomHandle.y() + bottomHandle.height(), bottomActualColor);
    }

    private ResizeData getResizeHandleAtPosition(DraggableElement element, SubElementType subElement, int mouseX, int mouseY) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || element == null || subElement == null) {
            return null;
        }
        ScreenRect rect = null;
        switch (element) {
            case HEALTH_BAR: {
                rect = HealthBarRenderer.getSubElementRect(subElement, (class_1657)player);
                break;
            }
            case MANA_BAR: {
                rect = ManaBarRenderer.getSubElementRect(subElement, (class_1657)player);
                break;
            }
            case STAMINA_BAR: {
                rect = StaminaBarRenderer.getSubElementRect(subElement, (class_1657)player);
                break;
            }
            case ARMOR_BAR: {
                rect = ArmorBarRenderer.getSubElementRect(subElement, (class_1657)player);
                break;
            }
            case AIR_BAR: {
                rect = AirBarRenderer.getSubElementRect(subElement, (class_1657)player);
            }
        }
        if (rect == null || rect.width() <= 0 || rect.height() <= 0) {
            return null;
        }
        int centerY = rect.y() + rect.height() / 2;
        int centerX = rect.x() + rect.width() / 2;
        ScreenRect rightHandle = new ScreenRect(rect.x() + rect.width() - 1, centerY - 1, 3, 3);
        ScreenRect bottomHandle = new ScreenRect(centerX - 1, rect.y() + rect.height() - 1, 3, 3);
        if (rightHandle.contains(mouseX, mouseY)) {
            return new ResizeData(element, subElement, ResizeMode.WIDTH, rect.width(), rect.height());
        }
        if (bottomHandle.contains(mouseX, mouseY)) {
            return new ResizeData(element, subElement, ResizeMode.HEIGHT, rect.width(), rect.height());
        }
        return null;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        DraggableElement clickedBarForDrag;
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (!EditModeManager.isEditModeEnabled() || button != 0) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        boolean isDoubleClick = currentTime - this.lastClickTime < 300L && Math.abs(mouseX - this.lastClickX) < 5.0 && Math.abs(mouseY - this.lastClickY) < 5.0;
        boolean actionTaken = false;
        DraggableElement currentFocusedElement = EditModeManager.getFocusedElement();
        ClientConfig config = ModConfigManager.getClient();
        if (currentFocusedElement != null) {
            SubElementType[] subElementTypesToTest;
            for (SubElementType subType : subElementTypesToTest = new SubElementType[]{SubElementType.BACKGROUND, SubElementType.BAR_MAIN, SubElementType.FOREGROUND_DETAIL}) {
                ResizeData resizeData;
                boolean canTestThisSubElement = false;
                switch (currentFocusedElement) {
                    case HEALTH_BAR: {
                        if (subType == SubElementType.BACKGROUND && config.enableHealthBackground) {
                            canTestThisSubElement = true;
                        }
                        if (subType == SubElementType.BAR_MAIN) {
                            canTestThisSubElement = true;
                        }
                        if (subType != SubElementType.FOREGROUND_DETAIL || !config.enableHealthForeground) break;
                        canTestThisSubElement = true;
                        break;
                    }
                    case MANA_BAR: {
                        if (subType == SubElementType.BACKGROUND && config.enableManaBackground) {
                            canTestThisSubElement = true;
                        }
                        if (subType == SubElementType.BAR_MAIN) {
                            canTestThisSubElement = true;
                        }
                        if (subType != SubElementType.FOREGROUND_DETAIL || !config.enableManaForeground) break;
                        canTestThisSubElement = true;
                        break;
                    }
                    case STAMINA_BAR: {
                        if (subType == SubElementType.BACKGROUND && config.enableStaminaBackground) {
                            canTestThisSubElement = true;
                        }
                        if (subType == SubElementType.BAR_MAIN) {
                            canTestThisSubElement = true;
                        }
                        if (subType != SubElementType.FOREGROUND_DETAIL || !config.enableStaminaForeground) break;
                        canTestThisSubElement = true;
                        break;
                    }
                    case ARMOR_BAR: {
                        if (subType == SubElementType.BACKGROUND) {
                            canTestThisSubElement = true;
                        }
                        if (subType != SubElementType.BAR_MAIN) break;
                        canTestThisSubElement = true;
                        break;
                    }
                    case AIR_BAR: {
                        if (subType == SubElementType.BACKGROUND) {
                            canTestThisSubElement = true;
                        }
                        if (subType != SubElementType.BAR_MAIN) break;
                        canTestThisSubElement = true;
                    }
                }
                if (!canTestThisSubElement || (resizeData = this.getResizeHandleAtPosition(currentFocusedElement, subType, (int)mouseX, (int)mouseY)) == null) continue;
                this.startResizeOperation(resizeData, (int)mouseX, (int)mouseY);
                actionTaken = true;
                break;
            }
            if (actionTaken) {
                this.lastClickTime = 0L;
                return true;
            }
        }
        if (isDoubleClick) {
            DraggableElement clickedBarForFocus = this.getClickedBarComplex(mouseX, mouseY, (class_1657)player);
            if (clickedBarForFocus != null) {
                if (EditModeManager.getFocusedElement() == clickedBarForFocus) {
                    EditModeManager.clearFocusedElement();
                } else {
                    EditModeManager.setFocusedElement(clickedBarForFocus);
                }
                this.rebuildEditorWidgets();
                actionTaken = true;
            }
            this.lastClickTime = 0L;
            if (actionTaken) {
                return true;
            }
        }
        if (!actionTaken && currentFocusedElement != null && this.currentResizeMode == ResizeMode.NONE) {
            SubElementType clickedSub = this.getClickedSubElement(currentFocusedElement, mouseX, mouseY, (class_1657)player);
            if (clickedSub != null) {
                int currentSubX = 0;
                int currentSubY = 0;
                switch (currentFocusedElement) {
                    case HEALTH_BAR: {
                        if (clickedSub == SubElementType.BAR_MAIN) {
                            currentSubX = config.healthBarXOffset;
                            currentSubY = config.healthBarYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.FOREGROUND_DETAIL) {
                            currentSubX = config.healthOverlayXOffset;
                            currentSubY = config.healthOverlayYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.BACKGROUND) {
                            currentSubX = config.healthBackgroundXOffset;
                            currentSubY = config.healthBackgroundYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.TEXT) {
                            currentSubX = config.healthTextXOffset;
                            currentSubY = config.healthTextYOffset;
                            break;
                        }
                        if (clickedSub != SubElementType.ABSORPTION_TEXT) break;
                        currentSubX = config.healthAbsorptionTextXOffset;
                        currentSubY = config.healthAbsorptionTextYOffset;
                        break;
                    }
                    case MANA_BAR: {
                        if (clickedSub == SubElementType.BAR_MAIN) {
                            currentSubX = config.manaBarXOffset;
                            currentSubY = config.manaBarYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.FOREGROUND_DETAIL) {
                            currentSubX = config.manaOverlayXOffset;
                            currentSubY = config.manaOverlayYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.BACKGROUND) {
                            currentSubX = config.manaBackgroundXOffset;
                            currentSubY = config.manaBackgroundYOffset;
                            break;
                        }
                        if (clickedSub != SubElementType.TEXT) break;
                        currentSubX = config.manaTextXOffset;
                        currentSubY = config.manaTextYOffset;
                        break;
                    }
                    case STAMINA_BAR: {
                        if (clickedSub == SubElementType.BAR_MAIN) {
                            currentSubX = config.staminaBarXOffset;
                            currentSubY = config.staminaBarYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.FOREGROUND_DETAIL) {
                            currentSubX = config.staminaOverlayXOffset;
                            currentSubY = config.staminaOverlayYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.BACKGROUND) {
                            currentSubX = config.staminaBackgroundXOffset;
                            currentSubY = config.staminaBackgroundYOffset;
                            break;
                        }
                        if (clickedSub != SubElementType.TEXT) break;
                        currentSubX = config.staminaTextXOffset;
                        currentSubY = config.staminaTextYOffset;
                        break;
                    }
                    case ARMOR_BAR: {
                        if (clickedSub == SubElementType.BAR_MAIN) {
                            currentSubX = config.armorBarXOffset;
                            currentSubY = config.armorBarYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.BACKGROUND) {
                            currentSubX = config.armorBackgroundXOffset;
                            currentSubY = config.armorBackgroundYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.TEXT) {
                            currentSubX = config.armorTextXOffset;
                            currentSubY = config.armorTextYOffset;
                            break;
                        }
                        if (clickedSub != SubElementType.ICON) break;
                        currentSubX = config.armorIconXOffset;
                        currentSubY = config.armorIconYOffset;
                        break;
                    }
                    case AIR_BAR: {
                        if (clickedSub == SubElementType.BAR_MAIN) {
                            currentSubX = config.airBarXOffset;
                            currentSubY = config.airBarYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.BACKGROUND) {
                            currentSubX = config.airBackgroundXOffset;
                            currentSubY = config.airBackgroundYOffset;
                            break;
                        }
                        if (clickedSub == SubElementType.TEXT) {
                            currentSubX = config.airTextXOffset;
                            currentSubY = config.airTextYOffset;
                            break;
                        }
                        if (clickedSub != SubElementType.ICON) break;
                        currentSubX = config.airIconXOffset;
                        currentSubY = config.airIconYOffset;
                    }
                }
                EditModeManager.setDraggedSubElement(clickedSub, (int)mouseX, (int)mouseY, currentSubX, currentSubY);
                this.lastFocusedElementForSubUndo = currentFocusedElement;
                this.lastDraggedSubElementForUndo = clickedSub;
                this.lastSubDragInitialXOffset = currentSubX;
                this.lastSubDragInitialYOffset = currentSubY;
                this.canUndoLastSubDrag = false;
                this.canUndoLastDrag = false;
                this.lastDraggedElementForUndo = null;
                actionTaken = true;
            }
            if (actionTaken) {
                this.lastClickTime = currentTime;
                this.lastClickX = mouseX;
                this.lastClickY = mouseY;
                return true;
            }
        }
        if (!actionTaken && EditModeManager.getFocusedElement() == null && this.currentResizeMode == ResizeMode.NONE && (clickedBarForDrag = this.getClickedBarComplex(mouseX, mouseY, (class_1657)player)) != null) {
            int totalX = 0;
            int totalY = 0;
            switch (clickedBarForDrag) {
                case HEALTH_BAR: {
                    totalX = config.healthTotalXOffset;
                    totalY = config.healthTotalYOffset;
                    break;
                }
                case MANA_BAR: {
                    totalX = config.manaTotalXOffset;
                    totalY = config.manaTotalYOffset;
                    break;
                }
                case STAMINA_BAR: {
                    totalX = config.staminaTotalXOffset;
                    totalY = config.staminaTotalYOffset;
                    break;
                }
                case ARMOR_BAR: {
                    totalX = config.armorTotalXOffset;
                    totalY = config.armorTotalYOffset;
                    break;
                }
                case AIR_BAR: {
                    totalX = config.airTotalXOffset;
                    totalY = config.airTotalYOffset;
                }
            }
            this.lastDraggedElementForUndo = clickedBarForDrag;
            this.lastDragInitialXOffset = totalX;
            this.lastDragInitialYOffset = totalY;
            this.canUndoLastDrag = false;
            EditModeManager.setDraggedElement(clickedBarForDrag, (int)mouseX, (int)mouseY, totalX, totalY);
            actionTaken = true;
        }
        if (!isDoubleClick && !actionTaken) {
            this.lastClickTime = currentTime;
            this.lastClickX = mouseX;
            this.lastClickY = mouseY;
        } else if (!actionTaken || isDoubleClick || this.currentResizeMode != ResizeMode.NONE || EditModeManager.getDraggedSubElement() != null || EditModeManager.getDraggedElement() == null) {
            // empty if block
        }
        return actionTaken;
    }

    private DraggableElement getClickedBarComplex(double mouseX, double mouseY, class_1657 player) {
        if (HealthBarRenderer.getScreenRect(player).contains((int)mouseX, (int)mouseY)) {
            return DraggableElement.HEALTH_BAR;
        }
        if (StaminaBarRenderer.getScreenRect(player).contains((int)mouseX, (int)mouseY)) {
            return DraggableElement.STAMINA_BAR;
        }
        if (ManaBarRenderer.getScreenRect(player).contains((int)mouseX, (int)mouseY)) {
            return DraggableElement.MANA_BAR;
        }
        if (ArmorBarRenderer.getScreenRect(player).contains((int)mouseX, (int)mouseY)) {
            return DraggableElement.ARMOR_BAR;
        }
        if (AirBarRenderer.getScreenRect(player).contains((int)mouseX, (int)mouseY)) {
            return DraggableElement.AIR_BAR;
        }
        return null;
    }

    private SubElementType getClickedSubElement(DraggableElement focusedBar, double mouseX, double mouseY, class_1657 player) {
        if (focusedBar == null) {
            return null;
        }
        ScreenRect barMainRect = null;
        ScreenRect barFgRect = null;
        ScreenRect barBgRect = null;
        ScreenRect barTextRect = null;
        ScreenRect barIconRect = null;
        ScreenRect barAbsorptionTextRect = null;
        ClientConfig currentConfig = ModConfigManager.getClient();
        switch (focusedBar) {
            case HEALTH_BAR: {
                barMainRect = HealthBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                if (currentConfig.enableHealthForeground) {
                    barFgRect = HealthBarRenderer.getSubElementRect(SubElementType.FOREGROUND_DETAIL, player);
                }
                if (currentConfig.enableHealthBackground) {
                    barBgRect = HealthBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                }
                barTextRect = HealthBarRenderer.getSubElementRect(SubElementType.TEXT, player);
                barAbsorptionTextRect = HealthBarRenderer.getSubElementRect(SubElementType.ABSORPTION_TEXT, player);
                break;
            }
            case STAMINA_BAR: {
                barMainRect = StaminaBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                if (currentConfig.enableStaminaForeground) {
                    barFgRect = StaminaBarRenderer.getSubElementRect(SubElementType.FOREGROUND_DETAIL, player);
                }
                if (currentConfig.enableStaminaBackground) {
                    barBgRect = StaminaBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                }
                barTextRect = StaminaBarRenderer.getSubElementRect(SubElementType.TEXT, player);
                break;
            }
            case MANA_BAR: {
                barMainRect = ManaBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                if (currentConfig.enableManaForeground) {
                    barFgRect = ManaBarRenderer.getSubElementRect(SubElementType.FOREGROUND_DETAIL, player);
                }
                if (currentConfig.enableManaBackground) {
                    barBgRect = ManaBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                }
                barTextRect = ManaBarRenderer.getSubElementRect(SubElementType.TEXT, player);
                break;
            }
            case ARMOR_BAR: {
                barMainRect = ArmorBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                barBgRect = ArmorBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                barTextRect = ArmorBarRenderer.getSubElementRect(SubElementType.TEXT, player);
                if (!currentConfig.enableArmorIcon) break;
                barIconRect = ArmorBarRenderer.getSubElementRect(SubElementType.ICON, player);
                break;
            }
            case AIR_BAR: {
                barMainRect = AirBarRenderer.getSubElementRect(SubElementType.BAR_MAIN, player);
                barBgRect = AirBarRenderer.getSubElementRect(SubElementType.BACKGROUND, player);
                barTextRect = AirBarRenderer.getSubElementRect(SubElementType.TEXT, player);
                if (!currentConfig.enableAirIcon) break;
                barIconRect = AirBarRenderer.getSubElementRect(SubElementType.ICON, player);
            }
        }
        if (barAbsorptionTextRect != null && barAbsorptionTextRect.contains((int)mouseX, (int)mouseY)) {
            return SubElementType.ABSORPTION_TEXT;
        }
        if (barIconRect != null && barIconRect.contains((int)mouseX, (int)mouseY)) {
            return SubElementType.ICON;
        }
        if (barTextRect != null && barTextRect.contains((int)mouseX, (int)mouseY)) {
            return SubElementType.TEXT;
        }
        if (barFgRect != null && barFgRect.contains((int)mouseX, (int)mouseY)) {
            return SubElementType.FOREGROUND_DETAIL;
        }
        if (barMainRect != null && barMainRect.contains((int)mouseX, (int)mouseY)) {
            return SubElementType.BAR_MAIN;
        }
        if (barBgRect != null && barBgRect.contains((int)mouseX, (int)mouseY)) {
            return SubElementType.BACKGROUND;
        }
        return null;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button != 0) {
            return super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        ClientConfig config = ModConfigManager.getClient();
        if (this.currentResizeMode != ResizeMode.NONE && this.resizingSubElement != null && EditModeManager.getFocusedElement() != null) {
            this.handleResize((int)mouseX, (int)mouseY);
            return true;
        }
        if (EditModeManager.getDraggedSubElement() != null && EditModeManager.getFocusedElement() != null) {
            int finalNewSubX = EditModeManager.getInitialSubElementXOffset() + (int)(mouseX - (double)EditModeManager.getSubElementDragStartX());
            int finalNewSubY = EditModeManager.getInitialSubElementYOffset() + (int)(mouseY - (double)EditModeManager.getSubElementDragStartY());
            DraggableElement focused = EditModeManager.getFocusedElement();
            SubElementType sub = EditModeManager.getDraggedSubElement();
            switch (focused) {
                case HEALTH_BAR: {
                    if (sub == SubElementType.BAR_MAIN) {
                        config.healthBarXOffset = finalNewSubX;
                        config.healthBarYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.FOREGROUND_DETAIL) {
                        config.healthOverlayXOffset = finalNewSubX;
                        config.healthOverlayYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.BACKGROUND) {
                        config.healthBackgroundXOffset = finalNewSubX;
                        config.healthBackgroundYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.TEXT) {
                        config.healthTextXOffset = finalNewSubX;
                        config.healthTextYOffset = finalNewSubY;
                        break;
                    }
                    if (sub != SubElementType.ABSORPTION_TEXT) break;
                    config.healthAbsorptionTextXOffset = finalNewSubX;
                    config.healthAbsorptionTextYOffset = finalNewSubY;
                    break;
                }
                case MANA_BAR: {
                    if (sub == SubElementType.BAR_MAIN) {
                        config.manaBarXOffset = finalNewSubX;
                        config.manaBarYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.FOREGROUND_DETAIL) {
                        config.manaOverlayXOffset = finalNewSubX;
                        config.manaOverlayYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.BACKGROUND) {
                        config.manaBackgroundXOffset = finalNewSubX;
                        config.manaBackgroundYOffset = finalNewSubY;
                        break;
                    }
                    if (sub != SubElementType.TEXT) break;
                    config.manaTextXOffset = finalNewSubX;
                    config.manaTextYOffset = finalNewSubY;
                    break;
                }
                case STAMINA_BAR: {
                    if (sub == SubElementType.BAR_MAIN) {
                        config.staminaBarXOffset = finalNewSubX;
                        config.staminaBarYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.FOREGROUND_DETAIL) {
                        config.staminaOverlayXOffset = finalNewSubX;
                        config.staminaOverlayYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.BACKGROUND) {
                        config.staminaBackgroundXOffset = finalNewSubX;
                        config.staminaBackgroundYOffset = finalNewSubY;
                        break;
                    }
                    if (sub != SubElementType.TEXT) break;
                    config.staminaTextXOffset = finalNewSubX;
                    config.staminaTextYOffset = finalNewSubY;
                    break;
                }
                case ARMOR_BAR: {
                    if (sub == SubElementType.BAR_MAIN) {
                        config.armorBarXOffset = finalNewSubX;
                        config.armorBarYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.TEXT) {
                        config.armorTextXOffset = finalNewSubX;
                        config.armorTextYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.BACKGROUND) {
                        config.armorBackgroundXOffset = finalNewSubX;
                        config.armorBackgroundYOffset = finalNewSubY;
                        break;
                    }
                    if (sub != SubElementType.ICON) break;
                    config.armorIconXOffset = finalNewSubX;
                    config.armorIconYOffset = finalNewSubY;
                    break;
                }
                case AIR_BAR: {
                    if (sub == SubElementType.BAR_MAIN) {
                        config.airBarXOffset = finalNewSubX;
                        config.airBarYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.TEXT) {
                        config.airTextXOffset = finalNewSubX;
                        config.airTextYOffset = finalNewSubY;
                        break;
                    }
                    if (sub == SubElementType.ICON) {
                        config.airIconXOffset = finalNewSubX;
                        config.airIconYOffset = finalNewSubY;
                        break;
                    }
                    if (sub != SubElementType.BACKGROUND) break;
                    config.airBackgroundXOffset = finalNewSubX;
                    config.airBackgroundYOffset = finalNewSubY;
                }
            }
            return true;
        }
        if (EditModeManager.getDraggedElement() != null) {
            int finalNewTotalX = EditModeManager.getInitialElementXOffset() + (int)(mouseX - (double)EditModeManager.getDragStartX());
            int finalNewTotalY = EditModeManager.getInitialElementYOffset() + (int)(mouseY - (double)EditModeManager.getDragStartY());
            DraggableElement dragged = EditModeManager.getDraggedElement();
            switch (dragged) {
                case HEALTH_BAR: {
                    config.healthTotalXOffset = finalNewTotalX;
                    config.healthTotalYOffset = finalNewTotalY;
                    break;
                }
                case MANA_BAR: {
                    config.manaTotalXOffset = finalNewTotalX;
                    config.manaTotalYOffset = finalNewTotalY;
                    break;
                }
                case STAMINA_BAR: {
                    config.staminaTotalXOffset = finalNewTotalX;
                    config.staminaTotalYOffset = finalNewTotalY;
                    break;
                }
                case ARMOR_BAR: {
                    config.armorTotalXOffset = finalNewTotalX;
                    config.armorTotalYOffset = finalNewTotalY;
                    break;
                }
                case AIR_BAR: {
                    config.airTotalXOffset = finalNewTotalX;
                    config.airTotalYOffset = finalNewTotalY;
                }
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        boolean handled = false;
        if (this.currentResizeMode != ResizeMode.NONE && button == 0) {
            this.finishResize();
            handled = true;
        }
        if (EditModeManager.getDraggedSubElement() != null && button == 0) {
            EditModeManager.clearDraggedSubElement();
            handled = true;
        }
        if (EditModeManager.getDraggedElement() != null && button == 0) {
            EditModeManager.clearDraggedElement();
            handled = true;
        }
        return handled || super.method_25406(mouseX, mouseY, button);
    }

    private void startResizeOperation(ResizeData resizeData, int mouseX, int mouseY) {
        this.currentResizeMode = resizeData.mode;
        this.focusedElementForResize = resizeData.element;
        this.resizingSubElement = resizeData.subElement;
        this.resizeStartX = mouseX;
        this.resizeStartY = mouseY;
        ClientConfig config = ModConfigManager.getClient();
        switch (resizeData.element) {
            case HEALTH_BAR: {
                if (resizeData.subElement == SubElementType.BACKGROUND) {
                    this.initialWidth = config.healthBackgroundWidth;
                    this.initialHeight = config.healthBackgroundHeight;
                    break;
                }
                if (resizeData.subElement == SubElementType.BAR_MAIN) {
                    this.initialWidth = config.healthBarWidth;
                    this.initialHeight = config.healthBarHeight;
                    break;
                }
                if (resizeData.subElement != SubElementType.FOREGROUND_DETAIL) break;
                this.initialWidth = config.healthOverlayWidth;
                this.initialHeight = config.healthOverlayHeight;
                break;
            }
            case MANA_BAR: {
                if (resizeData.subElement == SubElementType.BACKGROUND) {
                    this.initialWidth = config.manaBackgroundWidth;
                    this.initialHeight = config.manaBackgroundHeight;
                    break;
                }
                if (resizeData.subElement == SubElementType.BAR_MAIN) {
                    this.initialWidth = config.manaBarWidth;
                    this.initialHeight = config.manaBarHeight;
                    break;
                }
                if (resizeData.subElement != SubElementType.FOREGROUND_DETAIL) break;
                this.initialWidth = config.manaOverlayWidth;
                this.initialHeight = config.manaOverlayHeight;
                break;
            }
            case STAMINA_BAR: {
                if (resizeData.subElement == SubElementType.BACKGROUND) {
                    this.initialWidth = config.staminaBackgroundWidth;
                    this.initialHeight = config.staminaBackgroundHeight;
                    break;
                }
                if (resizeData.subElement == SubElementType.BAR_MAIN) {
                    this.initialWidth = config.staminaBarWidth;
                    this.initialHeight = config.staminaBarHeight;
                    break;
                }
                if (resizeData.subElement != SubElementType.FOREGROUND_DETAIL) break;
                this.initialWidth = config.staminaOverlayWidth;
                this.initialHeight = config.staminaOverlayHeight;
                break;
            }
            case ARMOR_BAR: {
                if (resizeData.subElement == SubElementType.BACKGROUND) {
                    this.initialWidth = config.armorBackgroundWidth;
                    this.initialHeight = config.armorBackgroundHeight;
                    break;
                }
                if (resizeData.subElement != SubElementType.BAR_MAIN) break;
                this.initialWidth = config.armorBarWidth;
                this.initialHeight = config.armorBarHeight;
                break;
            }
            case AIR_BAR: {
                if (resizeData.subElement == SubElementType.BACKGROUND) {
                    this.initialWidth = config.airBackgroundWidth;
                    this.initialHeight = config.airBackgroundHeight;
                    break;
                }
                if (resizeData.subElement != SubElementType.BAR_MAIN) break;
                this.initialWidth = config.airBarWidth;
                this.initialHeight = config.airBarHeight;
            }
        }
    }

    private void handleResize(int mouseX, int mouseY) {
        if (this.currentResizeMode == ResizeMode.NONE || this.resizingSubElement == null || this.focusedElementForResize == null) {
            return;
        }
        int deltaX = mouseX - this.resizeStartX;
        int deltaY = mouseY - this.resizeStartY;
        ClientConfig config = ModConfigManager.getClient();
        switch (this.focusedElementForResize) {
            case HEALTH_BAR: {
                this.applyHealthResizing(config, deltaX, deltaY);
                break;
            }
            case MANA_BAR: {
                this.applyManaResizing(config, deltaX, deltaY);
                break;
            }
            case STAMINA_BAR: {
                this.applyStaminaResizing(config, deltaX, deltaY);
                break;
            }
            case ARMOR_BAR: {
                this.applyArmorResizing(config, deltaX, deltaY);
                break;
            }
            case AIR_BAR: {
                this.applyAirResizing(config, deltaX, deltaY);
            }
        }
    }

    private void applyHealthResizing(ClientConfig config, int deltaX, int deltaY) {
        switch (this.resizingSubElement) {
            case BACKGROUND: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.healthBackgroundWidth = Math.max(10, this.initialWidth + deltaX);
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.healthBackgroundHeight = Math.max(4, this.initialHeight + deltaY);
                break;
            }
            case BAR_MAIN: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.healthBarWidth = Math.max(4, Math.min(256, this.initialWidth + deltaX));
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.healthBarHeight = Math.max(1, Math.min(32, this.initialHeight + deltaY));
                break;
            }
            case FOREGROUND_DETAIL: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.healthOverlayWidth = Math.max(10, Math.min(256, this.initialWidth + deltaX));
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.healthOverlayHeight = Math.max(4, Math.min(256, this.initialHeight + deltaY));
            }
        }
    }

    private void applyManaResizing(ClientConfig config, int deltaX, int deltaY) {
        switch (this.resizingSubElement) {
            case BACKGROUND: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.manaBackgroundWidth = Math.max(10, this.initialWidth + deltaX);
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.manaBackgroundHeight = Math.max(4, this.initialHeight + deltaY);
                break;
            }
            case BAR_MAIN: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.manaBarWidth = Math.max(4, Math.min(256, this.initialWidth + deltaX));
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.manaBarHeight = Math.max(1, Math.min(32, this.initialHeight + deltaY));
                break;
            }
            case FOREGROUND_DETAIL: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.manaOverlayWidth = Math.max(10, Math.min(256, this.initialWidth + deltaX));
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.manaOverlayHeight = Math.max(4, Math.min(256, this.initialHeight + deltaY));
            }
        }
    }

    private void applyStaminaResizing(ClientConfig config, int deltaX, int deltaY) {
        switch (this.resizingSubElement) {
            case BACKGROUND: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.staminaBackgroundWidth = Math.max(10, this.initialWidth + deltaX);
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.staminaBackgroundHeight = Math.max(4, this.initialHeight + deltaY);
                break;
            }
            case BAR_MAIN: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.staminaBarWidth = Math.max(4, Math.min(256, this.initialWidth + deltaX));
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.staminaBarHeight = Math.max(1, Math.min(32, this.initialHeight + deltaY));
                break;
            }
            case FOREGROUND_DETAIL: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.staminaOverlayWidth = Math.max(10, Math.min(256, this.initialWidth + deltaX));
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.staminaOverlayHeight = Math.max(4, Math.min(256, this.initialHeight + deltaY));
            }
        }
    }

    private void applyArmorResizing(ClientConfig config, int deltaX, int deltaY) {
        switch (this.resizingSubElement) {
            case BACKGROUND: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.armorBackgroundWidth = Math.max(10, this.initialWidth + deltaX);
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.armorBackgroundHeight = Math.max(4, this.initialHeight + deltaY);
                break;
            }
            case BAR_MAIN: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.armorBarWidth = Math.max(4, Math.min(256, this.initialWidth + deltaX));
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.armorBarHeight = Math.max(1, Math.min(32, this.initialHeight + deltaY));
            }
        }
    }

    private void applyAirResizing(ClientConfig config, int deltaX, int deltaY) {
        switch (this.resizingSubElement) {
            case BACKGROUND: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.airBackgroundWidth = Math.max(10, this.initialWidth + deltaX);
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.airBackgroundHeight = Math.max(4, this.initialHeight + deltaY);
                break;
            }
            case BAR_MAIN: {
                if (this.currentResizeMode == ResizeMode.WIDTH) {
                    config.airBarWidth = Math.max(4, Math.min(256, this.initialWidth + deltaX));
                    break;
                }
                if (this.currentResizeMode != ResizeMode.HEIGHT) break;
                config.airBarHeight = Math.max(1, Math.min(32, this.initialHeight + deltaY));
            }
        }
    }

    private void finishResize() {
        if (this.currentResizeMode != ResizeMode.NONE) {
            this.currentResizeMode = ResizeMode.NONE;
            this.focusedElementForResize = null;
            this.resizingSubElement = null;
        }
    }

    public void method_25419() {
        if (EditModeManager.isEditModeEnabled()) {
            EditModeManager.toggleEditMode();
        }
        if (EditModeManager.getFocusedElement() != null) {
            EditModeManager.clearFocusedElement();
        }
        ClientConfig.getInstance().save();
        this.field_22787.method_1507(this.previousScreen);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25422() {
        return EditModeManager.getFocusedElement() == null;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && EditModeManager.getFocusedElement() != null) {
            EditModeManager.clearFocusedElement();
            this.rebuildEditorWidgets();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_37067() {
        this.field_33816.clear();
        this.method_25396().clear();
    }

    private void resetPositionDefaultsAction(DraggableElement element) {
        ClientConfig config = ModConfigManager.getClient();
        if (element == null) {
            return;
        }
        HUDPositioning.BarPlacement defaultAnchor = null;
        boolean defaultTotalY = false;
        int defaultBgWidthForCalc = 0;
        switch (element) {
            case HEALTH_BAR: {
                defaultAnchor = ClientConfig.DEFAULT_HEALTH_BAR_ANCHOR;
                defaultBgWidthForCalc = 80;
                config.healthBarAnchor = defaultAnchor;
                config.healthBarXOffset = 3;
                config.healthBarYOffset = 3;
                config.healthOverlayXOffset = 0;
                config.healthOverlayYOffset = -3;
                config.healthBackgroundXOffset = 0;
                config.healthBackgroundYOffset = 0;
                config.healthTotalYOffset = 0;
                config.healthTextXOffset = 3;
                config.healthTextYOffset = 3;
                config.healthAbsorptionTextXOffset = 65;
                config.healthAbsorptionTextYOffset = 3;
                break;
            }
            case STAMINA_BAR: {
                defaultAnchor = ClientConfig.DEFAULT_STAMINA_BAR_ANCHOR;
                defaultBgWidthForCalc = 80;
                config.staminaBarAnchor = defaultAnchor;
                config.staminaBarXOffset = 3;
                config.staminaBarYOffset = 3;
                config.staminaOverlayXOffset = 0;
                config.staminaOverlayYOffset = -3;
                config.staminaBackgroundXOffset = 0;
                config.staminaBackgroundYOffset = 0;
                config.staminaTotalYOffset = 0;
                config.staminaTextXOffset = 3;
                config.staminaTextYOffset = 3;
                break;
            }
            case MANA_BAR: {
                defaultAnchor = ClientConfig.DEFAULT_MANA_BAR_ANCHOR;
                defaultBgWidthForCalc = 80;
                config.manaBarAnchor = defaultAnchor;
                config.manaBarXOffset = 3;
                config.manaBarYOffset = 3;
                config.manaOverlayXOffset = 0;
                config.manaOverlayYOffset = -3;
                config.manaBackgroundXOffset = 0;
                config.manaBackgroundYOffset = 0;
                config.manaTotalYOffset = 0;
                config.manaTextXOffset = 3;
                config.manaTextYOffset = 3;
                break;
            }
            case ARMOR_BAR: {
                defaultAnchor = ClientConfig.DEFAULT_ARMOR_BAR_ANCHOR;
                defaultBgWidthForCalc = 80;
                config.armorBarAnchor = defaultAnchor;
                config.armorBarXOffset = 3;
                config.armorBarYOffset = 3;
                config.armorTotalYOffset = 0;
                config.armorTextXOffset = 3;
                config.armorTextYOffset = 3;
                config.armorIconXOffset = 0;
                config.armorIconYOffset = -4;
                config.armorBackgroundXOffset = 0;
                config.armorBackgroundYOffset = 0;
                break;
            }
            case AIR_BAR: {
                defaultAnchor = ClientConfig.DEFAULT_AIR_BAR_ANCHOR;
                defaultBgWidthForCalc = 80;
                config.airBarAnchor = defaultAnchor;
                config.airBarXOffset = 3;
                config.airBarYOffset = 3;
                config.airTotalYOffset = 0;
                config.airTextXOffset = 3;
                config.airTextYOffset = 3;
                config.airIconXOffset = 66;
                config.airIconYOffset = -4;
                config.airBackgroundXOffset = 0;
                config.airBackgroundYOffset = 0;
                break;
            }
            default: {
                return;
            }
        }
        int newDefaultTotalX = 0;
        if (defaultAnchor == HUDPositioning.BarPlacement.ABOVE_UTILITIES) {
            newDefaultTotalX = -defaultBgWidthForCalc / 2;
        } else if (defaultAnchor != null && defaultAnchor.getSide() == HUDPositioning.AnchorSide.RIGHT) {
            newDefaultTotalX = -defaultBgWidthForCalc;
        }
        switch (element) {
            case HEALTH_BAR: {
                config.healthTotalXOffset = newDefaultTotalX;
                break;
            }
            case STAMINA_BAR: {
                config.staminaTotalXOffset = newDefaultTotalX;
                break;
            }
            case MANA_BAR: {
                config.manaTotalXOffset = newDefaultTotalX;
                break;
            }
            case ARMOR_BAR: {
                config.armorTotalXOffset = newDefaultTotalX;
                break;
            }
            case AIR_BAR: {
                config.airTotalXOffset = newDefaultTotalX;
            }
        }
        this.rebuildEditorWidgets();
    }

    private void resetSizeDefaultsAction(DraggableElement element) {
        ClientConfig config = ModConfigManager.getClient();
        if (element == null) {
            return;
        }
        switch (element) {
            case HEALTH_BAR: {
                config.healthBackgroundWidth = 80;
                config.healthBackgroundHeight = 10;
                config.healthBarWidth = 74;
                config.healthBarHeight = 4;
                config.healthOverlayWidth = 80;
                config.healthOverlayHeight = 10;
                break;
            }
            case STAMINA_BAR: {
                config.staminaBackgroundWidth = 80;
                config.staminaBackgroundHeight = 10;
                config.staminaBarWidth = 74;
                config.staminaBarHeight = 4;
                config.staminaOverlayWidth = 80;
                config.staminaOverlayHeight = 10;
                break;
            }
            case MANA_BAR: {
                config.manaBackgroundWidth = 80;
                config.manaBackgroundHeight = 10;
                config.manaBarWidth = 74;
                config.manaBarHeight = 4;
                config.manaOverlayWidth = 81;
                config.manaOverlayHeight = 9;
                break;
            }
            case ARMOR_BAR: {
                config.armorBackgroundWidth = 80;
                config.armorBackgroundHeight = 10;
                config.armorBarWidth = 74;
                config.armorBarHeight = 4;
                break;
            }
            case AIR_BAR: {
                config.airBackgroundWidth = 80;
                config.airBackgroundHeight = 10;
                config.airBarWidth = 74;
                config.airBarHeight = 4;
            }
        }
        this.rebuildEditorWidgets();
    }

    private void resetAllDefaultsAction() {
        this.resetPositionDefaultsAction(DraggableElement.HEALTH_BAR);
        this.resetSizeDefaultsAction(DraggableElement.HEALTH_BAR);
        this.resetVisualDefaultsAction(DraggableElement.HEALTH_BAR);
        this.resetPositionDefaultsAction(DraggableElement.STAMINA_BAR);
        this.resetSizeDefaultsAction(DraggableElement.STAMINA_BAR);
        this.resetVisualDefaultsAction(DraggableElement.STAMINA_BAR);
        this.resetPositionDefaultsAction(DraggableElement.MANA_BAR);
        this.resetSizeDefaultsAction(DraggableElement.MANA_BAR);
        this.resetVisualDefaultsAction(DraggableElement.MANA_BAR);
        this.resetPositionDefaultsAction(DraggableElement.ARMOR_BAR);
        this.resetSizeDefaultsAction(DraggableElement.ARMOR_BAR);
        this.resetVisualDefaultsAction(DraggableElement.ARMOR_BAR);
        this.resetPositionDefaultsAction(DraggableElement.AIR_BAR);
        this.resetSizeDefaultsAction(DraggableElement.AIR_BAR);
        this.resetVisualDefaultsAction(DraggableElement.AIR_BAR);
        this.rebuildEditorWidgets();
    }

    private void resetVisualDefaultsAction(DraggableElement element) {
        ClientConfig config = ModConfigManager.getClient();
        if (element == null) {
            return;
        }
        switch (element) {
            case HEALTH_BAR: {
                config.enableHealthBar = true;
                config.enableHealthBackground = true;
                config.enableHealthForeground = false;
                config.fadeHealthWhenFull = false;
                config.showHealthText = ClientConfig.DEFAULT_SHOW_HEALTH_TEXT;
                config.healthTextAlign = ClientConfig.DEFAULT_HEALTH_TEXT_ALIGN;
                config.healthFillDirection = ClientConfig.DEFAULT_HEALTH_FILL_DIRECTION;
                break;
            }
            case STAMINA_BAR: {
                config.staminaBarBehavior = ClientConfig.DEFAULT_STAMINA_BAR_BEHAVIOR;
                config.enableStaminaBackground = true;
                config.enableStaminaForeground = false;
                config.fadeStaminaWhenFull = false;
                config.showStaminaText = ClientConfig.DEFAULT_SHOW_STAMINA_TEXT;
                config.staminaTextAlign = ClientConfig.DEFAULT_STAMINA_TEXT_ALIGN;
                config.staminaFillDirection = ClientConfig.DEFAULT_STAMINA_FILL_DIRECTION;
                break;
            }
            case MANA_BAR: {
                config.manaBarBehavior = ClientConfig.DEFAULT_MANA_BAR_BEHAVIOR;
                config.enableManaBackground = true;
                config.enableManaForeground = true;
                config.fadeManaWhenFull = true;
                config.showManaText = ClientConfig.DEFAULT_SHOW_MANA_TEXT;
                config.manaTextAlign = ClientConfig.DEFAULT_MANA_TEXT_ALIGN;
                config.manaFillDirection = ClientConfig.DEFAULT_MANA_FILL_DIRECTION;
                break;
            }
            case ARMOR_BAR: {
                config.armorBarBehavior = ClientConfig.DEFAULT_ARMOR_BAR_BEHAVIOR;
                config.enableArmorIcon = true;
                config.showArmorText = ClientConfig.DEFAULT_SHOW_ARMOR_TEXT;
                config.armorTextAlign = ClientConfig.DEFAULT_ARMOR_TEXT_ALIGN;
                break;
            }
            case AIR_BAR: {
                config.airBarBehavior = ClientConfig.DEFAULT_AIR_BAR_BEHAVIOR;
                config.enableAirIcon = true;
                config.showAirText = ClientConfig.DEFAULT_SHOW_AIR_TEXT;
                config.airTextAlign = ClientConfig.DEFAULT_AIR_TEXT_ALIGN;
            }
        }
    }

    private void openConfirmScreen(class_2561 title, class_2561 explanation, Runnable confirmAction) {
        this.field_22787.method_1507((class_437)new ConfirmResetScreen(this, title, explanation, confirmAction));
    }

    private class_2561 getFriendlyElementName(DraggableElement element) {
        if (element == null) {
            return class_2561.method_43470((String)"None");
        }
        return switch (element) {
            case DraggableElement.HEALTH_BAR -> class_2561.method_43471((String)"gui.dynamic_resource_bars.element.health");
            case DraggableElement.MANA_BAR -> class_2561.method_43471((String)"gui.dynamic_resource_bars.element.mana");
            case DraggableElement.STAMINA_BAR -> class_2561.method_43471((String)"gui.dynamic_resource_bars.element.stamina");
            case DraggableElement.ARMOR_BAR -> class_2561.method_43471((String)"gui.dynamic_resource_bars.element.armor");
            case DraggableElement.AIR_BAR -> class_2561.method_43471((String)"gui.dynamic_resource_bars.element.air");
            default -> class_2561.method_43470((String)"Unknown Element");
        };
    }

    private class_2561 getBarBehaviorComponent(BarRenderBehavior behavior, String barTypeKey) {
        String behaviorKey = "bar_behavior." + behavior.name().toLowerCase();
        return class_2561.method_43469((String)("gui.dynamic_resource_bars.hud_editor.button." + barTypeKey + "_behavior_format"), (Object[])new Object[]{class_2561.method_43471((String)behaviorKey)});
    }

    private int getOutlineColorForSubElement(DraggableElement focusedElement, SubElementType subElementType) {
        if (focusedElement == null || subElementType == null) {
            return -1;
        }
        switch (subElementType) {
            case BACKGROUND: {
                return -1593835776;
            }
            case BAR_MAIN: {
                switch (focusedElement) {
                    case HEALTH_BAR: {
                        return -1610547456;
                    }
                    case MANA_BAR: {
                        return -1610547201;
                    }
                    case STAMINA_BAR: {
                        return -1593858816;
                    }
                    case ARMOR_BAR: {
                        return -1597980480;
                    }
                    case AIR_BAR: {
                        return -1599219482;
                    }
                }
                return -1;
            }
            case FOREGROUND_DETAIL: {
                return -1593900801;
            }
        }
        return -1;
    }

    private ManaBarBehavior getNextAvailableManaBarBehavior(ManaBarBehavior current) {
        ManaBarBehavior next = current;
        int attempts = 0;
        do {
            next = next.getNext();
            if (++attempts <= ManaBarBehavior.values().length) continue;
            return ManaBarBehavior.OFF;
        } while (next != ManaBarBehavior.OFF && !this.isManaModAvailable(next));
        return next;
    }

    private boolean isManaModAvailable(ManaBarBehavior behavior) {
        switch (behavior) {
            case OFF: {
                return true;
            }
            case IRONS_SPELLBOOKS: {
                return PlatformUtil.isModLoaded("irons_spellbooks");
            }
            case ARS_NOUVEAU: {
                return PlatformUtil.isModLoaded("ars_nouveau");
            }
            case RPG_MANA: {
                return PlatformUtil.isModLoaded("rpgmana");
            }
            case MANA_ATTRIBUTES: {
                return PlatformUtil.isModLoaded("manaattributes");
            }
        }
        return false;
    }

    private class_2561 getManaBarBehaviorComponent(ManaBarBehavior behavior) {
        class_5250 behaviorText = switch (behavior) {
            default -> throw new MatchException(null, null);
            case ManaBarBehavior.OFF -> class_2561.method_43471((String)"gui.dynamic_resource_bars.behavior.off");
            case ManaBarBehavior.IRONS_SPELLBOOKS -> class_2561.method_43471((String)"gui.dynamic_resource_bars.mana_behavior.irons_spellbooks");
            case ManaBarBehavior.ARS_NOUVEAU -> class_2561.method_43471((String)"gui.dynamic_resource_bars.mana_behavior.ars_nouveau");
            case ManaBarBehavior.RPG_MANA -> class_2561.method_43471((String)"gui.dynamic_resource_bars.mana_behavior.rpg_mana");
            case ManaBarBehavior.MANA_ATTRIBUTES -> class_2561.method_43471((String)"gui.dynamic_resource_bars.mana_behavior.mana_attributes");
        };
        return class_2561.method_43469((String)"gui.dynamic_resource_bars.mana_format", (Object[])new Object[]{behaviorText});
    }

    private class_2561 getStaminaBarBehaviorComponent(StaminaBarBehavior behavior) {
        class_5250 behaviorText = switch (behavior) {
            default -> throw new MatchException(null, null);
            case StaminaBarBehavior.OFF -> class_2561.method_43471((String)"gui.dynamic_resource_bars.behavior.off");
            case StaminaBarBehavior.FOOD -> class_2561.method_43471((String)"gui.dynamic_resource_bars.stamina_bar_behavior.food");
            case StaminaBarBehavior.STAMINA_ATTRIBUTES -> class_2561.method_43471((String)"gui.dynamic_resource_bars.stamina_bar_behavior.stamina_attributes");
        };
        return class_2561.method_43469((String)"gui.dynamic_resource_bars.stamina_format", (Object[])new Object[]{behaviorText});
    }

    private StaminaBarBehavior getNextAvailableStaminaBarBehavior(StaminaBarBehavior current) {
        StaminaBarBehavior next = current.getNext();
        for (int attempts = 0; !this.isStaminaProviderAvailable(next) && attempts < StaminaBarBehavior.values().length; ++attempts) {
            next = next.getNext();
        }
        return next;
    }

    private boolean isStaminaProviderAvailable(StaminaBarBehavior behavior) {
        return switch (behavior) {
            default -> throw new MatchException(null, null);
            case StaminaBarBehavior.OFF, StaminaBarBehavior.FOOD -> true;
            case StaminaBarBehavior.STAMINA_ATTRIBUTES -> StaminaProviderManager.isModLoaded("staminaattributes");
        };
    }

    private static enum ResizeMode {
        NONE,
        WIDTH,
        HEIGHT;

    }

    private static class ResizeData {
        final DraggableElement element;
        final SubElementType subElement;
        final ResizeMode mode;
        final int initialWidth;
        final int initialHeight;

        ResizeData(DraggableElement element, SubElementType subElement, ResizeMode mode, int initialWidth, int initialHeight) {
            this.element = element;
            this.subElement = subElement;
            this.mode = mode;
            this.initialWidth = initialWidth;
            this.initialHeight = initialHeight;
        }
    }
}

