/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.dynamic_resource_bars.compat;

import dev.muon.dynamic_resource_bars.util.PlatformUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_4174;
import squeek.appleskin.helpers.FoodHelper;

public class AppleSkinCompat {
    private static final boolean APPLESKIN_LOADED = PlatformUtil.isModLoaded("appleskin");

    public static boolean isLoaded() {
        return APPLESKIN_LOADED;
    }

    public static FoodData getFoodValues(class_1799 stack, class_1657 player) {
        if (!APPLESKIN_LOADED || stack.method_7960() || !AppleSkinCompat.canConsume(stack, player)) {
            return FoodData.EMPTY;
        }
        FoodHelper.QueriedFoodResult queriedResult = FoodHelper.query((class_1799)stack, (class_1657)player);
        if (queriedResult == null) {
            return FoodData.EMPTY;
        }
        return new FoodData(queriedResult.modifiedFoodComponent.comp_2491(), queriedResult.modifiedFoodComponent.comp_2492());
    }

    public static boolean canConsume(class_1799 stack, class_1657 player) {
        if (!APPLESKIN_LOADED || stack.method_7960()) {
            return false;
        }
        FoodHelper.QueriedFoodResult result = FoodHelper.query((class_1799)stack, (class_1657)player);
        return result != null && FoodHelper.canConsume((class_1657)player, (class_4174)result.modifiedFoodComponent);
    }

    public static float getEstimatedHealthRestoration(class_1799 stack, class_1657 player) {
        if (!APPLESKIN_LOADED || !AppleSkinCompat.canConsume(stack, player)) {
            return 0.0f;
        }
        FoodHelper.QueriedFoodResult queriedResult = FoodHelper.query((class_1799)stack, (class_1657)player);
        if (queriedResult == null) {
            return 0.0f;
        }
        return FoodHelper.getEstimatedHealthIncrement((class_1657)player, (class_4174)queriedResult.modifiedFoodComponent);
    }

    public static class FoodData {
        public static final FoodData EMPTY = new FoodData(0, 0.0f);
        public final int hunger;
        public final float saturation;

        public FoodData(int hunger, float saturation) {
            this.hunger = hunger;
            this.saturation = saturation;
        }

        public boolean isEmpty() {
            return this.hunger <= 0 && this.saturation <= 0.0f;
        }
    }
}

