/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.fabric.compat;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;
import net.spell_engine.compat.accessories.AccessoriesCompat;
import net.spell_engine.fabric.compat.FabricCompatConfig;
import net.spell_engine.fabric.compat.trinkets.TrinketsCompat;
import net.tiny_config.ConfigManager;

public class FabricCompatFeatures {
    private static final ConfigManager<FabricCompatConfig> config = new ConfigManager("fabric_compatibility", (Object)new FabricCompatConfig()).builder().setDirectory("spell_engine").sanitize(true).build();
    private static String selectedSlotMod = null;

    private static FabricCompatConfig safeConfig() {
        return (FabricCompatConfig)config.safeValue();
    }

    public static void initialize() {
        FabricCompatFeatures.initSlotCompat();
    }

    public static String initSlotCompat() {
        FabricCompatConfig loadedConfig = FabricCompatFeatures.safeConfig();
        if (selectedSlotMod != null) {
            return selectedSlotMod;
        }
        LinkedHashMap<String, Supplier> compatLoaders = new LinkedHashMap<String, Supplier>();
        if (FabricLoader.getInstance().isModLoaded("accessories")) {
            compatLoaders.put("accessories", AccessoriesCompat::init);
        }
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            compatLoaders.put("trinkets", TrinketsCompat::init);
        }
        String preferredId = loadedConfig.preferred_slot_mod;
        Supplier preferred = (Supplier)compatLoaders.get(loadedConfig.preferred_slot_mod);
        if (preferred != null) {
            compatLoaders.remove(preferredId);
            compatLoaders.putFirst(preferredId, preferred);
        }
        for (Map.Entry entry : compatLoaders.entrySet()) {
            String modName = (String)entry.getKey();
            Boolean initialized = (Boolean)((Supplier)entry.getValue()).get();
            if (!initialized.booleanValue()) continue;
            selectedSlotMod = modName;
            Optional container = FabricLoader.getInstance().getModContainer("spell_engine");
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)"spell_engine", (String)(modName + "_compat")), (ModContainer)((ModContainer)container.get()), (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
            return modName;
        }
        return null;
    }
}

