/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.oathswornpaladins.spells;

import com.cleannrooster.oathswornpaladins.OathswornPaladins;
import com.cleannrooster.oathswornpaladins.PaladinSchools;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.spell_engine.api.spell.ExternalSpellSchools;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import org.jetbrains.annotations.Nullable;

public class OathSpells {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static Entry lesser_divine_smite = OathSpells.add(OathSpells.lesser_divine_smite());
    private static Entry overpower = OathSpells.add(OathSpells.overpower());
    private static Entry divine_smite = OathSpells.add(OathSpells.divine_smite());
    private static Entry fervor = OathSpells.add(OathSpells.fervor());
    private static Entry vengeance = OathSpells.add(OathSpells.vengeance());
    private static Entry time_of_need = OathSpells.add(OathSpells.time_of_need());
    private static Entry shield_throw = OathSpells.add(OathSpells.shield_throw());
    public static Entry shield_pummel = OathSpells.add(OathSpells.shield_pummel());
    private static Entry rally = OathSpells.add(OathSpells.rally());
    private static Entry rebuke = OathSpells.add(OathSpells.rebuke());
    private static Entry seraph_strike = OathSpells.add(OathSpells.seraph_strike());
    private static Entry sigil_of_hope = OathSpells.add(OathSpells.sigil_of_hope());
    private static Entry divine_intervention = OathSpells.add(OathSpells.divine_intervention());

    private static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static ParticleBatch healCastingParticles() {
        return new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPELL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 1.0f, 0.05f, 0.1f);
    }

    private static ParticleBatch arcaneCastingParticles() {
        return new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPELL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 1.0f, 0.05f, 0.1f);
    }

    private static ParticleBatch fireCastingParticles() {
        return new ParticleBatch(SpellEngineParticles.flame.id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 1.0f, 0.05f, 0.1f);
    }

    private static ParticleBatch frostCastingParticles() {
        return new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPELL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 1.0f, 0.05f, 0.1f);
    }

    public static Spell activeSpellBase() {
        Spell spell = new Spell();
        spell.range = 0.0f;
        spell.tier = 7;
        spell.learn = new Spell.Learn();
        spell.type = Spell.Type.ACTIVE;
        spell.active = new Spell.Active();
        return spell;
    }

    private static Spell passiveSpellBase() {
        Spell spell = new Spell();
        spell.range = 0.0f;
        spell.tier = 7;
        spell.type = Spell.Type.PASSIVE;
        spell.passive = new Spell.Passive();
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.name = new Spell.Tooltip.LineOptions(true, true);
        spell.tooltip.description.color = class_124.field_1077.method_15434();
        spell.tooltip.description.show_in_compact = false;
        return spell;
    }

    private static Spell.Delivery createDelivery(Spell.Delivery.Type type) {
        Spell.Delivery delivery = new Spell.Delivery();
        delivery.type = type;
        return delivery;
    }

    private static Spell.Impact createImpact(Spell.Impact.Action.Type type, float coeff, float knockback) {
        Spell.Impact impact = new Spell.Impact();
        impact.action = new Spell.Impact.Action();
        impact.action.type = type;
        if (type == Spell.Impact.Action.Type.DAMAGE) {
            impact.action.damage = new Spell.Impact.Action.Damage();
            impact.action.damage.knockback = knockback;
            impact.action.damage.spell_power_coefficient = coeff;
        } else if (type == Spell.Impact.Action.Type.HEAL) {
            impact.action.heal = new Spell.Impact.Action.Heal();
            impact.action.heal.spell_power_coefficient = coeff;
        }
        return impact;
    }

    public static Spell.Impact createArcaneImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = OathSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = SpellSchools.ARCANE;
        ParticleBatch[] hitParticles = new ParticleBatch[]{new ParticleBatch("spell_engine:magic_arcane_impact_burst", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f)};
        impact.particles = hitParticles;
        impact.sound = sound = new Sound(SpellEngineSounds.GENERIC_ARCANE_RELEASE.id());
        return impact;
    }

    public static Spell.Impact createArmorImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = OathSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = PaladinSchools.ARMOR;
        impact.sound = sound = new Sound("minecraft:entity.player.attack.crit");
        return impact;
    }

    public static Spell.Impact createLightningImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = OathSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = SpellSchools.LIGHTNING;
        ParticleBatch[] hitParticles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPELL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f)};
        impact.particles = hitParticles;
        impact.sound = sound = new Sound(SpellEngineSounds.GENERIC_LIGHTNING_RELEASE.id());
        return impact;
    }

    private static Spell.Impact.TargetModifier createImpactModifier(String entityType) {
        Spell.TargetCondition condition = new Spell.TargetCondition();
        condition.entity_type = entityType;
        Spell.Impact.TargetModifier modifier = new Spell.Impact.TargetModifier();
        modifier.conditions = List.of(condition);
        return modifier;
    }

    private static Spell.Impact.TargetModifier extraCritAgainstUndead() {
        Spell.Impact.TargetModifier modifier = OathSpells.createImpactModifier("#minecraft:undead");
        Spell.Impact.Modifier powerModifier = new Spell.Impact.Modifier();
        powerModifier.critical_chance_bonus = 1.0f;
        modifier.modifier = powerModifier;
        return modifier;
    }

    public static Spell.Impact createHolyImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = OathSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.target_modifiers = List.of(OathSpells.extraCritAgainstUndead());
        impact.school = SpellSchools.HEALING;
        ParticleBatch[] hitParticles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPELL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f)};
        impact.particles = hitParticles;
        impact.sound = sound = new Sound(SpellEngineSounds.GENERIC_HEALING_IMPACT_1.id());
        return impact;
    }

    private static Spell.Impact createFrostImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = OathSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = SpellSchools.FROST;
        ParticleBatch[] hitParticles = new ParticleBatch[]{new ParticleBatch("spell_engine:magic_frost_impact_burst", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f)};
        impact.particles = hitParticles;
        impact.sound = sound = new Sound(SpellEngineSounds.GENERIC_FROST_IMPACT.id());
        return impact;
    }

    private static Spell.Impact createFireImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = OathSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = SpellSchools.FIRE;
        ParticleBatch[] hitParticles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame_spark.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f), new ParticleBatch("minecraft:smoke", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f)};
        impact.particles = hitParticles;
        impact.sound = sound = new Sound("minecraft:entity.player.hurt_on_fire");
        return impact;
    }

    public static Spell.Impact createHealingImpact(float coeff, float knockback) {
        Spell.Impact impact = OathSpells.createImpact(Spell.Impact.Action.Type.HEAL, coeff, knockback);
        impact.school = SpellSchools.HEALING;
        impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.HEAL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.PIPE, ParticleBatch.Origin.FEET, null, 20.0f, 0.2f, 0.7f, 360.0f).color(Color.GREEN.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.HEAL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.PIPE, ParticleBatch.Origin.FEET, null, 20.0f, 0.1f, 0.35f, 360.0f).color(Color.GREEN.toRGBA())};
        impact.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_IMPACT_1.id());
        return impact;
    }

    private static Spell.Impact createPhysicalimpact(float coeff, float knockback) {
        Spell.Impact impact = OathSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = ExternalSpellSchools.PHYSICAL_MELEE;
        return impact;
    }

    private static Spell.Active.Cast createCast(int channelticks, float duration, String sound, String animation, @Nullable SpellSchool school) {
        Spell.Active.Cast cast = new Spell.Active.Cast();
        cast = new Spell.Active.Cast();
        cast.animation = animation;
        cast.sound = new Sound(sound);
        cast.channel_ticks = channelticks;
        cast.duration = duration;
        if (school != null) {
            if (school.equals(SpellSchools.FIRE)) {
                cast.particles = new ParticleBatch[]{OathSpells.fireCastingParticles()};
            }
            if (school.equals(SpellSchools.FROST)) {
                cast.particles = new ParticleBatch[]{OathSpells.frostCastingParticles()};
            }
            if (school.equals(SpellSchools.ARCANE)) {
                cast.particles = new ParticleBatch[]{OathSpells.arcaneCastingParticles()};
            }
            if (school.equals(SpellSchools.HEALING)) {
                cast.particles = new ParticleBatch[]{OathSpells.healCastingParticles()};
            }
        }
        return cast;
    }

    private static void configureCooldown(Spell spell, float duration, boolean proportional, @Nullable String id) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        if (spell.cost.cooldown == null) {
            spell.cost.cooldown = new Spell.Cost.Cooldown();
        }
        if (id != null) {
            spell.cost.item = new Spell.Cost.Item();
            spell.cost.item.id = id;
            spell.cost.item.amount = 1;
        }
        if (proportional) {
            spell.cost.cooldown.proportional = true;
        }
        spell.cost.cooldown.duration = duration;
    }

    private static Spell projectileBase(SpellSchool school, class_2960 projIdentifier, float coeff, float velocity, float knockback) {
        Spell spell = OathSpells.activeSpellBase();
        spell.school = school;
        Spell.Delivery delivery = OathSpells.createDelivery(Spell.Delivery.Type.PROJECTILE);
        delivery.projectile = new Spell.Delivery.ShootProjectile();
        delivery.projectile.launch_properties.velocity = velocity;
        delivery.projectile.projectile = new Spell.ProjectileData();
        delivery.projectile.projectile.client_data = new Spell.ProjectileData.Client();
        Spell.ProjectileModel model = new Spell.ProjectileModel();
        model.model_id = String.valueOf(projIdentifier);
        delivery.projectile.projectile.client_data.model = model;
        spell.deliver = delivery;
        Spell.Impact[] impact = new Spell.Impact[]{OathSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback)};
        spell.impacts = List.of(impact[0]);
        return spell;
    }

    private static Spell meteor_base(SpellSchool school, class_2960 projIdentifier, float velocity, float knockback) {
        Spell spell = OathSpells.activeSpellBase();
        spell.school = school;
        Spell.Delivery delivery = OathSpells.createDelivery(Spell.Delivery.Type.METEOR);
        delivery.meteor = new Spell.Delivery.Meteor();
        delivery.meteor.launch_properties.velocity = velocity;
        delivery.meteor.projectile = new Spell.ProjectileData();
        delivery.meteor.projectile.client_data = new Spell.ProjectileData.Client();
        Spell.ProjectileModel model = new Spell.ProjectileModel();
        model.model_id = String.valueOf(projIdentifier);
        delivery.meteor.projectile.client_data.model = model;
        spell.deliver = delivery;
        Spell.Impact[] impact = new Spell.Impact[]{OathSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, 1.8f, knockback)};
        spell.impacts = List.of(impact[0]);
        return spell;
    }

    public static Entry lesser_divine_smite() {
        class_2960 id = class_2960.method_60655((String)"oathswornpaladins", (String)"lesser_divine_smite");
        String description = "On melee hit: 100% chance to deal arcane damage in an cone in front of you.";
        String title = "Lesser Divine Smite";
        Spell spell = OathSpells.passiveSpellBase();
        spell.tier = 0;
        spell.range = 6.0f;
        spell.learn = new Spell.Learn();
        spell.school = SpellSchools.HEALING;
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 1.0f;
        trigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        trigger.spell = new Spell.Trigger.SpellCondition();
        trigger.spell.archetype = SpellSchool.Archetype.MAGIC;
        spell.target = new Spell.Target();
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        spell.deliver = new Spell.Delivery();
        spell.deliver.type = Spell.Delivery.Type.DIRECT;
        spell.passive.triggers = List.of(trigger);
        spell.release.sound = new Sound(SpellEngineSounds.GENERIC_LIGHTNING_RELEASE.id());
        Spell.Impact[] impacts = new Spell.Impact[]{OathSpells.createHolyImpact(0.9f, 0.2f)};
        impacts[0].action.min_power = 2.0f;
        spell.impacts = List.of(impacts);
        OathSpells.configureCooldown(spell, 1.0f, false, null);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry overpower() {
        Spell spell = OathSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        class_2960 id = class_2960.method_60655((String)"oathswornpaladins", (String)"overpower");
        String description = "Shoot a feather projectile, dealing {damage} fire damage to the first enemy hit.";
        String title = "Exploding Feathers";
        spell.learn = new Spell.Learn();
        spell.tier = 4;
        spell.range = 0.0f;
        spell.range_mechanic = Spell.RangeMechanic.MELEE;
        spell.active.cast = OathSpells.createCast(0, 0.0f, SpellEngineSounds.GENERIC_HEALING_CASTING.id().toString(), "spell_engine:sword_swing_first", SpellSchools.HEALING);
        spell.target = new Spell.Target();
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.target.aim.required = true;
        Spell.Impact impact = OathSpells.createHolyImpact(0.6f, 0.2f);
        Spell.Impact impact2 = OathSpells.createPhysicalimpact(1.0f, 1.0f);
        Spell.Impact impact3 = new Spell.Impact();
        impact3.action = new Spell.Impact.Action();
        impact3.action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        impact3.action.status_effect = new Spell.Impact.Action.StatusEffect();
        impact3.action.status_effect.effect_id = "spellbladenext:sundered";
        impact3.action.status_effect.duration = 4.0f;
        impact3.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.SET;
        impact3.action.status_effect.amplifier = 0;
        impact2.sound = new Sound("minecraft:entity.player.attack.crit");
        Spell.Impact[] impacts = new Spell.Impact[]{impact, impact2, impact3};
        spell.release = new Spell.Release();
        spell.release.animation = "spellbladenext:sword_swing_first";
        spell.impacts = List.of(impacts);
        OathSpells.configureCooldown(spell, 12.0f, false, "runes:healing_stone");
        return new Entry(id, spell, title, description, null);
    }

    private static Entry divine_smite() {
        Spell spell = OathSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        class_2960 id = class_2960.method_60655((String)"oathswornpaladins", (String)"divine_smite");
        String description = "Shoot a feather projectile, dealing {damage} fire damage to the first enemy hit.";
        String title = "Exploding Feathers";
        spell.learn = new Spell.Learn();
        spell.tier = 1;
        spell.range = 0.0f;
        spell.active.cast = OathSpells.createCast(0, 1.0f, SpellEngineSounds.GENERIC_HEALING_CASTING.id().toString(), "spell_engine:one_handed_healing_charge", SpellSchools.HEALING);
        ParticleBatch[] particlebatch = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 30.0f, 0.8f, 1.0f, 0.0f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.HOLY, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 10.0f, 0.5f, 1.0f, 0.0f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.STRIPE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 10.0f, 0.5f, 1.0f, 0.0f).color(Color.HOLY.toRGBA())};
        spell.deliver = new Spell.Delivery();
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 1.0f;
        trigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        spell.deliver.stash_effect.triggers = List.of(trigger);
        spell.deliver.stash_effect.amplifier = 0;
        spell.deliver.stash_effect.duration = 30.0f;
        spell.deliver.stash_effect.id = OathswornPaladins.SMITE.method_55840();
        Spell.Impact impact = OathSpells.createHolyImpact(1.6f, 1.0f);
        Spell.Impact[] impacts = new Spell.Impact[]{impact};
        spell.area_impact = new Spell.AreaImpact();
        spell.area_impact.area = new Spell.Target.Area();
        spell.area_impact.radius = 2.0f;
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.release.particles = particlebatch;
        spell.area_impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 100.0f, 0.6f, 1.0f, 360.0f), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPELL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 100.0f, 0.4f, 0.8f, 360.0f), new ParticleBatch("minecraft:smoke", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 50.0f, 0.4f, 0.8f, 360.0f)};
        spell.release.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_RELEASE.id().toString());
        spell.impacts = List.of(impacts[0]);
        OathSpells.configureCooldown(spell, 4.0f, false, "runes:healing_stone");
        return new Entry(id, spell, title, description, null);
    }

    private static Entry fervor() {
        Spell spell = OathSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        class_2960 id = class_2960.method_60655((String)"oathswornpaladins", (String)"righteous_fervor");
        String description = "Shoot a feather projectile, dealing {damage} fire damage to the first enemy hit.";
        String title = "Exploding Feathers";
        spell.learn = new Spell.Learn();
        spell.tier = 1;
        spell.range = 0.0f;
        spell.active.cast = OathSpells.createCast(0, 1.0f, SpellEngineSounds.GENERIC_HEALING_CASTING.id().toString(), "spell_engine:one_handed_healing_charge", SpellSchools.HEALING);
        ParticleBatch[] particlebatch = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 30.0f, 0.8f, 1.0f, 0.0f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.HOLY, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 10.0f, 0.5f, 1.0f, 0.0f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.STRIPE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 10.0f, 0.5f, 1.0f, 0.0f).color(Color.HOLY.toRGBA())};
        spell.deliver = new Spell.Delivery();
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
        Spell.Trigger trigger = new Spell.Trigger();
        trigger.chance = 1.0f;
        trigger.type = Spell.Trigger.Type.MELEE_IMPACT;
        spell.deliver.stash_effect.triggers = List.of(trigger);
        spell.deliver.stash_effect.amplifier = 2;
        spell.deliver.stash_effect.duration = 30.0f;
        spell.deliver.stash_effect.id = OathswornPaladins.HOLY_FERVOR.method_55840();
        Spell.Impact impact = OathSpells.createHealingImpact(0.8f, 0.0f);
        impact.action.apply_to_caster = true;
        Spell.Impact[] impacts = new Spell.Impact[]{impact};
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.release.particles = particlebatch;
        spell.release.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_RELEASE.id().toString());
        spell.impacts = List.of(impacts[0]);
        OathSpells.configureCooldown(spell, 4.0f, false, "runes:healing_stone");
        return new Entry(id, spell, title, description, null);
    }

    private static Entry vengeance() {
        Spell spell = OathSpells.passiveSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.target = new Spell.Target();
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        class_2960 id = class_2960.method_60655((String)"oathswornpaladins", (String)"mark_of_vengeance");
        String description = "Blast an enemy for {damage} frost damage and inflict Wintertide on them, slowing them by 20%.";
        String title = "Wintertide";
        spell.deliver = new Spell.Delivery();
        spell.deliver.type = Spell.Delivery.Type.DIRECT;
        Spell.Trigger trigger1 = new Spell.Trigger();
        trigger1.type = Spell.Trigger.Type.DAMAGE_TAKEN;
        trigger1.chance = 1.0f;
        spell.passive.triggers = List.of(trigger1);
        spell.learn = new Spell.Learn();
        spell.tier = 2;
        spell.range = 8.0f;
        Spell.Impact[] impacts = new Spell.Impact[2];
        impacts[1] = new Spell.Impact();
        impacts[1].action = new Spell.Impact.Action();
        impacts[1].action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        impacts[1].action.status_effect = new Spell.Impact.Action.StatusEffect();
        impacts[1].action.status_effect.effect_id = OathswornPaladins.VENGEANCE_MARK.method_55840();
        impacts[1].action.status_effect.duration = 4.0f;
        spell.release = new Spell.Release();
        spell.impacts = List.of(impacts[1]);
        OathSpells.configureCooldown(spell, 0.0f, false, null);
        spell.cost.durability = 0;
        return new Entry(id, spell, title, description, null);
    }

    private static Entry time_of_need() {
        Spell spell = OathSpells.passiveSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.target = new Spell.Target();
        spell.target.type = Spell.Target.Type.CASTER;
        class_2960 id = class_2960.method_60655((String)"oathswornpaladins", (String)"time_of_need");
        String description = "Upon taking damage, give yourself {stacks} stacks of the Time of Need buff for 2 seconds, increasing movement speed by 10%% per stack and healing yourself by 1 per stack upon expiration.";
        String title = "Wintertide";
        spell.deliver = new Spell.Delivery();
        spell.deliver.type = Spell.Delivery.Type.DIRECT;
        Spell.Trigger trigger1 = new Spell.Trigger();
        trigger1.type = Spell.Trigger.Type.DAMAGE_TAKEN;
        trigger1.chance = 1.0f;
        spell.passive.triggers = List.of(trigger1);
        spell.learn = new Spell.Learn();
        spell.tier = 2;
        spell.range = 0.0f;
        Spell.Impact[] impacts = new Spell.Impact[2];
        impacts[1] = new Spell.Impact();
        impacts[1].action = new Spell.Impact.Action();
        impacts[1].action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        impacts[1].action.status_effect = new Spell.Impact.Action.StatusEffect();
        impacts[1].action.status_effect.effect_id = OathswornPaladins.TIME_OF_NEED.method_55840();
        impacts[1].action.status_effect.refresh_duration = false;
        impacts[1].action.status_effect.duration = 2.0f;
        impacts[1].action.status_effect.amplifier = 0;
        impacts[1].action.status_effect.amplifier_power_multiplier = 1.0f;
        impacts[1].action.apply_to_caster = true;
        spell.release = new Spell.Release();
        spell.impacts = List.of(impacts[1]);
        OathSpells.configureCooldown(spell, 2.0f, false, null);
        spell.cost.cooldown.haste_affected = false;
        SpellTooltip.DescriptionMutator mutator = args -> {
            int amplifier = impacts[1].action.status_effect.amplifier + (int)((double)impacts[1].action.status_effect.amplifier_power_multiplier * SpellPower.getSpellPower((SpellSchool)SpellSchools.HEALING, (class_1309)args.player()).nonCriticalValue());
            int amplifierCrit = impacts[1].action.status_effect.amplifier + (int)((double)impacts[1].action.status_effect.amplifier_power_multiplier * SpellPower.getSpellPower((SpellSchool)SpellSchools.HEALING, (class_1309)args.player()).forcedCriticalValue());
            return args.description().replace("{stacks}", String.valueOf(amplifier + "1 - " + amplifier + "1"));
        };
        spell.cost.durability = 0;
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry shield_throw() {
        Spell spell = OathSpells.projectileBase(SpellSchools.HEALING, class_2960.method_12829((String)"spellbladenext:projectile/shield"), 1.2f, 1.0f, 0.0f);
        spell.school = PaladinSchools.ARMOR;
        spell.deliver.projectile.projectile.perks.bounce = 4;
        spell.deliver.projectile.projectile.perks.ricochet = 4;
        spell.deliver.projectile.projectile.divergence = 0.0f;
        spell.deliver.projectile.projectile.client_data.model.scale = 2.0f;
        spell.deliver.projectile.projectile.homing_angle = 10.0f;
        spell.deliver.projectile.projectile.homing_after_relative_distance = 0.4f;
        spell.deliver.projectile.projectile.homing_after_absolute_distance = 8.0f;
        spell.target = new Spell.Target();
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        class_2960 id = class_2960.method_60655((String)"oathswornpaladins", (String)"shield_throw");
        String description = "Attack with a flurry of amethyst projectiles, dealing {damage} Arcane damage per second.";
        String title = "Shield of Faith";
        spell.learn = new Spell.Learn();
        spell.tier = 1;
        spell.range = 32.0f;
        spell.active.cast = OathSpells.createCast(0, 1.0f, "spell_engine:generic_frost_casting", "spell_engine:one_handed_throw_charge", PaladinSchools.ARMOR);
        ParticleBatch[] particlebatch = new ParticleBatch[]{new ParticleBatch("minecraft:smoke", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 8.0f, 0.05f, 0.1f, 360.0f), new ParticleBatch("minecraft:poof", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 3.0f, 0.05f, 0.1f, 360.0f)};
        spell.deliver.projectile.projectile.client_data.travel_particles = particlebatch;
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_throw_release_instant";
        Spell.Impact[] impacts = new Spell.Impact[]{OathSpells.createArmorImpact(1.2f, 0.0f)};
        impacts[0].particles = particlebatch;
        spell.impacts = List.of(impacts[0]);
        OathSpells.configureCooldown(spell, 4.0f, false, null);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry shield_pummel() {
        Spell spell = OathSpells.activeSpellBase();
        spell.school = PaladinSchools.ARMOR;
        spell.deliver = new Spell.Delivery();
        spell.deliver.type = Spell.Delivery.Type.DIRECT;
        class_2960 id = class_2960.method_60655((String)"oathswornpaladins", (String)"resonating_shield");
        String description = "Attack with a flurry of amethyst projectiles, dealing {damage} Arcane damage per second.";
        String title = "Resonating Shield";
        spell.target = new Spell.Target();
        spell.target.area = new Spell.Target.Area();
        spell.target.type = Spell.Target.Type.AREA;
        spell.learn = new Spell.Learn();
        spell.tier = 3;
        spell.range = 4.0f;
        spell.active.cast = OathSpells.createCast(20, 8.0f, null, "oathswornpaladins:shieldslam", PaladinSchools.ARMOR);
        ParticleBatch[] particlebatch = new ParticleBatch[]{new ParticleBatch("minecraft:smoke", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 8.0f, 0.05f, 0.1f, 360.0f), new ParticleBatch("minecraft:poof", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 3.0f, 0.05f, 0.1f, 360.0f)};
        ParticleBatch[] particlebatch2 = new ParticleBatch[]{new ParticleBatch("minecraft:cloud", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 20.0f, 0.2f, 0.6f, 360.0f), new ParticleBatch("minecraft:cloud", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 12.0f, 0.5f, 0.9f, 360.0f)};
        spell.release = new Spell.Release();
        Spell.Impact[] impacts = new Spell.Impact[]{OathSpells.createArmorImpact(0.6f, 0.2f)};
        impacts[0].particles = particlebatch;
        spell.impacts = List.of(impacts[0]);
        OathSpells.configureCooldown(spell, 8.0f, true, null);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry rally() {
        Spell spell = OathSpells.passiveSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.target = new Spell.Target();
        spell.target.type = Spell.Target.Type.AREA;
        spell.target.area = new Spell.Target.Area();
        class_2960 id = class_2960.method_60655((String)"oathswornpaladins", (String)"rally");
        String description = "Upon blocking with a shield, give allies nearby {stacks} stacks of the Time of Need buff for 4 seconds, increasing their movement speed by 10%% per stack and healing them by 1 per stack upon its expiration.";
        String title = "Wintertide";
        spell.deliver = new Spell.Delivery();
        spell.deliver.type = Spell.Delivery.Type.DIRECT;
        Spell.Trigger trigger1 = new Spell.Trigger();
        trigger1.type = Spell.Trigger.Type.SHIELD_BLOCK;
        trigger1.chance = 1.0f;
        spell.passive.triggers = List.of(trigger1);
        spell.learn = new Spell.Learn();
        spell.tier = 4;
        spell.range = 16.0f;
        Spell.Impact[] impacts = new Spell.Impact[2];
        impacts[1] = new Spell.Impact();
        impacts[1].action = new Spell.Impact.Action();
        impacts[1].action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        impacts[1].action.status_effect = new Spell.Impact.Action.StatusEffect();
        impacts[1].action.status_effect.effect_id = OathswornPaladins.TIME_OF_NEED.method_55840();
        impacts[1].action.status_effect.refresh_duration = false;
        impacts[1].action.status_effect.duration = 4.0f;
        impacts[1].action.status_effect.amplifier = 0;
        impacts[1].action.status_effect.amplifier_power_multiplier = 1.0f;
        spell.release = new Spell.Release();
        spell.impacts = List.of(impacts[1]);
        OathSpells.configureCooldown(spell, 4.0f, false, null);
        spell.cost.cooldown.haste_affected = false;
        SpellTooltip.DescriptionMutator mutator = args -> {
            int amplifier = impacts[1].action.status_effect.amplifier + (int)((double)impacts[1].action.status_effect.amplifier_power_multiplier * SpellPower.getSpellPower((SpellSchool)SpellSchools.HEALING, (class_1309)args.player()).nonCriticalValue());
            int amplifierCrit = impacts[1].action.status_effect.amplifier + (int)((double)impacts[1].action.status_effect.amplifier_power_multiplier * SpellPower.getSpellPower((SpellSchool)SpellSchools.HEALING, (class_1309)args.player()).forcedCriticalValue());
            return args.description().replace("{stacks}", String.valueOf(amplifier + "1 - " + amplifier + "1"));
        };
        return new Entry(id, spell, title, description, mutator);
    }

    private static Entry rebuke() {
        Spell spell = OathSpells.projectileBase(SpellSchools.HEALING, class_2960.method_60655((String)"spellbladenext", (String)"projectile/spear"), 0.8f, 2.0f, 4.0f);
        spell.school = SpellSchools.HEALING;
        class_2960 id = class_2960.method_60655((String)"oathswornpaladins", (String)"rebuke");
        String description = "Shoot a feather projectile, dealing {damage} fire damage to the first enemy hit.";
        String title = "Exploding Feathers";
        spell.learn = new Spell.Learn();
        spell.tier = 2;
        spell.range = 32.0f;
        spell.active.cast = OathSpells.createCast(0, 1.0f, SpellEngineSounds.GENERIC_HEALING_CASTING.id().toString(), "spell_engine:one_handed_throw_charge", SpellSchools.HEALING);
        spell.target = new Spell.Target();
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        ParticleBatch[] particlebatch = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 30.0f, 0.8f, 1.0f, 0.0f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.HOLY, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 10.0f, 0.5f, 1.0f, 0.0f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.STRIPE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 10.0f, 0.5f, 1.0f, 0.0f).color(Color.HOLY.toRGBA())};
        ParticleBatch[] particlebatch2 = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 3.0f, 0.08f, 0.1f, 0.0f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.HOLY, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 1.0f, 0.05f, 0.1f, 0.0f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.STRIPE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 1.0f, 0.05f, 1.0f, 0.0f).color(Color.HOLY.toRGBA())};
        spell.deliver.projectile.projectile.client_data.travel_particles = particlebatch2;
        Spell.Impact impact = OathSpells.createHolyImpact(0.8f, 1.0f);
        Spell.Impact[] impacts = new Spell.Impact[]{impact};
        spell.area_impact = new Spell.AreaImpact();
        spell.area_impact.area = new Spell.Target.Area();
        spell.area_impact.radius = 4.0f;
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_throw_release";
        spell.release.particles = particlebatch;
        spell.area_impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 100.0f, 0.6f, 1.0f, 360.0f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.HOLY, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 100.0f, 0.4f, 0.8f, 360.0f).color(Color.HOLY.toRGBA()), new ParticleBatch("minecraft:smoke", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 50.0f, 0.4f, 0.8f, 360.0f)};
        spell.release.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_RELEASE.id().toString());
        spell.impacts = List.of(impacts);
        OathSpells.configureCooldown(spell, 8.0f, false, "runes:healing_stone");
        return new Entry(id, spell, title, description, null);
    }

    private static Entry seraph_strike() {
        Spell spell = OathSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        class_2960 id = class_2960.method_60655((String)"oathswornpaladins", (String)"seraph_strike");
        String description = "Shoot a feather projectile, dealing {damage} fire damage to the first enemy hit.";
        String title = "Exploding Feathers";
        spell.learn = new Spell.Learn();
        spell.tier = 1;
        spell.range = 3.0f;
        spell.active.cast = OathSpells.createCast(0, 0.0f, SpellEngineSounds.GENERIC_HEALING_CASTING.id().toString(), "spell_engine:one_handed_healing_charge", SpellSchools.HEALING);
        spell.target = new Spell.Target();
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.target.aim.required = false;
        spell.target.aim.sticky = true;
        ParticleBatch[] particlebatch = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 30.0f, 0.8f, 1.0f, 0.0f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.HOLY, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 10.0f, 0.5f, 1.0f, 0.0f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.STRIPE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 10.0f, 0.5f, 1.0f, 0.0f).color(Color.HOLY.toRGBA())};
        spell.deliver = new Spell.Delivery();
        spell.deliver.type = Spell.Delivery.Type.METEOR;
        spell.deliver.meteor = new Spell.Delivery.Meteor();
        spell.deliver.meteor.projectile = OathSpells.projectileBase((SpellSchool)SpellSchools.HEALING, (class_2960)class_2960.method_60655((String)"spellbladenext", (String)"projectile/spear"), (float)1.2f, (float)100.0f, (float)0.0f).deliver.projectile.projectile;
        spell.deliver.meteor.launch_height = 0.0f;
        spell.deliver.meteor.projectile.client_data.model.scale = 0.0f;
        Spell.Impact impact = OathSpells.createHolyImpact(1.2f, 1.0f);
        Spell.Impact impact3 = OathSpells.createPhysicalimpact(0.8f, 1.0f);
        Spell.Impact impact2 = OathSpells.createHealingImpact(1.2f, 1.0f);
        Spell.Impact[] impacts = new Spell.Impact[]{impact, impact3, impact2};
        spell.area_impact = new Spell.AreaImpact();
        spell.area_impact.area = new Spell.Target.Area();
        spell.area_impact.radius = 4.0f;
        spell.release = new Spell.Release();
        spell.release.animation = "spellbladenext:seraph_strike";
        spell.release.particles = particlebatch;
        spell.area_impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 100.0f, 0.6f, 1.0f, 360.0f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.HOLY, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.FLOAT).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 100.0f, 0.4f, 0.8f, 360.0f).color(Color.HOLY.toRGBA()), new ParticleBatch("minecraft:smoke", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 50.0f, 0.4f, 0.8f, 360.0f)};
        spell.release.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_RELEASE.id().toString());
        spell.impacts = List.of(impacts);
        OathSpells.configureCooldown(spell, 4.0f, false, "runes:healing_stone");
        return new Entry(id, spell, title, description, null);
    }

    private static Entry sigil_of_hope() {
        Spell spell = OathSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.range = 8.0f;
        spell.target = new Spell.Target();
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.target.aim.sticky = true;
        spell.target.aim.required = true;
        spell.target.aim.use_caster_as_fallback = true;
        class_2960 id = class_2960.method_60655((String)"oathswornpaladins", (String)"sigil_of_hope");
        String description = "Blast an enemy for {damage} frost damage and inflict Wintertide on them, slowing them by 20%.";
        String title = "Wintertide";
        spell.deliver = new Spell.Delivery();
        spell.deliver.type = Spell.Delivery.Type.DIRECT;
        spell.active.cast = OathSpells.createCast(0, 1.0f, SpellEngineSounds.GENERIC_HEALING_CASTING.id().toString(), "spell_engine:one_handed_healing_charge", SpellSchools.HEALING);
        spell.learn = new Spell.Learn();
        spell.tier = 3;
        spell.range = 8.0f;
        Spell.Impact[] impacts = new Spell.Impact[2];
        ParticleBatch[] particlebatch = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 30.0f, 0.8f, 1.0f, 0.0f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.HOLY, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 10.0f, 0.5f, 1.0f, 0.0f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.STRIPE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 10.0f, 0.5f, 1.0f, 0.0f).color(Color.HOLY.toRGBA())};
        impacts[1] = new Spell.Impact();
        impacts[1].action = new Spell.Impact.Action();
        impacts[1].action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        impacts[1].action.status_effect = new Spell.Impact.Action.StatusEffect();
        impacts[1].action.status_effect.effect_id = "oathswornpaladins:sigil_of_hope";
        impacts[1].action.status_effect.duration = 12.0f;
        impacts[1].action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.SET;
        impacts[1].action.status_effect.amplifier = 0;
        impacts[1].action.status_effect.amplifier_power_multiplier = 0.4f;
        spell.release = new Spell.Release();
        spell.release.particles = particlebatch;
        spell.release.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_RELEASE.id().toString());
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.impacts = List.of(impacts[1]);
        OathSpells.configureCooldown(spell, 6.0f, false, null);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry divine_intervention() {
        Spell spell = OathSpells.activeSpellBase();
        spell.school = SpellSchools.HEALING;
        spell.range = 8.0f;
        spell.target = new Spell.Target();
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.target.aim.required = true;
        spell.target.aim.use_caster_as_fallback = true;
        class_2960 id = class_2960.method_60655((String)"oathswornpaladins", (String)"divine_intervention");
        String description = "Blast an enemy for {damage} frost damage and inflict Wintertide on them, slowing them by 20%.";
        String title = "Wintertide";
        spell.deliver = new Spell.Delivery();
        spell.deliver.type = Spell.Delivery.Type.DIRECT;
        spell.active.cast = OathSpells.createCast(0, 2.0f, SpellEngineSounds.GENERIC_HEALING_CASTING.id().toString(), "spell_engine:one_handed_healing_charge", SpellSchools.HEALING);
        spell.learn = new Spell.Learn();
        spell.tier = 4;
        spell.range = 16.0f;
        Spell.Impact[] impacts = new Spell.Impact[2];
        impacts[1] = new Spell.Impact();
        impacts[1].action = new Spell.Impact.Action();
        impacts[1].action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        impacts[1].action.status_effect = new Spell.Impact.Action.StatusEffect();
        impacts[1].action.status_effect.effect_id = OathswornPaladins.DIVINE_INTERVENTION.method_55840();
        impacts[1].action.status_effect.duration = 4.0f;
        impacts[1].action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.SET;
        impacts[1].action.status_effect.amplifier = 19;
        ParticleBatch[] particlebatch = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPARK, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 30.0f, 0.8f, 1.0f, 0.0f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.HOLY, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 10.0f, 0.5f, 1.0f, 0.0f).color(Color.HOLY.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.STRIPE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.FEET, null, 10.0f, 0.5f, 1.0f, 0.0f).color(Color.HOLY.toRGBA())};
        spell.release = new Spell.Release();
        spell.release.particles = particlebatch;
        spell.release.sound = new Sound(SpellEngineSounds.GENERIC_HEALING_RELEASE.id().toString());
        spell.release.animation = "spell_engine:one_handed_healing_release";
        spell.impacts = List.of(impacts[1]);
        OathSpells.configureCooldown(spell, 30.0f, false, null);
        return new Entry(id, spell, title, description, null);
    }

    public record Entry(class_2960 id, Spell spell, String title, String description, @Nullable SpellTooltip.DescriptionMutator mutator) {
    }
}

