/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.mixin;

import com.google.common.collect.Streams;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.datafixers.util.Pair;
import com.terraformersmc.biolith.api.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.biome.VanillaEndBiomeParameters;
import com.terraformersmc.biolith.impl.compat.BiolithCompat;
import com.terraformersmc.biolith.impl.compat.VanillaCompat;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2169;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_7871;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2169.class}, priority=990)
public abstract class MixinTheEndBiomeSource
extends class_1966 {
    @Unique
    private static class_7871<class_1959> biolith$biomeLookup;
    @Unique
    private static class_6544.class_6547<class_6880<class_1959>> biolith$biomeEntries;

    @Inject(method={"createVanilla"}, at={@At(value="HEAD")})
    private static void biolith$getRegistry(class_7871<class_1959> biomeLookup, CallbackInfoReturnable<class_2169> cir) {
        if (!biomeLookup.equals(biolith$biomeLookup)) {
            biolith$biomeLookup = biomeLookup;
            biolith$biomeEntries = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ModifyReturnValue(method={"biomeStream"}, at={@At(value="RETURN")})
    private Stream<class_6880<class_1959>> biolith$biomeStream(Stream<class_6880<class_1959>> original) {
        if (BiolithCompat.COMPAT_DATAGEN) {
            return original;
        }
        MixinTheEndBiomeSource mixinTheEndBiomeSource = this;
        synchronized (mixinTheEndBiomeSource) {
            if (biolith$biomeEntries == null) {
                ArrayList<Pair> parameterList = new ArrayList<Pair>(64);
                BiomeCoordinator.getBiomeLookup().ifPresent(lookup -> {
                    biolith$biomeLookup = lookup;
                });
                Objects.requireNonNull(biolith$biomeLookup, "Failed to acquire biome lookup for The End.");
                VanillaEndBiomeParameters.writeEndBiomeParameters(parameterList::add);
                parameterList.removeIf(entry -> !BiomeCoordinator.END.removalFilter((Pair<class_6544.class_4762, class_6880<class_1959>>)entry.mapSecond(key -> biolith$biomeLookup.method_46747(key))));
                BiomeCoordinator.END.writeBiomeParameters(parameterList::add);
                biolith$biomeEntries = new class_6544.class_6547(parameterList.stream().map(pair -> pair.mapSecond(key -> biolith$biomeLookup.method_46747(key))).toList());
            }
        }
        return Streams.concat((Stream[])new Stream[]{original, biolith$biomeEntries.method_38128().stream().map(Pair::getSecond)}).distinct();
    }

    @ModifyReturnValue(method={"getBiome"}, at={@At(value="RETURN")})
    private class_6880<class_1959> biolith$getBiome(class_6880<class_1959> original, int x, int y, int z, class_6544.class_6552 noise) {
        class_6544.class_6553 noisePoint = BiomeCoordinator.END.sampleEndNoise(x, y, z, noise, original);
        BiolithFittestNodes<class_6880<class_1959>> fittestNodes = VanillaCompat.getEndBiome(noisePoint, this.biolith$getBiomeEntries(), original);
        return BiomeCoordinator.END.getReplacement(x, y, z, noisePoint, fittestNodes);
    }

    @WrapOperation(method={"getBiome"}, at={@At(value="NEW", target="net/minecraft/world/gen/densityfunction/DensityFunction$UnblendedNoisePos")})
    private class_6910.class_6914 biolith$smoothEndNoise(int blockX, int blockY, int blockZ, Operation<class_6910.class_6914> original, int x, int y, int z) {
        return new class_6910.class_6914(class_5742.method_33101((int)x), class_5742.method_33101((int)y), class_5742.method_33101((int)z));
    }

    @NotNull
    public class_6544.class_6547<class_6880<class_1959>> biolith$getBiomeEntries() {
        if (biolith$biomeEntries == null) {
            this.method_49494();
            if (biolith$biomeEntries == null) {
                throw new IllegalStateException("biolith$biomeEntries is null after call to " + ((Object)((Object)this)).getClass().getCanonicalName() + ".biomeStream()");
            }
        }
        return biolith$biomeEntries;
    }
}

