/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.data.SurfaceGenerationMarshaller;
import com.terraformersmc.biolith.impl.surface.SurfaceRuleCollector;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;

public class SurfaceGenerationLoader
extends class_4080<List<SurfaceGenerationMarshaller>> {
    public static final String RESOURCE_PATH = "biolith/surface_generation.json";

    protected List<SurfaceGenerationMarshaller> prepare(class_3300 manager, class_3695 profiler) {
        profiler.method_16065();
        ArrayList<SurfaceGenerationMarshaller> marshallers = new ArrayList<SurfaceGenerationMarshaller>();
        for (String namespace : manager.method_14487()) {
            profiler.method_15396(namespace);
            try {
                for (class_3298 resource : manager.method_14489(class_2960.method_60655((String)namespace, (String)RESOURCE_PATH))) {
                    profiler.method_15396(resource.method_14480());
                    try {
                        InputStream inputStream = resource.method_14482();
                        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                            profiler.method_15396("parse");
                            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                            SurfaceGenerationMarshaller marshaller = SurfaceGenerationLoader.get(SurfaceGenerationMarshaller.CODEC, (JsonElement)jsonObject);
                            if (marshaller == null) {
                                throw new RuntimeException();
                            }
                            marshallers.add(marshaller);
                            profiler.method_15407();
                        }
                        catch (Throwable throwable) {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable closeBreak) {
                                    throwable.addSuppressed(closeBreak);
                                }
                            }
                            throw throwable;
                        }
                        inputStream.close();
                    }
                    catch (RuntimeException runtimeBreak) {
                        Biolith.LOGGER.warn("Invalid {} in resourcepack: '{}'", new Object[]{RESOURCE_PATH, resource.method_14480(), runtimeBreak});
                    }
                    profiler.method_15407();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            profiler.method_15407();
        }
        profiler.method_16066();
        return marshallers;
    }

    protected void apply(List<SurfaceGenerationMarshaller> marshallers, class_3300 manager, class_3695 profiler) {
        if (BiomeCoordinator.isServerStarted()) {
            Biolith.LOGGER.warn("Ignoring request to reload surface generation data while server is running.");
            return;
        }
        if (marshallers.size() > 0) {
            Biolith.LOGGER.info("Applying surface generation data from {} source(s).", (Object)marshallers.size());
        }
        SurfaceRuleCollector.OVERWORLD.clearFromData();
        SurfaceRuleCollector.NETHER.clearFromData();
        SurfaceRuleCollector.END.clearFromData();
        for (SurfaceGenerationMarshaller marshaller : marshallers) {
            marshaller.unmarshall();
        }
    }

    public static <R> R get(Decoder<R> decoder, JsonElement jsonElement) throws NullPointerException {
        return (R)decoder.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).result().orElseThrow();
    }
}

