/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome.sub;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraformersmc.biolith.api.biome.sub.Criterion;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBiomeCriterion
implements Criterion {
    protected final BiomeTarget biomeTarget;

    public AbstractBiomeCriterion(BiomeTarget biomeTarget) {
        this.biomeTarget = biomeTarget;
    }

    protected static <T extends AbstractBiomeCriterion> MapCodec<T> buildCodec(Function<BiomeTarget, T> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeTarget.CODEC.fieldOf("biome").forGetter(AbstractBiomeCriterion::biomeTarget)).apply((Applicative)instance, function));
    }

    public BiomeTarget biomeTarget() {
        return this.biomeTarget;
    }

    public record BiomeTarget(@Nullable class_5321<class_1959> biome, @Nullable class_6862<class_1959> tag) {
        public static final Codec<BiomeTarget> CODEC = Codec.either((Codec)class_5321.method_39154((class_5321)class_7924.field_41236), (Codec)class_6862.method_40093((class_5321)class_7924.field_41236)).flatComapMap(BiomeTarget::fromEither, BiomeTarget::toEither);

        public BiomeTarget(@Nullable class_5321<class_1959> biome, @Nullable class_6862<class_1959> tag) {
            if (biome == null && tag == null) {
                throw new IllegalArgumentException("Must specify either biome or tag!");
            }
        }

        public static BiomeTarget of(@NotNull class_5321<class_1959> biome) {
            return new BiomeTarget(biome, null);
        }

        public static BiomeTarget of(@NotNull class_6862<class_1959> tag) {
            return new BiomeTarget(null, tag);
        }

        public static BiomeTarget fromEither(Either<class_5321<class_1959>, class_6862<class_1959>> either) {
            return new BiomeTarget((class_5321<class_1959>)((class_5321)either.left().orElse(null)), (class_6862<class_1959>)((class_6862)either.right().orElse(null)));
        }

        public DataResult<Either<class_5321<class_1959>, class_6862<class_1959>>> toEither() {
            return DataResult.success((Object)(this.biome != null ? Either.left(this.biome) : Either.right(this.tag)));
        }

        public boolean matches(@Nullable class_6880<class_1959> biome) {
            if (biome == null) {
                return false;
            }
            if (this.biome != null && biome.method_40225(this.biome)) {
                return true;
            }
            return this.tag != null && biome.method_40220(this.tag);
        }
    }
}

